const {useEffect} = React;

export default function CustomCSS({data, setData}) {

    const {customCSS} = data;

    useEffect(() => {
        const element = document.querySelector('.radio-player-editor');

        if (!element) return;

        const instance = wp.codeEditor.initialize(element, {
            ...wp.codeEditor.defaultSettings,
            mode: 'css',
            wordWrap: true,
            tabSize: 2,
            autoComplete: {
                enable: true,
                showDescriptions: true,
                caseSensitive: true,
                autoTrigger: true,
                delay: 0,
                maxItems: 10,
                sortBy: 'score',
                maxLength: 0,
                maxResults: 10,
                highlightMatches: true,
                maxHighlightLength: 0,
                style: 'popup',
            },
            showGutter: true,
            showPrintMargin: true,
            highlightActiveLine: true,
            showLineNumbers: true,
            enableBasicAutocompletion: true,
            enableLiveAutocompletion: true,
            enableCodeFolding: true,
            enableCodeFormatting: true,
        });

        instance.codemirror.on('change', (codemirror) => {
            setData(data => ({...data, customCSS: codemirror.getValue()}));
        });

        return () => {
            instance.codemirror.off('change');
        }

    }, []);

    return (
        <div className="tab-content">

            <div className="settings-header">
                <img src={`${radioPlayer.plugin_url}/assets/images/settings/css.svg`} />

                <span>{wp.i18n.__('Custom CSS', 'radio-player')}</span>
            </div>

            <div className="setting-field custom-css">
                <label>{wp.i18n.__('Add custom CSS for the Radio Players.', 'radio-player')}</label>

                <div className="setting-field-content">
                    <textarea
                        value={customCSS}
                        placeholder="Enter custom CSS here..."
                        className="radio-player-editor"
                        id={`radio-player-custom-css`}
                        rows={20}
                    />
                </div>
            </div>

        </div>
    )
}