import AppContext from "../../../contexts/AppContext";
import {showProModal, getSkins} from "../../../includes/functions";

const {useContext} = React;

export default function Skins() {

    const isPro = !!radioPlayer.isPro;
    const context = useContext(AppContext);

    const {editData, setEditData} = context;
    const {skin = 'skin1'} = editData;

    const skins = getSkins();

    return (
        <div className="settings-body">

            <div className="settings-header">
                <h3 className="header-title">{wp.i18n.__('Choose Player Skin', 'radio-player')} </h3>
                <p>{wp.i18n.__('Skins will be applied to the shortcode and popup players but not to the sticky player.', 'radio-player')}</p>
            </div>

            <div className="skins">
                {
                    Object.keys(skins).map(key => {
                        const isProSkin = skins[key].isPro;
                        const config = skins[key].config ? skins[key].config : null;

                        return (
                            <div key={key}
                                 className={`skin-item ${skin === key ? 'active' : ''} ${(isProSkin && !isPro) ? 'pro' : ''}`}
                                 onClick={() => {

                                     if (isProSkin && !isPro) {
                                         showProModal(wp.i18n.__('Upgrade to PRO to use this skin', 'radio-player'));
                                         return;
                                     }

                                     setEditData(data => ({...data, skin: key}));

                                     if (config) {
                                         Object.keys(config).map(key => setEditData(data => ({
                                             ...data,
                                             [key]: config[key]
                                         })));
                                     }
                                 }}
                            >
                                {(isProSkin && !isPro) &&
                                    <div className="pro-icon-wrap">
                                        <i className={`radio-player-icon icon-pro`}></i>
                                        <span>{wp.i18n.__('PRO', 'radio-player')}</span>
                                    </div>
                                }

                                <div className="img-wrap">
                                    <img src={`${radioPlayer.plugin_url}/assets/images/skins/${key}.png`}/>
                                </div>

                                <div className="skin-title">
                                    <span>{skins[key]['title']}</span>

                                    <a href={`https://softlabbd.com/radio-player-multiple-player-skins#${key}`}
                                       target={'_blank'}
                                       onClick={e => e.stopPropagation()}
                                    >
                                        <i className="dashicons dashicons-visibility"></i>
                                        <span>{wp.i18n.__('Preview', 'radio-player')}</span>
                                    </a>
                                </div>
                            </div>
                        )
                    })
                }

            </div>

        </div>
    )
}