<?php defined( 'ABSPATH' ) || exit; ?>

<style>
    .update-php .wrap {
        max-width: calc(100% - 20px) !important;
    }

    .radio-player-proxy-addon-notice .notice-image img {
        width: 60px;
        height: auto;
    }
</style>

<div class="notice-image">
    <img src="<?php echo esc_url( RADIO_PLAYER_ASSETS . '/images/radio-player-proxy-icon.png' ); ?>">
</div>

<div class="notice-main">
    <div class="notice-text">

        <h3 class="notice-title">
            <?php esc_html_e( 'Update Required for the "Radio Player Proxy" Add-on', 'radio-player' ); ?>
        </h3>

        <p>
            <?php esc_html_e( 'A new version of the Radio Player Proxy add-on is available. Please update to the latest release to maintain full compatibility and optimal performance with the Radio Player plugin.', 'radio-player' ); ?>
        </p>

        <div class="notice-actions">

            <a href="#" class="button button-link-delete rpa-hide-notice">
                <i class="dashicons dashicons-no"></i>
                <?php esc_html_e( 'Dismiss', 'radio-player' ); ?>
            </a>

            <a href="<?php echo esc_url( rpp_fs()->_get_latest_download_local_url() ); ?>" class="button button-primary" target="_blank" rel="noopener">
                <i class="dashicons dashicons-download"></i>
                <?php esc_html_e( 'Download Latest Version', 'radio-player' ); ?>
            </a>

        </div>

    </div>
</div>

<script>
    (function ($) {
        $(function () {
            $('.rpa-hide-notice').on('click', function (e) {
                e.preventDefault();

                wp.ajax.post('rp_hide_radio_player_proxy_update_notice')
                    .done(function () {
                        $('.radio-player-proxy-update-notice').slideUp();
                    });
            });
        });
    })(jQuery);
</script>
