<?php defined( 'ABSPATH' ) or die( 'No script kiddies please!' ); ?>

<style>
    .update-php .wrap {
        max-width: calc(100% - 20px) !important;
    }
</style>

<div class="notice-image">
    <img src="<?php echo esc_url(RADIO_PLAYER_ASSETS . '/images/radio-player-proxy-icon.png'); ?>"
         alt="<?php echo esc_attr__('Radio Player Proxy Add-on Icon', 'radio-player'); ?>">
</div>

<div class="notice-main">
    <div class="notice-text">
        <h3 class="notice-title">
            <?php
                /* translators: Title for the Radio Player Proxy Add-on notice */
                esc_html_e( 'Radio Player Proxy Add-on', 'radio-player' );
            ?>
        </h3>
        <p>
            <?php
                /* translators: Description of the Radio Player Proxy Add-on's main feature */
                esc_html_e( 'Radio Player Proxy Add-on allows seamless playback of HTTP radio streams on HTTPS websites.', 'radio-player' );
            ?>
            <br>
            <?php
                /* translators: Additional features of the Radio Player Proxy Add-on */
                esc_html_e( 'Additionally, it can also fix the metadata display including current track title, artist, artwork, and recent play history in the player.', 'radio-player' );
            ?>
        </p>
        <a href="#" class="button button-link-delete hide_notice">
            <?php
                /* translators: Button text to permanently dismiss the notice */
                esc_html_e( 'Never show this', 'radio-player' );
            ?>
        </a>
        <a class="button" href="https://softlabbd.com/radio-player-proxy/" target="_blank">
            <?php
                /* translators: Button text to view more information */
                esc_html_e( 'More Details', 'radio-player' );
            ?>
        </a>
        <a target="_blank" class="button button-primary" href="https://softlabbd.com/radio-player-proxy/">
            <?php
                /* translators: Button text to purchase/download the add-on */
                esc_html_e( 'Get Now', 'radio-player' );
            ?>
        </a>
    </div>

</div>

<script>
    ;(function ($) {
        $(document).ready(function () {
            $('.hide_notice').on('click', function (e) {
                e.preventDefault();
                wp.ajax.post('rp_hide_radio_player_proxy_addon_notice');
                $('.radio-player-proxy-addon-notice').slideUp();
            });
        });
    })(jQuery);
</script>