<?php

if (! defined('ABSPATH')) {
    exit;
}

$logs = [
    'v2.0.90' => [
        'date' => '30 October, 2025',

        'fix'         => [
            'Fixed M3U8 streams not playing properly in all browsers.',
        ],
        'enhancement' => [
            'Added robust metadata fetching with fallback support',
            'Expanded MediaSession API integration for better OS media controls',
            'Optimized core player rendering and reduced memory usage',
        ]
    ],
    'v2.0.88' => [
        'date' => '07 May, 2025',
        'new'  => [
            'Added an option to play all player streams in sticky player mode.',
            'Introduced custom triggers for the sticky player.',
        ],
        'fix'  => [
            'Resolved dashboard statistics widget was not displaying data.',
        ],
    ],
    'v2.0.87' => [
        'date'        => '21 April, 2025',
        'new'         => [
            'Added stream source type options — Stream URL and Local Audio — for stations.',
            ' Introduced fallback display options for current song title and artist.',
        ],
        'fix'         => [
            'Resolved issue with multiple player instances playing simultaneously.',
            'Ensured compatibility with the Ads Player add-on.',
        ],
        'enhancement' => [
            'Remapped and enhanced the Statistics page layout.',
            'Improved overall plugin performance and user interface.',
        ]
    ],
    'v2.0.86' => [
        'date'        => '31 March, 2025',
        'new'         => [
            'Added New Player Skin 12.',
            'Added autoplay functionality for the player.',
            'Added resume playback option for local files.',
            'Added playback progress bar for local files.',
            'Added metadata display support for local files.',
        ],
        'fix'         => [
            'Fixed responsive issues with player skins.',
        ],
        'enhancement' => [
            'Improved the statistics page for better usability.',
        ]
    ],
    'v2.0.82' => [
        'date' => '11 November, 2024',
        'new'  => [
            'Added option to disable the song title scrolling.',
        ],
        'fix'  => [
            'Fixed stream metadata fetching issue for iceCast streams',
        ],
    ],
    'v2.0.81' => [
        'date' => '18 September, 2024',
        'fix'  => [
            'Fixed player took long time to load the page on IOS mobile device.',
            'Fixed Ads Player compatibility issue with the Radio Player plugin.',
        ],
    ],
    'v2.0.79' => [
        'date'        => '16 September, 2024',
        'fix'         => [
            'Fixed translation issue.',
        ],
        'enhancement' => [
            'Improved Ads Player Add-on compatibility.',
            'Improved overall performance and security.',
        ],
    ],
    'v2.0.78' => [
        'date'        => '12 August, 2024',
        'new'         => [
            'Added stations playlist height control settings.',
        ],
        'enhancement' => [
            'Improved overall plugin UI design and performance.',
            'Added support up to WordPress 6.6.1',
        ],
    ],
    'v2.0.77' => [
        'date'        => '09 July, 2024',
        'new'         => [
            'Added next playlist item playback on end.',
        ],
        'fix'         => [
            'Fixed compatibility issue with Proxy Player Add-on.',
            'Fixed compatibility issue with Ads Player Add-on.',
            'Fixed sticky player not displaying issue.',
        ],
        'enhancement' => [
            'Improved overall performance and security.',
        ],
    ],
    'v2.0.76' => [
        'date'        => '07 May, 2024',
        'new'         => [
            'Added option to customize the player playlist height.',
        ],
        'enhancement' => [
            'Enable Keyboard Accessibility for the Volume Slider.',
            'Improved overall performance and security.',
        ],
    ],
    'v2.0.75' => [
        'date'        => '19 March, 2024',
        'new'         => [
            'Added current song title metadata text scrolling speed setting.',
            'Added automatically reconnect the audio player when the internet connection is restored.',
        ],
        'fix'         => [
            'Fixed radio player is not displaying properly.',
        ],
        'enhancement' => [
            'Improved overall security and performance.',
        ],
    ],

];

?>

<div id="what-new" class="getting-started-content content-what-new">
    <section class="section-changelog section-full">
        <div class="content-heading">
            <h2>
                <?php
                esc_html_e("What's new in the latest changes", 'radio-player');
                ?>
            </h2>
            <p>
                <?php
                esc_html_e('Check out the latest change logs.', 'radio-player');
                ?>
            </p>
        </div>
        <div class="content-log">
            <?php
            $i = 0;
            foreach ($logs as $v => $log) { ?>
                <div class="log <?php echo esc_attr($i == 0 ? 'active' : ''); ?>">
                    <div class="log-header">
                        <span class="log-version"><?php echo esc_html($v); ?></span>
                        <span class="log-date">(<?php echo esc_html($log['date']); ?>)</span>

                        <i class="dashicons <?php echo esc_attr($i == 0 ? 'dashicons-arrow-up-alt2' : 'dashicons-arrow-down-alt2'); ?>"></i>
                    </div>

                    <div class="log-body">
                        <?php

                        if (! empty($log['new'])) {
                            echo '<div class="log-section new">';
                            echo '<h3>' . esc_html__('New Features', 'radio-player') . '</h3>';
                            foreach ($log['new'] as $item) {
                                printf(
                                    '<div class="log-item log-item-new"><i class="dashicons dashicons-plus-alt2"></i> <span>%s</span></div>',
                                    esc_html($item)
                                );
                            }
                            echo '</div>';
                        }

                        if (! empty($log['fix'])) {
                            echo '<div class="log-section fix">';
                            echo '<h3>' . esc_html__('Fixes', 'radio-player') . '</h3>';
                            foreach ($log['fix'] as $item) {
                                printf(
                                    '<div class="log-item log-item-fix"><i class="dashicons dashicons-saved"></i> <span>%s</span></div>',
                                    esc_html($item)
                                );
                            }
                            echo '</div>';
                        }

                        if (! empty($log['enhancement'])) {
                            echo '<div class="log-section enhancement">';
                            echo '<h3>' . esc_html__('Enhancements', 'radio-player') . '</h3>';
                            foreach ($log['enhancement'] as $item) {
                                printf(
                                    '<div class="log-item log-item-enhancement"><i class="dashicons dashicons-star-filled"></i> <span>%s</span></div>',
                                    esc_html($item)
                                );
                            }
                            echo '</div>';
                        }

                        if (! empty($log['remove'])) {
                            echo '<div class="log-section remove">';
                            echo '<h3>' . esc_html__('Removes', 'radio-player') . '</h3>';
                            foreach ($log['remove'] as $item) {
                                printf(
                                    '<div class="log-item log-item-remove"><i class="dashicons dashicons-trash"></i> <span>%s</span></div>',
                                    esc_html($item)
                                );
                            }
                            echo '</div>';
                        }

                        ?>
                    </div>
                </div>
            <?php
                $i++;
            } ?>
        </div>
    </section>
</div>


<script>
    jQuery(document).ready(function($) {
        $('.log-header').on('click', function() {
            $(this).next('.log-body').slideToggle();
            $(this).find('i').toggleClass('dashicons-arrow-down-alt2 dashicons-arrow-up-alt2');
            $(this).parent().toggleClass('active');
        });
    });
</script>