<?php

if (! defined('ABSPATH')) {
    exit;
}

?>

<div id="http-player-addon" class="getting-started-content">

    <section class="section-introduction section-full">
        <div class="content-heading">
            <h2>
                <?php
                esc_html_e('Radio Player Proxy Add-on - Quick Overview', 'radio-player');
                ?>
            </h2>
        </div>

        <div class="col-full">

            <div class="rp-popup">
                <img src="<?php echo esc_url(RADIO_PLAYER_ASSETS . '/images/getting-started/proxy-player/overview.png') ?>" alt="<?php echo esc_attr__('Overview', 'radio-player'); ?>" />
                <button class="rp-play" type="button" data-video-id="M3M7ssz8URc">
                    <img src="<?php echo esc_url(RADIO_PLAYER_ASSETS . '/images/getting-started/play.svg') ?>" alt="<?php echo esc_attr__('Play Icon', 'radio-player'); ?>" />
                </button>
            </div>

            <p>
                <?php
                esc_html_e('Recent updates in Google Chrome have introduced stringent rules against mixed content.
As a result, if a stream link isn\'t SSL-encrypted but your website is, it won\'t play on Chrome.
Notably, many browsers are following Chrome\'s lead. Therefore, it\'s crucial to ensure your stream links are SSL-secured.
', 'radio-player');
                ?>
            </p>

            <p>
                <?php
                esc_html_e('Radio Player Proxy Add-on facilitates the playback of HTTP (non-SSL) radio streams on HTTPS-enabled websites. Serving as a bridge, it retrieves the radio stream and delivers it to the player as an HTTPS stream.', 'radio-player');
                ?>
            </p>
            <p>
                <?php
                esc_html_e('The add-n use an external VPS proxy server that allow you to play most of the HTTP streams in your HTTPS website.', 'radio-player');
                ?>
            </p>

            <p>
                <?php
                esc_html_e('Additionally, if your website server struggles to retrieve stream data, the plugin can display the current song title for you.', 'radio-player');
                ?>
            </p>

        </div>
    </section>



    <section class="section-radio-player-ads">
        <div class="content-heading">
            <h2>
                <?php
                esc_html_e('How to Play HTTP streams on HTTPS website', 'radio-player');
                ?>
            </h2>
        </div>

        <div class="col-description">

            <p>
                <?php
                esc_html_e('To play HTTP streams on an HTTPS (SSL-enabled) website, follow these steps:', 'radio-player');
                ?>
            </p>

            <ul>
                <li>
                    Navigate to <strong>Radio Player > Settings</strong>.
                </li>

                <li>
                    In the <strong>Proxy Settings</strong> tab, modify the following settings:

                    <ul>
                        <li>
                            <strong>Enable HTTP Proxy:</strong> Activate this setting to play HTTP streams directly on
                            your server by enabling its proxy system. Utilizing the proxy on your own server eliminates
                            reliance on third-party servers, making your radio streams faster and more flexible.
                        </li>
                        <li>
                            <strong>Proxy URL:</strong> If the player still doesn't work after enabling the HTTP player,
                            copy the proxy link and paste it into the Proxy URL input box.
                        </li>
                        <li>
                            <strong>Save and Check:</strong> Save the settings and check the players.
                        </li>
                    </ul>
                </li>
            </ul>

            <p></p>
            <p></p>

            <p>
                <strong><?php esc_html_e('Note: ', 'radio-player'); ?></strong>
                <?php esc_html_e('The proxy system might not support certain HTTP streams, such as .m3u8.', 'radio-player'); ?>
            </p>

            <p>
                <?php esc_html_e('If this occurs, utilize the plugin\'s Popup player feature for these streams. This player operates in HTTP mode, but to use it, you must disable the HTTP to HTTPS redirection on your website.', 'radio-player'); ?>
            </p>
            <p>
                <?php esc_html_e('HTTP to HTTPS redirection can be set up in multiple ways: through the .htaccess file, SSL WordPress plugins, Cloudflare, or cPanel server settings. Ensure it\'s disabled in all relevant areas.', 'radio-player'); ?>
            </p>

        </div>
    </section>

    <section class="section-radio-player-ads">

        <div class="content-heading">
            <h2><?php esc_html_e('How to Fix Metadata Display (current track title, artist, artwork)', 'radio-player'); ?></h2>
        </div>

        <div class="col-description">

            <p>
                <?php esc_html_e('Occasionally, due to server limitations, the stream data including current song title, artist name and artwork image and recent play history may not appear in the player.', 'radio-player'); ?>
            </p>
            <p>
                <?php esc_html_e('To resolve this and display the stream metadata in the player, follow the steps below', 'radio-player'); ?>
            </p>
            <ul>
                <li>
                    Navigate to <strong>Radio Player > Settings<strong>
                </li>

                <li>
                    In the <strong>Proxy Settings</strong> tab, enable the %1$s Metadata Proxy %2$s option. This will
                    facilitate fetching the stream metadata through the proxy server.
                </li>
                <li>
                    <strong>Save and Check:</strong> Save the settings and check the players for the stream metadata.
                </li>
            </ul>

            <p>
                <strong>
                    <?php esc_html_e('Note: ', 'radio-player'); ?>
                </strong>

                <?php esc_html_e('Not all streams may have metadata for display.', 'radio-player'); ?>
            </p>

        </div>
    </section>


</div>