<?php

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

$features = [
        'compatibility'      => [
                'title'       =>
                        esc_html__( 'MP3 + AAC + M3U8 Compatible', 'radio-player' ),
                'description' =>
                        esc_html__( 'Radio Player is compatible with MP3, AAC, and M3U8 streams. It also supports HLS streams.', 'radio-player' ),
        ],
        'shortcode-player'   => [
                'title'       =>
                        esc_html__( 'Shortcode Player', 'radio-player' ),
                'description' =>
                        esc_html__( 'Radio Player comes with a shortcode player that you can use to display your player anywhere on your site.', 'radio-player' ),
        ],
        'current-song-title' => [
                'title'       =>
                        esc_html__( 'Stream Data Display', 'radio-player' ),
                'description' =>
                        esc_html__( 'Radio Player can grab and display the stream metadata including current track title, artist and artwork, and recent play history on the player.', 'radio-player' ),
        ],

        'player-duplicator' => [
                'title'       => esc_html__( 'Player Duplicator', 'radio-player' ),
                'description' => esc_html__( 'Radio Player comes with a player duplicator that allows you to duplicate your previously created players with all the settings.', 'radio-player' ),
        ],

        'mobile-media-notification' => [
                'title'       => esc_html__( 'Mobile Media Notification', 'radio-player' ),
                'description' => esc_html__( 'Radio Player shows a media notification on mobile devices, allowing users to easily play or pause from the notification bar.', 'radio-player' ),
        ],

        'add-multiple-players' => [
                'title'       => esc_html__( 'Add Multiple Players', 'radio-player' ),
                'description' => esc_html__( 'Radio Player allows you to create upto 10 players in the free version and and can create unlimited players in the PRO version.', 'radio-player' ),
        ],

        'multiple-instances' => [
                'title'       => esc_html__( 'Multiple Instances', 'radio-player' ),
                'description' => esc_html__( 'Radio Player allows you to display multiple players on the same page.', 'radio-player' ),
        ],

        'custom-css' => [
                'title'       => esc_html__( 'Custom CSS', 'radio-player' ),
                'description' => esc_html__( 'Radio Player provides a Custom CSS feature to customize the player looks and styles.', 'radio-player' ),
        ],

        'color-customizations' => [
                'title'       => esc_html__( 'Color Customizations', 'radio-player' ),
                'description' => esc_html__( 'Radio Player allows you to customize the player text, button, background, and box-shadow colors.', 'radio-player' ),
        ],
        'play-statistics'      => [
                'title'       => esc_html__( 'Play Statistics', 'radio-player' ),
                'description' => esc_html__( 'Radio Player allows you to track the play statistics of your players. You can see the total number of play count, total number of listeners, and the most played players.', 'radio-player' ),
        ],
        'gutenberg-block'      => [
                'title'       => esc_html__( 'Gutenberg Block', 'radio-player' ),
                'description' => esc_html__( 'Radio Player comes with a Gutenberg block that you can use to display your player on any page or post.', 'radio-player' ),
        ],
        'elementor-widget'     => [
                'title'       => esc_html__( 'Elementor Widget', 'radio-player' ),
                'description' => esc_html__( 'Radio Player comes with an Elementor widget that you can use to display your player on any page or post.', 'radio-player' ),
        ],

];

$plugins = [
        [
                'key'   => 'integrate-google-drive',
                'title' => 'Integrate Google Drive',
                'desc'  => esc_html__( 'Complete Google Drive integration for WordPress.', 'radio-player' ),
                'user'  => 15,
                'color' => '#2FB44A',
        ],
        [
                'key'   => 'dracula-dark-mode',
                'title' => 'Dracula Dark Mode',
                'desc'  => esc_html__( 'Smooth Dark Mode & Better Accessibility for WordPress.', 'radio-player' ),
                'user'  => 5,
                'color' => '#9BE494',
        ],
        [
                'key'   => 'essential-addons-for-contact-form-7',
                'title' => 'Essential Addons for Contact Form 7',
                'desc'  => esc_html__( '50+ Fields, Features & Integrations Add-ons for Contact Form 7.', 'radio-player' ),
                'user'  => 1,
                'color' => '#33C6F4',
        ],
        [
                'key'   => 'soft-multimedia-player',
                'title' => 'Multimedia Player',
                'desc'  => esc_html__( 'Play Audio, Video & Podcasts Easily in WordPress.', 'radio-player' ),
                'user'  => 0,
                'color' => '#0156D7',
        ],
];

?>

<div id="introduction" class="getting-started-content active">

    <section class="section-introduction section-full">
        <div class="content-heading">
            <h2><?php echo esc_html__( 'Quick Overview', 'radio-player' ); ?></h2>
            <p><?php echo esc_html__( 'Live Shoutcast, Icecast and Audio Stream Player for WordPress', 'radio-player' ); ?></p>
        </div>

        <div class="col-full">
            <div class="rp-popup">
                <img src="<?php echo esc_url( RADIO_PLAYER_ASSETS . '/images/getting-started/home/overview.png' ) ?>"
                     alt="<?php echo esc_attr__( 'Radio Player Quick Overview', 'radio-player' ); ?>"/>

                <button class="rp-play" type="button"
                        data-video-id="60puFspgnK8"
                        aria-label="<?php echo esc_attr__( 'Play Overview Video', 'radio-player' ); ?>"
                        data-title="<?php echo esc_attr__( 'Radio Player Quick Overview', 'radio-player' ); ?>"
                >
                    <img src="<?php echo esc_url( RADIO_PLAYER_ASSETS . '/images/getting-started/play.svg' ) ?>"
                         alt="<?php echo esc_attr__( 'Play Icon', 'radio-player' ); ?>"/>
                </button>
            </div>

            <h3>
                <?php esc_html_e( 'Radio Player Quick Overview', 'radio-player' ); ?>
            </h3>

            <p>
                <?php esc_html_e( 'Radio Player is a user-friendly and easily customizable web radio player tailored for WordPress websites. It effortlessly connects to live MP3, Shoutcast, IceCast, and various other audio streams, providing a smooth listening experience for your visitors.', 'radio-player' ); ?>
            </p>

            <p>
                <?php esc_html_e( 'Incorporate the player into your site using simple options like shortcodes, Gutenberg blocks, Elementor widgets, sticky players, or popup players. With Radio Player, you can effortlessly enhance your WordPress website\'s appeal to users seeking an enjoyable web radio experience.', 'radio-player' ); ?>
            </p>
        </div>
    </section>

    <section class="section-features">

        <div class="features">
            <div class="content-heading">
                <h2><?php esc_html_e( 'Never miss a valuable features', 'radio-player' ); ?>
                </h2>
                <p><?php esc_html_e( 'Let\'s explore the powerful features of the plugin', 'radio-player' ); ?></p>
            </div>

            <div class="section-wrap">
                <section class="section-border section-half">
                    <div class="col-description">
                        <h2>
                            <?php
                            esc_html_e( 'Sticky Player', 'radio-player' );
                            ?>
                        </h2>
                        <p>
                            <?php
                            esc_html_e( 'Radio Player provides a Sticky Player feature that allows you to display the player on the bottom of the screen. You can choose to display the Sticky Player on all pages or specific pages.', 'radio-player' );
                            ?>
                        </p>
                    </div>

                    <div class="col-image">
                        <img src="<?php echo esc_url( RADIO_PLAYER_URL . '/assets/images/getting-started/fullwidth-player.png' ); ?>"
                             alt="<?php echo esc_attr__( 'Sticky Player Demo', 'radio-player' ); ?>">
                    </div>
                </section>

                <section class="section-border section-half">
                    <div class="col-description">
                        <h2>
                            <?php
                            esc_html_e( 'Player Display Schedule', 'radio-player' );
                            ?>
                        </h2>
                        <p>
                            <?php
                            esc_html_e( 'You can schedule the player visibility by setting the start date and end date. The player will be displayed on your website during the scheduled time.', 'radio-player' );
                            ?>
                        </p>
                    </div>

                    <div class="col-image">
                        <img src="<?php echo esc_url( RADIO_PLAYER_URL . '/assets/images/getting-started/schedule.png' ); ?>"
                             alt="<?php echo esc_attr__( 'Player Schedule Settings', 'radio-player' ); ?>">
                    </div>
                </section>
            </div>

            <div class="section-wrap">
                <section class="section-border section-half">
                    <div class="col-description">
                        <h2>
                            <?php
                            esc_html_e( 'Multiple Player Skins', 'radio-player' );
                            ?>
                        </h2>
                        <p>
                            <?php
                            esc_html_e( 'Radio Player provides 10+ player skins with different layouts and styles to choose from. You can choose any player skin from the skins library and display it anywhere on your website using the shortcode.', 'radio-player' );
                            ?>
                        </p>
                    </div>

                    <div class="col-image">
                        <img src="<?php echo esc_url( RADIO_PLAYER_URL . '/assets/images/getting-started/multiple-skins.png' ); ?>"
                             alt="<?php echo esc_attr__( 'Player Skins Preview', 'radio-player' ); ?>">
                    </div>
                </section>

                <section class="section-border section-half">
                    <div class="col-description">
                        <h2>
                            <?php
                            esc_html_e( 'Multiple Stations Playlist', 'radio-player' );
                            ?>
                        </h2>
                        <p>
                            <?php
                            esc_html_e( 'You can add and display multiple radio stations in the same player. Users can play the stations by using the next/ previous button in the player.', 'radio-player' );
                            ?>
                        </p>
                    </div>
                    <div class="col-image">
                        <img src="<?php echo esc_url( RADIO_PLAYER_URL . '/assets/images/getting-started/multiple-stations.png' ); ?>"
                             alt="<?php echo esc_attr__( 'Multiple Stations Demo', 'radio-player' ); ?>">
                    </div>
                </section>
            </div>

            <div class="section-wrap">
                <section class="section-border section-half">
                    <div class="col-description">
                        <h2><?php esc_html_e( 'Popup Player', 'radio-player' ); ?></h2>
                        <p>
                            <?php
                            esc_html_e( 'Radio Player provides a Popup Player feature that allows you to display the player in a popup window. You can choose to display the Popup Player on all pages or specific pages.', 'radio-player' );
                            ?>
                        </p>
                    </div>

                    <div class="col-image">
                        <img src="<?php echo esc_url( RADIO_PLAYER_URL . '/assets/images/getting-started/popup-player.png' ); ?>"
                             alt="<?php echo esc_attr__( 'Popup Player Demo', 'radio-player' ); ?>">
                    </div>
                </section>

                <section class="section-border section-half">
                    <div class="col-description">
                        <h2>
                            <?php
                            esc_html_e( 'Player Embed Code', 'radio-player' );
                            ?>
                        </h2>
                        <p>
                            <?php
                            esc_html_e( 'You can embed the player anywhere on your website using the embed code. You can also customize the player appearance with the embed code.', 'radio-player' );
                            ?>
                        </p>
                    </div>

                    <div class="col-image">
                        <img src="<?php echo esc_url( RADIO_PLAYER_URL . '/assets/images/getting-started/embed-code.png' ); ?>"
                             alt="<?php echo esc_attr__( 'Embed Code Example', 'radio-player' ); ?>">
                    </div>
                </section>
            </div>

            <section class="section-border section-full">
                <div class="col-description">
                    <h2><?php esc_html_e( 'Realtime Player Editing Preview', 'radio-player' ); ?></h2>
                    <p><?php esc_html_e( 'You can customize the player appearance with a real-time preview. You can change the player colors, background color, background image, width, border radius, box shadow, and more.', 'radio-player' ); ?></p>
                </div>

                <div class="col-image">
                    <img src="<?php echo esc_url( RADIO_PLAYER_URL . '/assets/images/getting-started/realtime-preview.gif' ); ?>"
                         alt="<?php echo esc_attr__( 'Real-time Preview Demo', 'radio-player' ); ?>">
                </div>
            </section>
        </div>

        <div class="show-all-btn-wrap">
            <button type="button" class="radio-player-btn btn-primary show-all-btn" aria-label="Show All Features">
                <?php esc_html_e( 'Explore More Features', 'radio-player' ); ?>
                <i class="dashicon dashicons dashicons-arrow-down-alt2"></i>
            </button>
        </div>

    </section>

    <section class="section-integrations">

        <div class="content-heading">
            <h2><?php esc_html_e( 'More powerful features', 'radio-player' ); ?></h2>
            <p><?php esc_html_e( 'More extra valuable features to power up your website readability.', 'radio-player' ); ?></p>
        </div>

        <div class="integrations">
            <?php foreach ( $features as $key => $feature ) { ?>
                <div class="integration">
                    <div class="integration-logo">
                        <img src="<?php echo esc_url( RADIO_PLAYER_ASSETS . '/images/getting-started/' . $key . '.png' ); ?>"
                             alt="<?php echo esc_attr( sprintf( __( '%s Feature Icon', 'radio-player' ), esc_attr( $feature['title'] ) ) ); ?>">
                    </div>
                    <h3 class="integration-title"><?php echo esc_html( $feature['title'] ); ?></h3>
                    <p><?php echo esc_html( $feature['description'] ); ?></p>
                </div>
            <?php } ?>
        </div>

        <div class="show-all-btn-wrap">
            <button type="button" class="radio-player-btn btn-primary show-all-btn" aria-label="Show All Features">
                <?php esc_html_e( 'Show More Features', 'radio-player' ); ?>
                <i class="dashicon dashicons dashicons-arrow-down-alt2"></i>
            </button>
        </div>

    </section>

    <section class="section-popular-plugins section-full">
        <div class="content-heading">
            <h2>
                <?php
                esc_html_e( 'Explore Our Popular Plugins You Might Love.', 'radio-player' );
                ?>
            </h2>
            <p>
                <?php
                esc_html_e( 'Radio Player is developed by the same team behind some of the most popular WordPress plugins.', 'radio-player' );
                ?>
            </p>
        </div>


        <div class="popular-plugins-wrap">
            <?php

            foreach ( $plugins as $index => $item ) {
                $plugin_img_url = RADIO_PLAYER_ASSETS . '/images/getting-started/plugins/' . $item['key'] . '.png';
                $install_url    = admin_url( "plugin-install.php?tab=plugin-information&plugin={$item['key']}" );
                $learn_more_url = esc_url( "https://softlabbd.com/{$item['key']}" );
                ?>
                <div class="popular-plugin-item">
                    <img src="<?php echo esc_url( $plugin_img_url ); ?>"
                         alt="<?php echo esc_attr( $item['title'] ); ?>"/>

                    <div class="plugin-info">
                        <h3><?php echo esc_html( $item['title'] ); ?></h3>
                        <p><?php echo esc_html( $item['desc'] ); ?></p>
                        <div class="users-count" style="<?php echo '--plugin-color: ' . $item['color']; ?>">
                            <i class="dashicons dashicons-admin-users"></i>
                            <?php echo ! empty( $item['user'] ) ? sprintf( '%1$sK+ Active Users', esc_html( $item['user'] ) ) : esc_html__( 'New Plugin', 'radio-player' ); ?>
                        </div>
                    </div>

                    <div class="button-group">

                        <a class="radio-player-btn btn-info" href="<?php echo esc_url( $learn_more_url ); ?>"
                           target="_blank">
                            <i class="dashicons dashicons-external"></i>
                            <?php esc_html_e( 'Learn More', 'radio-player' ); ?>
                        </a>

                        <a class="radio-player-btn btn-primary" href="<?php echo esc_url( $install_url ); ?>">
                            <i class="dashicons dashicons-admin-plugins"></i>
                            <?php esc_html_e( 'Install Now', 'radio-player' ); ?>
                        </a>


                    </div>
                </div>
            <?php } ?>
        </div>
    </section>

</div>
<script>
    // Handle show all button
    jQuery(document).ready(function ($) {
        $(document).on('click', '.show-all-btn', function () {
            $(this).closest('.section-features, .section-integrations').addClass('show');
        });

    });
</script>