<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$base_assets = RADIO_PLAYER_ASSETS . '/images/getting-started/header/';

/**
 * Getting Started Menu Configuration
 */
$menu_items = [
        [
                'id'    => 'introduction',
                'icon'  => 'home.svg',
                'label' => __( 'Home', 'radio-player' ),
                'pro'   => false,
        ],

        [
                'id'    => 'add-ons',
                'icon'  => 'add-ons.svg',
                'label' => __( 'Add-ons', 'radio-player' ),
                'pro'   => false,
        ],
        [
                'id'    => 'help',
                'icon'  => 'help.svg',
                'label' => __( 'Help', 'radio-player' ),
                'pro'   => false,
        ],
        [
                'id'    => 'what-new',
                'icon'  => 'changelog.svg',
                'label' => __( 'Changelog', 'radio-player' ),
                'pro'   => false,
        ],
];

// Add "Get Pro" only if Pro is NOT active
if ( ! radio_player()->is_pro_active() ) {
    $menu_items[] = [
            'id'    => 'get-pro',
            'icon'  => 'get-pro.svg',
            'label' => __( 'Get Pro', 'radio-player' ),
            'pro'   => true,
    ];
}

?>

<div class="radio-player-getting-started">

    <!-- Header -->
    <div class="getting-started-header">

        <div class="header-logo">
            <img src="<?php echo esc_url( RADIO_PLAYER_ASSETS . '/images/radio-player-logo.png' ); ?>"
                 alt="<?php echo esc_attr__( 'Radio Player Logo', 'radio-player' ); ?>">

            <div class="header-title">
                <h1><?php esc_html_e( 'Radio Player', 'radio-player' ); ?></h1>
                <p><?php esc_html_e( 'Live Shoutcast, Icecast & Audio Stream Player', 'radio-player' ); ?></p>
            </div>
        </div>

        <div class="header-actions">
            <a href="https://softlabbd.com/docs-category/radio-player/"
               target="_blank"
               class="button docs">
                <img src="<?php echo esc_url( $base_assets . 'docs.svg' ); ?>"
                     alt="<?php echo esc_attr__( 'Documentation Icon', 'radio-player' ); ?>">
                <?php esc_html_e( 'Documentation', 'radio-player' ); ?>
            </a>

            <?php if ( ! radio_player()->is_pro_active() ) : ?>
                <a href="https://softlabbd.com/radio-player-pricing/"
                   target="_blank"
                   class="button upgrade buy-btn-pro">
                    <img src="<?php echo esc_url( $base_assets . 'upgrade.svg' ); ?>"
                         alt="<?php echo esc_attr__( 'Upgrade Icon', 'radio-player' ); ?>">
                    <?php esc_html_e( 'Upgrade Now', 'radio-player' ); ?>
                </a>
            <?php endif; ?>
        </div>

    </div>


    <!-- Main Layout -->
    <div class="getting-started-main">

        <!-- Menu -->
        <div class="getting-started-menu">

            <?php foreach ( $menu_items as $index => $item ) : ?>
                <div class="menu-item <?php echo $index === 0 ? 'active' : ''; ?>"
                     data-target="<?php echo esc_attr( $item['id'] ); ?>">

                    <img src="<?php echo esc_url( $base_assets . $item['icon'] ); ?>"
                         alt="<?php echo esc_attr( $item['label'] . ' Icon' ); ?>">

                    <span><?php echo esc_html( $item['label'] ); ?></span>

                </div>
            <?php endforeach; ?>

        </div>


        <!-- Content Sections -->
        <?php

        $views = [
                'introduction',
                'what-new',
                'add-ons',
                'help',
        ];

        foreach ( $views as $view ) {
            include_once RADIO_PLAYER_INCLUDES . "/views/getting-started/{$view}.php";
        }

        if ( ! radio_player()->is_pro_active() ) {
            include_once RADIO_PLAYER_INCLUDES . '/views/getting-started/get-pro.php';
        }

        ?>

    </div>
</div>
