<?php

if (! defined('ABSPATH')) {
    exit;
}

$faqs = [
    [
        'question' => /* translators: FAQ question about whether HTTP streams can play on HTTPS sites */
        esc_html__('Can I play HTTP stream on my HTTPS website?', 'radio-player'),
        'answer'   => /* translators: FAQ answer explaining HTTP/HTTPS stream compatibility */
        esc_html__('Browsers no longer accept mixed requests. That means you can\'t play an HTTP stream on an HTTPS website. However, this plugin uses a proxy system to play most HTTP streams on your HTTPS website.', 'radio-player'),
    ],
    [
        'question' => /* translators: FAQ question about song title display not working */
        esc_html__('Why is the current song title not displaying in the player?', 'radio-player'),
        'answer'   => /* translators: FAQ answer about troubleshooting song title display issues */
        esc_html__('There could be several reasons why the current song title isn\'t displaying on your player. One common reason is that the player is not receiving the stream metadata from the server. This can happen if the server doesn\'t provide the metadata, or if the player is not configured to display it.

To troubleshoot this issue, you can try the following steps:

1. Check if the stream has metadata: If the metadata is not present, then it won\'t be possible to display the current song title on the player. 

2. Make sure the "Show Track Title" setting is enabled in the player controls settings.

3. Make sure allow_url_fopen is enabled on the server: If allow_url_fopen is disabled on the server, the player won\'t be able to retrieve the metadata from the stream. You can contact your web host to enable this setting or modify the server configuration yourself if you have access.

4. If the stream title still not showing then try to enable the Metadata Proxy settings from the HTTP player settings tab in the plugin settings page.

5. If you\'ve tried these steps and still can\'t display the current song title on your player, please don\'t hesitate to contact us for further assistance.', 'radio-player'),
    ],
    [
        'question' => /* translators: FAQ question about multiple radio stations support */
        esc_html__('Can I add and display multiple radio stations in the same player?', 'radio-player'),
        'answer'   => /* translators: FAQ answer about configuring multiple stations */
        esc_html__('Yes, you can add and display multiple radio stations in the same player. While you create a new player, you can add multiple radio stations with Title, Stream URL and Image from the stations tab. They will display as stations playlist in the player.', 'radio-player'),
    ],
    [
        'question' => /* translators: FAQ question about configuring sticky player */
        esc_html__('How can I display the sticky player?', 'radio-player'),
        'answer'   => /* translators: FAQ answer about enabling sticky player functionality */
        esc_html__('To display the sticky player, you need to select the Player that you want to display as a sticky player from the "Radio Player > Sticky Player Settings".', 'radio-player'),
    ],
    [
        'question' => /* translators: FAQ question about page-specific sticky player */
        esc_html__('How can I display the sticky player only on specific pages?', 'radio-player'),
        'answer'   => /* translators: FAQ answer about configuring sticky player page visibility */
        esc_html__('By default, the sticky player will be displayed on all pages. But, You can also show the sticky player only on specific pages by excluding the pages from the "Radio Player > Settings > Sticky Player Settings".', 'radio-player'),
    ],
    [
        'question' => /* translators: FAQ question about popup player functionality */
        esc_html__('How can I display the popup player?', 'radio-player'),
        'answer'   => /* translators: FAQ answer about configuring popup player */
        esc_html__('There is a popup icon option for the player. You can show/hide the player\'s popup control, and when users click on it, the player will open within a new popup window.', 'radio-player'),
    ],
    [
        'question' => /* translators: FAQ question about embedding player on other sites */
        esc_html__('Can I embed a radio player on another website?', 'radio-player'),
        'answer'   => /* translators: FAQ answer about player embedding functionality */
        esc_html__('Yes, you can embed a radio player on another website. You can find the embed code on the player listing page. Just click on the Embed button and copy the embed code. Then paste the embed code on any website.', 'radio-player'),
    ],
    [
        'question' => /* translators: FAQ question about viewing player statistics */
        esc_html__('How can I view the play statistics for my radio player?', 'radio-player'),
        'answer'   => /* translators: FAQ answer about accessing player statistics */
        esc_html__('To view the play statistics for your radio player, navigate to "Radio Player > Statistics". Here, you can see the number of plays, the total play duration, and the top played stations.', 'radio-player'),
    ],
    [
        'question' => /* translators: FAQ question about customizing player appearance */
        esc_html__('How can I customize the appearance of the radio player?', 'radio-player'),
        'answer'   => /* translators: FAQ answer about player customization options */
        esc_html__('You can customize the appearance of the radio player using custom CSS. Navigate to "Radio Player > Settings > Custom CSS" to add your CSS code. You can also choose from multiple player skins and customize the popup player size, header, and footer content, and color scheme from the settings page.', 'radio-player'),
    ],
    [
        'question' => /* translators: FAQ question about mobile device compatibility */
        esc_html__('Is the radio player compatible with mobile devices?', 'radio-player'),
        'answer'   => /* translators: FAQ answer about mobile support and responsiveness */
        esc_html__('Yes, the radio player is compatible with mobile devices and supports mobile media notifications. The player will automatically adjust its size and appearance based on the device\'s screen size.', 'radio-player'),
    ],
];
?>

<div id="help" class="getting-started-content">
    <section class="section-help section-full">
        <div class="content-heading">
            <h2><?php
                /* translators: Section heading for FAQs */
                esc_html_e('Frequently Asked Questions', 'radio-player');
                ?></h2>
            <p><?php esc_html_e('Find quick answers to common queries in our FAQ section.', 'radio-player'); ?></p>
        </div>

        <section class="section-faq">
            <?php foreach ($faqs as $faq) : ?>
                <div class="faq-item">
                    <div class="faq-header">
                        <h3><?php echo esc_html($faq['question']); ?></h3>
                        <i class="dashicons dashicons-arrow-down-alt2"></i>
                    </div>

                    <div class="faq-body">
                        <p><?php echo wp_kses($faq['answer'], array(
                                'code' => array(),
                                'br' => array(),
                                'b' => array(),
                                'strong' => array(),
                                'ol' => array(),
                                'li' => array(),
                            )); ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
        </section>
    </section>

    <section class="section-help section-full">
        <div class="content-heading">
            <h2><?php esc_html_e('Need Help?', 'radio-player'); ?></h2>
            <p><?php esc_html_e('Read our knowledge base documentation or you can contact us directly.', 'radio-player'); ?></p>
        </div>

        <div class="section-wrap">
            <div class="section-documentation section-half">
                <div class="col-image">
                    <img src="<?php echo esc_url(RADIO_PLAYER_ASSETS . '/images/getting-started/help/documentation.png'); ?>" alt="<?php esc_attr_e('Documentation', 'radio-player'); ?>">
                </div>
                <div class="col-description">
                    <h3><?php esc_html_e('Documentation', 'radio-player'); ?></h3>
                    <p>
                        <?php esc_html_e('Check out our online documentation and video tutorials to find out more about what you can do.', 'radio-player'); ?>
                    </p>
                    <a class="radio-player-btn" href="https://softlabbd.com/docs-category/radio-player/" target="_blank">
                        <img src="<?php echo esc_url(RADIO_PLAYER_ASSETS . '/images/getting-started/help/docs.svg'); ?>" alt="icon" />
                        <?php esc_html_e('Documentation', 'radio-player'); ?>
                    </a>
                </div>
            </div>

            <div class="section-contact section-half">
                <div class="col-image">
                    <img src="<?php echo esc_url(RADIO_PLAYER_ASSETS . '/images/getting-started/help/contact.png'); ?>" alt="<?php esc_attr_e('Contact', 'radio-player'); ?>">
                </div>
                <div class="col-description">
                    <h3><?php esc_html_e('Support', 'radio-player'); ?></h3>
                    <p><?php esc_html_e('We have dedicated support team to provide you fast, friendly & top-notch customer support.', 'radio-player'); ?></p>
                    <a class="radio-player-btn" href="https://softlabbd.com/support" target="_blank">
                        <img src="<?php echo esc_url(RADIO_PLAYER_ASSETS . '/images/getting-started/help/support.svg'); ?>" alt="icon" />
                        <?php esc_html_e('Get Support', 'radio-player'); ?>
                    </a>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
    jQuery(document).ready(function($) {
        $('.faq-item .faq-header').on('click', function() {
            $(this).parent().toggleClass('active');
        });
    });
</script>