<?php

defined('ABSPATH') or die('No script kiddies please!');

$features = [
	[
		'title' =>
		esc_html__('Shortcode Player', 'radio-player'),
		'pro'   => 0,
	],
	[
		'title' =>
		esc_html__('MP3 + AAC + M3U8 Compatibility', 'radio-player'),
		'pro'   => 0,
	],
	[
		'title' =>
		esc_html__('Current Song Title', 'radio-player'),
		'pro'   => 0,
	],
	[
		'title' =>
		esc_html__('Add Multiple Players', 'radio-player'),
		'pro'   => 0,
	],
	[
		'title' =>
		esc_html__('Player Duplicator', 'radio-player'),
		'pro'   => 0,
	],
	[
		'title' =>
		esc_html__('Live Player Editing Preview', 'radio-player'),
		'pro'   => 0,
	],
	[
		'title' =>
		esc_html__('Multiple Player Instance', 'radio-player'),
		'pro'   => 0,
	],
	[
		'title' =>
		esc_html__('Mobile Media Notification', 'radio-player'),
		'pro'   => 0,
	],
	[
		'title' =>
		esc_html__('Gutenberg Editor Block', 'radio-player'),
		'pro'   => 0,
	],
	[
		'title' =>
		esc_html__('Elementor Page Builder Widget', 'radio-player'),
		'pro'   => 0,
	],
	[
		'title' =>
		esc_html__('Custom CSS', 'radio-player'),
		'pro'   => 0,
	],
	[
		'title' =>
		esc_html__('Full-width Sticky Player', 'radio-player'),
		'pro'   => true,
	],
	[
		'title' =>
		esc_html__('Sticky Player on Specific Pages', 'radio-player'),
		'pro'   => true,
	],
	[
		'title' =>
		esc_html__('Multiple Stations in a Player', 'radio-player'),
		'pro'   => true,
	],
	[
		'title' =>
		esc_html__('Multiple Player Skins', 'radio-player'),
		'pro'   => true,
	],
	[
		'title' =>
		esc_html__('Stations Playlist', 'radio-player'),
		'pro'   => true,
	],
	[
		'title' =>
		esc_html__('Recent Play History', 'radio-player'),
		'pro'   => true,
	],
	[
		'title' =>
		esc_html__('Artist + Artwork Display', 'radio-player'),
		'pro'   => true,
	],
	[
		'title' =>
		esc_html__('Play Statistics', 'radio-player'),
		'pro'   => true,
	],
	[
		'title' =>
		esc_html__('Popup Player', 'radio-player'),
		'pro'   => true,
	],
	[
		'title' =>
		esc_html__('Player Embed', 'radio-player'),
		'pro'   => true,
	],
	[
		'title' =>
		esc_html__('Size Customizations', 'radio-player'),
		'pro'   => true,
	],
	[
		'title' =>
		esc_html__('Color Customizations', 'radio-player'),
		'pro'   => true,
	],
];

$reviews = [
	[
		'title' 	=> esc_html__('“Best Radio Player Available', 'radio-player'),
		'review' 	=> esc_html__('We spent several days reviewing the available Wordpress radio players for streaming and this was by far the best one available that could work on every Wordpress theme. Highly recommended!”', 'radio-player'),
		'author' 	=> esc_html__('Collabo', 'radio-player'),
		'thumbnail' => esc_url(RADIO_PLAYER_ASSETS . '/images/getting-started/get-pro/collabo.png'),
	],
	[
		'title' 	=> esc_html__('#1 Radio Player Plugin', 'radio-player'),
		'review' 	=> esc_html__('This plugin works as advertised! Most importantly the support team was very responsive to my emails and helped me figure out why my stream URL didn’t worked and provided a solution.', 'radio-player'),
		'author' 	=> esc_html__('Tom Pennington', 'radio-player'),
		'thumbnail' => esc_url(RADIO_PLAYER_ASSETS . '/images/getting-started/get-pro/tom-pennington.png'),
	],
	[
		'title' 	=> esc_html__('PERFECT!', 'radio-player'),
		'review' 	=> esc_html__('Perfect! The pro version helped me to get rid of some https problems and now everyone can hear my broadcasts!', 'radio-player'),
		'author' 	=> esc_html__('Per Kindwall', 'radio-player'),
		'thumbnail' => esc_url(RADIO_PLAYER_ASSETS . '/images/getting-started/get-pro/per-kindwall.png'),
	],
	[
		'title' 	=> esc_html__('PERFECTO, FUNCIONA MUY BIEN!', 'radio-player'),
		'review' 	=> esc_html__('Merece la pena la versión pro, funciona de maravilla!', 'radio-player'),
		'author' 	=> esc_html__('CentroWebs S.C.', 'radio-player'),
		'thumbnail' => esc_url(RADIO_PLAYER_ASSETS . '/images/getting-started/get-pro/controlwebs.png'),
	],
]

?>

<div id="get-pro" class="getting-started-content content-get-pro">
	<section class="section-pricing">
		<div class="content-heading">
			<h2>
				<?php esc_html_e('Simple Pricing, Unbeatable Value', 'radio-player'); ?>
			</h2>
			<p>
				<?php esc_html_e('Join 10000+ User\'s Happy Community', 'radio-player'); ?>
			</p>
		</div>

		<div class="pricing">
			<div class="pricing-switcher">
				<span class="switch-text annual">Annual</span>
				<span class="switch"></span>
				<span class="switch-text lifetime">Lifetime</span>
			</div>

			<div class="pricing-container">
				<!-- 1 license card -->
				<div class="pricing-card card-blue ">

					<h3>Personal</h3>
					<p>Perfect for individuals</p>
					<div class="price-text license-1 annual">

						<div class="offer-price annual single">
							<div class="price-offer">
								<p class="price-off">$50 </p>
								<span class="price-dis">30%OFF</span>
							</div>
						</div>

						<span class="price-value annual single">39</span>
						<div class="offer-price lifetime single">
							<div class="price-offer">
								<p class="price-off">$167 </p>
								<span class="price-dis">30%OFF</span>
							</div>
						</div>
						<span class="price-value lifetime single">129</span>
						<span class="price-suffix annual">/ Per year</span>
						<span class="price-suffix lifetime">/ Billed once</span>
					</div>
					<div class="plan-name " data-license="1">Single-site license</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>All Free Features</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Full-width Sticky Player</span>
					</div>

					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Multiple Stations in a Player</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Multiple Player Skins</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Stations Playlist</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Play Statistics</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Popup Player</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Size Customizations</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Color Customizations</span>
					</div>
					<div class="pricing-btn">
						<a href="#features" class="features-btn">See All Features <i class="dashicons dashicons-arrow-right-alt"></i></a>
						<a href="#" class="buy-btn-pro buy-btn-single btn-blue">Get Started</a>
					</div>
				</div>
				<!-- two license card -->
				<div class="pricing-card card-orange">
					<h3>Essentials</h3>
					<p>Great for small teams</p>
					<div class="price-text license-2 annual">
						<div class="offer-price annual two">
							<div class="price-offer">
								<p class="price-off">$76 </p>
								<span class="price-dis">30%OFF</span>
							</div>
						</div>
						<span class="price-value annual two">59</span>
						<div class="offer-price lifetime two">
							<div class="price-offer">
								<p class="price-off">$232</p>
								<span class="price-dis">30%OFF</span>
							</div>
						</div>
						<span class="price-value lifetime two">179</span>
						<span class="price-suffix annual">/ Per year</span>
						<span class="price-suffix lifetime">/ Billed once</span>
					</div>

					<div class="plan-name " data-license="2">2-sites license</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>All Free Features</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Full-width Sticky Player</span>
					</div>

					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Multiple Stations in a Player</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Multiple Player Skins</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Stations Playlist</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Play Statistics</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Popup Player</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Size Customizations</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Color Customizations</span>
					</div>
					<div class="pricing-btn">
						<a href="#features" class="features-btn">See All Features <i class="dashicons dashicons-arrow-right-alt"></i></a>
						<a href="#" class="buy-btn-pro buy-btn-two btn-orange">Get Started</a>
					</div>
				</div>
				<!-- five license card -->
				<div class="pricing-card card-profesion">
					<div class="card-profe text-center">
						<h3>Most Popular</h3>
					</div>

					<div class="pricing-card card-green">

						<h3>Professional</h3>
						<p>Built for agencies</p>
						<div class="price-text license-5 annual">


							<div class="offer-price annual five">
								<div class="price-offer">
									<p class="price-off">$128 </p>
									<span class="price-dis">30%OFF</span>
								</div>

							</div>

							<span class="price-value annual five">99</span>

							<div class="offer-price lifetime five">
								<div class="price-offer">
									<p class="price-off">$258 </p>
									<span class="price-dis">30%OFF</span>
								</div>

							</div>

							<span class="price-value lifetime five">199</span>

							<span class="price-suffix annual">/ Per year</span>
							<span class="price-suffix lifetime">/ Billed once</span>
						</div>

						<div class="plan-name " data-license="5">5-sites license</div>
						<div class="feature-item">
							<i class="dashicons dashicons-yes"></i>
							<span>All Free Features</span>
						</div>
						<div class="feature-item">
							<i class="dashicons dashicons-yes"></i>
							<span>Full-width Sticky Player</span>
						</div>

						<div class="feature-item">
							<i class="dashicons dashicons-yes"></i>
							<span>Multiple Stations in a Player</span>
						</div>
						<div class="feature-item">
							<i class="dashicons dashicons-yes"></i>
							<span>Multiple Player Skins</span>
						</div>
						<div class="feature-item">
							<i class="dashicons dashicons-yes"></i>
							<span>Stations Playlist</span>
						</div>
						<div class="feature-item">
							<i class="dashicons dashicons-yes"></i>
							<span>Play Statistics</span>
						</div>
						<div class="feature-item">
							<i class="dashicons dashicons-yes"></i>
							<span>Popup Player</span>
						</div>
						<div class="feature-item">
							<i class="dashicons dashicons-yes"></i>
							<span>Size Customizations</span>
						</div>
						<div class="feature-item">
							<i class="dashicons dashicons-yes"></i>
							<span>Color Customizations</span>
						</div>
						<div class="pricing-btn">
							<a href="#features" class="features-btn">See All Features <i class="dashicons dashicons-arrow-right-alt"></i></a>
							<a href="#" class="buy-btn-pro buy-btn-five btn-green">Get Started</a>
						</div>
					</div>
				</div>
				<!-- hundred license card -->
				<div class="pricing-card card-pink">
					<h3>Business</h3>
					<p>Powerful for enterprises</p>
					<div class="price-text license-100 annual">

						<div class="offer-price annual hundred">
							<div class="price-offer">
								<p class="price-off">$258 </p>
								<span class="price-dis">30%OFF</span>
							</div>

						</div>

						<span class="price-value annual hundred">199</span>
						<div class="offer-price lifetime hundred">
							<div class="price-offer">
								<p class="price-off">$518 </p>
								<span class="price-dis">30%OFF</span>
							</div>

						</div>
						<span class="price-value lifetime hundred">399</span>

						<span class="price-suffix annual">/ Per year</span>
						<span class="price-suffix lifetime">/ Billed once</span>
					</div>

					<div class="plan-name " data-license="100">100-sites license</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>All Free Features</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Full-width Sticky Player</span>
					</div>

					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Multiple Stations in a Player</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Multiple Player Skins</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Stations Playlist</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Play Statistics</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Popup Player</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Size Customizations</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Color Customizations</span>
					</div>
					<div class="pricing-btn">
						<a href="#features" class="features-btn">See All Features <i class="dashicons dashicons-arrow-right-alt"></i></a>
						<a href="#" class="buy-btn-pro buy-btn-hundred btn-pink">Get Started</a>
					</div>
				</div>
				<!-- unlimited license card -->
				<div class="pricing-card card-sky-blue">
					<h3>Enterprise</h3>
					<p>Limitless growth</p>
					<div class="price-text license-unlimited annual">

						<div class="offer-price annual unlimited">
							<div class="price-offer">
								<p class="price-off">$388 </p>
								<span class="price-dis">30%OFF</span>
							</div>

						</div>

						<span class="price-value annual unlimited ">259</span>

						<div class="offer-price lifetime unlimited ">
							<div class="price-offer">
								<p class="price-off">$648 </p>
								<span class="price-dis">30%OFF</span>
							</div>

						</div>

						<span class="price-value lifetime unlimited">499</span>

						<span class="price-suffix annual">/ Per year</span>
						<span class="price-suffix lifetime">/ Billed once</span>
					</div>

					<div class="plan-name " data-license="unlimited">Unlimited-sites license</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>All Free Features</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Full-width Sticky Player</span>
					</div>

					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Multiple Stations in a Player</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Multiple Player Skins</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Stations Playlist</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Play Statistics</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Popup Player</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Size Customizations</span>
					</div>
					<div class="feature-item">
						<i class="dashicons dashicons-yes"></i>
						<span>Color Customizations</span>
					</div>
					<div class="pricing-btn">
						<a href="#features" class="features-btn">See All Features <i class="dashicons dashicons-arrow-right-alt"></i></a>
						<a href="#" class="buy-btn-pro buy-btn-unlimited btn-sky-blue">Get Started</a>
					</div>
				</div>
			</div>
		</div>
	</section>

	<section class="section-moneyback section-full">
		<div class="content-heading">
			<h2><?php esc_html_e('7-day money back guarantee', 'radio-player'); ?></h2>
			<p>
				<?php esc_html_e('We guarantee our help & support service. However, if you have any bug/issues with our plugin and we are unable to resolve the issue, we’ll happily refund the full amount of your money within 7 days of your purchase. Read More', 'radio-player'); ?>
			</p>
		</div>

		<img src="<?php echo esc_url(RADIO_PLAYER_ASSETS . '/images/getting-started/get-pro/payments.png'); ?>" class="payments" alt="moneyback" />
	</section>

	<section class="section-get-pro" id="features">
		<div class="content-heading">
			<h2>
				<?php
				esc_html_e('Unlock the full power of the Radio Player', 'radio-player');
				?>
			</h2>
			<p>
				<?php
				esc_html_e('Upgrade to the Pro version to get more powerful features and premium support.', 'radio-player');
				?>
			</p>
		</div>

		<div class="content-heading free-vs-pro">
			<h2>
				<span>
					<?php
					esc_html_e('Free', 'radio-player'); ?>
				</span>
				vs
				<span>
					<?php
					esc_html_e('Pro', 'radio-player');
					?>
				</span>
			</h2>
		</div>

		<div class="features-list">
			<div class="list-header">
				<div class="feature-title">
					<?php
					esc_html_e('Feature List', 'radio-player');
					?>
				</div>
				<div class="feature-free">
					<?php
					esc_html_e('Free', 'radio-player');
					?>
				</div>
				<div class="feature-pro">
					<?php
					esc_html_e('Pro', 'radio-player');
					?>
				</div>
			</div>

			<?php foreach ($features as $feature) : ?>
				<div class="feature">
					<div class="feature-title"><?php echo esc_html($feature['title']); ?></div>
					<div class="feature-free">
						<?php if ($feature['pro']) : ?>
							<i class="dashicons dashicons-no-alt"></i>
						<?php else : ?>
							<i class="dashicons dashicons-saved"></i>
						<?php endif; ?>
					</div>
					<div class="feature-pro">
						<i class="dashicons dashicons-saved"></i>
					</div>
				</div>
			<?php endforeach; ?>

		</div>
	</section>

	<section class="section-reviews">
		<div class="content-heading">
			<h2>
				<?php
				esc_html_e('What People Think About Our Products', 'radio-player');
				?>
			</h2>
			<p>
				<?php
				esc_html_e('We Ensuring high-quality products is one way to  help you get consumers to appreciate', 'radio-player');
				?>
			</p>
		</div>

		<div class="reviews">
			<?php foreach ($reviews as $review) : ?>
				<div class="review-item">
					<img src="<?php echo esc_url(RADIO_PLAYER_ASSETS . '/images/getting-started/get-pro/quote.svg'); ?>" class="quote" alt="review-1" />
					<h3>
						<?php echo $review['title']; ?>
					</h3>
					<div class="rating">
						<i class="dashicons dashicons-star-filled"></i>
						<i class="dashicons dashicons-star-filled"></i>
						<i class="dashicons dashicons-star-filled"></i>
						<i class="dashicons dashicons-star-filled"></i>
						<i class="dashicons dashicons-star-filled"></i>
					</div>
					<p> <?php echo $review['review']; ?> </p>
					<div class="author">
						<img src="<?php echo esc_url($review['thumbnail']); ?>" />
						<p><?php echo $review['author']; ?></p>
					</div>
				</div>
			<?php endforeach; ?>
		</div>
	</section>

	<section class="section-cta">
		<div class="get-pro-cta">
			<div class="cta-content">
				<h2>
					<?php
					esc_html_e('Don\'t waste time, get the PRO version now!', 'radio-player');
					?>
				</h2>
				<p>
					<?php
					esc_html_e('Upgrade to the PRO version of the plugin and unlock all the amazing Google Drive Integration features for your website.', 'radio-player');
					?>
				</p>
			</div>

			<div class="cta-btn">
				<a href="https://softlabbd.com/radio-player-pricing" target="_blank" class="radio-player-btn buy-btn-pro">
					<img src="<?php echo esc_url(RADIO_PLAYER_ASSETS . '/images/getting-started/get-pro/upgrade.svg'); ?>" alt="upgrade" />
					<?php esc_html_e('Upgrade Now', 'radio-player'); ?>
				</a>
			</div>
		</div>

		<div class="demo-cta">
			<div class="cta-content">
				<h2>
					<?php
					esc_html_e('Want to try live demo, before purchase?', 'radio-player');
					?>
				</h2>
				<p>
					<?php
					esc_html_e('You can try our instant ready-made demo. The demo allows you to experiment with all the functionality of the plugins on both Front-End and Back-End.', 'radio-player');
					?>
				</p>
			</div>

			<div class="cta-btn">
				<a href="https://demo.softlabbd.com/?product=radio-player" target="_blank"
					class="radio-player-btn">
					<img src="<?php echo esc_url(RADIO_PLAYER_ASSETS . '/images/getting-started/get-pro/demo.svg'); ?>" alt="demo" />
					<?php esc_html_e('Try Live Demo', 'radio-player'); ?>
				</a>
			</div>

		</div>
	</section>
</div>

<script>
	(function($) {
		$(document).on('ready', function() {
			const productIcon = "<?php echo RADIO_PLAYER_ASSETS; ?>/images/radio-player-logo.png";
			var handler = FS.Checkout.configure({
				plugin_id: '8684',
				plan_id: '14508',
				public_key: 'pk_6175576896c0d8c125d31e42287ab',
				image: productIcon,
			});

			// Handle all buy button clicks dynamically
			$('.buy-btn-pro').on('click', function(e) {
				e.preventDefault();

				var $card = $(this).closest('.pricing-card');
				var license = $card.find('[data-license]').attr('data-license');
				var planName = $card.find('h3').text();

				// assign product info
				const productInfo = {
					productIcon: productIcon,
					planName: planName,
					productName: "Radio Player",
					docs: "https://softlabbd.com/docs-category/radio-player/",
					video: "https://www.youtube.com/watch?v=60puFspgnK8&list=PLaR5hjDXnXZxHDAWtk7syboP6obo1uX3k",
					productDescription: "Live Shoutcast, Icecast and Audio Stream Player for WordPress.",
				};

				handler.open({
					name: planName,
					licenses: license,
					purchaseCompleted: function(response) {
						setTimeout(function() {
							// assign productInfo to response
							response.productInfo = productInfo;

							// data 
							const data = window.btoa(JSON.stringify(response));

							// redirect
							window.location.href = "<?php echo site_url('/thank-you'); ?>?data=" + data;
						}, 2000);
					},
					success: function(response) {
						console.log("Purchase Successful:", response);
					}
				});
			});
		});
	})(jQuery);
</script>