<?php

if (! defined('ABSPATH')) {
    exit;
}

?>

<div id="ads-player-addon" class="getting-started-content">

    <section class="section-introduction section-full">
        <div class="content-heading">
            <h2>
                <?php
                esc_html_e('Radio Ads Player Addon - Quick Overview', 'radio-player');
                ?>
            </h2>
        </div>
        <div class="col-full">

            <div class="rp-popup">
                <img src="<?php echo esc_url(RADIO_PLAYER_ASSETS . '/images/getting-started/ads-player/overview.png') ?>" alt="<?php echo esc_attr__('Display Player', 'radio-player'); ?>" />
                <button class="rp-play" type="button" data-video-id="J3-awEWXFIU">
                    <img src="<?php echo esc_url(RADIO_PLAYER_ASSETS . '/images/getting-started/play.svg') ?>" alt="<?php echo esc_attr__('Play Icon', 'radio-player'); ?>" />
                </button>
            </div>

            <p>
                <?php
                esc_html_e('The Radio Player Ads Addon offers you the ability to monetize your radio player by allowing you to play
                audio advertisements and other promotional content while your users listen to the radio.', 'radio-player');
                ?>
            </p>
            <p>
                <?php
                esc_html_e('You can now easily manage and create your own audio campaigns, target your desired audience, and
                increase your revenue stream.', 'radio-player');
                ?>
            </p>

            <p>
                <?php
                esc_html_e('With its user-friendly interface and easy integration with the existing
                Radio Player plugin, you can quickly and effortlessly create a professional audio campaign.
                Radio Player Ads is an excellent tool that can help you take your radio website to the next level and
                improve your overall user experience.', 'radio-player');
                ?>
            </p>

        </div>
    </section>

    <section class="section-radio-player-ads">
        <div class="content-heading">
            <h2>
                <?php
                esc_html_e('How to Play Custom Audio Ads and Promos Using Radio Player Ads Addon', 'radio-player');
                ?>
            </h2>
            <p>
                <?php
                esc_html_e('To play custom audio ads and promos, follow these steps:', 'radio-player');
                ?>
            </p>
        </div>

        <div class="col-description">

            <h3>
                <img src="<?php echo esc_url(RADIO_PLAYER_ASSETS . '/images/getting-started/ads-player/ads.png') ?>" alt="<?php echo esc_attr('ADS Player', 'radio-player'); ?>" />
                <?php
                esc_html_e('Create Audio Ads', 'radio-player');
                ?>
            </h3>

            <p>
                <?php
                esc_html_e('To create audio ads, follow these steps:', 'radio-player');
                ?>
            </p>

            <ol>
                <li>
                    Navigate to <strong>Radio Player Ads &gt; Add New Ad &gt; Enter Ad Title</strong>.
                </li>

                <li>
                    From the <strong>General Tab</strong>, set up general ad settings:

                    <ul>
                        <li><strong>Ad Source:</strong> Enter the audio ad file URL or select the ad file from the
                            WordPress media library.
                        </li>

                        <li><strong>Ad Image:</strong> Enter the ad image URL or select the ad image from local storage.
                        </li>

                        <li>
                            <strong>Ad Playback Mode:</strong> Select the ad playback mode from 2 different types:
                            <ul>
                                <li><strong>Overlay:</strong> The ad will play in the background while the radio is
                                    playing.
                                </li>
                                <li><strong>Interrupt:</strong> The ad will pause the radio stream and play the ad.</li>
                            </ul>
                        </li>

                        <li>
                            <strong>Ad Placement:</strong> Select the ad type from 3 different types of ads:
                            <ul>
                                <li><strong>Pre-roll:</strong> The ad will be played before the radio station play
                                    starts.
                                </li>
                                <li><strong>Mid-roll:</strong> The ad will be played in the middle of the radio station
                                    play.
                                </li>
                                <li><strong>Both:</strong> The ad will be played before and in the middle of the radio
                                    station play.
                                </li>
                            </ul>
                        </li>

                        <li><strong>Ad Duration:</strong> Select the ad duration and how long the ad will play. You can
                            select 10 sec, 20 sec, 30 sec, 1 min, full length, and custom length.
                        </li>

                        <li><strong>Players:</strong> Select specific radio players where you want to play ads. The ad
                            will be played only for the selected players.
                        </li>
                    </ul>
                </li>

                <li>
                    From the <strong>Expiration Tab</strong>, customize ad expiration settings:
                    <ul>
                        <li>
                            <strong>Expiration Type:</strong> Select the ad expiration type depending on your need:
                            <ul>
                                <li><strong>Expire by Count:</strong> The ad will be expired after the given number of
                                    plays.
                                </li>
                                <li><strong>Expire by Date:</strong> The ad will be expired after the given date.</li>
                            </ul>
                        </li>
                    </ul>
                </li>

                <li>
                    From the <strong>Advertiser Tab</strong>, enter advertiser information:
                    <ul>
                        <li><strong>Advertiser Name:</strong> Enter the advertiser name</li>
                        <li><strong>Advertiser Email:</strong> Enter the advertiser email (this email is used to send
                            email reports of ad playing statistics).
                        </li>
                    </ul>
                </li>

                <li>
                    Select the <strong>Ad Status</strong> and click <strong>Publish</strong> when customizations are
                    done.
                </li>
            </ol>
        </div>

        <div class="col-description">
            <h3>
                <img src="<?php echo esc_url(RADIO_PLAYER_ASSETS . '/images/getting-started/ads-player/settings.png') ?>" alt="<?php echo esc_attr('ad settings', 'radio-player'); ?>" />
                <?php
                esc_html_e('Adjust Ad Settings', 'radio-player');
                ?>
            </h3>
            <p>
                <?php
                esc_html_e('To adjust ad settings, follow these steps:', 'radio-player');
                ?>
            </p>

            <ul>
                <li>
                    Navigate to <strong>Radio Player &gt; Settings</strong>.
                </li>

                <li>
                    From the <strong>Ads Player Settings Tab</strong>, adjust the following settings:
                    <ul>
                        <li>
                            <strong>Pre-roll Ads Interval:</strong> This setting allows you to configure the time
                            interval between consecutive pre-roll ads. Pre-roll ads are played before the radio station
                            starts playing. Adjust this interval to control how often pre-roll ads will be displayed to
                            your listeners.
                        </li>
                        <li>
                            <strong>Mid-roll Ads Interval:</strong> This setting lets you set the time interval between
                            consecutive mid-roll ads. Mid-roll ads are played during the radio station play, typically
                            in the middle of the content. By adjusting this interval, you can determine how frequently
                            mid-roll ads will be displayed to your listeners.
                        </li>
                        <li>
                            <strong>Show Skip Button:</strong> This setting enables or disables the "Skip" button for
                            your ads. When activated, listeners will have the option to skip the ad after a certain
                            duration or if they find it irrelevant. Enabling this feature can improve the user
                            experience, but may also affect ad revenue. Be sure to weigh the pros and cons before
                            enabling or disabling this option.
                        </li>
                    </ul>

                </li>
            </ul>

            <p>
                <?php
                esc_html_e('When anyone plays the radio, the ads will keep displaying depending on the settings you have customized so far.', 'radio-player');
                ?>
            </p>
        </div>

        <div class="col-description">
            <h2>
                <?php
                esc_html_e('Video Tutorial', 'radio-player');
                ?>
            </h2>

            <div class="col-image">                
                <div class="rp-popup">
                    <img src="<?php echo esc_url(RADIO_PLAYER_ASSETS . '/images/getting-started/ads-player/video.png') ?>" alt="<?php echo esc_attr__('Player', 'radio-player'); ?>" />
                    <button class="rp-play" type="button" data-video-id="lrDCHPzjHB4">
                        <img src="<?php echo esc_url(RADIO_PLAYER_ASSETS . '/images/getting-started/play.svg') ?>" alt="<?php echo esc_attr__('Play Icon', 'radio-player'); ?>" />
                    </button>
                </div>
            </div>

        </div>
    </section>

</div>