<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$addons = [
        [
                'key'          => 'proxy-player',
                'title'        => __( 'Radio Player Proxy', 'radio-player' ),
                'description'  => __( 'Enable seamless playback of HTTP (non-SSL) radio streams on HTTPS websites. The Proxy Add-on also resolves metadata issues including now-playing titles, artist details, and artwork ideal for servers that struggle to fetch stream data.', 'radio-player' ),
                'docs_url'     => 'https://softlabbd.com/docs/how-to-play-an-http-stream-on-https-website/',
                'learn_more'   => 'https://softlabbd.com/radio-player-proxy/',
                'get_now'      => 'https://softlabbd.com/radio-player-proxy#addon-pricing',
                'is_installed' => function_exists( 'rpp_fs' ),
        ],
        [
                'key'          => 'ads-player',
                'title'        => __( 'Radio Player Ads', 'radio-player' ),
                'description'  => __( 'Boost your radio streaming strategy with the Ads Add-on. Easily integrate targeted ads, manage campaigns, and track performance with in-depth analytics—designed to increase audience engagement and revenue effortlessly.', 'radio-player' ),
                'docs_url'     => 'https://softlabbd.com/docs/how-to-create-and-play-custom-audio-ads-on-radio-player/',
                'learn_more'   => 'https://softlabbd.com/radio-player-ads/',
                'get_now'      => 'https://softlabbd.com/radio-player-ads#addon-pricing',
                'is_installed' => function_exists( 'rpa_fs' ),
        ],
];

?>

<div id="add-ons" class="getting-started-content add-ons-content">
    <div class="wrap">

        <!-- Add-ons Section -->
        <section class="section-add-ons section-full">
            <div class="content-heading">
                <h2><?php esc_html_e( 'Radio Player Enhancements', 'radio-player' ); ?></h2>
                <p><?php esc_html_e( 'Enhance your Radio Player with powerful add-ons crafted to expand features, improve performance, and elevate the overall listening experience.', 'radio-player' ); ?></p>
            </div>

            <div class="section-wrap">

                <?php foreach ( $addons as $addon ) : ?>
                    <section class="section-border section-half">
                        <div class="col-description">

                            <?php if ( $addon['is_installed'] ) { ?>
                                <div class="ribbon">
                                    <i class="dashicons dashicons-saved"></i>
                                    <span><?php esc_html_e( 'Installed', 'radio-player' ); ?></span>
                                </div>
                            <?php } ?>

                            <img
                                    src="<?php echo esc_url( RADIO_PLAYER_ASSETS . '/images/getting-started/add-ons/' . $addon['key'] ); ?>.png"
                                    class="icon"
                                    alt="<?php echo esc_attr( $addon['title'] ); ?>"
                            />

                            <h3><?php echo esc_html( $addon['title'] ); ?></h3>

                            <p><?php echo esc_html( $addon['description'] ); ?></p>

                            <div class="actions">

                                <a href="<?php echo esc_url( $addon['docs_url'] ); ?>" class="button docs"
                                   target="_blank">

                                    <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_4505_13493)">
                                            <path d="M3.66631 -0.00422726C3.71064 -0.00427231 3.71064 -0.00427231 3.75586 -0.00431828C3.85502 -0.00437625 3.95418 -0.00418268 4.05334 -0.00399069C4.12436 -0.00398077 4.19539 -0.00398633 4.26641 -0.00400624C4.4594 -0.00401635 4.65238 -0.00380937 4.84536 -0.00356419C5.04698 -0.0033447 5.24859 -0.00332379 5.45021 -0.00328205C5.83208 -0.00317269 6.21394 -0.00288408 6.59581 -0.00253148C7.03051 -0.00213878 7.46522 -0.00194529 7.89993 -0.00176875C8.79423 -0.00140109 9.68853 -0.000782552 10.5828 4.41447e-07C10.5831 0.0452318 10.5834 0.0904631 10.5837 0.137065C10.5864 0.564786 10.5895 0.992503 10.5929 1.42022C10.5947 1.64008 10.5963 1.85993 10.5977 2.07979C10.599 2.29224 10.6006 2.50469 10.6024 2.71714C10.6031 2.79791 10.6036 2.87868 10.604 2.95945C10.6016 3.96735 10.6016 3.96735 11.1032 4.8175C11.522 5.19242 12.0018 5.24224 12.5396 5.2455C12.5757 5.24585 12.6117 5.2462 12.6489 5.24655C12.767 5.24766 12.8851 5.24853 13.0033 5.2494C13.0856 5.25013 13.1679 5.25087 13.2502 5.25162C13.466 5.25355 13.6819 5.25529 13.8978 5.25699C14.1184 5.25876 14.3389 5.26072 14.5595 5.26266C14.9918 5.26643 15.424 5.27 15.8563 5.27344C15.8603 6.73019 15.8634 8.18694 15.8652 9.6437C15.8655 9.8158 15.8657 9.9879 15.8659 10.16C15.866 10.1943 15.866 10.2285 15.8661 10.2638C15.8668 10.8181 15.8682 11.3724 15.8698 11.9267C15.8715 12.4957 15.8724 13.0647 15.8728 13.6337C15.873 13.9846 15.8738 14.3356 15.8752 14.6865C15.8762 14.9274 15.8764 15.1682 15.8762 15.4091C15.8761 15.5479 15.8763 15.6867 15.8772 15.8255C15.8781 15.9529 15.8781 16.0803 15.8775 16.2077C15.8774 16.275 15.8782 16.3423 15.879 16.4096C15.8749 16.8896 15.7051 17.2569 15.3788 17.6017C15.1244 17.8419 14.7841 18.004 14.4341 18.0048C14.3949 18.005 14.3557 18.0052 14.3153 18.0054C14.2723 18.0054 14.2292 18.0054 14.1849 18.0054C14.1391 18.0056 14.0934 18.0057 14.0463 18.0059C13.9192 18.0063 13.7921 18.0065 13.6651 18.0067C13.528 18.0069 13.391 18.0073 13.254 18.0076C12.923 18.0085 12.592 18.009 12.261 18.0095C12.1675 18.0096 12.074 18.0098 11.9805 18.0099C11.3995 18.0108 10.8185 18.0116 10.2375 18.012C10.1029 18.0121 9.96834 18.0122 9.83377 18.0123C9.7836 18.0123 9.7836 18.0123 9.73242 18.0124C9.19099 18.0128 8.64956 18.014 8.10813 18.0155C7.55198 18.017 6.99584 18.0178 6.43969 18.018C6.12755 18.0181 5.81541 18.0185 5.50327 18.0197C5.23735 18.0206 4.97143 18.021 4.70551 18.0206C4.56995 18.0205 4.43441 18.0206 4.29885 18.0214C4.15152 18.0224 4.00423 18.0219 3.8569 18.0214C3.81455 18.0219 3.77221 18.0223 3.72858 18.0229C3.25213 18.0184 2.88559 17.8461 2.54358 17.5225C2.27798 17.2412 2.13985 16.8921 2.14051 16.5108C2.14041 16.4846 2.14032 16.4583 2.14022 16.4312C2.13995 16.3428 2.13993 16.2543 2.13991 16.1658C2.13977 16.1019 2.13962 16.038 2.13945 15.9741C2.13902 15.7981 2.13883 15.6222 2.13867 15.4462C2.13846 15.2565 2.13805 15.0669 2.13767 14.8773C2.13681 14.4191 2.13629 13.9608 2.13584 13.5026C2.13571 13.3732 2.13557 13.2438 2.13543 13.1144C2.13454 12.3108 2.13377 11.5071 2.13333 10.7035C2.13322 10.5174 2.13312 10.3312 2.13301 10.145C2.13298 10.0756 2.13298 10.0756 2.13294 10.0048C2.13249 9.25536 2.13132 8.50591 2.12986 7.75647C2.12837 6.98707 2.12754 6.21767 2.12735 5.44827C2.12723 5.01627 2.12682 4.58427 2.12566 4.15226C2.12468 3.78431 2.12429 3.41637 2.12469 3.04841C2.12487 2.86074 2.12477 2.67307 2.1239 2.4854C2.1231 2.31339 2.12313 2.14141 2.1238 1.9694C2.1239 1.90736 2.1237 1.84533 2.12317 1.78329C2.11873 1.22858 2.23217 0.811081 2.62282 0.398255C2.91634 0.121158 3.27081 -0.00569297 3.66631 -0.00422726ZM5.41485 7.62891C5.3192 7.78598 5.32166 7.94225 5.34454 8.12109C5.42165 8.27818 5.50229 8.36397 5.66095 8.4375C5.80701 8.4751 5.946 8.47716 6.09645 8.47736C6.12227 8.47744 6.14809 8.47752 6.17469 8.4776C6.26102 8.47782 6.34735 8.47779 6.43368 8.47776C6.49565 8.47787 6.55763 8.47799 6.6196 8.47812C6.78783 8.47843 6.95605 8.47851 7.12428 8.47854C7.22941 8.47856 7.33454 8.47864 7.43966 8.47873C7.80649 8.47905 8.17331 8.4792 8.54014 8.47917C8.88197 8.47915 9.22379 8.47952 9.56562 8.48007C9.8592 8.48054 10.1528 8.48072 10.4464 8.4807C10.6217 8.48069 10.797 8.48079 10.9723 8.48116C11.1371 8.4815 11.302 8.48151 11.4669 8.48125C11.5274 8.48121 11.5878 8.4813 11.6482 8.48151C11.7309 8.48178 11.8135 8.48162 11.8962 8.48135C11.9424 8.48137 11.9886 8.48139 12.0362 8.48141C12.225 8.46856 12.3655 8.44175 12.5098 8.31665C12.6468 8.15622 12.6754 8.06597 12.67 7.86003C12.6485 7.70987 12.5926 7.62386 12.4813 7.52344C12.1824 7.38501 11.8741 7.40332 11.5519 7.40488C11.4899 7.40479 11.428 7.40466 11.366 7.40449C11.1983 7.40416 11.0307 7.40449 10.863 7.40496C10.6873 7.40536 10.5116 7.40521 10.3358 7.40514C10.0408 7.40511 9.74583 7.4055 9.45084 7.40615C9.11005 7.40689 8.76926 7.40702 8.42846 7.4068C8.10018 7.4066 7.77189 7.4068 7.4436 7.40719C7.30407 7.40735 7.16455 7.40738 7.02502 7.40731C6.86071 7.40724 6.69641 7.40753 6.5321 7.40809C6.47188 7.40824 6.41166 7.40827 6.35145 7.40817C6.26911 7.40805 6.18678 7.40837 6.10443 7.4088C6.05841 7.40888 6.01238 7.40895 5.96496 7.40902C5.74302 7.42451 5.57597 7.47239 5.41485 7.62891ZM5.41485 9.73828C5.3192 9.89535 5.32166 10.0516 5.34454 10.2305C5.42165 10.3876 5.50229 10.4734 5.66095 10.5469C5.80701 10.5845 5.946 10.5865 6.09645 10.5867C6.12227 10.5868 6.14809 10.5869 6.17469 10.587C6.26102 10.5872 6.34735 10.5872 6.43368 10.5871C6.49565 10.5872 6.55763 10.5874 6.6196 10.5875C6.78783 10.5878 6.95605 10.5879 7.12428 10.5879C7.22941 10.5879 7.33454 10.588 7.43966 10.5881C7.80649 10.5884 8.17331 10.5886 8.54014 10.5885C8.88197 10.5885 9.22379 10.5889 9.56562 10.5895C9.8592 10.5899 10.1528 10.5901 10.4464 10.5901C10.6217 10.5901 10.797 10.5902 10.9723 10.5905C11.1371 10.5909 11.302 10.5909 11.4669 10.5906C11.5274 10.5906 11.5878 10.5907 11.6482 10.5909C11.7309 10.5912 11.8135 10.591 11.8962 10.5907C11.9424 10.5907 11.9886 10.5908 12.0362 10.5908C12.225 10.5779 12.3655 10.5511 12.5098 10.426C12.6468 10.2656 12.6754 10.1753 12.67 9.96941C12.6485 9.81925 12.5926 9.73324 12.4813 9.63281C12.1824 9.49439 11.8741 9.5127 11.5519 9.51425C11.4899 9.51417 11.428 9.51404 11.366 9.51387C11.1983 9.51354 11.0307 9.51387 10.863 9.51433C10.6873 9.51473 10.5116 9.51459 10.3358 9.51452C10.0408 9.51449 9.74583 9.51488 9.45084 9.51552C9.11005 9.51627 8.76926 9.51639 8.42846 9.51617C8.10018 9.51597 7.77189 9.51617 7.4436 9.51657C7.30407 9.51673 7.16455 9.51676 7.02502 9.51669C6.86071 9.51662 6.69641 9.51691 6.5321 9.51746C6.47188 9.51761 6.41166 9.51764 6.35145 9.51754C6.26911 9.51743 6.18678 9.51775 6.10443 9.51818C6.05841 9.51825 6.01238 9.51832 5.96496 9.5184C5.74302 9.53388 5.57597 9.58177 5.41485 9.73828ZM5.41485 11.8477C5.3192 12.0047 5.32166 12.161 5.34454 12.3398C5.42165 12.4969 5.50229 12.5827 5.66095 12.6562C5.80701 12.6938 5.946 12.6959 6.09645 12.6961C6.12227 12.6962 6.14809 12.6963 6.17469 12.6963C6.26102 12.6966 6.34735 12.6965 6.43368 12.6965C6.49565 12.6966 6.55763 12.6967 6.6196 12.6969C6.78783 12.6972 6.95605 12.6973 7.12428 12.6973C7.22941 12.6973 7.33454 12.6974 7.43966 12.6975C7.80649 12.6978 8.17331 12.6979 8.54014 12.6979C8.88197 12.6979 9.22379 12.6983 9.56562 12.6988C9.8592 12.6993 10.1528 12.6995 10.4464 12.6995C10.6217 12.6994 10.797 12.6995 10.9723 12.6999C11.1371 12.7003 11.302 12.7003 11.4669 12.7C11.5274 12.7 11.5878 12.7 11.6482 12.7003C11.7309 12.7005 11.8135 12.7004 11.8962 12.7001C11.9424 12.7001 11.9886 12.7001 12.0362 12.7002C12.225 12.6873 12.3655 12.6605 12.5098 12.5354C12.6468 12.375 12.6754 12.2847 12.67 12.0788C12.6485 11.9286 12.5926 11.8426 12.4813 11.7422C12.1824 11.6038 11.8741 11.6221 11.5519 11.6236C11.4899 11.6235 11.428 11.6234 11.366 11.6232C11.1983 11.6229 11.0307 11.6232 10.863 11.6237C10.6873 11.6241 10.5116 11.624 10.3358 11.6239C10.0408 11.6239 9.74583 11.6243 9.45084 11.6249C9.11005 11.6256 8.76926 11.6258 8.42846 11.6255C8.10018 11.6253 7.77189 11.6255 7.4436 11.6259C7.30407 11.6261 7.16455 11.6261 7.02502 11.6261C6.86071 11.626 6.69641 11.6263 6.5321 11.6268C6.47188 11.627 6.41166 11.627 6.35145 11.6269C6.26911 11.6268 6.18678 11.6271 6.10443 11.6276C6.05841 11.6276 6.01238 11.6277 5.96496 11.6278C5.74302 11.6433 5.57597 11.6911 5.41485 11.8477ZM5.41485 13.957C5.3192 14.1141 5.32166 14.2704 5.34454 14.4492C5.42165 14.6063 5.50229 14.6921 5.66095 14.7656C5.78119 14.7947 5.89286 14.8052 6.01637 14.8055C6.05176 14.8056 6.08714 14.8058 6.12359 14.8059C6.16202 14.8059 6.20045 14.8059 6.24005 14.8059C6.28083 14.806 6.3216 14.8061 6.36362 14.8062C6.49844 14.8066 6.63327 14.8066 6.7681 14.8067C6.83814 14.8068 6.90819 14.8069 6.97824 14.8069C7.19847 14.8072 7.41869 14.8073 7.63892 14.8073C7.86572 14.8073 8.09251 14.8076 8.31931 14.8082C8.51437 14.8087 8.70943 14.8088 8.90449 14.8088C9.02084 14.8088 9.13719 14.8089 9.25354 14.8093C9.38338 14.8096 9.51322 14.8095 9.64306 14.8093C9.70049 14.8096 9.70049 14.8096 9.75909 14.8099C10.1057 14.8098 10.1057 14.8098 10.4005 14.6448C10.5374 14.4843 10.566 14.3941 10.5606 14.1882C10.5392 14.0385 10.4836 13.9511 10.3719 13.8516C10.1375 13.7321 9.89355 13.7312 9.6362 13.733C9.575 13.7328 9.575 13.7328 9.51256 13.7326C9.3785 13.7323 9.24445 13.7328 9.11038 13.7333C9.01684 13.7333 8.92329 13.7333 8.82975 13.7333C8.63406 13.7332 8.43837 13.7336 8.24268 13.7343C8.01692 13.735 7.79116 13.7351 7.56539 13.7349C7.34748 13.7347 7.12957 13.7349 6.91165 13.7353C6.81923 13.7355 6.7268 13.7355 6.63437 13.7354C6.50522 13.7354 6.37607 13.7359 6.24691 13.7364C6.20885 13.7364 6.17078 13.7363 6.13156 13.7362C5.85177 13.7381 5.6255 13.7524 5.41485 13.957Z"
                                                  fill="currentColor"/>
                                            <path d="M11.637 0.28125C11.8536 0.460397 12.0515 0.65561 12.2499 0.854436C12.2863 0.890785 12.3227 0.927127 12.3591 0.963462C12.4573 1.0615 12.5554 1.15965 12.6535 1.25782C12.7562 1.36066 12.859 1.46341 12.9619 1.56618C13.1342 1.73849 13.3065 1.91088 13.4788 2.08331C13.6782 2.28288 13.8777 2.48232 14.0773 2.6817C14.2487 2.85299 14.4201 3.02434 14.5914 3.19576C14.6937 3.2981 14.796 3.40043 14.8984 3.50269C14.9944 3.59862 15.0904 3.69463 15.1862 3.79071C15.2215 3.82604 15.2568 3.86135 15.2922 3.89662C15.3402 3.94455 15.3881 3.99259 15.436 4.04065C15.4629 4.06756 15.4898 4.09448 15.5175 4.12221C15.5745 4.18359 15.5745 4.18359 15.5745 4.21875C15.106 4.22201 14.6375 4.22451 14.169 4.22604C13.9515 4.22677 13.734 4.22777 13.5164 4.22936C13.3065 4.23089 13.0965 4.23173 12.8866 4.23209C12.8065 4.23235 12.7264 4.23286 12.6463 4.23362C12.5341 4.23464 12.422 4.23478 12.3098 4.23471C12.2767 4.23522 12.2436 4.23573 12.2095 4.23625C12.0134 4.23501 11.8946 4.2142 11.7425 4.07813C11.6047 3.92035 11.6228 3.74874 11.625 3.54998C11.625 3.51464 11.625 3.47929 11.625 3.44288C11.6251 3.32627 11.6259 3.20967 11.6267 3.09306C11.6269 3.01213 11.6271 2.93119 11.6272 2.85026C11.6276 2.63739 11.6286 2.42454 11.6298 2.21167C11.6308 1.9944 11.6313 1.77713 11.6319 1.55985C11.633 1.13365 11.6348 0.70745 11.637 0.28125Z"
                                                  fill="currentColor"/>
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_4505_13493">
                                                <rect width="18" height="18" fill="currentColor"/>
                                            </clipPath>
                                        </defs>
                                    </svg>

                                    <?php esc_html_e( 'Documentation', 'radio-player' ); ?>
                                </a>

                                <a href="<?php echo esc_url( $addon['learn_more'] ); ?>" class="button learn-more"
                                   target="_blank">
                                    <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path d="M3.375 9H14.625M14.625 9L10.4062 4.5M14.625 9L10.4062 13.5"
                                              stroke="#00BB45" stroke-width="1.5" stroke-linecap="round"
                                              stroke-linejoin="round"/>
                                    </svg>

                                    <?php esc_html_e( 'Learn More', 'radio-player' ); ?>
                                </a>

                                <?php if ( !$addon['is_installed'] ) { ?>
                                    <a href="<?php echo esc_url( $addon['get_now'] ); ?>"
                                       class="button upgrade buy-<?php echo esc_attr($addon['key']); ?>-btn"
                                       target="_blank">
                                        <?php esc_html_e( 'Get Now', 'radio-player' ); ?>

                                        <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path d="M3.375 9H14.625M14.625 9L10.4062 4.5M14.625 9L10.4062 13.5"
                                                  stroke="#00BB45" stroke-width="1.5" stroke-linecap="round"
                                                  stroke-linejoin="round"/>
                                        </svg>
                                    </a>
                                <?php } ?>

                            </div>

                        </div>
                    </section>
                <?php endforeach; ?>

            </div>
        </section>

    </div>
</div>
