<?php

defined( 'ABSPATH' ) || exit();

class Radio_Player_Shortcode {

	/**
	 * @var null
	 */
	private static $instance = null;

	/**
	 * Radio_Player_Shortcode constructor.
	 */
	public function __construct() {
		add_action( 'plugins_loaded', array( $this, 'replace_radio_player_shortcode' ) );
	}

	public function replace_radio_player_shortcode() {
		remove_shortcode( 'radio_player' );

		add_shortcode( 'radio_player', array( $this, 'render_player' ) );
	}

	/**
	 * @param $atts
	 *
	 * @return false|string|void
	 * @since 1.0.0
	 */
	public function render_player( $atts ) {

		$is_preview = isset( $_GET['preview'] );

		$atts = shortcode_atts( array(
			'id'          => '',
			'player_type' => 'shortcode',
		), $atts );

		$id = intval( $atts['id'] );

		$player = radio_player_get_players( $id );

		if ( empty( $player['status'] ) ) {
			if ( ! $is_preview || ( $is_preview && ! current_user_can( 'edit_posts' ) ) ) {
				return;
			}
		}

		$config = $player['config'];

		$config['id'] = $id;

		// Enqueue frontend scripts
		Radio_Player_Enqueue::instance()->frontend_scripts();

		$shortcode_output = sprintf( '<div class="radio_player" data-player-type="%1$s" data-data="%2$s"></div>', esc_attr( $atts['player_type'] ), esc_attr( base64_encode( json_encode( $config ) ) ) );

		return apply_filters( 'radio_player/shortcode_output', $shortcode_output, $atts, $config, $is_preview );
	}

	/**
	 * @return Radio_Player_Shortcode|null
	 */
	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

}

Radio_Player_Shortcode::instance();