<?php

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

defined( 'ABSPATH' ) || exit();

class Radio_Player_Elementor_Widget extends Widget_Base {

	public function get_name() {
		return 'radio_player';
	}

	public function get_title() {
		return esc_html__( 'Radio Player', 'radio-player' );
	}

	public function get_icon() {
		return 'eicon-play';
	}

	public function get_categories() {
		return [ 'basic' ];
	}

	public function get_keywords() {
		return [ 'audio', 'radio', 'music', 'radio-player', 'radio player' ];
	}

	public function register_controls() {

		$this->start_controls_section( '_section_radio_player',
			[
				'label' => esc_html__( 'Radio Player', 'radio-player' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			] );


		$players = radio_player_get_players();

		if ( ! empty( $players ) ) {
			$players = wp_list_pluck( $players, 'title', 'id' );
		} else {
			$players = [ '' => esc_html__( 'No Player Found', 'radio-player' ) ];
		}

		$this->add_control( 'player_id',
			[
				'label'       => esc_html__( 'Select Player', 'radio-player' ),
				'type'        => Controls_Manager::SELECT,
				'label_block' => true,
				'default'     => 0,
				'options'     => [ 0 => esc_html__( 'Select Player', 'radio-player' ) ] + $players,
			] );

		//Add align control
		$this->add_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'radio-player' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left'   => [
						'title' => esc_html__( 'Left', 'radio-player' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'radio-player' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right'  => [
						'title' => esc_html__( 'Right', 'radio-player' ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
			]
		);


		$this->end_controls_section();
	}

	public function render() {
		$settings = $this->get_settings_for_display();

		$id    = ! empty( $settings['player_id'] ) ? $settings['player_id'] : 0;
		$align = ! empty( $settings['align'] ) ? $settings['align'] : 'center';

		if ( empty( $id ) ) {
			$html = '<p style="padding: 20px;border: 1px solid #ddd;margin: 20px;font-size: 1.5rem;font-weight: bold;border-radius: 0.3rem;text-align: center;">' . esc_html__( 'Please select a player.', 'radio-player' ) . '</p>';

			echo wp_kses( $html, wp_kses_allowed_html( 'post' ) );

		} else {
			$html = sprintf( '<div class="align%s">%s</div>', $align, do_shortcode( "[radio_player id=$id]" ) );

			echo wp_kses( $html, wp_kses_allowed_html( 'post' ) );
		}
	}

}