<?php
/**
 *       @file  qtrExternalScanner.php
 *      @brief  This module contains API to query external scanner
 *
 *     @author  Quttera (qtr), contactus@quttera.com
 *
 *   @internal
 *     Created  01/17/2016
 *    Compiler  gcc/g++
 *     Company  Quttera
 *   Copyright  Copyright (c) 2016, Quttera
 *
 * This source code is released for free distribution under the terms of the
 * GNU General Public License as published by the Free Software Foundation.
 * =====================================================================================
 */


class CQtrExternalScanner
{

    /**
    * @brief       sends request to remote scanner 
    * @param[in]   remote_url - URL query 
    * @return      on success returns retireved Json, on failure empty string
    */
    public static function SendQuery ( $remote_url )
    {

        if(!wp_http_validate_url($remote_url)){
            /* the provided URL is not valid/safe to use */
            return "";
        }
	
	    $response = wp_safe_remote_get( $remote_url);

	    if ( is_wp_error( $response ) ) {
           return "";
	    } else {
             $body = wp_remote_retrieve_body( $response );
             return $body;
	    }
    }
}


?>
