jQuery( document ).ready( function() {
	
	jQuery( document ).on( 'click', '#qwc_quote_complete', function() {
		
		// update the DB quote status
		var data = {
			order_id: qwc_params.order_id,
			status: 'quote-complete',
			action: 'qwc_update_status',
			security_nonce: qwc_params.qwc_status_nonce
		};
		
		jQuery.post( qwc_params.ajax_url, data, function( response ) {
			// reload the page
			location.reload( true );
		});
	});
	
	jQuery( document ).on( 'click', '#qwc_send_quote', function() {
		// Add a spinner.
		jQuery( '#qwc_msg' ).html('');
		var spinner = jQuery('<span>', {
			class: 'spinner is-active' // WP core spinner.
		}).css({
            float: 'none',   // keep inline.
            verticalAlign: 'middle'
        });
		jQuery('#qwc_msg').prepend(spinner);
		// send an email.
		var data = {
			order_id: qwc_params.order_id,
			action: 'qwc_send_quote',
			security_nonce: qwc_params.qwc_send_nonce
		};
		
		jQuery.post( qwc_params.ajax_url, data, function( response ) {
			if ( 'quote-sent' === response ) {
				jQuery('.spinner').removeClass('is-active');
				jQuery( '#qwc_msg' ).html( qwc_params.email_msg );
				jQuery( '#qwc_msg' ).attr( 'display', 'block' );
			}
		});
	});
});