<?php
/**
 * SiteGround Compatibility
 *
 * @since 1.8.2
 *
 * @package Compatibility
 */

namespace QuillForms;

/**
 * The class is responsible for making Quill Forms compatible with siteground optimize plugin.
 *
 * @since 1.8.2
 */
class SG_Optimize_Compatibility {

	/**
	 * Hooks
	 *
	 * @static
	 * @since 1.8.2
	 */
	public static function hooks() {
		add_filter( 'sgo_javascript_combine_exclude', array( __CLASS__, 'exclude_quillforms_pages' ) );
		add_filter( 'sgo_js_minify_exclude', array( __CLASS__, 'exclude_quillforms_pages' ) );
		add_filter('sgo_javascript_combine_exclude', array( __CLASS__, 'exclude_quillforms_pages'));
		add_filter('sgo_javascript_combine_excluded_inline_content', function($excluded_inline_content){
			$excluded_inline_content[] = 'lodash';
			$excluded_inline_content[] = 'wp-i18n';
			$excluded_inline_content[] = 'quillforms-renderer-core';
			$excluded_inline_content[] = 'wp-data';
			$excluded_inline_content[] = 'quillforms-blocks';
			$excluded_inline_content[] = 'quillforms-config';
			return $excluded_inline_content;
		});
		add_filter( 'sgo_js_async_exclude', array( __CLASS__, 'exclude_quillforms_pages' ) );
		add_action( 'init', array( __CLASS__, 'exclude_quillforms_post_type' ) );
		add_filter('sgo_javascript_combine_exclude_all_inline', function($exclude) {
			if(function_exists('is_singular') && is_singular('quill_forms')) {
				$exclude = true;
			}
			return $exclude;
		});


	}

	/**
	 * Exclude Quill Forms js.
	 *
	 * @static
	 * @since 1.8.2
	 *
	 * @param array $exclude_list The exclude list.
	 *
	 * @return array $exclude_list
	 */
	public static function exclude_quillforms_pages( $exclude_list ) {
		if ( function_exists('is_singular') && is_singular( 'quill_forms' ) ) {
			$exclude_list[] = 'wp-content/plugins/quillforms';
			$exclude_list[] = 'wp-content/plugins/QuillForms';
			$exclude_list[] = 'wp-content/plugins/quillforms-*';
			$exclude_list[] = 'wp-includes/js/dist';
			$exclude_list[] = 'wp-includes/js/tinymce';
			// $exclude_list[] = 'wp-includes/js/dist/lodash';
			// $exclude_list[] = 'js/jquery/jquery.js';
			// $exclude_list[] = 'js/jquery/jquery.min.js';

			$exclude_list[] = 'react';
			$exclude_list[] = 'react-dom';
			$exclude_list[] = 'emotion';
			// $exclude_list[] = 'jquery';
			// $exclude_list[] = 'lodash';
			$exclude_list[] = 'quillforms-blocks';
			$exclude_list[] = 'quillforms-*';
			$exclude_list[] = 'quillforms-renderer-core';
			$exclude_list[] = 'wp-autop';
			$exclude_list[] = 'wp-data';
			$exclude_list[] = 'wp-polyfill-inert';
			$exclude_list[] = 'wp-polyfill';
			$exclude_list[] = 'wp-i18n';
			$exclude_list[] = 'wp-escape-html';
			$exclude_list[] = 'regenerator-runtime';
			$exclude_list[] = 'wp-deprecated';
			$exclude_list[] = 'wp-dom';
			$exclude_list[] = 'wp-compose';
			$exclude_list[] = 'wp-priority-queue';
			$exclude_list[] = 'wp-keycodes';
			$exclude_list[] = 'wp-is-shallow-equal';
			$exclude_list[] = 'wp-redux-routine';
			$exclude_list[] = 'quillforms-config';
			$exclude_list[] = 'quillforms-blocklib-date-block-renderer-script';
			$exclude_list[] = 'quillforms-blocklib-dropdown-block-renderer-script';
			$exclude_list[] = 'quillforms-blocklib-email-block-renderer-script';
			$exclude_list[] = 'quillforms-blocklib-long-text-block-renderer-script';
			$exclude_list[] = 'quillforms-blocklib-multiple-choice-block-renderer-script';
			$exclude_list[] = 'quillforms-blocklib-number-block-renderer-script';
			$exclude_list[] = 'quillforms-blocklib-short-text-block-renderer-script';
			$exclude_list[] = 'quillforms-blocklib-statement-block-renderer-script';
			$exclude_list[] = 'quillforms-blocklib-website-block-renderer-script';
			$exclude_list[] = 'quillforms-blocklib-welcome-screen-block-renderer-script';
			$exclude_list[] = 'quillforms-blocklib-rating-block-renderer-script';
			$exclude_list[] = 'quillforms-blocklib-phone-block-renderer-script';
			$exclude_list[] = 'quillforms-blocklib-address-block-renderer-script';
			$exclude_list[] = 'quillforms-blocklib-file-block-renderer-script';
			$exclude_list[] = 'quillforms-blocklib-opinion-scale-block-renderer-script';
			$exclude_list[] = 'quillforms-blocklib-picture-choice-block-renderer-script';
			$exclude_list[] = 'quillforms-blocklib-matrix-block-renderer-script';
			$exclude_list[] = 'quillforms-blocklib-slider-block-renderer-script';
			$exclude_list[] = 'quillforms-blocklib-legal-block-renderer-script';
			$exclude_list[] = 'quillforms-blocklib-group-block-renderer-script';
			$exclude_list[] = 'quillforms-blocklib-custom-thankyouscreen-block-renderer-script';
			$exclude_list[] = 'quillforms-iframe-resizer';
			$exclude_list[] = 'quillforms-iframe-resizer-implementer';
			$exclude_list[] = 'quillforms-iframe-resizer-content-window-script';
			$exclude_list[] = 'quillforms-react-renderer-script';
			$exclude_list[] = 'quillforms-blocklib-group-block-renderer-script';
			$exclude_list[] = 'quillforms-payment-gateways';
			$exclude_list[] = 'wp-dom-ready';
			$exclude_list[] = 'quillforms-blocklib-legal-block-renderer-script';
			$exclude_list[] = 'quillforms-react-renderer-script';
			$exclude_list[] = 'quillforms-stripe-renderer';
			$exclude_list[] = 'quillforms-paypal-renderer';
			$exclude_list[] = 'quillforms-logic-renderer';
			$exclude_list[] = 'wp-element';
			$exclude_list[] = 'quillforms-utils';
			$exclude_list[] = 'wp-hooks';
			$exclude_list[] = 'wp-*';
			$exclude_list[] = 'wp-private-apis';
			$exclude_list[] = 'quillforms-*';
			$exclude_list[] = 'wp-primitives';
			$exclude_list[] = 'wp-url';
			$exclude_list[] = 'wp-html-entities';
			$exclude_list[] = 'wp-core-data';
			$exclude_list[] = 'react-jsx-runtime';

		}
		return $exclude_list;
	}

	/**
	 * Exclude Quill Forms post type.
	 *
	 * @static
	 * @since 1.8.2
	 */
	public static function exclude_quillforms_post_type() {
		$post_types = \get_option( 'siteground_optimizer_post_types_exclude', array() );
		if ( ! in_array( 'quill_forms', $post_types, true ) ) {
			$post_types[] = 'quill_forms';
			\update_option( 'siteground_optimizer_post_types_exclude', $post_types );
		}
	}
		
}

SG_Optimize_Compatibility::hooks();
