<?php

/**
 * Template Name: Quick Download Button Page
 *
 * Template for quick download button
 * @package quick-download-button
 */
defined( 'ABSPATH' ) || exit; // Exit if accessed directly


include_once( dirname(__FILE__) . '/download.php') ; 

//If the 'quick-download-button' page URL is accessed directly, redirect to home

if(!current_user_can( 'edit_post', $post->ID )) {
     wp_redirect( site_url() );
     exit;
} 

// For user with permission, let show them message to know that this page is just to process download
get_header();

?>

<div class="wrapper" id="full-width-page-wrapper">

	<div class="container" id="content">

		<div class="row">

			<div class="col-md-12 content-area" id="primary">

				<main class="site-main" id="main" role="main">
                    <div class="container" style="padding:2.5rem">
                        <div style="margin-bottom:2rem"><strong>This page is generated by the Quick Download Button plugin</strong></div>
                        <p>You are seeing this because you have permission to edit. This page is a template use by the Quick Download Button Plugin, any other user will not see this.</p>
                        <p>When user access this page directly, they will be sent to homepage. You can rename this page as you wish. </p>
						<p><strong>Please check that your attributes for the quick download buttons are correct. For example the URL, when using shortcode for external link use 'url_external'. For internal link, use 'url'.</strong>.</p>

						<p>As an admin user - You will normally see this page when a download link fails. </p>
                    </div>
				</main><!-- #main -->

			</div><!-- #primary -->

		</div><!-- .row end -->

	</div><!-- Container end -->

</div><!-- Wrapper end -->

<?php get_footer(); ?>
