<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

require_once QCFW_CHECKOUT_PATH . 'includes/backend/class-qcfw-checkout-settings.php';

class Qcfw_Checkout_Add_To_Cart {

   /**
     * The single instance of the class.
     */
    protected static $instance;

    /**
     * Returns the single instance of the class.
     */
    public static function get_instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }

        return self::$instance;
    }

	/**
	 * Constructor.
	 */
	public function __construct() { 
		add_filter( 'woocommerce_product_add_to_cart_text', array( $this, 'qcfw_checkout_shop_add_to_cart_button_text_archives' ), 10, 2);
		add_filter( 'woocommerce_product_single_add_to_cart_text', array( $this, 'qcfw_checkout_single_add_to_cart_button_text_single' ) , 10, 2);
	}

	/**
	 * Archive/loop button text.
	 */
	public function qcfw_checkout_shop_add_to_cart_button_text_archives( $text, $product = null ) {
		if ( ! $product instanceof WC_Product ) {
			return $text;
		}

		$settings = Qcfw_Checkout_Settings::get_settings();

		$map = array(
			'simple'   => isset( $settings['qcfw_checkout_shop_simple_add_to_cart_btn'] ) ? $settings['qcfw_checkout_shop_simple_add_to_cart_btn'] : '',
			'variable' => isset( $settings['qcfw_checkout_shop_variable_add_to_cart_btn'] ) ? $settings['qcfw_checkout_shop_variable_add_to_cart_btn'] : '',
			'grouped'  => isset( $settings['qcfw_checkout_shop_grouped_add_to_cart_btn'] ) ? $settings['qcfw_checkout_shop_grouped_add_to_cart_btn'] : '',
			'external' => isset( $settings['qcfw_checkout_shop_external_add_to_cart_btn'] ) ? $settings['qcfw_checkout_shop_external_add_to_cart_btn'] : '',
		);

		$type  = $product->get_type();
		$label = isset( $map[ $type ] ) ? $map[ $type ] : '';

		return $label !== '' ? $label : $text;
	}

	/**
	 * Single product page button text.
	 */
	public function qcfw_checkout_single_add_to_cart_button_text_single( $text, $product = null ) {
		if ( ! $product instanceof WC_Product ) {
			return $text;
		}

		$settings = Qcfw_Checkout_Settings::get_settings();

		$map = array(
			'simple'   => isset( $settings['qcfw_checkout_single_simple_add_to_cart_btn'] ) ? $settings['qcfw_checkout_single_simple_add_to_cart_btn'] : '',
			'variable' => isset( $settings['qcfw_checkout_single_variable_add_to_cart_btn'] ) ? $settings['qcfw_checkout_single_variable_add_to_cart_btn'] : '',
			'grouped'  => isset( $settings['qcfw_checkout_single_grouped_add_to_cart_btn'] ) ? $settings['qcfw_checkout_single_grouped_add_to_cart_btn'] : '',
			'external' => isset( $settings['qcfw_checkout_single_external_add_to_cart_btn'] ) ? $settings['qcfw_checkout_single_external_add_to_cart_btn'] : '',
		);

		$type  = $product->get_type();
		$label = isset( $map[ $type ] ) ? $map[ $type ] : '';

		return $label !== '' ? $label : $text;
	}

}

/** Initialize the class instance. */
Qcfw_Checkout_Add_To_Cart::get_instance();