/******/ (function() { // webpackBootstrap
jQuery(document).ready(function ($) {
  'use strict';

  $('.qnap-purchase-add').on('click', function (e) {
    var self = $(this);
    self.attr('disabled', true);
    var dialog = self.closest('.qnap-modal-dialog');
    var error = dialog.find('.qnap-modal-error');
    var index = dialog.attr('id').split('-').pop();
    var purchaseId = dialog.find('.qnap-purchase-id').val();
    var updateLink = dialog.find('.qnap-update-link').val(); // Check Purchase ID

    $.ajax({
      url: 'https://qeek.com/purchase/' + purchaseId + '/check',
      type: 'GET',
      dataType: 'json',
      dataFilter: function dataFilter(data) {
        return QNAP.Util.json(data);
      }
    }).done(function (product) {
      // Update Purchase ID
      $.ajax({
        url: qnap_updater.ajax.url,
        type: 'POST',
        dataType: 'json',
        data: {
          qnap_uuid: product.uuid,
          qnap_extension: product.extension
        },
        dataFilter: function dataFilter(data) {
          return QNAP.Util.json(data);
        }
      }).done(function () {
        window.location.hash = ''; // Update plugin row

        $('#qnap-update-section-' + index).html($('<a />').attr('href', updateLink).text(qnap_locale.check_for_updates));
        self.attr('disabled', false);
      });
    }).fail(function () {
      self.attr('disabled', false);
      error.html(qnap_locale.invalid_purchase_id);
    });
    e.preventDefault();
  });
  $('.qnap-purchase-discard').on('click', function (e) {
    window.location.hash = '';
    e.preventDefault();
  });
});
/******/ })()
;