/******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 332:
/***/ (function() {

jQuery(document).ready(function ($) {
  'use strict'; // Idea

  $('#qnap-feedback-type-link-1').on('click', function () {
    var radio = $('#qnap-feedback-type-1');

    if (radio.is(':checked')) {
      radio.attr('checked', false);
    } else {
      radio.attr('checked', true);
    }
  }); // Help

  $('#qnap-feedback-type-2').on('click', function () {
    // Hide other options
    $('#qnap-feedback-type-1').closest('li').hide(); // Change placeholder message

    $('.qnap-feedback-form').find('.qnap-feedback-message').attr('placeholder', qnap_locale.how_may_we_help_you); // Show feedback form

    $('.qnap-feedback-form').fadeIn();
  }); // Cancel feedback form

  $('#qnap-feedback-cancel').on('click', function (e) {
    $('.qnap-feedback-form').fadeOut(function () {
      $('.qnap-feedback-type').attr('checked', false).closest('li').show();
    });
    e.preventDefault();
  }); // Send feedback form

  $('#qnap-feedback-submit').on('click', function (e) {
    var self = $(this);
    var spinner = self.next();
    var type = $('.qnap-feedback-type:checked').val();
    var email = $('.qnap-feedback-email').val();
    var message = $('.qnap-feedback-message').val();
    var terms = $('.qnap-feedback-terms').is(':checked');
    self.attr('disabled', true);
    spinner.css('visibility', 'visible');
    $.ajax({
      url: qnap_feedback.ajax.url,
      type: 'POST',
      dataType: 'json',
      async: true,
      data: {
        secret_key: qnap_feedback.secret_key,
        qnap_type: type,
        qnap_email: email,
        qnap_message: message,
        qnap_terms: +terms
      },
      dataFilter: function dataFilter(data) {
        return QNAP.Util.json(data);
      }
    }).done(function (data) {
      self.attr('disabled', false);
      spinner.css('visibility', 'hidden');

      if (data.errors.length > 0) {
        $('.qnap-feedback .qnap-message').remove();
        var errorMessage = $('<div />').addClass('qnap-message qnap-error-message');
        $.each(data.errors, function (key, value) {
          errorMessage.append($('<p />').text(value));
        });
        $('.qnap-feedback').prepend(errorMessage);
      } else {
        var successMessage = $('<div />').addClass('qnap-message qnap-success-message');
        successMessage.append($('<p />').text(qnap_locale.thanks_for_submitting_your_feedback));
        $('.qnap-feedback').html(successMessage);
      }
    });
    e.preventDefault();
  });
});

/***/ }),

/***/ 947:
/***/ (function() {

jQuery(document).ready(function ($) {
  'use strict';

  $('#qnap-report-problem-button').on('click', function (e) {
    $(this).next('.qnap-report-problem-dialog').toggleClass('qnap-report-active');
    e.preventDefault();
  });
  $('#qnap-report-cancel').on('click', function (e) {
    $(this).closest('.qnap-report-problem-dialog').removeClass('qnap-report-active');
    e.preventDefault();
  });
  $('#qnap-report-submit').on('click', function (e) {
    var self = $(this);
    var spinner = self.next();
    var email = $('.qnap-report-email').val();
    var message = $('.qnap-report-message').val();
    var terms = $('.qnap-report-terms').is(':checked');
    self.attr('disabled', true);
    spinner.css('visibility', 'visible');
    $.ajax({
      url: qnap_report.ajax.url,
      type: 'POST',
      dataType: 'json',
      async: true,
      data: {
        secret_key: qnap_report.secret_key,
        qnap_email: email,
        qnap_message: message,
        qnap_terms: +terms
      },
      dataFilter: function dataFilter(data) {
        return QNAP.Util.json(data);
      }
    }).done(function (data) {
      self.attr('disabled', false);
      spinner.css('visibility', 'hidden');

      if (data.errors.length > 0) {
        $('.qnap-report-problem-dialog .qnap-message').remove();
        var errorMessage = $('<div />').addClass('qnap-message qnap-error-message');
        $.each(data.errors, function (key, value) {
          errorMessage.append($('<p />').text(value));
        });
        $('.qnap-report-problem-dialog').prepend(errorMessage);
      } else {
        var successMessage = $('<div />').addClass('qnap-message qnap-success-message');
        successMessage.append($('<p />').text(qnap_locale.thanks_for_submitting_your_request));
        $('.qnap-report-problem-dialog').html(successMessage); // Hide message

        setTimeout(function () {
          $('.qnap-report-problem-dialog').removeClass('qnap-report-active');
        }, 2000);
      }
    });
    e.preventDefault();
  });
});

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		if(__webpack_module_cache__[moduleId]) {
/******/ 			return __webpack_module_cache__[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/global */
/******/ 	!function() {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	}();
/******/ 	
/************************************************************************/
!function() {
var Feedback = __webpack_require__(332),
    Report = __webpack_require__(947);

jQuery(document).ready(function () {
  'use strict';
});
__webpack_require__.g.QNAP = jQuery.extend({}, __webpack_require__.g.QNAP, {
  Feedback: Feedback,
  Report: Report
});
}();
/******/ })()
;