/******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 12:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var Modal = __webpack_require__(326),
    $ = jQuery;

var Export = function Export() {
  var self = this; // Set params

  this.params = []; // Set modal

  this.modal = new Modal(); // Set stop listener

  this.modal.onStop = function (options) {
    self.onStop(options);
  };
};

Export.prototype.setParams = function (params) {
  this.params = QNAP.Util.list(params);
};

Export.prototype.start = function (options, retries) {
  var self = this;
  retries = retries || 0; // Reset stop flag

  if (retries === 0) {
    this.stopExport(false);
  } // Stop running export


  if (this.isExportStopped()) {
    return;
  } // Initializing beforeunload event


  $(window).bind('beforeunload', function () {
    return qnap_locale.stop_exporting_your_website;
  }); // Set initial status

  this.setStatus({
    type: 'info',
    message: qnap_locale.preparing_to_export
  }); // Set params

  var params = this.params.concat({
    name: 'secret_key',
    value: qnap_export.secret_key
  }); // Set additional params

  if (options) {
    params = params.concat(QNAP.Util.list(options));
  } // Export


  $.ajax({
    url: qnap_export.ajax.url,
    type: 'POST',
    dataType: 'json',
    data: params,
    dataFilter: function dataFilter(data) {
      return QNAP.Util.json(data);
    }
  }).done(function () {
    self.getStatus();
  }).done(function (result) {
    if (result) {
      self.run(result);
    }
  }).fail(function (xhr) {
    var timeout = retries * 1000;

    try {
      var json = QNAP.Util.json(xhr.responseText);

      if (json) {
        var result = JSON.parse(json);
        var error = result.errors.pop();

        if (error.message) {
          self.stopExport(true);
          self.setStatus({
            type: 'error',
            title: qnap_locale.unable_to_export,
            message: error.message
          });
          return;
        }
      }
    } catch (e) {}

    if (retries >= 5) {
      self.stopExport(true);
      self.setStatus({
        type: 'error',
        title: qnap_locale.unable_to_export,
        message: qnap_locale.unable_to_start_the_export
      });
      return;
    }

    retries++;
    setTimeout(self.start.bind(self, options, retries), timeout);
  });
};

Export.prototype.run = function (params, retries) {
  var self = this;
  retries = retries || 0; // Stop running export

  if (this.isExportStopped()) {
    return;
  } // Export


  $.ajax({
    url: qnap_export.ajax.url,
    type: 'POST',
    dataType: 'json',
    data: params,
    dataFilter: function dataFilter(data) {
      return QNAP.Util.json(data);
    }
  }).done(function (result) {
    if (result) {
      self.run(result);
    }
  }).fail(function (xhr) {
    var timeout = retries * 1000;

    try {
      var json = QNAP.Util.json(xhr.responseText);

      if (json) {
        var result = JSON.parse(json);
        var error = result.errors.pop();

        if (error.message) {
          self.stopExport(true);
          self.setStatus({
            type: 'error',
            title: qnap_locale.unable_to_export,
            message: error.message
          });
          return;
        }
      }
    } catch (e) {}

    if (retries >= 5) {
      self.stopExport(true);
      self.setStatus({
        type: 'error',
        title: qnap_locale.unable_to_export,
        message: qnap_locale.unable_to_run_the_export
      });
      return;
    }

    retries++;
    setTimeout(self.run.bind(self, params, retries), timeout);
  });
};

Export.prototype.clean = function (options, retries) {
  var self = this;
  retries = retries || 0; // Reset stop flag

  if (retries === 0) {
    this.stopExport(true);
  } // Set initial status


  this.setStatus({
    type: 'info',
    message: qnap_locale.please_wait_stopping_the_export
  }); // Set params

  var params = this.params.concat({
    name: 'secret_key',
    value: qnap_export.secret_key
  }).concat({
    name: 'priority',
    value: 300
  }); // Set additional params

  if (options) {
    params = params.concat(QNAP.Util.list(options));
  } // Clean


  $.ajax({
    url: qnap_export.ajax.url,
    type: 'POST',
    dataType: 'json',
    data: params,
    dataFilter: function dataFilter(data) {
      return QNAP.Util.json(data);
    }
  }).done(function () {
    // Unbinding the beforeunload event when we stop exporting
    $(window).unbind('beforeunload'); // Destroy modal

    self.modal.destroy();
  }).fail(function (xhr) {
    var timeout = retries * 1000;

    try {
      var json = QNAP.Util.json(xhr.responseText);

      if (json) {
        var result = JSON.parse(json);
        var error = result.errors.pop();

        if (error.message) {
          self.stopExport(true);
          self.setStatus({
            type: 'error',
            title: qnap_locale.unable_to_export,
            message: error.message
          });
          return;
        }
      }
    } catch (e) {}

    if (retries >= 5) {
      self.stopExport(true);
      self.setStatus({
        type: 'error',
        title: qnap_locale.unable_to_export,
        message: qnap_locale.unable_to_stop_the_export
      });
      return;
    }

    retries++;
    setTimeout(self.clean.bind(self, options, retries), timeout);
  });
};

Export.prototype.getStatus = function () {
  var self = this; // Stop getting status

  if (this.isExportStopped()) {
    return;
  }

  this.statusXhr = $.ajax({
    url: qnap_export.status.url,
    type: 'GET',
    dataType: 'json',
    cache: false,
    dataFilter: function dataFilter(data) {
      return QNAP.Util.json(data);
    }
  }).done(function (params) {
    if (params) {
      self.setStatus(params); // Next status

      switch (params.type) {
        case 'done':
        case 'error':
        case 'download':
          // Unbinding beforeunload event when any case is performed
          $(window).unbind('beforeunload');
          return;
      }
    } // Export is not done yet, let's check status in 3 seconds


    setTimeout(self.getStatus.bind(self), 3000);
  }).fail(function () {
    // Export is not done yet, let's check status in 3 seconds
    setTimeout(self.getStatus.bind(self), 3000);
  });
};

Export.prototype.setStatus = function (params) {
  this.modal.render(params);
};

Export.prototype.onStop = function (options) {
  this.clean(options);
};

Export.prototype.stopExport = function (isStopped) {
  try {
    if (isStopped && this.statusXhr) {
      this.statusXhr.abort();
    }
  } finally {
    this.isStopped = isStopped;
  }
};

Export.prototype.isExportStopped = function () {
  return this.isStopped;
};

module.exports = Export;

/***/ }),

/***/ 326:
/***/ (function(module) {

var $ = jQuery;

var Modal = function Modal() {
  var self = this; // Error Modal

  this.error = function (params) {
    // Create the modal container
    var container = $('<div></div>'); // Create section to hold title, message and action

    var section = $('<section></section>'); // Create header to hold title

    var header = $('<h1></h1>'); // Create paragraph to hold mesage

    var message = $('<p></p>').html(params.message); // Create action section

    var action = $('<div></div>'); // Create title

    var title = $('<span></span>').addClass('qnap-title-red').text(params.title); // Create close button

    var closeButton = $('<button type="button" class="qnap-button-red"></button>').on('click', function () {
      self.destroy();
    }); // Append text to close button

    closeButton.append(qnap_locale.close_export); // Append close button to action

    action.append(closeButton); // Append title to section

    header.append(title); // Append header and message to section

    section.append(header).append(message); // Append section and action to container

    container.append(section).append(action); // Render modal

    self.modal.html(container).show();
    self.modal.trigger('focus');
    self.overlay.show();
  }; // Info Modal


  this.info = function (params) {
    // Create the modal container
    var container = $('<div></div>'); // Create section to hold title, message and action

    var section = $('<section></section>'); // Create header to hold loader

    var header = $('<h1></h1>'); // Create paragraph to hold mesage

    var message = $('<p></p>').html(params.message); // Create action section

    var action = $('<div></div>'); // Create loader

    var loader = $('<span class="qnap-loader"></span>'); // Create stop export

    var stopButton = $('<button type="button" class="qnap-button-red"></button>').on('click', function () {
      stopButton.attr('disabled', 'disabled');
      self.onStop();
    }); // Append text to stop button

    stopButton.append('<i class="qnap-icon-notification"></i> ' + qnap_locale.stop_export); // Append stop button to action

    action.append(stopButton); // Append loader to header

    header.append(loader); // Append header and message to section

    section.append(header).append(message); // Append section and action to container

    container.append(section).append(action); // Render modal

    self.modal.html(container).show();
    self.modal.trigger('focus');
    self.overlay.show();
  }; // Done Modal


  this.done = function (params) {
    // Create the modal container
    var container = $('<div></div>'); // Create section to hold title, message and action

    var section = $('<section></section>'); // Create header to hold title

    var header = $('<h1></h1>'); // Create paragraph to hold mesage

    var message = $('<p></p>').html(params.message); // Create action section

    var action = $('<div></div>'); // Create title

    var title = $('<span></span>').addClass('qnap-title-green').text(params.title); // Create close button

    var closeButton = $('<button type="button" class="qnap-button-red"></button>').on('click', function () {
      self.destroy();
    }); // Append text to close button

    closeButton.append(qnap_locale.close_export); // Append close button to action

    action.append(closeButton); // Append title to section

    header.append(title); // Append header and message to section

    section.append(header).append(message); // Append section and action to container

    container.append(section).append(action); // Render modal

    self.modal.html(container).show();
    self.modal.trigger('focus');
    self.overlay.show();
  }; // Download Modal


  this.download = function (params) {
    // Create the modal container
    var container = $('<div></div>'); // Create section to hold title, message and action

    var section = $('<section></section>'); // Create paragraph to hold mesage

    var message = $('<p></p>').html(params.message); // Create action section

    var action = $('<div></div>'); // Create close button

    var closeButton = $('<button type="button" class="qnap-button-red"></button>').on('click', function () {
      self.destroy();
    }); // Append text to close button

    closeButton.append(qnap_locale.close_export); // Append close button to action

    action.append(closeButton); // Append message to section

    section.append(message); // Append section and action to container

    container.append(section).append(action); // Render modal

    self.modal.html(container).show();
    self.modal.trigger('focus');
    self.overlay.show();
  }; // Create the overlay


  this.overlay = $('<div class="qnap-overlay"></div>'); // Create the modal container

  this.modal = $('<div class="qnap-modal-container" role="dialog" tabindex="-1"></div>');
  $('body').append(this.overlay) // Append overlay to body
  .append(this.modal); // Append modal to body
};

Modal.prototype.render = function (params) {
  $(document).trigger('qnap-export-status', params); // Show modal

  switch (params.type) {
    case 'error':
      this.error(params);
      break;

    case 'info':
      this.info(params);
      break;

    case 'done':
      this.done(params);
      break;

    case 'download':
      this.download(params);
      break;
  }
};

Modal.prototype.destroy = function () {
  this.modal.hide();
  this.overlay.hide();
};

module.exports = Modal;

/***/ }),

/***/ 813:
/***/ (function() {

(function ($) {
  $.fn.qnap_find_replace = function () {
    $(this).on('click', function (e) {
      e.preventDefault();
      var row = $('#qnap-queries > li:first').clone(); // Reset input values

      row.find('input').val(''); // Reset qnap-query-find-text

      row.find('.qnap-query-find-text').html('&lt;text&gt;'); // Reset qnap-query-replace-text

      row.find('.qnap-query-replace-text').html('&lt;another-text&gt;');
      $('#qnap-queries > li').removeClass('qnap-open');
      $(row).addClass('qnap-open'); // Add new replace fields

      $('#qnap-queries').append(row);
      $(row).qnap_query();
      $(row).find('p:first').on('click', function () {
        $(this).parent().toggleClass('qnap-open');
      });
    });
    return this;
  };
})(jQuery);

/***/ }),

/***/ 88:
/***/ (function() {

(function ($) {
  $.fn.qnap_query = function () {
    var findInput = $(this).find('input.qnap-query-find-input'),
        replaceInput = $(this).find('input.qnap-query-replace-input'),
        findText = $(this).find('small.qnap-query-find-text'),
        replaceText = $(this).find('small.qnap-query-replace-text');
    findInput.on('change paste input keypress keydown keyup', function () {
      var _inputValue = $(this).val().length > 0 ? $(this).val() : '<text>';

      findText.text(_inputValue);
    });
    replaceInput.on('change paste input keypress keydown keyup', function () {
      var _inputValue = $(this).val().length > 0 ? $(this).val() : '<another-text>';

      replaceText.text(_inputValue);
    });
    return this;
  };
})(jQuery);

/***/ }),

/***/ 332:
/***/ (function() {

jQuery(document).ready(function ($) {
  'use strict'; // Idea

  $('#qnap-feedback-type-link-1').on('click', function () {
    var radio = $('#qnap-feedback-type-1');

    if (radio.is(':checked')) {
      radio.attr('checked', false);
    } else {
      radio.attr('checked', true);
    }
  }); // Help

  $('#qnap-feedback-type-2').on('click', function () {
    // Hide other options
    $('#qnap-feedback-type-1').closest('li').hide(); // Change placeholder message

    $('.qnap-feedback-form').find('.qnap-feedback-message').attr('placeholder', qnap_locale.how_may_we_help_you); // Show feedback form

    $('.qnap-feedback-form').fadeIn();
  }); // Cancel feedback form

  $('#qnap-feedback-cancel').on('click', function (e) {
    $('.qnap-feedback-form').fadeOut(function () {
      $('.qnap-feedback-type').attr('checked', false).closest('li').show();
    });
    e.preventDefault();
  }); // Send feedback form

  $('#qnap-feedback-submit').on('click', function (e) {
    var self = $(this);
    var spinner = self.next();
    var type = $('.qnap-feedback-type:checked').val();
    var email = $('.qnap-feedback-email').val();
    var message = $('.qnap-feedback-message').val();
    var terms = $('.qnap-feedback-terms').is(':checked');
    self.attr('disabled', true);
    spinner.css('visibility', 'visible');
    $.ajax({
      url: qnap_feedback.ajax.url,
      type: 'POST',
      dataType: 'json',
      async: true,
      data: {
        secret_key: qnap_feedback.secret_key,
        qnap_type: type,
        qnap_email: email,
        qnap_message: message,
        qnap_terms: +terms
      },
      dataFilter: function dataFilter(data) {
        return QNAP.Util.json(data);
      }
    }).done(function (data) {
      self.attr('disabled', false);
      spinner.css('visibility', 'hidden');

      if (data.errors.length > 0) {
        $('.qnap-feedback .qnap-message').remove();
        var errorMessage = $('<div />').addClass('qnap-message qnap-error-message');
        $.each(data.errors, function (key, value) {
          errorMessage.append($('<p />').text(value));
        });
        $('.qnap-feedback').prepend(errorMessage);
      } else {
        var successMessage = $('<div />').addClass('qnap-message qnap-success-message');
        successMessage.append($('<p />').text(qnap_locale.thanks_for_submitting_your_feedback));
        $('.qnap-feedback').html(successMessage);
      }
    });
    e.preventDefault();
  });
});

/***/ }),

/***/ 947:
/***/ (function() {

jQuery(document).ready(function ($) {
  'use strict';

  $('#qnap-report-problem-button').on('click', function (e) {
    $(this).next('.qnap-report-problem-dialog').toggleClass('qnap-report-active');
    e.preventDefault();
  });
  $('#qnap-report-cancel').on('click', function (e) {
    $(this).closest('.qnap-report-problem-dialog').removeClass('qnap-report-active');
    e.preventDefault();
  });
  $('#qnap-report-submit').on('click', function (e) {
    var self = $(this);
    var spinner = self.next();
    var email = $('.qnap-report-email').val();
    var message = $('.qnap-report-message').val();
    var terms = $('.qnap-report-terms').is(':checked');
    self.attr('disabled', true);
    spinner.css('visibility', 'visible');
    $.ajax({
      url: qnap_report.ajax.url,
      type: 'POST',
      dataType: 'json',
      async: true,
      data: {
        secret_key: qnap_report.secret_key,
        qnap_email: email,
        qnap_message: message,
        qnap_terms: +terms
      },
      dataFilter: function dataFilter(data) {
        return QNAP.Util.json(data);
      }
    }).done(function (data) {
      self.attr('disabled', false);
      spinner.css('visibility', 'hidden');

      if (data.errors.length > 0) {
        $('.qnap-report-problem-dialog .qnap-message').remove();
        var errorMessage = $('<div />').addClass('qnap-message qnap-error-message');
        $.each(data.errors, function (key, value) {
          errorMessage.append($('<p />').text(value));
        });
        $('.qnap-report-problem-dialog').prepend(errorMessage);
      } else {
        var successMessage = $('<div />').addClass('qnap-message qnap-success-message');
        successMessage.append($('<p />').text(qnap_locale.thanks_for_submitting_your_request));
        $('.qnap-report-problem-dialog').html(successMessage); // Hide message

        setTimeout(function () {
          $('.qnap-report-problem-dialog').removeClass('qnap-report-active');
        }, 2000);
      }
    });
    e.preventDefault();
  });
});

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		if(__webpack_module_cache__[moduleId]) {
/******/ 			return __webpack_module_cache__[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/global */
/******/ 	!function() {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	}();
/******/ 	
/************************************************************************/
!function() {
var Query = __webpack_require__(88),
    FindReplace = __webpack_require__(813),
    Feedback = __webpack_require__(332),
    Report = __webpack_require__(947),
    Export = __webpack_require__(12);

jQuery(document).ready(function ($) {
  'use strict';

  var model = new Export(); // Export to file

  $('#qnap-export-file').on('click', function (e) {
    var storage = QNAP.Util.random(12);
    var options = QNAP.Util.form('#qnap-export-form').concat({
      name: 'storage',
      value: storage
    }).concat({
      name: 'file',
      value: 1
    }); // Set global params

    model.setParams(options); // Start export

    model.start();
    e.preventDefault();
  });
  $('.qnap-accordion > .qnap-title').on('click', function () {
    $(this).parent().toggleClass('qnap-active');
  });
  $('#qnap-add-new-replace-button').qnap_find_replace();
  $('.qnap-expandable > p:first, .qnap-expandable > h4:first, .qnap-expandable > div.qnap-button-main').on('click', function () {
    $(this).parent().toggleClass('qnap-open');
  });
  $('.qnap-query').qnap_query();
});
__webpack_require__.g.QNAP = jQuery.extend({}, __webpack_require__.g.QNAP, {
  Query: Query,
  FindReplace: FindReplace,
  Feedback: Feedback,
  Report: Report,
  Export: Export
});
}();
/******/ })()
;