<?php

add_shortcode( 'avada_property_enquiry_form_link', function( $atts ) {
    $atts = shortcode_atts( array(
        'content_align'    => 'left',
        'fusion_font_family_enquiry_form_link_font' => '',
        'fusion_font_variant_enquiry_form_link_font' => '',
        'font_size'  => '',
        'letter_spacing'  => '',
        'text_transform'  => '',
        'line_height'  => '',
        'text_color'       => '',
    ), $atts );

    if ( get_post_type( get_the_ID() ) != 'property' )
    {
    	return '';
    }

    fusion_element_rendering_elements( true );

    global $property;
    
    if ( empty($property) )
    {
        $property = new PH_Property(get_the_ID());
    }

    $style = Fusion_Builder_Element_Helper::get_font_styling( $atts, 'enquiry_form_link_font' );

	if ( $atts['font_size'] ) {
		$style .= 'font-size:' . fusion_library()->sanitize->get_value_with_unit( $atts['font_size'] ) . ';';
	}

	if ( $atts['letter_spacing'] ) {
		$style .= 'letter-spacing:' . fusion_library()->sanitize->get_value_with_unit( $atts['letter_spacing'] ) . ';';
	}

	if ( ! empty( $atts['text_transform'] ) ) {
		$style .= 'text-transform:' . $atts['text_transform'] . ';';
	}

	if ( ! empty( $atts['content_align'] ) ) {
		$style .= 'text-align:' . $atts['content_align'] . ';';
	}

    ob_start();
?>

    <a data-fancybox data-src="#makeEnquiry<?php echo $property->id; ?>" href="javascript:;" style="<?php echo $style; ?>"><?php echo esc_html(__( 'Make Enquiry', 'propertyhive' )); ?></a>

    <!-- LIGHTBOX FORM -->
    <div id="makeEnquiry<?php echo (int)$property->id; ?>" style="display:none;">
        
        <h2><?php echo esc_html(__( 'Make Enquiry', 'propertyhive' )); ?></h2>
        
        <p><?php _e( 'Please complete the form below and a member of staff will be in touch shortly.', 'propertyhive' ); ?></p>
        
        <?php propertyhive_enquiry_form(); ?>
        
    </div>
    <!-- END LIGHTBOX FORM -->
    
<?php

    $html = ob_get_clean();

    fusion_element_rendering_elements( false );

    return $html;
});