<?php
/**
 * MemberPress subscription form
 *
 * @author    Pronamic <info@pronamic.eu>
 * @copyright 2005-2024 Pronamic
 * @license   GPL-3.0-or-later
 * @package   Pronamic\WordPress\Pay\Extensions\MemberPress
 */

if ( ! isset( $memberpress_subscription_id ) ) {
	return;
}

$query = new WP_Query(
	[
		'post_type'   => 'pronamic_pay_subscr',
		'post_status' => [ 'any', 'trash' ],
		'nopaging'    => true,
		'meta_query'  => [
			[
				'key'     => '_pronamic_subscription_source',
				'compare' => '=',
				'value'   => 'memberpress_subscription',
			],
			[
				'key'     => '_pronamic_subscription_source_id',
				'compare' => '=',
				'value'   => $memberpress_subscription_id,
			],
		],
	]
);

$ps = array_filter(
	$query->posts,
	function ( $post ) {
		return $post instanceof WP_Post;
	}
);

$items = [];

foreach ( $ps as $p ) {
	$url = get_edit_post_link( $p );

	if ( null === $url ) {
		continue;
	}

	$items[ $p->ID ] = $url;
}

?>
<tr valign="top">
	<th scope="row">
		<label for="trans_num"><?php esc_html_e( 'Pronamic Subscription', 'pronamic-ideal' ); ?></label>
	</th>
	<td>
		<?php

		if ( \count( $items ) > 0 ) {
			echo '<ul>';

			foreach ( $items as $subscription_id => $url ) {
				echo '<li>';

				// Status.
				$status_label = __( 'Unknown status', 'pronamic-ideal' );

				$post_status = get_post_status( $subscription_id );

				if ( 'trash' === $post_status ) {
					$post_status = get_post_meta( $subscription_id, '_wp_trash_meta_status', true );
				}

				if ( is_string( $post_status ) ) {
					$status_object = get_post_status_object( $post_status );

					if ( null !== $status_object && isset( $status_object->label ) ) {
						$status_label = $status_object->label;
					}
				}

				// Next payment date.
				$next_payment = __( 'No payment scheduled', 'pronamic-ideal' );

				$subscription = get_pronamic_subscription( $subscription_id );

				if ( null !== $subscription ) {
					$next_payment_date = $subscription->get_next_payment_date();

					if ( null !== $next_payment_date ) {
						$next_payment = sprintf(
						/* translators: %s: formatted next payment date */
							__( 'Next payment at %s', 'pronamic-ideal' ),
							$next_payment_date->format_i18n( __( 'D j M Y', 'pronamic-ideal' ) )
						);
					}
				}

				\printf(
					'<a href="%s">%s</a> — %s — %s',
					\esc_url( $url ),
					\esc_html( (string) $subscription_id ),
					\esc_html( $status_label ),
					\esc_html( $next_payment )
				);

				echo '</li>';
			}

			echo '</ul>';
		}

		?>
	</td>
</tr>
