<?php
/**
 * Currencies
 *
 * @author    Pronamic <info@pronamic.eu>
 * @copyright 2005-2024 Pronamic
 * @license   GPL-3.0-or-later
 * @package   Pronamic\WordPress\Money
 */

namespace Pronamic\WordPress\Money;

/**
 * Currencies
 *
 * @link https://github.com/moneyphp/money/blob/v3.1.3/src/Currencies/ISOCurrencies.php#L90-L102
 * @link https://github.com/moneyphp/money/blob/v3.1.3/resources/currency.php
 *
 * @author Remco Tolsma
 * @version 1.2.2
 */
return [
	new Currency(
		'AED',
		'784',
		__( 'UAE Dirham', 'pronamic-ideal' ),
		'د.إ',
		2
	),
	new Currency(
		'AFN',
		'971',
		__( 'Afghan Afghani', 'pronamic-ideal' ),
		'؋',
		2
	),
	new Currency(
		'ALL',
		'008',
		__( 'Albanian Lek', 'pronamic-ideal' ),
		'L',
		2
	),
	new Currency(
		'AMD',
		'051',
		__( 'Armenian Dram', 'pronamic-ideal' ),
		'֏',
		2
	),
	new Currency(
		'ANG',
		'532',
		__( 'Netherlands Antillean Guilder', 'pronamic-ideal' ),
		'ƒ',
		2
	),
	new Currency(
		'AOA',
		'973',
		__( 'Angolan Kwanza', 'pronamic-ideal' ),
		'Kz',
		2
	),
	new Currency(
		'ARS',
		'032',
		__( 'Argentine Peso', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'AUD',
		'036',
		__( 'Australian Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'AWG',
		'533',
		__( 'Aruban Florin', 'pronamic-ideal' ),
		'ƒ',
		2
	),
	new Currency(
		'AZN',
		'944',
		__( 'Azerbaijan Manat', 'pronamic-ideal' ),
		'₼',
		2
	),
	new Currency(
		'BAM',
		'977',
		__( 'Bosnia and Herzegovina Convertible Mark', 'pronamic-ideal' ),
		'KM',
		2
	),
	new Currency(
		'BBD',
		'052',
		__( 'Barbados Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'BDT',
		'050',
		__( 'Bangladeshi Taka', 'pronamic-ideal' ),
		'৳',
		2
	),
	new Currency(
		'BGN',
		'975',
		__( 'Bulgarian Lev', 'pronamic-ideal' ),
		'лв.',
		2
	),
	new Currency(
		'BHD',
		'048',
		__( 'Bahraini Dinar', 'pronamic-ideal' ),
		'.د.ب',
		3
	),
	new Currency(
		'BIF',
		'108',
		__( 'Burundian Franc', 'pronamic-ideal' ),
		'FBu',
		0
	),
	new Currency(
		'BMD',
		'060',
		__( 'Bermudian Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'BND',
		'096',
		__( 'Brunei Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'BOB',
		'068',
		__( 'Bolíviano', 'pronamic-ideal' ),
		'$b',
		2
	),
	new Currency(
		'BOV',
		'984',
		__( 'Bolivian Mvdol', 'pronamic-ideal' ),
		null,
		2
	),
	new Currency(
		'BRL',
		'986',
		__( 'Brazilian Real', 'pronamic-ideal' ),
		'R$',
		2
	),
	new Currency(
		'BSD',
		'044',
		__( 'Bahamian Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'BTN',
		'064',
		__( 'Bhutanese Ngultrum', 'pronamic-ideal' ),
		'Nu.',
		2
	),
	new Currency(
		'BWP',
		'072',
		__( 'Botswana Pula', 'pronamic-ideal' ),
		'P',
		2
	),
	new Currency(
		'BYN',
		'933',
		__( 'Belarusian Ruble', 'pronamic-ideal' ),
		'Br',
		2
	),
	new Currency(
		'BZD',
		'084',
		__( 'Belize Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'CAD',
		'124',
		__( 'Canadian Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'CDF',
		'976',
		__( 'Congolese Franc', 'pronamic-ideal' ),
		'F',
		2
	),
	new Currency(
		'CHE',
		'947',
		__( 'WIR Euro', 'pronamic-ideal' ),
		'€',
		2
	),
	new Currency(
		'CHF',
		'756',
		__( 'Swiss Franc', 'pronamic-ideal' ),
		'F',
		2
	),
	new Currency(
		'CHW',
		'948',
		__( 'WIR Franc', 'pronamic-ideal' ),
		'F',
		2
	),
	new Currency(
		'CLF',
		'990',
		__( 'Unidad de Fomento', 'pronamic-ideal' ),
		'UF',
		4
	),
	new Currency(
		'CLP',
		'152',
		__( 'Chilean Peso', 'pronamic-ideal' ),
		'$',
		0
	),
	new Currency(
		'CNY',
		'156',
		__( 'Renminbi Yuan', 'pronamic-ideal' ),
		'元',
		2
	),
	new Currency(
		'COP',
		'170',
		__( 'Colombian Peso', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'COU',
		'970',
		__( 'Unidad de Valor Real', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'CRC',
		'188',
		__( 'Costa Rican Colon', 'pronamic-ideal' ),
		'₡',
		2
	),
	new Currency(
		'CUC',
		'931',
		__( 'Cuban Convertible Peso', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'CUP',
		'192',
		__( 'Cuban Peso', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'CVE',
		'132',
		__( 'Cape Verde Escudo', 'pronamic-ideal' ),
		'Esc',
		2
	),
	new Currency(
		'CZK',
		'203',
		__( 'Czech Koruna', 'pronamic-ideal' ),
		'Kč',
		2
	),
	new Currency(
		'DJF',
		'262',
		__( 'Djiboutian Franc', 'pronamic-ideal' ),
		'F',
		0
	),
	new Currency(
		'DKK',
		'208',
		__( 'Danish Krone', 'pronamic-ideal' ),
		'kr',
		2
	),
	new Currency(
		'DOP',
		'214',
		__( 'Dominican Peso', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'DZD',
		'012',
		__( 'Algerian Dinar', 'pronamic-ideal' ),
		'دج',
		2
	),
	new Currency(
		'EGP',
		'818',
		__( 'Egyptian Pound', 'pronamic-ideal' ),
		'£',
		2
	),
	new Currency(
		'ERN',
		'232',
		__( 'Eritrean Nakfa', 'pronamic-ideal' ),
		'Nfk',
		2
	),
	new Currency(
		'ETB',
		'230',
		__( 'Ethiopian Birr', 'pronamic-ideal' ),
		'Br',
		2
	),
	new Currency(
		'EUR',
		'978',
		__( 'Euro', 'pronamic-ideal' ),
		'€',
		2
	),
	new Currency(
		'FJD',
		'242',
		__( 'Fiji Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'FKP',
		'238',
		__( 'Falkland Islands Pound', 'pronamic-ideal' ),
		'£',
		2
	),
	new Currency(
		'GBP',
		'826',
		__( 'Pound Sterling', 'pronamic-ideal' ),
		'£',
		2
	),
	new Currency(
		'GEL',
		'981',
		__( 'Georgian Lari', 'pronamic-ideal' ),
		'ლ',
		2
	),
	new Currency(
		'GHS',
		'936',
		__( 'Ghanaian Cedi', 'pronamic-ideal' ),
		'GH₵',
		2
	),
	new Currency(
		'GIP',
		'292',
		__( 'Gibraltar Pound', 'pronamic-ideal' ),
		'£',
		2
	),
	new Currency(
		'GMD',
		'270',
		__( 'Gambian Dalasi', 'pronamic-ideal' ),
		'D',
		2
	),
	new Currency(
		'GNF',
		'324',
		__( 'Guinean Franc', 'pronamic-ideal' ),
		'F',
		0
	),
	new Currency(
		'GTQ',
		'320',
		__( 'Guatemalan Quetzal', 'pronamic-ideal' ),
		'Q',
		2
	),
	new Currency(
		'GYD',
		'328',
		__( 'Guyanese Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'HKD',
		'344',
		__( 'Hong Kong Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'HNL',
		'340',
		__( 'Honduran Lempira', 'pronamic-ideal' ),
		'L',
		2
	),
	new Currency(
		'HRK',
		'191',
		__( 'Croatian Kuna', 'pronamic-ideal' ),
		'kn',
		2
	),
	new Currency(
		'HTG',
		'332',
		__( 'Haitian Gourde', 'pronamic-ideal' ),
		'G',
		2
	),
	new Currency(
		'HUF',
		'348',
		__( 'Hungarian Forint', 'pronamic-ideal' ),
		'Ft',
		2
	),
	new Currency(
		'IDR',
		'360',
		__( 'Indonesian Rupiah', 'pronamic-ideal' ),
		'Rp',
		2
	),
	new Currency(
		'ILS',
		'376',
		__( 'Israeli New Sheqel', 'pronamic-ideal' ),
		'₪',
		2
	),
	new Currency(
		'INR',
		'356',
		__( 'Indian Rupee', 'pronamic-ideal' ),
		'₹',
		2
	),
	new Currency(
		'IQD',
		'368',
		__( 'Iraqi Dinar', 'pronamic-ideal' ),
		'د.ع',
		3
	),
	new Currency(
		'IRR',
		'364',
		__( 'Iranian Rial', 'pronamic-ideal' ),
		'﷼',
		2
	),
	new Currency(
		'ISK',
		'352',
		__( 'Icelandic Króna', 'pronamic-ideal' ),
		'kr',
		0
	),
	new Currency(
		'JMD',
		'388',
		__( 'Jamaican Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'JOD',
		'400',
		__( 'Jordanian Dinar', 'pronamic-ideal' ),
		'JD',
		3
	),
	new Currency(
		'JPY',
		'392',
		__( 'Japanese Yen', 'pronamic-ideal' ),
		'¥',
		0
	),
	new Currency(
		'KES',
		'404',
		__( 'Kenyan Shilling', 'pronamic-ideal' ),
		'Ksh',
		2
	),
	new Currency(
		'KGS',
		'417',
		__( 'Kyrgyzstani Som', 'pronamic-ideal' ),
		'С̲',
		2
	),
	new Currency(
		'KHR',
		'116',
		__( 'Cambodian Riel', 'pronamic-ideal' ),
		'៛',
		2
	),
	new Currency(
		'KMF',
		'174',
		__( 'Comorian Franc', 'pronamic-ideal' ),
		'F',
		0
	),
	new Currency(
		'KPW',
		'408',
		__( 'North Korean Won', 'pronamic-ideal' ),
		'₩',
		2
	),
	new Currency(
		'KRW',
		'410',
		__( 'South Korean Won', 'pronamic-ideal' ),
		'₩',
		0
	),
	new Currency(
		'KWD',
		'414',
		__( 'Kuwaiti Dinar', 'pronamic-ideal' ),
		'د.ك',
		3
	),
	new Currency(
		'KYD',
		'136',
		__( 'Cayman Islands Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'KZT',
		'398',
		__( 'Kazakhstani Tenge', 'pronamic-ideal' ),
		'₸',
		2
	),
	new Currency(
		'LAK',
		'418',
		__( 'Lao Kip', 'pronamic-ideal' ),
		'₭',
		2
	),
	new Currency(
		'LBP',
		'422',
		__( 'Lebanese Pound', 'pronamic-ideal' ),
		'LL',
		2
	),
	new Currency(
		'LKR',
		'144',
		__( 'Sri Lankan Rupee', 'pronamic-ideal' ),
		'₨',
		2
	),
	new Currency(
		'LRD',
		'430',
		__( 'Liberian Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'LSL',
		'426',
		__( 'Lesotho Loti', 'pronamic-ideal' ),
		/**
		 * Symbol based on plural form "maloti". The one-loti note employs the symbol L.
		 *
		 * @link https://en.wikipedia.org/wiki/Currency_symbol#List_of_currency_symbols_currently_in_use
		 */
		'M',
		2
	),
	new Currency(
		'LYD',
		'434',
		__( 'Libyan Dinar', 'pronamic-ideal' ),
		'ل.د',
		3
	),
	new Currency(
		'MAD',
		'504',
		__( 'Moroccan Dirham', 'pronamic-ideal' ),
		'د.م.',
		2
	),
	new Currency(
		'MDL',
		'498',
		__( 'Moldovan Leu', 'pronamic-ideal' ),
		'L',
		2
	),
	new Currency(
		'MGA',
		'969',
		__( 'Malagasy Ariary', 'pronamic-ideal' ),
		'Ar',
		2
	),
	new Currency(
		'MKD',
		'807',
		__( 'Macedonian Denar', 'pronamic-ideal' ),
		'ден',
		2
	),
	new Currency(
		'MMK',
		'104',
		__( 'Myanmar Kyat', 'pronamic-ideal' ),
		'K',
		2
	),
	new Currency(
		'MNT',
		'496',
		__( 'Mongolian Tögrög', 'pronamic-ideal' ),
		'₮',
		2
	),
	new Currency(
		'MOP',
		'446',
		__( 'Macanese Pataca', 'pronamic-ideal' ),
		'MOP$',
		2
	),
	new Currency(
		'MRO',
		'478',
		__( 'Mauritanian Ouguiya', 'pronamic-ideal' ),
		'UM',
		2
	),
	new Currency(
		'MUR',
		'480',
		__( 'Mauritian Rupee', 'pronamic-ideal' ),
		'₨',
		2
	),
	new Currency(
		'MVR',
		'462',
		__( 'Maldivian Rufiyaa', 'pronamic-ideal' ),
		'Rf.',
		2
	),
	new Currency(
		'MWK',
		'454',
		__( 'Malawian Kwacha', 'pronamic-ideal' ),
		'K',
		2
	),
	new Currency(
		'MXN',
		'484',
		__( 'Mexican Peso', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'MXV',
		'979',
		__( 'Mexican Unidad de Inversion (UDI)', 'pronamic-ideal' ),
		'UDI',
		2
	),
	new Currency(
		'MYR',
		'458',
		__( 'Malaysian Ringgit', 'pronamic-ideal' ),
		'RM',
		2
	),
	new Currency(
		'MZN',
		'943',
		__( 'Mozambican Metical', 'pronamic-ideal' ),
		'MT',
		2
	),
	new Currency(
		'NAD',
		'516',
		__( 'Namibian Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'NGN',
		'566',
		__( 'Nigerian Naira', 'pronamic-ideal' ),
		'₦',
		2
	),
	new Currency(
		'NIO',
		'558',
		__( 'Nicaraguan Córdoba', 'pronamic-ideal' ),
		'C$',
		2
	),
	new Currency(
		'NLG',
		null,
		__( 'Gulden', 'pronamic-ideal' ),
		'G',
		4
	),
	new Currency(
		'NOK',
		'578',
		__( 'Norwegian Krone', 'pronamic-ideal' ),
		'kr',
		2
	),
	new Currency(
		'NPR',
		'524',
		__( 'Nepalese Rupee', 'pronamic-ideal' ),
		'₨',
		2
	),
	new Currency(
		'NZD',
		'554',
		__( 'New Zealand Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'OMR',
		'512',
		__( 'Omani Rial', 'pronamic-ideal' ),
		'ر.ع.',
		3
	),
	new Currency(
		'PAB',
		'590',
		__( 'Panamanian Balboa', 'pronamic-ideal' ),
		'B/.',
		2
	),
	new Currency(
		'PEN',
		'604',
		__( 'Peruvian Sol', 'pronamic-ideal' ),
		'S/',
		2
	),
	new Currency(
		'PGK',
		'598',
		__( 'Papua New Guinean Kina', 'pronamic-ideal' ),
		'K',
		2
	),
	new Currency(
		'PHP',
		'608',
		__( 'Philippine Peso', 'pronamic-ideal' ),
		'₱',
		2
	),
	new Currency(
		'PKR',
		'586',
		__( 'Pakistani Rupee', 'pronamic-ideal' ),
		'₨',
		2
	),
	new Currency(
		'PLN',
		'985',
		__( 'Polish Zloty', 'pronamic-ideal' ),
		'zł',
		2
	),
	new Currency(
		'PYG',
		'600',
		__( 'Paraguayan Guaraní', 'pronamic-ideal' ),
		'₲',
		0
	),
	new Currency(
		'QAR',
		'634',
		__( 'Qatari Rial', 'pronamic-ideal' ),
		'ر.ق',
		2
	),
	new Currency(
		'RON',
		'946',
		__( 'Romanian Leu', 'pronamic-ideal' ),
		'L',
		2
	),
	new Currency(
		'RSD',
		'941',
		__( 'Serbian Dinar', 'pronamic-ideal' ),
		'дин',
		2
	),
	new Currency(
		'RUB',
		'643',
		__( 'Russian Ruble', 'pronamic-ideal' ),
		'₽',
		2
	),
	new Currency(
		'RWF',
		'646',
		__( 'Rwandan Franc', 'pronamic-ideal' ),
		'FRw',
		0
	),
	new Currency(
		'SAR',
		'682',
		__( 'Saudi Riyal', 'pronamic-ideal' ),
		'ر.س',
		2
	),
	new Currency(
		'SBD',
		'090',
		__( 'Solomon Islands Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'SCR',
		'690',
		__( 'Seychelles Rupee', 'pronamic-ideal' ),
		'SRe',
		2
	),
	new Currency(
		'SDG',
		'938',
		__( 'Sudanese Pound', 'pronamic-ideal' ),
		'ج.س',
		2
	),
	new Currency(
		'SEK',
		'752',
		__( 'Swedish Krona', 'pronamic-ideal' ),
		'kr',
		2
	),
	new Currency(
		'SGD',
		'702',
		__( 'Singapore Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'SHP',
		'654',
		__( 'Saint Helena Pound', 'pronamic-ideal' ),
		'£',
		2
	),
	new Currency(
		'SLL',
		'694',
		__( 'Sierra Leonean Leone', 'pronamic-ideal' ),
		'Le',
		2
	),
	new Currency(
		'SOS',
		'706',
		__( 'Somali Shilling', 'pronamic-ideal' ),
		'Sh.So.',
		2
	),
	new Currency(
		'SRD',
		'968',
		__( 'Surinamese Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'SSP',
		'728',
		__( 'South Sudanese Pound', 'pronamic-ideal' ),
		'SS£',
		2
	),
	new Currency(
		'STD',
		'678',
		__( 'São Tomé and Príncipe Dobra', 'pronamic-ideal' ),
		'Db',
		2
	),
	new Currency(
		'SVC',
		'222',
		__( 'Salvadoran Colon', 'pronamic-ideal' ),
		'₡',
		2
	),
	new Currency(
		'SYP',
		'760',
		__( 'Syrian Pound', 'pronamic-ideal' ),
		'£',
		2
	),
	new Currency(
		'SZL',
		'748',
		__( 'Swazi Lilangeni', 'pronamic-ideal' ),
		/**
		 * Symbol based on the plural form "emalangeni" However the one-lilageni note employs the currency symbol L.
		 *
		 * @link https://en.wikipedia.org/wiki/Currency_symbol#List_of_currency_symbols_currently_in_use
		 */
		'E',
		2
	),
	new Currency(
		'THB',
		'764',
		__( 'Thai Baht', 'pronamic-ideal' ),
		'฿',
		2
	),
	new Currency(
		'TJS',
		'972',
		__( 'Tajikistani Somoni', 'pronamic-ideal' ),
		'SM',
		2
	),
	new Currency(
		'TMT',
		'934',
		__( 'Turkmenistan Manat', 'pronamic-ideal' ),
		'T',
		2
	),
	new Currency(
		'TND',
		'788',
		__( 'Tunisian Dinar', 'pronamic-ideal' ),
		'د.ت',
		3
	),
	new Currency(
		'TOP',
		'776',
		__( 'Tongan Pa’anga', 'pronamic-ideal' ),
		'T$',
		2
	),
	new Currency(
		'TRY',
		'949',
		__( 'Turkish Lira', 'pronamic-ideal' ),
		'₺',
		2
	),
	new Currency(
		'TTD',
		'780',
		__( 'Trinidad and Tobago Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'TWD',
		'901',
		__( 'New Taiwan Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'TZS',
		'834',
		__( 'Tanzanian Shilling', 'pronamic-ideal' ),
		'Tsh',
		2
	),
	new Currency(
		'UAH',
		'980',
		__( 'Ukrainian Hryvnia', 'pronamic-ideal' ),
		'₴',
		2
	),
	new Currency(
		'UGX',
		'800',
		__( 'Ugandan Shilling', 'pronamic-ideal' ),
		'USh',
		0
	),
	new Currency(
		'USD',
		'840',
		__( 'US Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'USN',
		'997',
		__( 'US Dollar (Next day)', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'UYI',
		'940',
		__( 'Uruguay Peso en Unidades Indexadas (URUIURUI)', 'pronamic-ideal' ),
		'$',
		0
	),
	new Currency(
		'UYU',
		'858',
		__( 'Uruguayan Peso', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'UYW',
		'927',
		__( 'Unidad Previsional', 'pronamic-ideal' ),
		null,
		4
	),
	new Currency(
		'UZS',
		'860',
		__( 'Uzbekistan Som', 'pronamic-ideal' ),
		'лв',
		2
	),
	new Currency(
		'VES',
		'928',
		__( 'Venezuelan Bolívar Soberano', 'pronamic-ideal' ),
		'Bs.S.',
		2
	),
	new Currency(
		'VND',
		'704',
		__( 'Vietnamese Dồng', 'pronamic-ideal' ),
		'₫',
		0
	),
	new Currency(
		'VUV',
		'548',
		__( 'Vanuatu Vatu', 'pronamic-ideal' ),
		'VT',
		0
	),
	new Currency(
		'WST',
		'882',
		__( 'Samoan Tala', 'pronamic-ideal' ),
		'WS$',
		2
	),
	new Currency(
		'XAF',
		'950',
		__( 'CFA Franc BEAC', 'pronamic-ideal' ),
		'FCFA',
		0
	),
	new Currency(
		'XAG',
		'961',
		__( 'Silver', 'pronamic-ideal' ),
		'Ag oz t.',
		0
	),
	new Currency(
		'XAU',
		'959',
		__( 'Gold', 'pronamic-ideal' ),
		'Au oz t.',
		0
	),
	new Currency(
		'XBA',
		'955',
		__( 'Bond Markets Unit European Composite Unit (EURCO)', 'pronamic-ideal' ),
		null,
		0
	),
	new Currency(
		'XBB',
		'956',
		__( 'Bond Markets Unit European Monetary Unit (E.M.U.-6)', 'pronamic-ideal' ),
		null,
		0
	),
	new Currency(
		'XBC',
		'957',
		__( 'Bond Markets Unit European Unit of Account 9 (E.U.A.-9)', 'pronamic-ideal' ),
		null,
		0
	),
	new Currency(
		'XBD',
		'958',
		__( 'Bond Markets Unit European Unit of Account 17 (E.U.A.-17)', 'pronamic-ideal' ),
		null,
		0
	),
	new Currency(
		'XCD',
		'951',
		__( 'East Caribbean Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
	new Currency(
		'XDR',
		'960',
		__( 'SDR (Special Drawing Right)', 'pronamic-ideal' ),
		'SDR',
		0
	),
	new Currency(
		'XOF',
		'952',
		__( 'CFA Franc BCEAO', 'pronamic-ideal' ),
		'CFA',
		0
	),
	new Currency(
		'XPD',
		'964',
		__( 'Palladium', 'pronamic-ideal' ),
		'Pd oz t.',
		0
	),
	new Currency(
		'XPF',
		'953',
		__( 'CFP Franc', 'pronamic-ideal' ),
		'F',
		0
	),
	new Currency(
		'XPT',
		'962',
		__( 'Platinum', 'pronamic-ideal' ),
		'Pt oz t.',
		0
	),
	new Currency(
		'XSU',
		'994',
		__( 'Sucre', 'pronamic-ideal' ),
		'Sucre',
		0
	),
	new Currency(
		'XTS',
		'963',
		__( 'Code reserved for testing', 'pronamic-ideal' ),
		null,
		0
	),
	new Currency(
		'XUA',
		'965',
		__( 'ADB Unit of Account', 'pronamic-ideal' ),
		null,
		0
	),
	new Currency(
		'XXX',
		'999',
		__( 'No currency', 'pronamic-ideal' ),
		null,
		0
	),
	new Currency(
		'YER',
		'886',
		__( 'Yemeni Rial', 'pronamic-ideal' ),
		'ر.ي',
		2
	),
	new Currency(
		'ZAR',
		'710',
		__( 'South African Rand', 'pronamic-ideal' ),
		'R',
		2
	),
	new Currency(
		'ZMW',
		'967',
		__( 'Zambian Kwacha', 'pronamic-ideal' ),
		'K',
		2
	),
	new Currency(
		'ZWL',
		'932',
		__( 'Zimbabwean Dollar', 'pronamic-ideal' ),
		'$',
		2
	),
];
