# Change Log

All notable changes to this project will be documented in this file.

This projects adheres to [Semantic Versioning](http://semver.org/) and [Keep a CHANGELOG](http://keepachangelog.com/).

## [Unreleased][unreleased]

<!-- Start changelog -->

## [9.18.1] - 2025-11-17

### Composer

- Changed `automattic/jetpack-autoloader` from `v5.0.12` to `v5.0.13`.
	Release notes: https://github.com/Automattic/jetpack-autoloader/releases/tag/v5.0.13
- Changed `pronamic/wp-mollie` from `v1.10.0` to `v1.10.1`.
	Release notes: https://github.com/pronamic/wp-mollie/releases/tag/v1.10.1
- Changed `wp-pay-extensions/restrict-content-pro` from `v4.7.2` to `v4.8.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/releases/tag/v4.8.0
- Changed `wp-pay-gateways/mollie` from `v4.16.3` to `v4.17.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.17.0
- Changed `wp-pay/core` from `v4.27.1` to `v4.28.0`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.28.0

Full set of changes: [`9.18.0...9.18.1`][9.18.1]

[9.18.1]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.18.0...v9.18.1

## [9.18.0] - 2025-11-11

### Composer

- Changed `automattic/jetpack-autoloader` from `v5.0.10` to `v5.0.12`.
	Release notes: https://github.com/Automattic/jetpack-autoloader/releases/tag/v5.0.12
- Changed `pronamic/wp-pronamic-pay-forms` from `v1.1.3` to `v1.1.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-forms/releases/tag/v1.1.4
- Changed `wp-pay-extensions/charitable` from `v4.3.4` to `v4.3.5`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-charitable/releases/tag/v4.3.5
- Changed `wp-pay-extensions/contact-form-7` from `v4.1.1` to `v4.1.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-contact-form-7/releases/tag/v4.1.2
- Changed `wp-pay-extensions/easy-digital-downloads` from `v4.3.6` to `v4.3.7`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-easy-digital-downloads/releases/tag/v4.3.7
- Changed `wp-pay-extensions/event-espresso` from `v4.3.3` to `v4.3.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-event-espresso/releases/tag/v4.3.4
- Changed `wp-pay-extensions/formidable-forms` from `v4.4.3` to `v4.4.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-formidable-forms/releases/tag/v4.4.4
- Changed `wp-pay-extensions/give` from `v4.2.4` to `v4.2.5`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-give/releases/tag/v4.2.5
- Changed `wp-pay-extensions/gravityforms` from `v4.10.1` to `v4.10.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-gravityforms/releases/tag/v4.10.2
- Changed `wp-pay-extensions/memberpress` from `v4.8.4` to `v4.8.5`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-memberpress/releases/tag/v4.8.5
- Changed `wp-pay-extensions/ninjaforms` from `v3.3.3` to `v3.3.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ninjaforms/releases/tag/v3.3.4
- Changed `wp-pay-extensions/restrict-content-pro` from `v4.7.1` to `v4.7.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/releases/tag/v4.7.2
- Changed `wp-pay-gateways/adyen` from `v4.7.0` to `v4.8.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-adyen/releases/tag/v4.8.0
- Changed `wp-pay-gateways/buckaroo` from `v4.4.0` to `v4.4.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-buckaroo/releases/tag/v4.4.1
- Changed `wp-pay-gateways/ems-e-commerce` from `v4.4.2` to `v4.4.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ems-e-commerce/releases/tag/v4.4.3
- Changed `wp-pay-gateways/mollie` from `v4.16.2` to `v4.16.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.16.3
- Changed `wp-pay-gateways/multisafepay` from `v4.6.1` to `v4.6.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-multisafepay/releases/tag/v4.6.2
- Changed `wp-pay-gateways/ogone` from `v4.8.0` to `v4.8.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ingenico/releases/tag/v4.8.1
- Changed `wp-pay-gateways/omnikassa-2` from `v4.9.1` to `v4.9.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-rabo-smart-pay/releases/tag/v4.9.2
- Changed `wp-pay-gateways/pay-nl` from `v4.6.0` to `v4.6.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-pay-nl/releases/tag/v4.6.1

Full set of changes: [`9.17.2...9.18.0`][9.18.0]

[9.18.0]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.17.2...v9.18.0

## [9.17.2] - 2025-09-17

### Changed

- Improved payment lines support for Mollie.

### Composer

- Changed `automattic/jetpack-autoloader` from `v5.0.9` to `v5.0.10`.
	Release notes: https://github.com/Automattic/jetpack-autoloader/releases/tag/v5.0.10
- Changed `wp-pay-extensions/memberpress` from `v4.8.3` to `v4.8.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-memberpress/releases/tag/v4.8.4
- Changed `wp-pay-extensions/restrict-content-pro` from `v4.7.0` to `v4.7.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/releases/tag/v4.7.1
- Changed `wp-pay-gateways/mollie` from `v4.16.1` to `v4.16.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.16.2
- Changed `wp-pay/core` from `v4.27.0` to `v4.27.1`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.27.1

Full set of changes: [`9.17.1...9.17.2`][9.17.2]

[9.17.2]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.17.1...v9.17.2

## [9.17.1] - 2025-08-26

### Composer

- Changed `wp-pay-gateways/mollie` from `v4.16.0` to `v4.16.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.16.1

Full set of changes: [`9.17.0...9.17.1`][9.17.1]

[9.17.1]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.17.0...v9.17.1

## [9.17.0] - 2025-08-22

### Changed

- Require PHP 8.2.

### Removed

- Removed iDEAL Advanced integrations.
- Removed iDEL Basic integrations.

### Composer

- Removed `wp-pay-gateways/ideal` `^4.1`.
- Removed `wp-pay-gateways/ideal-advanced-v3` `^4.3`.
- Removed `wp-pay-gateways/ideal-basic` `^4.3`.
- Changed `php` from `>=8.1` to `>=8.2`.
- Changed `automattic/jetpack-autoloader` from `v5.0.7` to `v5.0.9`.
	Release notes: https://github.com/Automattic/jetpack-autoloader/releases/tag/v5.0.9
- Changed `pronamic/wp-mollie` from `v1.9.0` to `v1.10.0`.
	Release notes: https://github.com/pronamic/wp-mollie/releases/tag/v1.10.0
- Changed `woocommerce/action-scheduler` from `3.9.2` to `3.9.3`.
	Release notes: https://github.com/woocommerce/action-scheduler/releases/tag/3.9.3
- Changed `wp-pay-extensions/restrict-content-pro` from `v4.6.3` to `v4.7.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/releases/tag/v4.7.0
- Changed `wp-pay-extensions/woocommerce` from `v4.12.1` to `v4.13.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-woocommerce/releases/tag/v4.13.0
- Changed `wp-pay-gateways/adyen` from `v4.6.1` to `v4.7.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-adyen/releases/tag/v4.7.0
- Changed `wp-pay-gateways/mollie` from `v4.15.0` to `v4.16.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.16.0
- Changed `wp-pay/core` from `v4.26.0` to `v4.27.0`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.27.0

Full set of changes: [`9.16.0...9.17.0`][9.17.0]

[9.17.0]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.16.0...v9.17.0

## [9.16.0] - 2025-06-19

### Removed

- Removed support for ICEPAY ([4189a5f](https://github.com/pronamic/wp-pronamic-pay/commit/4189a5fa03abb93373e22555357d8e404144b612))

### Composer

- Removed `wp-pay-gateways/icepay` `^4.3`.
- Changed `automattic/jetpack-autoloader` from `v3.1.3` to `v5.0.7`.
	Release notes: https://github.com/Automattic/jetpack-autoloader/releases/tag/v5.0.7
- Changed `pronamic/pronamic-pay-admin-reports` from `v1.0.0` to `v1.0.1`.
	Release notes: https://github.com/pronamic/pronamic-pay-admin-reports/releases/tag/v1.0.1
- Changed `pronamic/pronamic-wp-updater` from `v1.0.2` to `v1.0.3`.
	Release notes: https://github.com/pronamic/pronamic-wp-updater/releases/tag/v1.0.3
- Changed `pronamic/wp-mollie` from `v1.8.0` to `v1.9.0`.
	Release notes: https://github.com/pronamic/wp-mollie/releases/tag/v1.9.0
- Changed `wp-pay-extensions/contact-form-7` from `v4.0.1` to `v4.1.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-contact-form-7/releases/tag/v4.1.1
- Changed `wp-pay-extensions/event-espresso` from `v4.3.2` to `v4.3.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-event-espresso/releases/tag/v4.3.3
- Changed `wp-pay-extensions/gravityforms` from `v4.9.0` to `v4.10.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-gravityforms/releases/tag/v4.10.1
- Changed `wp-pay-extensions/memberpress` from `v4.8.2` to `v4.8.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-memberpress/releases/tag/v4.8.3
- Changed `wp-pay-extensions/restrict-content-pro` from `v4.6.2` to `v4.6.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/releases/tag/v4.6.3
- Changed `wp-pay-extensions/woocommerce` from `v4.11.0` to `v4.12.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-woocommerce/releases/tag/v4.12.1
- Changed `wp-pay-gateways/adyen` from `v4.5.2` to `v4.6.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-adyen/releases/tag/v4.6.1
- Changed `wp-pay-gateways/buckaroo` from `v4.3.5` to `v4.4.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-buckaroo/releases/tag/v4.4.0
- Changed `wp-pay-gateways/mollie` from `v4.14.1` to `v4.15.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.15.0
- Changed `wp-pay-gateways/multisafepay` from `v4.5.1` to `v4.6.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-multisafepay/releases/tag/v4.6.1
- Changed `wp-pay-gateways/ogone` from `v4.7.1` to `v4.8.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ingenico/releases/tag/v4.8.0
- Changed `wp-pay-gateways/omnikassa-2` from `v4.9.0` to `v4.9.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-rabo-smart-pay/releases/tag/v4.9.1
- Changed `wp-pay-gateways/pay-nl` from `v4.5.7` to `v4.6.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-pay-nl/releases/tag/v4.6.0
- Changed `wp-pay/core` from `v4.25.0` to `v4.26.0`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.26.0
- Changed `wp-pay/fundraising` from `v3.2.6` to `v3.2.7`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-fundraising/releases/tag/v3.2.7

Full set of changes: [`9.15.1...9.16.0`][9.16.0]

[9.16.0]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.15.1...v9.16.0

## [9.15.1] - 2025-03-03

### Commits

- Fixed fatal error with Contact Form 7 due to incorrect file path. ([#24](https://github.com/pronamic/wp-pronamic-pay-contact-form-7/issues/24))

### Composer

- Changed `wp-pay-extensions/contact-form-7` from `v4.0.0` to `v4.0.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-contact-form-7/releases/tag/v4.0.1

Full set of changes: [`9.15.0...9.15.1`][9.15.1]

[9.15.1]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.15.0...v9.15.1

## [9.15.0] - 2025-02-28

### Composer

- Changed `wp-pay-extensions/contact-form-7` from `v3.7.0` to `v4.0.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-contact-form-7/releases/tag/v4.0.0

Full set of changes: [`9.14.1...9.15.0`][9.15.0]

[9.15.0]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.14.1...v9.15.0

## [9.14.1] - 2025-02-25

### Changed

- Improved Mollie error handling when updating subscription mandate. ([8f03de5](https://github.com/pronamic/wp-pronamic-pay-mollie/commit/8f03de511ccf3ebb0223919dd7fcf6185e4e9c3c))
- Removed iDEAL issuer selection for Rabo Smart Pay. ([9916e49](https://github.com/pronamic/wp-pronamic-pay-rabo-smart-pay/commit/9916e49529d25cb61e3a669c5774acb8a9d62b1c))

### Composer

- Changed `wp-pay-gateways/mollie` from `v4.14.0` to `v4.14.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.14.1
- Changed `wp-pay-gateways/omnikassa-2` from `v4.8.0` to `v4.9.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-rabo-smart-pay/releases/tag/v4.9.0

Full set of changes: [`9.14.0...9.14.1`][9.14.1]

[9.14.1]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.14.0...v9.14.1

## [9.14.0] - 2025-02-14

### Removed

- Removed ING - iDEAL Advanced. ([46aff99](https://github.com/pronamic/wp-pronamic-pay/commit/46aff99d6fdf1bc63655f8437d3ca88e184921ea))
- Removed ING - iDEAL Basic. ([60c646f](https://github.com/pronamic/wp-pronamic-pay/commit/60c646f765bb560de8d52899a0bba246ffcc1eb3))
- Removed ING - iDEAL Advanced - Old platform. ([b5dbba6](https://github.com/pronamic/wp-pronamic-pay/commit/b5dbba64ec1b35dee02491fe8df728cec92a95db))
- Removed Rabobank - iDEAL Professional. ([036c644](https://github.com/pronamic/wp-pronamic-pay/commit/036c644e711ccb039012d9501ce4faff0ccfb9ab))
- Removed ABN AMRO - iDEAL Zelfbouw. ([c158f32](https://github.com/pronamic/wp-pronamic-pay/commit/c158f324e3a99204b2865d1ff3c6e77901f033b1))
- Removed Deutsche Bank - iDEAL Expert. ([55ff42c](https://github.com/pronamic/wp-pronamic-pay/commit/55ff42cf529ea16c4253aea27cad78225eccd517))
- Removed Sisow - iDEAL Basic. ([70e4ba1](https://github.com/pronamic/wp-pronamic-pay/commit/70e4ba1cde1f53aca84d7ba1f64f046b4cb4407b))

### Composer

- Added `pronamic/wp-pay-logos` `^2.2`.
- Changed `pronamic/wp-mollie` from `v1.7.0` to `v1.8.0`.
	Release notes: https://github.com/pronamic/wp-mollie/releases/tag/v1.8.0
- Changed `woocommerce/action-scheduler` from `3.9.0` to `3.9.2`.
	Release notes: https://github.com/woocommerce/action-scheduler/releases/tag/3.9.2
- Changed `wp-pay-extensions/charitable` from `v4.3.3` to `v4.3.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-charitable/releases/tag/v4.3.4
- Changed `wp-pay-extensions/gravityforms` from `v4.8.1` to `v4.9.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-gravityforms/releases/tag/v4.9.0
- Changed `wp-pay-extensions/woocommerce` from `v4.10.0` to `v4.11.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-woocommerce/releases/tag/v4.11.0
- Changed `wp-pay-gateways/adyen` from `v4.5.1` to `v4.5.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-adyen/releases/tag/v4.5.2
- Changed `wp-pay-gateways/ems-e-commerce` from `v4.4.1` to `v4.4.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ems-e-commerce/releases/tag/v4.4.2
- Changed `wp-pay-gateways/mollie` from `v4.13.0` to `v4.14.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.14.0
- Changed `wp-pay/core` from `v4.24.0` to `v4.25.0`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.25.0

Full set of changes: [`9.13.0...9.14.0`][9.14.0]

[9.14.0]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.13.0...v9.14.0

## [9.13.0] - 2024-12-18

### Added

- Core - Show license admin notice only on dashboard and Pronamic Pay pages. ([eff26a4](https://github.com/pronamic/wp-pay-core/commit/eff26a47e6c5a1e6759ff8fbf7db652d0d45dde4))
- Core - Prevent payments for subscription payment method changes from updating subscription status. ([cfccc0b](https://github.com/pronamic/wp-pay-core/commit/cfccc0b893f7a1fdaa2ea7cfeccd6637b90171d1))
- Mollie - Added support for Klarna payment method https://github.com/pronamic/wp-pronamic-pay-mollie/issues/57. ([41ec79e](https://github.com/pronamic/wp-mollie/commit/41ec79e3f41a6335046e0f5b9804d00c0d37df1c))
- Rabo Smart Pay - Added support for `skipHppResultPage` parameter. ([f542395](https://github.com/pronamic/wp-pronamic-pay-rabo-smart-pay/commit/f54239595e294b40736f32f6fd860769c21cb853))
- WooCommerce - Added setting "Show iDEAL issuers", since the launch of the new iDEAL 2.0 platform, it is recommended to no longer show the iDEAL issuer selection field on the WooCommerce checkout form.

### Changed

- Contact Form 7 - Store submissions with Flamingo when redirected for payment. ([6cbdb96](https://github.com/pronamic/wp-pronamic-pay-contact-form-7/commit/6cbdb962f6f7946383e9b07829ff64d0fe685fa9))
- Mollie - Format phone number in E164 format. ([170252d](https://github.com/pronamic/wp-pronamic-pay-mollie/commit/170252dbfb0412cb63eaa84f2a2eaff15c624507))
- WooCommerce - Orders paid via the direct debit (SEPA) payment method will now have the status 'on-hold' instead of 'pending'. This status ensures that customers cannot (re)pay for the order during the direct debit, which can take several days to process.

### Composer

- Changed `automattic/jetpack-autoloader` from `v3.1.0` to `v3.1.3`.
	Release notes: https://github.com/Automattic/jetpack-autoloader/releases/tag/v3.1.3
- Changed `composer/installers` from `v2.3.0` to `v2.3.0`.
	Release notes: https://github.com/composer/installers/releases/tag/v2.3.0
- Changed `pronamic/wp-datetime` from `v2.1.7` to `v2.1.8`.
	Release notes: https://github.com/pronamic/wp-datetime/releases/tag/v2.1.8
- Changed `pronamic/wp-gravityforms-nl` from `v3.0.9` to `v3.0.10`.
	Release notes: https://github.com/pronamic/wp-gravityforms-nl/releases/tag/v3.0.10
- Changed `pronamic/wp-html` from `v2.2.1` to `v2.2.2`.
	Release notes: https://github.com/pronamic/wp-html/releases/tag/v2.2.2
- Changed `pronamic/wp-http` from `v1.2.3` to `v1.2.4`.
	Release notes: https://github.com/pronamic/wp-http/releases/tag/v1.2.4
- Changed `pronamic/wp-mollie` from `v1.6.0` to `v1.7.0`.
	Release notes: https://github.com/pronamic/wp-mollie/releases/tag/v1.7.0
- Changed `pronamic/wp-money` from `v2.4.3` to `v2.4.4`.
	Release notes: https://github.com/pronamic/wp-money/releases/tag/v2.4.4
- Changed `pronamic/wp-number` from `v1.3.2` to `v1.3.3`.
	Release notes: https://github.com/pronamic/wp-number/releases/tag/v1.3.3
- Changed `pronamic/wp-pronamic-pay-forms` from `v1.1.2` to `v1.1.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-forms/releases/tag/v1.1.3
- Changed `woocommerce/action-scheduler` from `3.8.2` to `3.9.0`.
	Release notes: https://github.com/woocommerce/action-scheduler/releases/tag/3.9.0
- Changed `wp-pay-extensions/contact-form-7` from `v3.6.0` to `v3.7.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-contact-form-7/releases/tag/v3.7.0
- Changed `wp-pay-extensions/easy-digital-downloads` from `v4.3.5` to `v4.3.6`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-easy-digital-downloads/releases/tag/v4.3.6
- Changed `wp-pay-extensions/event-espresso` from `v4.3.1` to `v4.3.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-event-espresso/releases/tag/v4.3.2
- Changed `wp-pay-extensions/formidable-forms` from `v4.4.2` to `v4.4.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-formidable-forms/releases/tag/v4.4.3
- Changed `wp-pay-extensions/give` from `v4.2.3` to `v4.2.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-give/releases/tag/v4.2.4
- Changed `wp-pay-extensions/gravityforms` from `v4.8.0` to `v4.8.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-gravityforms/releases/tag/v4.8.1
- Changed `wp-pay-extensions/memberpress` from `v4.8.1` to `v4.8.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-memberpress/releases/tag/v4.8.2
- Changed `wp-pay-extensions/ninjaforms` from `v3.3.2` to `v3.3.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ninjaforms/releases/tag/v3.3.3
- Changed `wp-pay-extensions/woocommerce` from `v4.9.1` to `v4.10.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-woocommerce/releases/tag/v4.10.0
- Changed `wp-pay-gateways/buckaroo` from `v4.3.4` to `v4.3.5`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-buckaroo/releases/tag/v4.3.5
- Changed `wp-pay-gateways/ems-e-commerce` from `v4.4.0` to `v4.4.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ems-e-commerce/releases/tag/v4.4.1
- Changed `wp-pay-gateways/icepay` from `v4.3.7` to `v4.3.8`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-icepay/releases/tag/v4.3.8
- Changed `wp-pay-gateways/ideal` from `v4.1.3` to `v4.1.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal/releases/tag/v4.1.4
- Changed `wp-pay-gateways/ideal-advanced-v3` from `v4.3.7` to `v4.3.8`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal-advanced-v3/releases/tag/v4.3.8
- Changed `wp-pay-gateways/ideal-basic` from `v4.3.6` to `v4.3.7`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal-basic/releases/tag/v4.3.7
- Changed `wp-pay-gateways/mollie` from `v4.12.0` to `v4.13.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.13.0
- Changed `wp-pay-gateways/multisafepay` from `v4.5.0` to `v4.5.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-multisafepay/releases/tag/v4.5.1
- Changed `wp-pay-gateways/ogone` from `v4.7.0` to `v4.7.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ingenico/releases/tag/v4.7.1
- Changed `wp-pay-gateways/omnikassa-2` from `v4.7.2` to `v4.8.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-rabo-smart-pay/releases/tag/v4.8.0
- Changed `wp-pay-gateways/pay-nl` from `v4.5.6` to `v4.5.7`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-pay-nl/releases/tag/v4.5.7
- Changed `wp-pay-gateways/paypal` from `v2.3.6` to `v2.3.7`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-paypal/releases/tag/v2.3.7
- Changed `wp-pay/core` from `v4.22.1` to `v4.24.0`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.24.0
- Changed `wp-pay/fundraising` from `v3.2.5` to `v3.2.6`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-fundraising/releases/tag/v3.2.6

Full set of changes: [`9.12.1...9.13.0`][9.13.0]

[9.13.0]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.12.1...v9.13.0

## [9.12.1] - 2024-09-27

### Fixed

- Fixed active subscription put 'On Hold' by expired first payment. ([#194](https://github.com/pronamic/wp-pay-core/issues/194))
- Fixed infinite loop when activating Restrict Content Pro subscription with past expiry date. ([#26](https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/issues/26))
- Improved updating MemberPress subscription gateway only on payment method changes. ([#22](https://github.com/pronamic/wp-pronamic-pay-memberpress/issues/22))

### Changed

- Use directory name as plugin dependencies slug. ([#388](https://github.com/pronamic/wp-pronamic-pay/issues/388))
- Only show admin tour within first day after plugin installation. ([#186](https://github.com/pronamic/wp-pay-core/issues/186))

### Composer

- Changed `woocommerce/action-scheduler` from `3.8.1` to `3.8.2`.
	Release notes: https://github.com/woocommerce/action-scheduler/releases/tag/3.8.2
- Changed `wp-pay-extensions/memberpress` from `v4.8.0` to `v4.8.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-memberpress/releases/tag/v4.8.1
- Changed `wp-pay-extensions/restrict-content-pro` from `v4.6.1` to `v4.6.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/releases/tag/v4.6.2
- Changed `wp-pay/core` from `v4.22.0` to `v4.22.1`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.22.1

Full set of changes: [`9.12.0...9.12.1`][9.12.1]

[9.12.1]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.12.0...v9.12.1

## [9.12.0] - 2024-09-10

### Removed

- Removed VAT number validation from core. ([#189](https://github.com/pronamic/wp-pay-core/issues/189))

### Changed

- Update subscription action links UI ([#180](https://github.com/pronamic/wp-pay-core/pull/180))
- Always show 'Disable Recurring Payments' setting. ([#165](https://github.com/pronamic/wp-pay-core/issues/165))
- Added plugin information to MultiSafepay redirect transaction request. ([#5](https://github.com/pronamic/wp-pronamic-pay-multisafepay/issues/5))

### Composer

- Changed `automattic/jetpack-autoloader` from `v3.0.9` to `v3.1.0`.
	Release notes: https://github.com/Automattic/jetpack-autoloader/releases/tag/v3.1.0
- Changed `wp-pay-gateways/multisafepay` from `v4.4.0` to `v4.5.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-multisafepay/releases/tag/v4.5.0
- Changed `wp-pay/core` from `v4.21.1` to `v4.22.0`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.22.0

Full set of changes: [`9.11.1...9.12.0`][9.12.0]

[9.12.0]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.11.1...v9.12.0

## [9.11.1] - 2024-08-01

### Fixed

- Fixed calculated number of subscription periods created falling outside optional phase end date. ([0364e4f](https://github.com/pronamic/wp-pay-core/commit/0364e4f31d38c53b09e5a4505d7a7e1a2778beac))
- Fixed time difference between Restrict Content Pro membership and subscription next payment date. ([2242a69](https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/commit/2242a692287f637cf3422159051988ee5b62face))
- Tested up to: 6.6 ([977a350](https://github.com/pronamic/wp-pronamic-pay/commit/977a3501e0860448e234b3fcb15626dc71817dae))

### Composer

- Changed `wp-pay-extensions/restrict-content-pro` from `v4.6.0` to `v4.6.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/releases/tag/v4.6.1
- Changed `wp-pay/core` from `v4.21.0` to `v4.21.1`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.21.1

Full set of changes: [`9.11.0...9.11.1`][9.11.1]

[9.11.1]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.11.0...v9.11.1

## [9.11.0] - 2024-07-25

### Added

- Added support for Restrict Content Pro payment method updates. ([c056a4d](https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/commit/c056a4deef669cc4c21ed9191ca8dc62a9786ae2))

### Changed

- Send MemberPress refund notices also for chargebacks. ([024dd78](https://github.com/pronamic/wp-pronamic-pay-memberpress/commit/024dd78b533b12c8183b8872cd4d3d2f2efb5cde))
- Use bundled images instead of https://cdn.wp-pay.org/. ([5d9bed0](https://github.com/pronamic/wp-pay-core/commit/5d9bed040df3dcae9eea819ace6acb4ce2b31ee7))

### Composer

- Changed `automattic/jetpack-autoloader` from `v3.0.8` to `v3.0.9`.
	Release notes: https://github.com/Automattic/jetpack-autoloader/releases/tag/v3.0.9
- Changed `composer/installers` from `v2.2.0` to `v2.3.0`.
	Release notes: https://github.com/composer/installers/releases/tag/v2.3.0
- Changed `woocommerce/action-scheduler` from `3.8.0` to `3.8.1`.
	Release notes: https://github.com/woocommerce/action-scheduler/releases/tag/3.8.1
- Changed `wp-pay-extensions/memberpress` from `v4.7.11` to `v4.8.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-memberpress/releases/tag/v4.8.0
- Changed `wp-pay-extensions/restrict-content-pro` from `v4.5.0` to `v4.6.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/releases/tag/v4.6.0
- Changed `wp-pay/core` from `v4.20.0` to `v4.21.0`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.21.0

Full set of changes: [`9.10.1...9.11.0`][9.11.0]

[9.11.0]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.10.1...v9.11.0

## [9.10.1] - 2024-06-19

### Commits

- Updated “Requires PHP” to PHP 8.1 (due to pronamic/ideal-issuers library). ([e3b34b7](https://github.com/pronamic/wp-pronamic-pay/commit/e3b34b7897174c70779b77735a1f185a48469a00))
- Fixed warning on https://wordpress.org/plugins/pronamic-ideal/. ([0f327df](https://github.com/pronamic/wp-pronamic-pay/commit/0f327df635c0676d93b0257b905558a20b3751d4))

### Composer

- Added `pronamic/pronamic-pay-admin-reports` `^1.0`.
- Changed `wp-pay-extensions/event-espresso` from `v4.3.0` to `v4.3.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-event-espresso/releases/tag/v4.3.1
- Changed `wp-pay-extensions/woocommerce` from `v4.9.0` to `v4.9.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-woocommerce/releases/tag/v4.9.1
- Changed `wp-pay-gateways/omnikassa-2` from `v4.7.1` to `v4.7.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-rabo-smart-pay/releases/tag/v4.7.2
- Changed `wp-pay/core` from `v4.19.0` to `v4.20.0`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.20.0

Full set of changes: [`9.10.0...9.10.1`][9.10.1]

[9.10.1]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.10.0...v9.10.1

## [9.10.0] - 2024-06-12

### Removed

- Removed `images` folder.

### Composer

- Changed `automattic/jetpack-autoloader` from `v3.0.7` to `v3.0.8`.
	Release notes: https://github.com/Automattic/jetpack-autoloader/releases/tag/v3.0.8
- Changed `pronamic/wp-number` from `v1.3.1` to `v1.3.2`.
	Release notes: https://github.com/pronamic/wp-number/releases/tag/v1.3.2
- Changed `wp-pay-extensions/event-espresso` from `v4.2.4` to `v4.3.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-event-espresso/releases/tag/v4.3.0
- Changed `wp-pay-extensions/gravityforms` from `v4.7.0` to `v4.8.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-gravityforms/releases/tag/v4.8.0
- Changed `wp-pay-extensions/woocommerce` from `v4.8.0` to `v4.9.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-woocommerce/releases/tag/v4.9.0
- Changed `wp-pay-gateways/mollie` from `v4.11.0` to `v4.12.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.12.0
- Changed `wp-pay-gateways/ogone` from `v4.6.0` to `v4.7.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ingenico/releases/tag/v4.7.0
- Changed `wp-pay/core` from `v4.18.0` to `v4.19.0`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.19.0

Full set of changes: [`9.9.0...9.10.0`][9.10.0]

[9.10.0]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.9.0...v9.10.0

## [9.9.0] - 2024-05-27

### Composer

- Changed `php` from `>=8.0` to `>=8.1`.
- Changed `pronamic/wp-http` from `v1.2.2` to `v1.2.3`.
	Release notes: https://github.com/pronamic/wp-http/releases/tag/v1.2.3
- Changed `pronamic/wp-mollie` from `v1.5.1` to `v1.6.0`.
	Release notes: https://github.com/pronamic/wp-mollie/releases/tag/v1.6.0
- Changed `pronamic/wp-number` from `v1.3.0` to `v1.3.1`.
	Release notes: https://github.com/pronamic/wp-number/releases/tag/v1.3.1
- Changed `woocommerce/action-scheduler` from `3.7.4` to `3.8.0`.
	Release notes: https://github.com/woocommerce/action-scheduler/releases/tag/3.8.0
- Changed `wp-pay-gateways/ems-e-commerce` from `v4.3.5` to `v4.4.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ems-e-commerce/releases/tag/v4.4.0
- Changed `wp-pay-gateways/mollie` from `v4.10.3` to `v4.11.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.11.0
- Changed `wp-pay-gateways/omnikassa-2` from `v4.6.0` to `v4.7.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-rabo-smart-pay/releases/tag/v4.7.1
- Changed `wp-pay/core` from `v4.17.0` to `v4.18.0`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.18.0

Full set of changes: [`9.8.1...9.9.0`][9.9.0]

[9.9.0]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.8.1...v9.9.0

## [9.8.1] - 2024-05-15

### Commits

- Removed DigiWallet and TargetPay. ([684ff99](https://github.com/pronamic/wp-pronamic-pay/commit/684ff993d6ae62fa98234f320d99e04603895994))
- Use `$wpdb->prefix` for table names in uninstall (#375). ([51048f3](https://github.com/pronamic/wp-pronamic-pay/commit/51048f3aea11a927b07e1d67e0559c4536665e65))
- Removed the s2Member screenshot. ([35b9fc9](https://github.com/pronamic/wp-pronamic-pay/commit/35b9fc98ac40998b5f817479bf0106c448557e7c))
- Rename "iDEAL Professional" to "Rabo iDEAL Professional". ([3f49d35](https://github.com/pronamic/wp-pronamic-pay/commit/3f49d357d396ac063037bdc7ba05f4512d816a5c))
- Rename "OmniKassa 2.0" to "Rabo Smart Pay". ([4ee5c3c](https://github.com/pronamic/wp-pronamic-pay/commit/4ee5c3cb454845ec22ef1ef8f94d61bb55ce12c1))

### Composer

- Removed `wp-pay-gateways/digiwallet` `^3.3`.
- Changed `automattic/jetpack-autoloader` from `v3.0.4` to `v3.0.7`.
	Release notes: https://github.com/Automattic/jetpack-autoloader/releases/tag/v3.0.7
- Changed `pronamic/pronamic-wp-updater` from `v1.0.1` to `v1.0.2`.
	Release notes: https://github.com/pronamic/pronamic-wp-updater/releases/tag/v1.0.2
- Changed `woocommerce/action-scheduler` from `3.7.3` to `3.7.4`.
	Release notes: https://github.com/woocommerce/action-scheduler/releases/tag/3.7.4
- Changed `wp-pay-extensions/gravityforms` from `v4.6.1` to `v4.7.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-gravityforms/releases/tag/v4.7.0
- Changed `wp-pay-extensions/restrict-content-pro` from `v4.4.4` to `v4.5.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/releases/tag/v4.5.0
- Changed `wp-pay-gateways/adyen` from `v4.5.0` to `v4.5.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-adyen/releases/tag/v4.5.1
- Changed `wp-pay-gateways/mollie` from `v4.10.0` to `v4.10.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.10.3
- Changed `wp-pay/core` from `v4.16.0` to `v4.17.0`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.17.0

Full set of changes: [`9.8.0...9.8.1`][9.8.1]

[9.8.1]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.8.0...v9.8.1

## [9.8.0] - 2024-03-27

### Added

- Core - Added support for the more general card payment method.
- WooCommerce - Added gateway icon display setting, administrators can now choose a standard icon, a custom icon or no icon.
- MultiSafepay - Added `<plugin>` information to direct transaction request message.
- Rabo Smart Pay - Added `X-Api-User-Agent` header.

### Changed

- Core - Improved home URL changes detector.
- Core - Improved view of redirection and subscription pages on mobile.

### Fixed

- WooCommerce Subscriptions - Fixed Pronamic Pay subscription meta box visibility.

### Composer

- Changed `automattic/jetpack-autoloader` from `v3.0.2` to `v3.0.4`.
	Release notes: https://github.com/Automattic/jetpack-autoloader/releases/tag/v3.0.4
- Changed `pronamic/wp-gravityforms-nl` from `v3.0.7` to `v3.0.9`.
	Release notes: https://github.com/pronamic/wp-gravityforms-nl/releases/tag/v3.0.9
- Changed `pronamic/wp-pronamic-pay-forms` from `v1.1.1` to `v1.1.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-forms/releases/tag/v1.1.2
- Changed `woocommerce/action-scheduler` from `3.7.2` to `3.7.3`.
	Release notes: https://github.com/woocommerce/action-scheduler/releases/tag/3.7.3
- Changed `wp-pay-extensions/contact-form-7` from `v3.5.0` to `v3.5.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-contact-form-7/releases/tag/v3.5.1
- Changed `wp-pay-extensions/easy-digital-downloads` from `v4.3.4` to `v4.3.5`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-easy-digital-downloads/releases/tag/v4.3.5
- Changed `wp-pay-extensions/event-espresso` from `v4.2.3` to `v4.2.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-event-espresso/releases/tag/v4.2.4
- Changed `wp-pay-extensions/gravityforms` from `v4.6.0` to `v4.6.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-gravityforms/releases/tag/v4.6.1
- Changed `wp-pay-extensions/ninjaforms` from `v3.3.1` to `v3.3.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ninjaforms/releases/tag/v3.3.2
- Changed `wp-pay-extensions/woocommerce` from `v4.7.1` to `v4.8.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-woocommerce/releases/tag/v4.8.0
- Changed `wp-pay-gateways/adyen` from `v4.5.0` to `v4.5.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-adyen/releases/tag/v4.5.0
- Changed `wp-pay-gateways/buckaroo` from `v4.3.3` to `v4.3.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-buckaroo/releases/tag/v4.3.4
- Changed `wp-pay-gateways/icepay` from `v4.3.6` to `v4.3.7`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-icepay/releases/tag/v4.3.7
- Changed `wp-pay-gateways/ideal-basic` from `v4.3.5` to `v4.3.6`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal-basic/releases/tag/v4.3.6
- Changed `wp-pay-gateways/mollie` from `v4.9.2` to `v4.10.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.10.0
- Changed `wp-pay-gateways/multisafepay` from `v4.3.4` to `v4.4.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-multisafepay/releases/tag/v4.4.0
- Changed `wp-pay-gateways/omnikassa-2` from `v4.5.4` to `v4.6.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-rabo-smart-pay/releases/tag/v4.6.0
- Changed `wp-pay/core` from `v4.15.1` to `v4.16.0`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.16.0
- Changed `wp-pay/fundraising` from `v3.2.4` to `v3.2.5`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-fundraising/releases/tag/v3.2.5

Full set of changes: [`9.7.1...9.8.0`][9.8.0]

[9.8.0]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.7.1...v9.8.0

## [9.7.1] - 2024-03-14

### Added

- Added support for TWINT payment method with Mollie. ([e4b482b](https://github.com/pronamic/wp-pronamic-pay-mollie/commit/e4b482b304c1157e7acd886e0815734e86733c39))

### Fixed

- Fixed setting Restrict Content Pro refunded payment status on refunds and chargebacks ([#14](https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/issues/14)). ([09a28d8](https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/commit/09a28d8304a477fdd4a0eb8cf43481dc62bce764))
- Fixed updating RCP membership status on subscription status update ([#13](https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/issues/13)). ([7fe6938](https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/commit/7fe693819524ac32a81daa5a40280f92b0accb39))

### Composer

- Changed `automattic/jetpack-autoloader` from `v2.12.0` to `v3.0.2`.
	Release notes: https://github.com/Automattic/jetpack-autoloader/releases/tag/v3.0.2
- Changed `pronamic/pronamic-wp-updater` from `v1.0.0` to `v1.0.1`.
	Release notes: https://github.com/pronamic/pronamic-wp-updater/releases/tag/v1.0.1
- Changed `pronamic/wp-mollie` from `v1.5.0` to `v1.5.1`.
	Release notes: https://github.com/pronamic/wp-mollie/releases/tag/v1.5.1
- Changed `woocommerce/action-scheduler` from `3.7.1` to `3.7.2`.
	Release notes: https://github.com/woocommerce/action-scheduler/releases/tag/3.7.2
- Changed `wp-pay-extensions/ninjaforms` from `v3.3.0` to `v3.3.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ninjaforms/releases/tag/v3.3.1
- Changed `wp-pay-extensions/restrict-content-pro` from `v4.4.2` to `v4.4.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/releases/tag/v4.4.4
- Changed `wp-pay-gateways/adyen` from `v4.4.8` to `v4.5.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-adyen/releases/tag/v4.5.0
- Changed `wp-pay-gateways/mollie` from `v4.9.0` to `v4.9.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.9.2
- Changed `wp-pay-gateways/omnikassa-2` from `v4.5.3` to `v4.5.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-rabo-smart-pay/releases/tag/v4.5.4
- Changed `wp-pay/core` from `v4.15.0` to `v4.15.1`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.15.1
- Changed `wp-pay/fundraising` from `v3.2.3` to `v3.2.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-fundraising/releases/tag/v3.2.4

Full set of changes: [`9.7.0...9.7.1`][9.7.1]

[9.7.1]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.7.0...v9.7.1

## [9.7.0] - 2024-02-08

### Added

- Mollie → Added support for card token. [2941dee](https://github.com/pronamic/wp-mollie/commit/2941dee85b0c7ad2f510c9c1a34ceca1faa91585)
- Mollie/WooCommerce → Added support for Mollie card field/component in WooCommerce legacy checkout. [#40](https://github.com/pronamic/wp-pronamic-pay-mollie/pull/40)

### Changed

- Contact Form 7 → Improved the support for Contact Form 7 checkbox fields used for the amount to be paid (`pronamic_pay_amount` tag option), multiple checked options/amounts are now added up. ([ba1322a](https://github.com/pronamic/wp-pronamic-pay-contact-form-7/commit/ba1322afb5d859f21281827a263dc94ed0dae350))
- Gravity Forms → Optimize performance by reusing instances of `PayFeed` from memory. ([fa89eab](https://github.com/pronamic/wp-pronamic-pay-gravityforms/commit/fa89eaba746000d5c432b480f1b4f0b4b8e07994))
- Mollie → The HTTP timeout option is increased when connecting to Mollie via WP-Cron, WP-CLI or the Action Scheduler library. [pronamic/wp-pay-core#170](https://github.com/pronamic/wp-pay-core/issues/170)

### Fixed

- Gravity Forms → Fixed deleting feeds through `PaymentAddOn::delete_feeds()`. ([89f88b7](https://github.com/pronamic/wp-pronamic-pay-gravityforms/commit/89f88b7ea1b27af52418bf34a04b5c31690f5ff3))
- Mollie → Fixed `wp_register_script` and `wp_register_style` are called incorrectly https://github.com/pronamic/wp-pronamic-pay-mollie/issues/42. ([41bfb35](https://github.com/pronamic/wp-pronamic-pay-mollie/commit/41bfb35d058cb50012d2141d111c084f24ec1e3c))
- WooCommerce → Fixed "Fatal error: Uncaught Error: Call to undefined function wc_get_order()" in source text if WooCommerce is not active. ([c4ccf37](https://github.com/pronamic/wp-pronamic-pay-woocommerce/commit/c4ccf3729ea994df23737181c5771abcaf8cd6c6))

### Removed

- Worldline (formerly Ingenico/Ogone) → Removed `DirectLink` integration. ([51047d6](https://github.com/pronamic/wp-pronamic-pay-ingenico/commit/51047d6c9c73b5b9d63ecd151fa6fff169e39638))

### Composer

- Changed `automattic/jetpack-autoloader` from `v2.12.0` to `v2.12.0`.
	Release notes: https://github.com/Automattic/jetpack-autoloader/releases/tag/v2.12.0
- Changed `pronamic/wp-mollie` from `v1.4.0` to `v1.5.0`.
	Release notes: https://github.com/pronamic/wp-mollie/releases/tag/v1.5.0
- Changed `woocommerce/action-scheduler` from `3.7.1` to `3.7.1`.
	Release notes: https://github.com/woocommerce/action-scheduler/releases/tag/3.7.1
- Changed `wp-pay-extensions/contact-form-7` from `v3.4.0` to `v3.5.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-contact-form-7/releases/tag/v3.5.0
- Changed `wp-pay-extensions/gravityforms` from `v4.5.8` to `v4.6.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-gravityforms/releases/tag/v4.6.0
- Changed `wp-pay-extensions/ninjaforms` from `v3.2.4` to `v3.3.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ninjaforms/releases/tag/v3.3.0
- Changed `wp-pay-extensions/restrict-content-pro` from `v4.4.1` to `v4.4.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/releases/tag/v4.4.2
- Changed `wp-pay-extensions/woocommerce` from `v4.7.0` to `v4.7.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-woocommerce/releases/tag/v4.7.1
- Changed `wp-pay-gateways/mollie` from `v4.8.1` to `v4.9.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.9.0
- Changed `wp-pay-gateways/ogone` from `v4.6.0` to `v4.6.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ingenico/releases/tag/v4.6.0
- Changed `wp-pay/core` from `v4.14.3` to `v4.15.0`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.15.0

Full set of changes: [`9.6.4...9.7.0`][9.7.0]

[9.7.0]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.6.4...v9.7.0

## [9.6.4] - 2023-12-18

### Removed

- Removed 'Ingenico - DirectLink' integration (pronamic/wp-pronamic-pay-ingenico/15). ([5322ba9](https://github.com/pronamic/wp-pronamic-pay/commit/5322ba9862e7af3196b8b2dda26723b953933c34))

### Composer

- Changed `woocommerce/action-scheduler` from `3.6.4` to `3.7.1`.
	Release notes: https://github.com/woocommerce/action-scheduler/releases/tag/3.7.1
- Changed `wp-pay-extensions/contact-form-7` from `v3.3.2` to `v3.4.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-contact-form-7/releases/tag/v3.4.0
- Changed `wp-pay-extensions/formidable-forms` from `v4.4.1` to `v4.4.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-formidable-forms/releases/tag/v4.4.2
- Changed `wp-pay-extensions/memberpress` from `v4.7.10` to `v4.7.11`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-memberpress/releases/tag/v4.7.11
- Changed `wp-pay-extensions/woocommerce` from `v4.6.3` to `v4.7.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-woocommerce/releases/tag/v4.7.0
- Changed `wp-pay-gateways/ogone` from `v4.5.4` to `v4.6.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ingenico/releases/tag/v4.6.0
- Changed `wp-pay-gateways/omnikassa-2` from `v4.5.2` to `v4.5.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-omnikassa-2/releases/tag/v4.5.3
- Changed `wp-pay/core` from `v4.14.2` to `v4.14.3`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.14.3

Full set of changes: [`9.6.3...9.6.4`][9.6.4]

[9.6.4]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.6.3...v9.6.4

## [9.6.3] - 2023-11-15

### Fixed

- Fixed fatal error in Formidable Forms bank select field.

### Commits

- WooCommerce tested up to 8.2.2. ([c7bb73c](https://github.com/pronamic/wp-pronamic-pay/commit/c7bb73c30cbf3eb24d700e70b27ca7e8fac6f570))
- Formidable Forms tested up to 6.5.4. ([cdcd068](https://github.com/pronamic/wp-pronamic-pay/commit/cdcd068623c9befe91eb26d12cbb838f29cdf92d))
- WordPress tested up to 6.4. ([78ba625](https://github.com/pronamic/wp-pronamic-pay/commit/78ba625833028741c1d15f2500187a8dc9fa9d25))

### Composer

- Changed `wp-pay-extensions/formidable-forms` from `v4.4.0` to `v4.4.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-formidable-forms/releases/tag/v4.4.1

Full set of changes: [`9.6.2...9.6.3`][9.6.3]

[9.6.3]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.6.2...v9.6.3

## [9.6.2] - 2023-11-09

### Fixed

- Fixed setting Mollie sequence type. ([163](https://github.com/pronamic/wp-pay-core/issues/163))

### Commits

- Updated libraries. ([9175eba](https://github.com/pronamic/wp-pronamic-pay/commit/9175eba920555d62295bcd2f5ef1a265d6cba4a6))

### Composer

- Changed `wp-pay/core` from `v4.14.1` to `v4.14.2`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.14.2

Full set of changes: [`9.6.1...9.6.2`][9.6.2]

[9.6.2]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.6.1...v9.6.2

## [9.6.1] - 2023-11-08

### Composer

- Changed `wp-pay-gateways/omnikassa-2` from `v4.5.1` to `v4.5.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-omnikassa-2/releases/tag/v4.5.2

Full set of changes: [`9.6.0...9.6.1`][9.6.1]

[9.6.1]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.6.0...v9.6.1

## [9.6.0] - 2023-11-06

### Changed

- Use https://github.com/pronamic/pronamic-wp-updater. ([c21646b](https://github.com/pronamic/wp-pronamic-pay/commit/c21646b187681672963a55ff2767cea4bda7bd4d))
- Use WordPress file data header notation for version, core now uses `get_file_data` to retrieve version. ([1982c9e](https://github.com/pronamic/wp-pronamic-pay/commit/1982c9e1c3908336c5a0a20b205201c1acdaa859))
- Bump to PHP 8. ([1384639](https://github.com/pronamic/wp-pronamic-pay/commit/1384639ef4514672574fc83051924a90476ae841))

### Removed

- Removed Payvision, deprecated. ([979deeb](https://github.com/pronamic/wp-pronamic-pay/commit/979deebebd7ad1e30490c1eba56762c96a104932))
- Removed `global $pronamic_ideal`, no longer used. ([561edb2](https://github.com/pronamic/wp-pronamic-pay/commit/561edb252335f732790a0caaeb1f256057b3d5af))
- Removed expired certificates. ([03c37db](https://github.com/pronamic/wp-pronamic-pay/commit/03c37db833fc8445a8656d6de0eafc64628b518c))
- Removed redirect message view, is now part of core. ([f57abce](https://github.com/pronamic/wp-pronamic-pay/commit/f57abce7c6a4e77764df5041d2b60127df42207d))
- Removed exception view, is now part of core. ([36b9fc2](https://github.com/pronamic/wp-pronamic-pay/commit/36b9fc2dbbbe9a3f924a1088cae6fe8b288f2aca))
- Removed error view, is now part of core library. ([0c2a471](https://github.com/pronamic/wp-pronamic-pay/commit/0c2a471f1bc837c1780ecad22660b5e7a1b70183))

### Composer

- Added `pronamic/pronamic-wp-updater` `^1.0`.
- Changed `php` from `>=7.4` to `>=8.0`.
- Changed `automattic/jetpack-autoloader` from `v2.11.22` to `v2.12.0`.
	Release notes: https://github.com/Automattic/jetpack-autoloader/releases/tag/v2.12.0
- Changed `pronamic/wp-datetime` from `v2.1.4` to `v2.1.7`.
	Release notes: https://github.com/pronamic/wp-datetime/releases/tag/v2.1.7
- Changed `pronamic/wp-gravityforms-nl` from `v3.0.6` to `v3.0.7`.
	Release notes: https://github.com/pronamic/wp-gravityforms-nl/releases/tag/v3.0.7
- Changed `pronamic/wp-html` from `v2.1.3` to `v2.2.1`.
	Release notes: https://github.com/pronamic/wp-html/releases/tag/v2.2.1
- Changed `pronamic/wp-mollie` from `v1.2.3` to `v1.4.0`.
	Release notes: https://github.com/pronamic/wp-mollie/releases/tag/v1.4.0
- Changed `pronamic/wp-money` from `v2.4.1` to `v2.4.3`.
	Release notes: https://github.com/pronamic/wp-money/releases/tag/v2.4.3
- Changed `pronamic/wp-pronamic-pay-forms` from `v1.1.0` to `v1.1.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-forms/releases/tag/v1.1.1
- Changed `woocommerce/action-scheduler` from `3.6.2` to `3.6.4`.
	Release notes: https://github.com/woocommerce/action-scheduler/releases/tag/3.6.4
- Changed `wp-pay-extensions/contact-form-7` from `v3.3.0` to `v3.3.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-contact-form-7/releases/tag/v3.3.2
- Changed `wp-pay-extensions/formidable-forms` from `v4.4.0` to `v4.4.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-formidable-forms/releases/tag/v4.4.0
- Changed `wp-pay-extensions/gravityforms` from `v4.5.6` to `v4.5.8`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-gravityforms/releases/tag/v4.5.8
- Changed `wp-pay-extensions/ninjaforms` from `v3.2.3` to `v3.2.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ninjaforms/releases/tag/v3.2.4
- Changed `wp-pay-extensions/restrict-content-pro` from `v4.4.0` to `v4.4.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/releases/tag/v4.4.1
- Changed `wp-pay-extensions/woocommerce` from `v4.5.9` to `v4.6.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-woocommerce/releases/tag/v4.6.3
- Changed `wp-pay-gateways/adyen` from `v4.4.6` to `v4.4.8`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-adyen/releases/tag/v4.4.8
- Changed `wp-pay-gateways/ems-e-commerce` from `v4.3.4` to `v4.3.5`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ems-e-commerce/releases/tag/v4.3.5
- Changed `wp-pay-gateways/icepay` from `v4.3.5` to `v4.3.6`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-icepay/releases/tag/v4.3.6
- Changed `wp-pay-gateways/ideal-advanced-v3` from `v4.3.6` to `v4.3.7`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal-advanced-v3/releases/tag/v4.3.7
- Changed `wp-pay-gateways/mollie` from `v4.7.11` to `v4.8.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.8.1
- Changed `wp-pay-gateways/multisafepay` from `v4.3.3` to `v4.3.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-multisafepay/releases/tag/v4.3.4
- Changed `wp-pay-gateways/ogone` from `v4.5.3` to `v4.5.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ingenico/releases/tag/v4.5.4
- Changed `wp-pay-gateways/omnikassa-2` from `v4.4.5` to `v4.5.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-omnikassa-2/releases/tag/v4.5.1
- Changed `wp-pay-gateways/pay-nl` from `v4.5.5` to `v4.5.6`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-pay-nl/releases/tag/v4.5.6
- Changed `wp-pay-gateways/paypal` from `v2.3.5` to `v2.3.6`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-paypal/releases/tag/v2.3.6
- Changed `wp-pay/core` from `v4.12.0` to `v4.14.1`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.14.1

Full set of changes: [`9.5.0...9.6.0`][9.6.0]

[9.6.0]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.5.0...v9.6.0

<!-- End changelog -->

## [9.5.1] - 2023-09-29

### Fixed

- Fixed duplicate payment status email with Restrict Content Pro.

### Composer

- Changed `automattic/jetpack-autoloader` from `v2.11.22` to `v2.12.0`.
	Release notes: https://github.com/Automattic/jetpack-autoloader/releases/tag/v2.12.0
- Changed `woocommerce/action-scheduler` from `3.6.2` to `3.6.3`.
	Release notes: https://github.com/woocommerce/action-scheduler/releases/tag/3.6.3
- Changed `wp-pay-extensions/restrict-content-pro` from `v4.4.0` to `v4.4.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/releases/tag/v4.4.1

Full set of changes: [`9.5.0...9.5.1`][9.5.1]

[9.5.1]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.5.0...v9.5.1

## [9.5.0] - 2023-09-11

### Composer

- Changed `pronamic/wp-gravityforms-nl` from `v3.0.5` to `v3.0.6`.
	Release notes: https://github.com/pronamic/wp-gravityforms-nl/releases/tag/v3.0.6
- Changed `pronamic/wp-money` from `v2.4.0` to `v2.4.1`.
	Release notes: https://github.com/pronamic/wp-money/releases/tag/v2.4.1
- Changed `pronamic/wp-pronamic-pay-forms` from `v1.0.3` to `v1.1.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-forms/releases/tag/v1.1.0
- Changed `wp-pay-extensions/formidable-forms` from `v4.3.4` to `v4.4.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-formidable-forms/releases/tag/v4.4.0
- Changed `wp-pay-extensions/restrict-content-pro` from `v4.3.6` to `v4.4.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/releases/tag/v4.4.0
- Changed `wp-pay-extensions/woocommerce` from `v4.5.8` to `v4.5.9`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-woocommerce/releases/tag/v4.5.9
- Changed `wp-pay-gateways/ideal-basic` from `v4.3.4` to `v4.3.5`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal-basic/releases/tag/v4.3.5
- Changed `wp-pay-gateways/mollie` from `v4.7.10` to `v4.7.11`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.7.11
- Changed `wp-pay-gateways/ogone` from `v4.5.2` to `v4.5.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ingenico/releases/tag/v4.5.3
- Changed `wp-pay-gateways/pay-nl` from `v4.5.4` to `v4.5.5`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-pay-nl/releases/tag/v4.5.5
- Changed `wp-pay-gateways/paypal` from `v2.3.4` to `v2.3.5`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-paypal/releases/tag/v2.3.5
- Changed `wp-pay/core` from `v4.11.0` to `v4.12.0`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.12.0
- Changed `wp-pay/fundraising` from `v3.2.2` to `v3.2.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-fundraising/releases/tag/v3.2.3

Full set of changes: [`9.4.11...9.5.0`][9.5.0]

[9.5.0]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.4.11...v9.5.0

## [9.4.11] - 2023-08-30

### Fixed

- Fixed setting Billie payment method status.

### Commits

- Updated Mollie library. ([b8e1384](https://github.com/pronamic/wp-pronamic-pay/commit/b8e138490f2cf882336356d30632e0ff989eeabe))

### Composer

- Changed `wp-pay-extensions/contact-form-7` from `v3.3.0` to `v3.3.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-contact-form-7/releases/tag/v3.3.0
- Changed `wp-pay-gateways/mollie` from `v4.7.9` to `v4.7.10`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.7.10
- Changed `wp-pay/core` from `v4.11.0` to `v4.11.0`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.11.0

Full set of changes: [`9.4.10...9.4.11`][9.4.11]

[9.4.11]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.4.10...v9.4.11

## [9.4.10] - 2023-08-28

### Changed

- Improved processing of Contact Form 7 form submission data.

### Fixed

- Fixed compatibility with plugin "Send PDF for Contact Form 7".

### Commits

- Updated translations. ([f4010df](https://github.com/pronamic/wp-pronamic-pay/commit/f4010dff0272f2324f8cb7d1ca02d49292c75b62))
- Updated libraries. ([b5c46c7](https://github.com/pronamic/wp-pronamic-pay/commit/b5c46c7eb7391c4fbabcd0ed46d17b3b7fc087ef))
- Tested up to 6.3. ([f0f003a](https://github.com/pronamic/wp-pronamic-pay/commit/f0f003af6a95bfd2da5477d37a1732ed96f1e0ba))

### Composer

- Changed `automattic/jetpack-autoloader` from `v2.11.21` to `v2.11.22`.
	Release notes: https://github.com/Automattic/jetpack-autoloader/releases/tag/v2.11.22
- Changed `pronamic/wp-mollie` from `v1.2.2` to `v1.2.3`.
	Release notes: https://github.com/pronamic/wp-mollie/releases/tag/v1.2.3
- Changed `woocommerce/action-scheduler` from `3.6.1` to `3.6.2`.
	Release notes: https://github.com/woocommerce/action-scheduler/releases/tag/3.6.2
- Changed `wp-pay-extensions/contact-form-7` from `v3.2.5` to `v3.3.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-contact-form-7/releases/tag/v3.3.0
- Changed `wp-pay-extensions/woocommerce` from `v4.5.7` to `v4.5.8`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-woocommerce/releases/tag/v4.5.8
- Changed `wp-pay-gateways/adyen` from `v4.4.5` to `v4.4.6`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-adyen/releases/tag/v4.4.6
- Changed `wp-pay-gateways/mollie` from `v4.7.8` to `v4.7.9`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.7.9
- Changed `wp-pay/core` from `v4.10.1` to `v4.11.0`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.11.0

Full set of changes: [`9.4.9...9.4.10`][9.4.10]

[9.4.10]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.4.9...v9.4.10

## [9.4.9] - 2023-07-20

### Fixed

- Fixed 'Forms' admin menu item not shown with new plugin installations.

### Composer

- Changed `pronamic/wp-pronamic-pay-forms` from `v1.0.1` to `v1.0.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-forms/releases/tag/v1.0.3

Full set of changes: [`9.4.8...9.4.9`][9.4.9]

[9.4.9]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.4.8...v9.4.9

## [9.4.8] - 2023-07-20

### Fixed

- Fixed untranslated plugin.

### Commits

- Use relative `^wp-content/` path in PHPCS config. ([1950c8f](https://github.com/pronamic/wp-pronamic-pay/commit/1950c8f0eebaca92602274fab22b20e928bdcd07))

Full set of changes: [`9.4.7...9.4.8`][9.4.8]

[9.4.8]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.4.7...v9.4.8

## [9.4.7] - 2023-07-19

### Commits

- Added forms plugin integration. ([6174b96](https://github.com/pronamic/wp-pronamic-pay/commit/6174b96f3924828f3a8429f92e128a5413769bcd))

### Composer

- Changed `pronamic/wp-pronamic-pay-forms` from `v1.0.0` to `v1.0.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-forms/releases/tag/v1.0.1
- Changed `wp-pay/core` from `v4.10.0` to `v4.10.1`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.10.1

Full set of changes: [`9.4.6...9.4.7`][9.4.7]

[9.4.7]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.4.6...v9.4.7

## [9.4.6] - 2023-07-18

### Composer

- Added `pronamic/wp-pronamic-pay-forms` `^1.0`.
- Changed `wp-pay-extensions/memberpress` from `v4.7.9` to `v4.7.10`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-memberpress/releases/tag/v4.7.10
- Changed `wp-pay-extensions/restrict-content-pro` from `v4.3.5` to `v4.3.6`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/releases/tag/v4.3.6
- Changed `wp-pay/core` from `v4.9.4` to `v4.10.0`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.10.0

Full set of changes: [`9.4.5...9.4.6`][9.4.6]

[9.4.6]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.4.5...v9.4.6

## [9.4.5] - 2023-07-12

### Changed

- 📣 Mollie payment methods that can be used as a first payment for recurring
  payments are marked with support for recurring payments. For extensions such
  as WooCommerce Subscriptions, MemberPress and Restrict Content Pro, this may
  mean that payment methods such as Bancontact, Belfius, EPS, Giropay, iDEAL,
  KBC and Sofort can now also be visible when paying for subscriptions. Where
  previously the "Direct Debit (mandate via iDEAL)" payment method/gateway had
  to be used, the regular iDEAL payment method/gateway can now also be used.

### Commits

- Removed notifications about removed extensions. ([d9bdd88](https://github.com/pronamic/wp-pronamic-pay/commit/d9bdd88cfd44b85192340876dd92562629a3891c))
- Also replace `pronamic-money` text domain. ([eec3016](https://github.com/pronamic/wp-pronamic-pay/commit/eec30169e695392ee8b7dbccad22dab630c24e51))
- Added `nl_NL_formal` based on `nl_NL`. ([23400f4](https://github.com/pronamic/wp-pronamic-pay/commit/23400f49b5599b49121bcb4382d9c1abe07628de))
- Added `nl_BE` based on `nl_NL`. ([d4864c5](https://github.com/pronamic/wp-pronamic-pay/commit/d4864c5039dc32c14c645eb1a3430ead27c8afda))
- Fixed "PHP Fatal error:  Uncaught Error: Class "Pronamic\Deployer\Changelog" not found". ([f06ed60](https://github.com/pronamic/wp-pronamic-pay/commit/f06ed602ad9151771a9011b32a91617d1c2a4c89))

### Composer

- Changed `pronamic/wp-mollie` from `v1.2.1` to `v1.2.2`.
	Release notes: https://github.com/pronamic/wp-mollie/releases/tag/v1.2.2
- Changed `woocommerce/action-scheduler` from `3.6.0` to `3.6.1`.
	Release notes: https://github.com/woocommerce/action-scheduler/releases/tag/3.6.1
- Changed `wp-pay-extensions/charitable` from `v4.3.2` to `v4.3.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-charitable/releases/tag/v4.3.3
- Changed `wp-pay-extensions/gravityforms` from `v4.5.5` to `v4.5.6`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-gravityforms/releases/tag/v4.5.6
- Changed `wp-pay-extensions/memberpress` from `v4.7.8` to `v4.7.9`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-memberpress/releases/tag/v4.7.9
- Changed `wp-pay-extensions/restrict-content-pro` from `v4.3.4` to `v4.3.5`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/releases/tag/v4.3.5
- Changed `wp-pay-extensions/woocommerce` from `v4.5.6` to `v4.5.7`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-woocommerce/releases/tag/v4.5.7
- Changed `wp-pay-gateways/adyen` from `v4.4.4` to `v4.4.5`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-adyen/releases/tag/v4.4.5
- Changed `wp-pay-gateways/digiwallet` from `v3.3.3` to `v3.3.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-digiwallet/releases/tag/v3.3.4
- Changed `wp-pay-gateways/ems-e-commerce` from `v4.3.3` to `v4.3.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ems-e-commerce/releases/tag/v4.3.4
- Changed `wp-pay-gateways/icepay` from `v4.3.4` to `v4.3.5`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-icepay/releases/tag/v4.3.5
- Changed `wp-pay-gateways/ideal-advanced-v3` from `v4.3.5` to `v4.3.6`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal-advanced-v3/releases/tag/v4.3.6
- Changed `wp-pay-gateways/ideal-basic` from `v4.3.3` to `v4.3.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal-basic/releases/tag/v4.3.4
- Changed `wp-pay-gateways/mollie` from `v4.7.7` to `v4.7.8`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.7.8
- Changed `wp-pay-gateways/ogone` from `v4.5.1` to `v4.5.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ingenico/releases/tag/v4.5.2
- Changed `wp-pay-gateways/omnikassa-2` from `v4.4.4` to `v4.4.5`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-omnikassa-2/releases/tag/v4.4.5
- Changed `wp-pay-gateways/pay-nl` from `v4.5.3` to `v4.5.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-pay-nl/releases/tag/v4.5.4
- Changed `wp-pay/core` from `v4.9.3` to `v4.9.4`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.9.4

Full set of changes: [`9.4.4...9.4.5`][9.4.5]

[9.4.5]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.4.4...v9.4.5

## [9.4.4] - 2023-06-01

### Commits

- Changed text domain from `pronamic_ideal` to `pronamic-ideal`. ([a61ad49](https://github.com/pronamic/wp-pronamic-pay/commit/a61ad497b56e6f2b54901bac4a15875b66fa3ccb))
- Updated extensions tested up to versions. ([555b376](https://github.com/pronamic/wp-pronamic-pay/commit/555b376c5c4a28c5e5b9ae827304538e431049b6))

### Composer

- Changed `automattic/jetpack-autoloader` from `v2.11.18` to `v2.11.21`.
	Release notes: https://github.com/Automattic/jetpack-autoloader/releases/tag/v2.11.21
- Changed `pronamic/wp-gravityforms-nl` from `v3.0.4` to `v3.0.5`.
	Release notes: https://github.com/pronamic/wp-gravityforms-nl/releases/tag/v3.0.5
- Changed `woocommerce/action-scheduler` from `3.5.4` to `3.6.0`.
	Release notes: https://github.com/woocommerce/action-scheduler/releases/tag/3.6.0
- Changed `wp-pay-extensions/contact-form-7` from `v3.2.4` to `v3.2.5`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-contact-form-7/releases/tag/v3.2.5
- Changed `wp-pay-extensions/easy-digital-downloads` from `v4.3.3` to `v4.3.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-easy-digital-downloads/releases/tag/v4.3.4
- Changed `wp-pay-extensions/event-espresso` from `v4.2.2` to `v4.2.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-event-espresso/releases/tag/v4.2.3
- Changed `wp-pay-extensions/formidable-forms` from `v4.3.3` to `v4.3.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-formidable-forms/releases/tag/v4.3.4
- Changed `wp-pay-extensions/give` from `v4.2.2` to `v4.2.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-give/releases/tag/v4.2.3
- Changed `wp-pay-extensions/gravityforms` from `v4.5.4` to `v4.5.5`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-gravityforms/releases/tag/v4.5.5
- Changed `wp-pay-extensions/memberpress` from `v4.7.7` to `v4.7.8`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-memberpress/releases/tag/v4.7.8
- Changed `wp-pay-extensions/ninjaforms` from `v3.2.2` to `v3.2.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ninjaforms/releases/tag/v3.2.3
- Changed `wp-pay-extensions/restrict-content-pro` from `v4.3.3` to `v4.3.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/releases/tag/v4.3.4
- Changed `wp-pay-extensions/woocommerce` from `v4.5.5` to `v4.5.6`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-woocommerce/releases/tag/v4.5.6
- Changed `wp-pay-gateways/buckaroo` from `v4.3.2` to `v4.3.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-buckaroo/releases/tag/v4.3.3
- Changed `wp-pay-gateways/digiwallet` from `v3.3.2` to `v3.3.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-digiwallet/releases/tag/v3.3.3
- Changed `wp-pay-gateways/ems-e-commerce` from `v4.3.2` to `v4.3.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ems-e-commerce/releases/tag/v4.3.3
- Changed `wp-pay-gateways/icepay` from `v4.3.3` to `v4.3.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-icepay/releases/tag/v4.3.4
- Changed `wp-pay-gateways/ideal` from `v4.1.2` to `v4.1.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal/releases/tag/v4.1.3
- Changed `wp-pay-gateways/ideal-advanced-v3` from `v4.3.4` to `v4.3.5`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal-advanced-v3/releases/tag/v4.3.5
- Changed `wp-pay-gateways/ideal-basic` from `v4.3.2` to `v4.3.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal-basic/releases/tag/v4.3.3
- Changed `wp-pay-gateways/mollie` from `v4.7.6` to `v4.7.7`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.7.7
- Changed `wp-pay-gateways/multisafepay` from `v4.3.2` to `v4.3.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-multisafepay/releases/tag/v4.3.3
- Changed `wp-pay-gateways/ogone` from `v4.5.0` to `v4.5.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ingenico/releases/tag/v4.5.1
- Changed `wp-pay-gateways/omnikassa-2` from `v4.4.3` to `v4.4.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-omnikassa-2/releases/tag/v4.4.4
- Changed `wp-pay-gateways/pay-nl` from `v4.5.2` to `v4.5.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-pay-nl/releases/tag/v4.5.3
- Changed `wp-pay-gateways/paypal` from `v2.3.2` to `v2.3.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-paypal/releases/tag/v2.3.4
- Changed `wp-pay/core` from `v4.9.2` to `v4.9.3`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.9.3
- Changed `wp-pay/fundraising` from `v3.2.1` to `v3.2.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-fundraising/releases/tag/v3.2.2

Full set of changes: [`9.4.3...9.4.4`][9.4.4]

[9.4.4]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.4.3...v9.4.4

## [9.4.3] - 2023-04-05

### Fixed

- Fixed error caused by undefined `PRONAMIC_PAY_DEBUG` constant.
- Fixed warning about missing `package.json` file in Mollie integration.

### Commits

- Check if `PRONAMIC_PAY_DEBUG` constant is defined. ([10c8e53](https://github.com/pronamic/wp-pronamic-pay/commit/10c8e5374fc6e28564f9fe5499b81005f8736a03))
- Make sure to define `PRONAMIC_PAY_DEBUG` constant (accidentally removed in 778b554b). ([6e41f23](https://github.com/pronamic/wp-pronamic-pay/commit/6e41f234654a4e192718907728746e569449be07))
- Mark 'Old platform' integrations for ING iDEAL Advanced as deprecated. ([82cd05e](https://github.com/pronamic/wp-pronamic-pay/commit/82cd05ee7615d96075ee7484138a6b4687e418d0))
- Updated translations. ([b056794](https://github.com/pronamic/wp-pronamic-pay/commit/b0567941d165a7209972d9e64e82b7280200ef13))

### Composer

- Changed `pronamic/wp-mollie` from `v1.2.0` to `v1.2.1`.
	Release notes: https://github.com/pronamic/wp-mollie/releases/tag/v1.2.1

Full set of changes: [`9.4.2...9.4.3`][9.4.3]

[9.4.3]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.4.2...v9.4.3

## [9.4.2] - 2023-03-31

### Fixed

- Fixed fatal error due to errorneous translations.

### Commits

- Updated translations. ([a416552](https://github.com/pronamic/wp-pronamic-pay/commit/a41655239944cf37900daca960c3468dc51fd59d))

### Composer

- Changed `wp-pay-extensions/charitable` from `v4.3.1` to `v4.3.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-charitable/releases/tag/v4.3.2
- Changed `wp-pay-gateways/adyen` from `v4.4.3` to `v4.4.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-adyen/releases/tag/v4.4.4
- Changed `wp-pay/core` from `v4.9.1` to `v4.9.2`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.9.2

Full set of changes: [`9.4.1...9.4.2`][9.4.2]

[9.4.2]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.4.1...v9.4.2

## [9.4.1] - 2023-03-30

### Fixed

- Fixed refunded amount checks.

### Composer

- Changed `automattic/jetpack-autoloader` from `v2.11.17` to `v2.11.18`.
	Release notes: https://github.com/Automattic/jetpack-autoloader/releases/tag/v2.11.18
- Changed `wp-pay-extensions/easy-digital-downloads` from `v4.3.2` to `v4.3.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-easy-digital-downloads/releases/tag/v4.3.3
- Changed `wp-pay-extensions/gravityforms` from `v4.5.3` to `v4.5.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-gravityforms/releases/tag/v4.5.4
- Changed `wp-pay-extensions/memberpress` from `v4.7.6` to `v4.7.7`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-memberpress/releases/tag/v4.7.7
- Changed `wp-pay-extensions/woocommerce` from `v4.5.4` to `v4.5.5`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-woocommerce/releases/tag/v4.5.5
- Changed `wp-pay/core` from `v4.9.0` to `v4.9.1`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.9.1
Full set of changes: [`9.4.0...9.4.1`][9.4.1]

[9.4.1]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.4.0...v9.4.1

## [9.4.0] - 2023-03-29
### Changed

- Tested up to WordPress version 6.2. ([c7b8768](https://github.com/pronamic/wp-pronamic-pay/commit/c7b8768b58c05c55ee22edae2f6de4905c6d5f56))
- Use Jetpack autoloader. ([778b554](https://github.com/pronamic/wp-pronamic-pay/commit/778b554b29857b5537b41523dc3916fa2f6101ee))
- Support for refunds further expanded and improved.
- Simplified and improved payment status pages generator.
- Built-in forms no longer create WordPress users for each entry.

### Added

- Added a home URL modification watcher to warn users about consequences related to webhooks and subscriptions.
- Addes support for metadata in payment lines.
- Ingenico: Added Yoursafe iDEAL issuer.
- Mollie: Added support for Mollie orders refunds.
- Mollie: Added support for in3 payment method.
- Rabo Smart Pay: Added support for Rabo Smart Pay refunds.

### Composer

- Added `ext-json` `*`.
- Added `automattic/jetpack-autoloader` `^2.11`.
- Added `pronamic/wp-gravityforms-nl` `^3.0`.
- Added `pronamic/wp-http` `^1.2`.
- Added `pronamic/wp-mollie` `^1.2`.
- Changed `pronamic/wp-datetime` from `v2.1.2` to `v2.1.4`.
	Release notes: https://github.com/pronamic/wp-datetime/releases/tag/v2.1.4
- Changed `pronamic/wp-html` from `v2.1.1` to `v2.1.3`.
	Release notes: https://github.com/pronamic/wp-html/releases/tag/v2.1.3
- Changed `pronamic/wp-money` from `v2.2.1` to `v2.4.0`.
	Release notes: https://github.com/pronamic/wp-money/releases/tag/v2.4.0
- Changed `pronamic/wp-number` from `v1.2.1` to `v1.3.0`.
	Release notes: https://github.com/pronamic/wp-number/releases/tag/v1.3.0
- Changed `wp-pay-extensions/charitable` from `v4.3.1` to `v4.3.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-charitable/releases/tag/v4.3.1
- Changed `wp-pay-extensions/contact-form-7` from `v3.2.2` to `v3.2.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-contact-form-7/releases/tag/v3.2.4
- Changed `wp-pay-extensions/easy-digital-downloads` from `v4.3.1` to `v4.3.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-easy-digital-downloads/releases/tag/v4.3.2
- Changed `wp-pay-extensions/event-espresso` from `v4.2.1` to `v4.2.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-event-espresso/releases/tag/v4.2.2
- Changed `wp-pay-extensions/formidable-forms` from `v4.3.2` to `v4.3.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-formidable-forms/releases/tag/v4.3.3
- Changed `wp-pay-extensions/give` from `v4.2.1` to `v4.2.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-give/releases/tag/v4.2.2
- Changed `wp-pay-extensions/gravityforms` from `v4.5.2` to `v4.5.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-gravityforms/releases/tag/v4.5.3
- Changed `wp-pay-extensions/memberpress` from `v4.7.5` to `v4.7.6`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-memberpress/releases/tag/v4.7.6
- Changed `wp-pay-extensions/ninjaforms` from `v3.2.1` to `v3.2.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ninjaforms/releases/tag/v3.2.2
- Changed `wp-pay-extensions/restrict-content-pro` from `v4.3.2` to `v4.3.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/releases/tag/v4.3.3
- Changed `wp-pay-extensions/woocommerce` from `v4.5.2` to `v4.5.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-woocommerce/releases/tag/v4.5.4
- Changed `wp-pay-gateways/adyen` from `v4.4.3` to `v4.4.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-adyen/releases/tag/v4.4.3
- Changed `wp-pay-gateways/buckaroo` from `v4.3.1` to `v4.3.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-buckaroo/releases/tag/v4.3.2
- Changed `wp-pay-gateways/digiwallet` from `v3.3.1` to `v3.3.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-digiwallet/releases/tag/v3.3.2
- Changed `wp-pay-gateways/ems-e-commerce` from `v4.3.1` to `v4.3.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ems-e-commerce/releases/tag/v4.3.2
- Changed `wp-pay-gateways/icepay` from `v4.3.2` to `v4.3.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-icepay/releases/tag/v4.3.3
- Changed `wp-pay-gateways/ideal` from `v4.1.1` to `v4.1.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal/releases/tag/v4.1.2
- Changed `wp-pay-gateways/ideal-advanced-v3` from `v4.3.3` to `v4.3.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal-advanced-v3/releases/tag/v4.3.4
- Changed `wp-pay-gateways/ideal-basic` from `v4.3.1` to `v4.3.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal-basic/releases/tag/v4.3.2
- Changed `wp-pay-gateways/mollie` from `v4.7.4` to `v4.7.6`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.7.6
- Changed `wp-pay-gateways/multisafepay` from `v4.3.1` to `v4.3.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-multisafepay/releases/tag/v4.3.2
- Changed `wp-pay-gateways/ogone` from `v4.4.1` to `v4.5.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ingenico/releases/tag/v4.5.0
- Changed `wp-pay-gateways/omnikassa-2` from `v4.4.2` to `v4.4.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-omnikassa-2/releases/tag/v4.4.3
- Changed `wp-pay-gateways/pay-nl` from `v4.5.1` to `v4.5.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-pay-nl/releases/tag/v4.5.2
- Changed `wp-pay-gateways/paypal` from `v2.3.1` to `v2.3.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-paypal/releases/tag/v2.3.2
- Changed `wp-pay/core` from `v4.7.3` to `v4.9.0`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.9.0
- Changed `wp-pay/fundraising` from `v3.2.0` to `v3.2.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-fundraising/releases/tag/v3.2.1
Full set of changes: [`9.3.6...9.4.0`][9.4.0]

[9.4.0]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.3.6...v9.4.0

## [9.3.6] - 2023-02-23

### Added

- Added payment method selection on manual subscription renewal. ([af9c0c9](https://github.com/pronamic/wp-pay-core/commit/af9c0c922b6abcbf5ff1c5bc9417a2ad9568db21))
- Added support for border control in fundraising blocks. ([950af6b](https://github.com/wp-pay/fundraising/commit/950af6b120ea111c7ef9c5f493cfec81e96dbf5b))
- Added support for multiple free text value options in Contact Form 7. ([84d9856](https://github.com/pronamic/wp-pronamic-pay-contact-form-7/commit/84d9856461da4f915fed5485bf60818162c120cf))

### Fixed

- Fixed duplicate execution of `$gateway->start( $payment )` in redirect routine of HTML form gateways. ([467aeb5](https://github.com/pronamic/wp-pay-core/commit/467aeb59e24846c0bbd01e88ff5e1191bcfde6b5))
- Changed payment amount to `0.00` for credit card and PayPal authorizations when updating mandate. ([3132ff6](https://github.com/pronamic/wp-pay-core/commit/3132ff61a0a8f78f98c8f499e584364d7bfc869a))

### Removed

- Removed default border from fundraising blocks. ([a6b7bdf](https://github.com/wp-pay/fundraising/commit/a6b7bdfd831dff4c771159eee071b131c3f6a9b1))

### Composer

- Changed `wp-pay-extensions/contact-form-7` from `v3.2.1` to `v3.2.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-contact-form-7/releases/tag/v3.2.2
- Changed `wp-pay/core` from `v4.7.2` to `v4.7.3`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.7.3
- Changed `wp-pay/fundraising` from `v3.1.1` to `v3.2.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-fundraising/releases/tag/v3.2.0
Full set of changes: [`9.3.5...9.3.6`][9.3.6]

[9.3.6]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.3.5...v9.3.6

## [9.3.5] - 2023-02-17

### Fixed

- Fixed field inputs options in recurring amount settings field of Gravity Forms.
- Fixed expiry date of MemberPress transaction with trial period.
- Fixed running Mollie integration installation.

### Composer

- Changed `wp-pay-extensions/gravityforms` from `v4.5.1` to `v4.5.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-gravityforms/releases/tag/v4.5.2
- Changed `wp-pay-extensions/memberpress` from `v4.7.4` to `v4.7.5`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-memberpress/releases/tag/v4.7.5
- Changed `wp-pay-gateways/mollie` from `v4.7.3` to `v4.7.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.7.4
Full set of changes: [`9.3.4...9.3.5`][9.3.5]

[9.3.5]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.3.4...v9.3.5

## [9.3.4] - 2023-02-15
### Composer

- Changed `wp-pay-extensions/memberpress` from `v4.7.3` to `v4.7.4`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-memberpress/releases/tag/v4.7.4
- Changed `wp-pay-gateways/adyen` from `v4.4.1` to `v4.4.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-adyen/releases/tag/v4.4.3
Full set of changes: [`9.3.3...9.3.4`][9.3.4]

[9.3.4]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.3.3...v9.3.4

## [9.3.3] - 2023-02-07
### Composer

- Changed `wp-pay-extensions/memberpress` from `v4.7.2` to `v4.7.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-memberpress/releases/tag/v4.7.3
- Changed `wp-pay-extensions/restrict-content-pro` from `v4.3.1` to `v4.3.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/releases/tag/v4.3.2
- Changed `wp-pay-extensions/woocommerce` from `v4.5.1` to `v4.5.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-woocommerce/releases/tag/v4.5.2
- Changed `wp-pay-gateways/icepay` from `v4.3.1` to `v4.3.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-icepay/releases/tag/v4.3.2
- Changed `wp-pay-gateways/ideal-advanced-v3` from `v4.3.2` to `v4.3.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal-advanced-v3/releases/tag/v4.3.3
- Changed `wp-pay-gateways/mollie` from `v4.7.2` to `v4.7.3`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.7.3
- Changed `wp-pay/core` from `v4.7.1` to `v4.7.2`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.7.2
Full set of changes: [`9.3.2...9.3.3`][9.3.3]

[9.3.3]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.3.2...v9.3.3

## [9.3.2] - 2023-01-31

### Commits

- Lower PHP requirement to PHP 7.4. ([785a9c3](https://github.com/pronamic/wp-pronamic-pay/commit/785a9c385f843e218128c4f924fa0cac1c5d25d6))

### Composer

- Changed `php` from `>=8.0` to `>=7.4`.
- Changed `wp-pay-extensions/charitable` from `v4.3.0` to `v4.3.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-charitable/releases/tag/v4.3.1
- Changed `wp-pay-gateways/adyen` from `v4.4.0` to `v4.4.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-adyen/releases/tag/v4.4.1

Full set of changes: [`9.3.1...9.3.2`][9.3.2]

[9.3.2]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.3.1...v9.3.2

## [9.3.1] - 2023-01-31
### Commits

- Updated translation files. ([bd70f73](https://github.com/pronamic/wp-pronamic-pay/commit/bd70f73d6f648fbc9da55a1a4a2040cbba8e8cf2))

### Composer

- Changed `pronamic/wp-datetime` from `v2.1.1` to `v2.1.2`.
	Release notes: https://github.com/pronamic/wp-datetime/releases/tag/v2.1.2
- Changed `pronamic/wp-html` from `v2.1.0` to `v2.1.1`.
	Release notes: https://github.com/pronamic/wp-html/releases/tag/v2.1.1
- Changed `pronamic/wp-money` from `v2.2.0` to `v2.2.1`.
	Release notes: https://github.com/pronamic/wp-money/releases/tag/v2.2.1
- Changed `pronamic/wp-number` from `v1.2.0` to `v1.2.1`.
	Release notes: https://github.com/pronamic/wp-number/releases/tag/v1.2.1
- Changed `wp-pay-extensions/contact-form-7` from `v3.2.0` to `v3.2.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-contact-form-7/releases/tag/v3.2.1
- Changed `wp-pay-extensions/easy-digital-downloads` from `v4.3.0` to `v4.3.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-easy-digital-downloads/releases/tag/v4.3.1
- Changed `wp-pay-extensions/event-espresso` from `v4.2.0` to `v4.2.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-event-espresso/releases/tag/v4.2.1
- Changed `wp-pay-extensions/formidable-forms` from `v4.3.1` to `v4.3.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-formidable-forms/releases/tag/v4.3.2
- Changed `wp-pay-extensions/give` from `v4.2.0` to `v4.2.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-give/releases/tag/v4.2.1
- Changed `wp-pay-extensions/gravityforms` from `v4.5.0` to `v4.5.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-gravityforms/releases/tag/v4.5.1
- Changed `wp-pay-extensions/memberpress` from `v4.7.1` to `v4.7.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-memberpress/releases/tag/v4.7.2
- Changed `wp-pay-extensions/ninjaforms` from `v3.2.0` to `v3.2.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ninjaforms/releases/tag/v3.2.1
- Changed `wp-pay-extensions/restrict-content-pro` from `v4.3.0` to `v4.3.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/releases/tag/v4.3.1
- Changed `wp-pay-extensions/woocommerce` from `v4.5.0` to `v4.5.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-woocommerce/releases/tag/v4.5.1
- Changed `wp-pay-gateways/buckaroo` from `v4.3.0` to `v4.3.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-buckaroo/releases/tag/v4.3.1
- Changed `wp-pay-gateways/digiwallet` from `v3.3.0` to `v3.3.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-digiwallet/releases/tag/v3.3.1
- Changed `wp-pay-gateways/ems-e-commerce` from `v4.3.0` to `v4.3.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ems-e-commerce/releases/tag/v4.3.1
- Changed `wp-pay-gateways/icepay` from `v4.3.0` to `v4.3.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-icepay/releases/tag/v4.3.1
- Changed `wp-pay-gateways/ideal` from `v4.1.0` to `v4.1.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal/releases/tag/v4.1.1
- Changed `wp-pay-gateways/ideal-advanced-v3` from `v4.3.1` to `v4.3.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal-advanced-v3/releases/tag/v4.3.2
- Changed `wp-pay-gateways/ideal-basic` from `v4.3.0` to `v4.3.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal-basic/releases/tag/v4.3.1
- Changed `wp-pay-gateways/mollie` from `v4.7.1` to `v4.7.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.7.2
- Changed `wp-pay-gateways/multisafepay` from `v4.3.0` to `v4.3.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-multisafepay/releases/tag/v4.3.1
- Changed `wp-pay-gateways/ogone` from `v4.4.0` to `v4.4.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ingenico/releases/tag/v4.4.1
- Changed `wp-pay-gateways/omnikassa-2` from `v4.4.1` to `v4.4.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-omnikassa-2/releases/tag/v4.4.2
- Changed `wp-pay-gateways/pay-nl` from `v4.5.0` to `v4.5.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-pay-nl/releases/tag/v4.5.1
- Changed `wp-pay-gateways/paypal` from `v2.3.0` to `v2.3.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-paypal/releases/tag/v2.3.1
- Changed `wp-pay/core` from `v4.7.0` to `v4.7.1`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.7.1
- Changed `wp-pay/fundraising` from `v3.1.0` to `v3.1.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-fundraising/releases/tag/v3.1.1

Full set of changes: [`9.3.0...9.3.1`][9.3.1]

[9.3.1]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.3.0...v9.3.1

## [9.3.0] - 2023-01-18
### Added

- Added support for Gravity Forms subscription trial period.
- Added support for WooCommerce → Mollie → Klarna Pay Later via Mollie Orders API.

### Changed

- Built-in payment forms now show a payment method selection list.
- iDEAL Advanced integration error/exception handling is improved.
- Mollie Orders API integration is improved.
- Ingenico iDEAL payment method is extended with a built-in banks selection list.

### Fixed

- Fixed "Undefined array key" notices in Formidable Forms integration.

### Composer

- Changed `composer/installers` from `v1.12.0` to `v2.2.0`.
	Release notes: https://github.com/composer/installers/releases/tag/v2.2.0
- Changed `woocommerce/action-scheduler` from `3.5.3` to `3.5.4`.
	Release notes: https://github.com/woocommerce/action-scheduler/releases/tag/3.5.4
- Changed `wp-pay-extensions/formidable-forms` from `v4.3.0` to `v4.3.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-formidable-forms/releases/tag/v4.3.1
- Changed `wp-pay-extensions/gravityforms` from `v4.4.1` to `v4.5.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-gravityforms/releases/tag/v4.5.0
- Changed `wp-pay-extensions/memberpress` from `v4.7.0` to `v4.7.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-memberpress/releases/tag/v4.7.1
- Changed `wp-pay-extensions/woocommerce` from `v4.4.0` to `v4.5.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-woocommerce/releases/tag/v4.5.0
- Changed `wp-pay-gateways/ideal-advanced-v3` from `v4.3.0` to `v4.3.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal-advanced-v3/releases/tag/v4.3.1
- Changed `wp-pay-gateways/mollie` from `v4.7.0` to `v4.7.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.7.1
- Changed `wp-pay-gateways/ogone` from `v4.3.0` to `v4.4.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ingenico/releases/tag/v4.4.0
- Changed `wp-pay-gateways/omnikassa-2` from `v4.4.0` to `v4.4.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-omnikassa-2/releases/tag/v4.4.1
- Changed `wp-pay/core` from `v4.6.0` to `v4.7.0`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.7.0

Full set of changes: [`9.2.0...9.3.0`][9.3.0]

[9.3.0]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.2.0...v9.3.0

## [9.2.1] - 2023-01-04

### Fixed

- Gravity Forms - Fixed problem with saving status page settings in payment feed. ([#14](https://github.com/pronamic/wp-pronamic-pay-gravityforms/issues/14))

### Composer

- Changed `composer/installers` from `v1.12.0` to `v2.2.0`.
	Release notes: https://github.com/composer/installers/releases/tag/v2.2.0
- Changed `wp-pay-extensions/gravityforms` from `v4.4.1` to `v4.4.2`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-gravityforms/releases/tag/v4.4.2

Full set of changes: [`9.2.0...9.2.1`][9.2.1]

[9.2.1]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.2.0...v9.2.1

## [9.2.0] - 2023-01-02

### Changed

- Requires PHP 8.0. ([b511154](https://github.com/pronamic/wp-pronamic-pay/commit/b511154f25386a11c82f254d4d62b31ee1b26dc0))
- Removed usage of deprecated constant `FILTER_SANITIZE_STRING`. ([883175b](https://github.com/pronamic/wp-pronamic-pay/commit/883175b99f0ffa1418ec192994e44a0ef094d92b))

### Composer

- Changed `php` from `>=7.4` to `>=8.0`.
- Changed `pronamic/wp-datetime` from `2.0.3` to `v2.1.1`.
	Release notes: https://github.com/pronamic/wp-datetime/releases/tag/v2.1.1
- Changed `pronamic/wp-html` from `2.0.2` to `v2.1.0`.
	Release notes: https://github.com/pronamic/wp-html/releases/tag/v2.1.0
- Changed `pronamic/wp-money` from `2.0.3` to `v2.2.0`.
	Release notes: https://github.com/pronamic/wp-money/releases/tag/v2.2.0
- Changed `pronamic/wp-number` from `1.1.1` to `v1.2.0`.
	Release notes: https://github.com/pronamic/wp-number/releases/tag/v1.2.0
- Changed `wp-pay-extensions/charitable` from `4.2.1` to `v4.3.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-charitable/releases/tag/v4.3.0
- Changed `wp-pay-extensions/contact-form-7` from `3.1.2` to `v3.2.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-contact-form-7/releases/tag/v3.2.0
- Changed `wp-pay-extensions/easy-digital-downloads` from `4.2.2` to `v4.3.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-easy-digital-downloads/releases/tag/v4.3.0
- Changed `wp-pay-extensions/event-espresso` from `4.1.2` to `v4.2.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-event-espresso/releases/tag/v4.2.0
- Changed `wp-pay-extensions/formidable-forms` from `4.2.1` to `v4.3.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-formidable-forms/releases/tag/v4.3.0
- Changed `wp-pay-extensions/give` from `4.1.1` to `v4.2.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-give/releases/tag/v4.2.0
- Changed `wp-pay-extensions/gravityforms` from `4.3.0` to `v4.4.1`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-gravityforms/releases/tag/v4.4.1
- Changed `wp-pay-extensions/memberpress` from `4.6.0` to `v4.7.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-memberpress/releases/tag/v4.7.0
- Changed `wp-pay-extensions/ninjaforms` from `3.1.1` to `v3.2.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ninjaforms/releases/tag/v3.2.0
- Changed `wp-pay-extensions/restrict-content-pro` from `4.2.1` to `v4.3.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-restrict-content-pro/releases/tag/v4.3.0
- Changed `wp-pay-extensions/woocommerce` from `4.3.3` to `v4.4.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-woocommerce/releases/tag/v4.4.0
- Changed `wp-pay-gateways/adyen` from `4.3.1` to `v4.4.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-adyen/releases/tag/v4.4.0
- Changed `wp-pay-gateways/buckaroo` from `4.2.2` to `v4.3.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-buckaroo/releases/tag/v4.3.0
- Changed `wp-pay-gateways/digiwallet` from `3.2.1` to `v3.3.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-digiwallet/releases/tag/v3.3.0
- Changed `wp-pay-gateways/ems-e-commerce` from `4.2.0` to `v4.3.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ems-e-commerce/releases/tag/v4.3.0
- Changed `wp-pay-gateways/icepay` from `4.2.0` to `v4.3.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-icepay/releases/tag/v4.3.0
- Changed `wp-pay-gateways/ideal` from `4.0.1` to `v4.1.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal/releases/tag/v4.1.0
- Changed `wp-pay-gateways/ideal-advanced-v3` from `4.2.0` to `v4.3.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal-advanced-v3/releases/tag/v4.3.0
- Changed `wp-pay-gateways/ideal-basic` from `4.2.0` to `v4.3.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ideal-basic/releases/tag/v4.3.0
- Changed `wp-pay-gateways/mollie` from `4.6.0` to `v4.7.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/v4.7.0
- Changed `wp-pay-gateways/multisafepay` from `4.2.0` to `v4.3.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-multisafepay/releases/tag/v4.3.0
- Changed `wp-pay-gateways/ogone` from `4.2.0` to `v4.3.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-ingenico/releases/tag/v4.3.0
- Changed `wp-pay-gateways/omnikassa-2` from `4.3.0` to `v4.4.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-omnikassa-2/releases/tag/v4.4.0
- Changed `wp-pay-gateways/pay-nl` from `4.4.0` to `v4.5.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-pay-nl/releases/tag/v4.5.0
- Changed `wp-pay-gateways/paypal` from `2.2.2` to `v2.3.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-paypal/releases/tag/v2.3.0
- Changed `wp-pay/core` from `4.5.0` to `v4.6.0`.
	Release notes: https://github.com/pronamic/wp-pay-core/releases/tag/v4.6.0
- Changed `wp-pay/fundraising` from `3.0.3` to `v3.1.0`.
	Release notes: https://github.com/pronamic/wp-pronamic-pay-fundraising/releases/tag/v3.1.0
Full set of changes: [`9.1.3...9.2.0`][9.2.0]

[9.2.0]: https://github.com/pronamic/wp-pronamic-pay/compare/v9.1.3...v9.2.0

## [9.1.3] - 2022-12-01

### Fixed
- Updated WordPress pay Easy Digital Downloads library to version 4.2.2.
  - Fix required field indicator HTML escaped. [#5](https://github.com/pronamic/wp-pronamic-pay-easy-digital-downloads/issues/5)
- Updated WordPress pay WooCommerce library to version 4.3.3.
  - Fix creating zero amount refunds. [#31](https://github.com/pronamic/wp-pronamic-pay-woocommerce/issues/31)
- Updated WordPress pay Adyen library to version 4.3.1.
  - Redirect API-only payment methods to payment action URL. [#18](https://github.com/pronamic/wp-pronamic-pay-adyen/issues/18)
  - Make `redirectResult` no longer required in return endpoint. [#19](https://github.com/pronamic/wp-pronamic-pay-adyen/issues/19)

### Changed
- Updated WordPress pay Mollie library to version 4.6.0.
  - Use new `pronamic/wp-mollie` library.
  - Use new `str_*_with` functions, requires WordPress `5.9` or higher.
- Updated WordPress pay Pay. library to version 4.4.0.
  - Updated to REST API version 13: https://rest-api.pay.nl/v13/.
  - Added `statsData` to transaction requests. [#18](https://github.com/pronamic/pronamic-pay/issues/18)

## [9.1.2] - 2022-11-09

### Fixed
- Updated WordPress pay WooCommerce library to version 4.3.2.
  - Fixed "Fatal error: Uncaught Error: Call to undefined function wcs_get_subscriptions_for_order()". ([#29](https://github.com/pronamic/wp-pronamic-pay-woocommerce/issues/29))

## [9.1.1] - 2022-11-07

### Fixed
- Updated WordPress pay WooCommerce library to version `4.3.1`.
  - Fixed "Fatal error: Uncaught Error: Call to undefined function wcs_get_subscription()". Props @jeffreyvr. [#28](https://github.com/pronamic/wp-pronamic-pay-woocommerce/pull/28)

## [9.1.0] - 2022-11-07

### Changed
- Updated WordPress pay core library to version `4.5.0`.
  - Catch exceptions while retrieving options from for example iDEAL issuer select fields. ([#78](https://github.com/pronamic/wp-pay-core/issues/78))
  - Allow subscription payments at gateways that don't have support for recurring payments. ([pronamic/wp-pronamic-pay-woocommerce#15](https://github.com/pronamic/wp-pronamic-pay-woocommerce/issues/15))
  - Added MobilePay payment method. ([pronamic/wp-pronamic-pay-adyen#16](https://github.com/pronamic/wp-pronamic-pay-adyen/issues/16))
- Updated WordPress pay Event Espresso library to version `4.1.2`.
  - Fixed "Expected type 'null|array'. Found 'string'.".
- Updated WordPress pay Gravity Forms library to version `4.3.0`.
  - No support for manual renewals with Gravity Forms.
- Updated WordPress pay MemberPress library to version `4.6.0`.
  - Prevent recurring payment at gateways without recurring support. [#7](https://github.com/pronamic/wp-pronamic-pay-memberpress/pull/7)
- Updated WordPress pay WooCommerce library to version `4.3.0`.
  - Fixed subscription status not updated if admin reactivates a WooCommerce subscription. [#25](https://github.com/pronamic/wp-pronamic-pay-woocommerce/issues/25)
  - Fixed fatal error while cancelling subscription. Props @knit-pay. [#14](https://github.com/pronamic/wp-pronamic-pay-woocommerce/issues/14)
  - Fixed payment method field errors not displayed in WooCommerce checkout block. [#22](https://github.com/pronamic/wp-pronamic-pay-woocommerce/issues/22)
  - Added MobilePay payment method. [pronamic/wp-pronamic-pay-adyen#16](https://github.com/pronamic/wp-pronamic-pay-adyen/issues/16)
- Updated WordPress pay Adyen library to version `4.3.0`.
  - Added MobilePay payment method. [#16](https://github.com/pronamic/wp-pronamic-pay-adyen/issues/16)
- Updated WordPress pay Mollie library to version `4.5.0`.
  - Added user agent to HTTP requests to Mollie. [#13](https://github.com/pronamic/wp-pronamic-pay-mollie/issues/13)
- Updated WordPress pay Rabo Smart Pay (formerly OmniKassa) library to version `4.3.0`.
  - Changed name from "OmniKassa" to "Rabo Smart Pay". [#13](https://github.com/pronamic/wp-pronamic-pay-omnikassa-2/issues/13)
  - Enrich payments methods from new `order/server/api/payment-brands` endpoint. [#15](https://github.com/pronamic/wp-pronamic-pay-omnikassa-2/issues/15)
  - Added support for SOFORT payment method. [#16](https://github.com/pronamic/wp-pronamic-pay-omnikassa-2/issues/16)
- Updated WordPress pay Pay. library to version `4.3.0`.
  - Updated dashboard URL to https://my.pay.nl/. [#3](https://github.com/pronamic/wp-pronamic-pay-pay-nl/pull/3)
  - Added payment provider URL filter. [#3](https://github.com/pronamic/wp-pronamic-pay-pay-nl/pull/3)
  - Update integration name from "Pay.nl" to "Pay.". [#2](https://github.com/pronamic/wp-pronamic-pay-pay-nl/issues/2)

## [9.0.1] - 2022-10-11

### Fixed
- Updated WordPress pay core library to version 4.4.1.
  - Added support for multi-dimensional array in `Util::html_hidden_fields()` method ([#73](https://github.com/pronamic/wp-pay-core/issues/73)).
  - Fixed setting empty consumer bank details object ([pronamic/wp-pronamic-pay-mollie#11](https://github.com/pronamic/wp-pronamic-pay-mollie/issues/11)).
  - Removed unused gateway subscription methods.
- Updated WordPress pay Adyen library to version 4.2.3.
  - Updated Adyen Drop-in to version `5.27.0` ([#14](https://github.com/pronamic/wp-pronamic-pay-adyen/issues/14)).
  - Fixed error triggered by Adyen drop-in with Swish payment method on mobile.
- Updated WordPress pay Buckaroo library to version 4.2.2.
  - Fixed possible "Warning: Invalid argument supplied for foreach()" when enriching payment methods ([#7](https://github.com/pronamic/wp-pronamic-pay-buckaroo/issues/7)).
- Updated WordPress pay Mollie library to version 4.4.1.
  - Fixed recurring payments using latest mandate of Mollie customer instead of subscription mandate ([#11](https://github.com/pronamic/wp-pronamic-pay-mollie/issues/11)).
- Updated WordPress pay Gravity Forms library to version 4.2.2.
  - Fixed catching exceptions in issuer field ([#10](https://github.com/pronamic/wp-pronamic-pay-gravityforms/issues/10)).

## [9.0.0] - 2022-09-27

### Changed
- Updated WordPress pay core library to version 4.4.0.
  - Fixed list table styling on mobile ([#72](https://github.com/pronamic/wp-pay-core/issues/72)).
  - Refactored payments methods and fields support.
  - Removed phone number field from test meta box.
  - Removed Sisow reservation payments support.
- Updated WordPress pay Buckaroo library to version 4.2.1.
  - Updated payment methods registration.
  - Updated for Sisow via Buckaroo integration ([pronamic/wp-pronamic-pay-sisow#3](https://github.com/pronamic/wp-pronamic-pay-sisow/issues/3)).
- Updated WordPress pay Mollie library to version 4.4.0.
  - Fixed empty billing email address causing `Unprocessable Entity - The email address '' is invalid` error.
  - Updated payment methods registration.
- Updated WordPress pay Easy Digital Downloads library to version 4.2.1.
  - Fixed Easy Digital Downloads 3 compatibility.
  - Updated for new payment methods and fields registration.
- Updated WordPress pay Gravity Forms library to version 4.2.1.
  - Fixed conditional logic object without any logic.
  - Updated for new payment methods and fields registration.
- Updated WordPress pay WooCommerce library to version 4.2.0.
  - Added upgrade script to add missing Pronamic subscription ID to WooCommerce subscription meta ([#11](https://github.com/pronamic/wp-pronamic-pay-woocommerce/issues/11)).
  - Updated for new payment methods and fields registration.
  - Improved WooCommerce Blocks support.
- Updated WordPress DateTime library to version 2.0.3.
- Updated WordPress HTML library to version 2.0.2.
- Updated WordPress HTTP library to version 1.1.3.
- Updated WordPress Money library to version 2.0.3.
- Updated WordPress Number library to version 1.1.1.
- Updated WordPress pay Fundraising library to version 3.0.2.
- Updated WordPress pay Adyen library to version 4.2.1.
- Updated WordPress pay DigiWallet library to version 3.2.1.
- Updated WordPress pay EMS e-Commerce; library to version 4.2.0.
- Updated WordPress pay ICEPAY library to version 4.2.0.
- Updated WordPress pay iDEAL library to version 4.0.1.
- Updated WordPress pay iDEAL Advanced v3 library to version 4.2.0.
- Updated WordPress pay iDEAL Basic library to version 4.2.0.
- Updated WordPress pay MultiSafepay library to version 4.2.0.
- Updated WordPress pay Ingenico library to version 4.2.0.
- Updated WordPress pay OmniKassa 2.0 library to version 4.2.0.
- Updated WordPress pay Pay.nl library to version 4.2.0.
- Updated WordPress pay PayPal library to version 2.2.1.
- Updated WordPress pay Charitable library to version 4.2.1.
- Updated WordPress pay Contact Form 7 library to version 3.1.1.
- Updated WordPress pay Event Espresso library to version 4.1.1.
- Updated WordPress pay Formidable Forms library to version 4.2.1.
- Updated WordPress pay Give library to version 4.1.1.
- Updated WordPress pay MemberPress library to version 4.5.1.
- Updated WordPress pay Ninja Forms library to version 3.1.1.
- Updated WordPress pay Restrict Content Pro library to version 4.2.1.

## [8.5.1] - 2022-08-15

### Changed
- Updated WordPress pay Mollie library to version 4.3.1.
  - Updated payment provider URL from `www.mollie.com` to `my.mollie.com` ([#8](https://github.com/pronamic/wp-pronamic-pay-mollie/issues/8)).
- Updated WordPress pay MultiSafepay library to version 4.1.2.
  - Fixed parsing gateways response message ([#3](https://github.com/pronamic/wp-pronamic-pay-multisafepay/issues/3)).
- Updated WordPress pay Formidable Forms library to version 4.1.1.
  - Fixed not showing error messages if form success action is not 'message'.
- Updated WordPress pay Gravity Forms library to version 4.1.1.
  - Fixed compatibility issue with plugins producing output in `gform_admin_pre_render` filter.
  - Fixed duplicate configurations in payment gateway configuration field setting ([#8](https://github.com/pronamic/wp-pronamic-pay-gravityforms/issues/8)).
- Updated WordPress pay ICEPAY library to version 4.1.1.

## [8.5.0] - 2022-07-04

### Changed
- Updated WordPress core library to version 4.3.1.
  - Added billing and shipping address details to test payments.
  - Added tax details to test payments.
  - Added `Authorized` payment status. ([pronamic/wp-pay-core#66](https://github.com/pronamic/wp-pay-core/issues/66))
  - Updated logos library to version `1.8.3`.
- Updated WordPress Adyen library to version 4.1.0.
  - Added WordPress network ID and blog ID to merchant reference ([#1](https://github.com/pronamic/wp-pronamic-pay-adyen/issues/1)).
- Updated WordPress MemberPress library to version 4.4.0.
  - Added support for Klarna Pay Now, Klarna Pay Later and Klarna Pay Over Time ([pronamic/wp-pronamic-pay#190](https://github.com/pronamic/wp-pronamic-pay/issues/190)).
- Updated WordPress Mollie library to version 4.3.0.
  - Added support for Mollie orders API. [pronamic/wp-pronamic-pay#190](https://github.com/pronamic/wp-pronamic-pay/issues/190)
  - Improved JSON serialization for communication towards Mollie API.

## [8.4.1] - 2022-06-03

### Fixed
- Updated WordPress Contact Form 7 library to version [`3.0.3`](https://github.com/pronamic/wp-pronamic-pay-contact-form-7/releases/tag/3.0.3).

## [8.4.0] - 2022-05-30

### Changed
- Updated WordPress core library to version [`4.2.0`](https://github.com/pronamic/wp-pay-core/releases/tag/4.2.0).
- Updated WordPress Adyen library to version [`4.0.0`](https://github.com/pronamic/wp-pronamic-pay-adyen/releases/tag/4.0.0).
- Updated WordPress Mollie library to version [`4.2.0`](https://github.com/pronamic/wp-pronamic-pay-mollie/releases/tag/4.2.0).
- Updated WordPress MultiSafepay library to version [`4.1.1`](https://github.com/pronamic/wp-pronamic-pay-multisafepay/releases/tag/4.1.1).
- Updated WordPress Contact Form 7 library to version [`3.0.2`](https://github.com/pronamic/wp-pronamic-pay-contact-form-7/releases/tag/3.0.2).
- Updated WordPress MemberPress library to version [`4.3.0`](https://github.com/pronamic/wp-pronamic-pay-memberpress/releases/tag/4.3.0).

## [8.3.0] - 2022-05-04

### Changed
- Updated WordPress core library to version 4.1.3.
- Updated WordPress MemberPress library to version 4.2.0.
  - Update subscription phases on MemberPress subscription updates.
  - Added subscription status and next payment date to MemberPress subscription form.
  - Added payment status to MemberPress transaction form.

## [8.2.2] - 2022-04-19

### Fixed
- Updated WordPress core library to version 4.1.2.
  - Fixed plugin updater.
- Updated WordPress WooCommerce library to version 4.1.1.

## [8.2.1] - 2022-04-13

### Fixed
- Updated WordPress core library to version 4.1.1.
- Updated WordPress Charitable library to version 4.1.0.
- Updated WordPress Adyen library to version 3.1.1.
- Updated WordPress OmniKassa 2.0 library to version 4.1.1.
- Updated WordPress Sisow library to version 4.1.1.

## [8.2.0] - 2022-04-12

### Changed
- Updated WordPress core library to version 4.1.0.
  - Added a user interface to change a subscription's next payment date.
  - Added a count badge in the WordPress admin menu for the number of subscriptions on hold.
  - The next payment date is now stored in the subscription and no longer in the subscription phases.
  - The general / global gateway integration mode setting for test or live mode is removed.
  - Sorting payments by customer or transaction number in the WordPress admin dashboard has been removed.
- Updated WordPress WooCommerce library to version 4.1.0.
  - Transform expired WooCommerce subscription status to Pronamic status Completed.
  - Add failure reason notice on 'Pay for order' page (pronamic/wp-pronamic-pay-adyen#2).
  - Added support for WooCommerce Blocks.
  - Fix resetting trial phase next payment date on payment status update.
  - Ignore seconds in calculation of subscription trial phase interval.
- Updated WordPress Restrict Content Pro library to version 4.1.0.
  - Transform expired Restrict Content Pro membership to Pronamic status Completed.
  - Fix missing gateway registration key.
  - Simplify gateway registration and supported features.
- Updated WordPress MemberPress library to version 4.1.0.
  - Call limit reached actions on subscription completion.
- Updated WordPress Gravity Forms library to version 4.1.0.
  - Improve payment and subscription source text when Gravity Forms plugin is not active.
  - Fix possible invalid empty conditional logic object.
  - Add support for gf_list_* CSS classes in payment methods field.
- Updated WordPress Formidable Forms library to version 4.1.0.
  - Add payment action setting for gateway configuration.
- Updated WordPress Easy Digital Downloads library to version 4.1.0.
  - Add company name controller.
- Updated WordPress Charitable library to version 4.1.0.
- Updated WordPress Sisow library to version 4.1.0.
- Updated WordPress Payvision library to version 3.1.0.
- Updated WordPress PayPal library to version 2.1.0.
- Updated WordPress Pay.nl library to version 4.1.0.
- Updated WordPress OmniKassa 2.0 library to version 4.1.0.
  - Added support for iDEAL issuers.
- Updated WordPress Ingenico library to version 4.1.0.
- Updated WordPress MultiSafepay library to version 4.1.0.
- Updated WordPress Mollie library to version 4.1.0.
- Updated WordPress iDEAL Basic library to version 4.1.0.
- Updated WordPress iDEAL Advanced v3 library to version 4.1.0.
- Updated WordPress ICEPAY library to version 4.1.0.
- Updated WordPress EMS e-Commerce library to version 4.1.0.
- Updated WordPress DigiWallet library to version 3.1.0.
- Updated WordPress Buckaroo library to version 4.1.0.
- Updated WordPress Adyen library to version 3.1.0.

## [8.1.0] - 2022-02-16

### Added
- Added support for new ING iDEAL Advanced platform.

### Changed
- Updated WordPress core library to version 4.0.2.
  - Changed minimum PHP version requirement to `7.4` (https://github.com/pronamic/wp-pronamic-pay/issues/274).
  - Changed follow-up payments query to subscriptions which needed renewal in past 24 hours only.
  - Added next payment date column in subscriptions admin (https://github.com/pronamic/wp-pronamic-pay/issues/288).
  - Fixed empty payment description admin column.
  - Fixed error on subscription mandate selection page with invalid Mollie customer.
  - Fixed possible infinite loop on updating active payment methods (https://github.com/pronamic/wp-pay-core/issues/54).
  - Fixed setting Mollie sequence type when manually re-trying payment for a period.
  - Updated scheduling follow-up payments pages.
  - Updated site health tests and debug information.
  - Updated pronamic/wp-pay-logos library to version `1.7.1`.
  - Removed time from next payment dates in admin.
- Updated WordPress Adyen library to version 3.0.1.
  - Added support for Klarna Pay Now and Klarna Pay Over Time.
  - Added support for Afterpay and the Adyen `afterpaytouch` payment method indicator.
  - Updated drop-in error handling (https://github.com/pronamic/wp-pronamic-pay-adyen/issues/2).
- Updated WordPress MultiSafepay library to version 4.0.1.
  - Fixed possible error "Call to a member function get_total() on null".
- Updated WordPress Gravity Forms library to version 4.0.1.
  - Fixed processing delayed feeds during fulfilment of free payments (e.g. user registration for entry with discount; https://github.com/pronamic/wp-pronamic-pay/issues/279).
- Updated WordPress MemberPress library to version 4.0.1.
  - Fixed MemberPress gateway capabilities based on gateway support.
  - Fixed confirming subscription confirmation transaction only for recurring payments.
- Updated WordPress Ninja Forms library to version 3.0.1.
  - Fixed delaying all actions (https://github.com/pronamic/wp-pronamic-pay-ninjaforms/issues/4).
- Updated WordPress WooCommerce library to version 4.0.1.
  - Added Klarna Pay Now and Klarna Pay Over Time gateways.
  - Added support for multiple subscriptions.
  - Fixed adding periods to payments.
  - Fixed handling subscription payment method changes.
  - Fixed setting input fields only if gateway is enabled.
  - Updated AfterPay.nl and Afterpay.com method descriptions to clarify differences in target countries.
  - Updated subscription source texts.
- Updated WordPress Mollie library to version 4.0.1.

## [8.0.0] - 2022-01-13

### Removed
- Removed support for Event Espresso 3 → https://www.pronamic.eu/pronamic-pay-support-for-event-espresso-3-removed/.
- Removed support for s2Member → https://www.pronamic.eu/pronamic-pay-support-for-s2member-removed/.
- Removed support for WP eCommerce → https://www.pronamic.eu/pronamic-pay-support-for-wp-ecommerce-removed/.

### Changed
- Updated WordPress core library to version `4.0.0`.
- Refactored subscription follow-up payments processes.
- Increased WordPress requirement to version `5.2` or higher.
- Updated all extension libraries → https://github.com/wp-pay-extensions.
- Updated all gateway libraries → https://github.com/wp-pay-gateways.

### Added
- Added https://actionscheduler.org/ library for subscription processes.
- Added payment method icon to amount column and info meta boxes.
- Added BLIK payment method.
- Added MB WAY payment method.
- Added TWINT payment method.
- Added new ABN ARMO signing certificate for iDEAL (valid until 29-09-2026).
- Added new ING signing certificate for iDEAL (valid until 29-09-2026).
- Added new Rabobank signing certificate for iDEAL (valid until 29-09-2026).

## [7.0.2] - 2021-09-30

### Changed
- Updated WordPress core library to version `3.2.0`.
  - Start using `<input type="number">` in payment forms en test meta box.
  - Removed deprecated `Util::string_to_amount( $value )` function.
  - Updated logo library to version `1.6.8` for new Bancontact logo.
  - Improved security by using correct escaping functions.
- Updated WordPress pay Fundraising library to version `2.0.3`.
  - Load assets from relative links.
  - Added Update URI in plugin file.
  - Included and use `block.json`.
  - Improved security by using correct escaping functions.

## [7.0.1] - 2021-09-16

### Changed
- Updated WordPress pay Adyen library to version 2.0.4.
  - Added support for the PayPal payment method (pronamic/wp-pronamic-pay#180).
  - Added country code to Apple Pay payment method configuration.
- Updated WordPress pay Fundraising library to version 2.0.2.
  - Fixed blocks not loading in editor (pronamic/wp-pronamic-pay#204).
- Updated WordPress pay Gravity Forms library to version 3.0.2.
  - Updated issuers field to only use active payment feeds.
  - Fixed duplicate `pronamic_payment_id` entry meta (pronamic/wp-pronamic-pay#208).
  - Fixed empty merge tags in 'Form is submitted' notification event.
- Updated WordPress core library to version 3.1.1.
- Updated WordPress pay Charitable library to version 3.0.1.

## [7.0.0] - 2021-09-03

### Changed
- Updated WordPress core library to version 3.1.0.
  - No longer create recurring payments for subscriptions with the status `Failed` (see https://github.com/pronamic/wp-pronamic-pay/issues/188#issuecomment-907155800).
  - No longer set payments with an empty amount to success (gateways and extensions should handle this).
  - Subscription renewal page uses last failed period for manual renewal, if failed period has not yet passed.
  - Fixed block titles (pronamic/wp-pronamic-pay#185).
  - Fixed layout issue with input HTML on subscription renewal page.
  - Fixed script error in payment form block.
- Updated WordPress pay Mollie library to version 3.1.0.
  - Added `pronamic_pay_mollie_payment_description` filter (with example).
  - Removed check for empty amount, `0` amount is allowed for credit card authorizations.
- Updated WordPress pay Gravity Forms library to version 3.0.1.
  - Updated processing of free payments (allows credit card authorizations for subscriptions).
- Updated WordPress pay MemberPress library to version 3.1.0.
  - Completely revised integration.
  - Improved support for free (amount = 0) transactions.
  - Improved support for subscription upgrades and downgrades.
  - Account page 'Update' allows users to manually pay for last period if payment failed.
  - Added Pronamic payment column to the MemberPress transactions table in WordPress admin dashboard.
  - Temporarily removed support for suspend and resume subscriptions due to unintended behavior.
- Updated WordPress pay WooCommerce library to version 3.0.2.
  - Set pending order status when awaiting payment.
  - Fixed using non-existing `shipping_phone` order property.
- Updated Pronamic WordPress DateTime library to version 1.2.2.
- Updated WordPress pay Adyen library to version 2.0.3.
- Updated WordPress pay Fundraising library to version 2.0.1.
- Updated WordPress pay PayPal library to version 1.0.2.

## [6.9.6] - 2021-08-24

### Changed
- Updated WordPress pay Pay.nl library to version `3.0.1`
  - Fixed "Fatal error: Uncaught Error: Call to undefined method Pronamic\WordPress\Money\Money::get_including_tax()".

## [6.9.5] - 2021-08-19

### Changed
- Updated WordPress pay Adyen library to version `2.0.2`: https://github.com/wp-pay-gateways/adyen/releases/tag/2.0.2.
  - Adyen drop-in gateway supports Klarna Pay Later payment method.
- Updated WordPress pay MemberPress library to version `3.0.3`: https://github.com/wp-pay-extensions/memberpress/releases/tag/3.0.3.
  - Added Giropay gateway.

## [6.9.4] - 2021-08-18

### Changed
- Updated WordPress pay EMS e-Commerce library to version `3.0.1`: https://github.com/wp-pay-gateways/ems-e-commerce/releases/tag/3.0.1.
  - Fixed `chargetotal` number format.

## [6.9.3] - 2021-08-18

### Changed
- Updated WordPress pay Adyen library to version `2.0.1`: https://github.com/wp-pay-gateways/adyen/releases/tag/2.0.1.
  - No longer require PHP `intl` extensie.
  - Simplified exception handling.
- Updated WordPress pay Buckaroo library to version `3.0.2`: https://github.com/wp-pay-gateways/buckaroo/releases/tag/3.0.2.
  - Fix "Fatal error: Uncaught Error: Undefined class constant 'V_PAY'".

## [6.9.2] - 2021-08-17

### Changed
- Updated WordPress pay core library to version `3.0.1`: https://github.com/pronamic/wp-pay-core/releases/tag/3.0.1
  - Added debug page for subscriptions follow-up payments.
  - Added support for 'American Express' payment method.
  - Added support for 'Mastercard' payment method.
  - Added support for 'Visa' payment method.
  - Added support for 'V PAY' payment method.
- Updated WordPress pay MemberPress library to version `3.0.2`: https://github.com/wp-pay-extensions/memberpress/releases/tag/3.0.2.
  - Fixed "Fatal error: Uncaught Error: Call to a member function get_periods() on bool".
- Updated WordPress pay WooCommerce library to version `3.0.1`: https://github.com/wp-pay-extensions/woocommerce/releases/tag/3.0.1.
  - Added American Express, Mastercard, V PAY and Visa payment gateways.
- Updated WordPress pay OmniKassa 2.0 library to version `3.0.1`: https://github.com/wp-pay-gateways/omnikassa-2/releases/tag/3.0.1.
  - Added support for Mastercard, V PAY and Visa.
- Updated WordPress pay Buckaroo library to version `3.0.1`: https://github.com/wp-pay-gateways/buckaroo/releases/tag/3.0.1.
  - Added support for American Express, Maestro, Mastercard, V PAY and Visa.
  - Save `CustomerIBAN` and `CustomerBIC` for Sofort payments.

## [6.9.1] - 2021-08-13

### Changed
- Updated WordPress pay MemberPress library to version `3.0.1`: https://github.com/wp-pay-extensions/memberpress/releases/tag/3.0.1.
  - Fixed "Fatal error: Uncaught Error: Class 'Pronamic\WordPress\Pay\Extensions\MemberPress\Money' not found".
- Updated WordPress pay PayPal library to version `1.0.1`: https://github.com/wp-pay-gateways/paypal/releases/tag/1.0.1.
  - Improved support for tax.

## [6.9.0] - 2021-08-09

### Changed
- Updated WordPress pay core library to version `3.0.0`: https://github.com/pronamic/wp-pay-core/releases/tag/3.0.0.
- Updated WordPress pay money library to version `3.0.0`: https://github.com/pronamic/wp-money/releases/tag/2.0.0.

### Added
- Added WordPress pay PayPal library version `1.0.0`: https://github.com/wp-pay-gateways/paypal/releases/tag/1.0.0.
- Added support for SprayPay payment method.

### Removed
- Removed deprecated ING Kassa Compleet gateway, the `api.kassacompleet.nl` endpoint is no longer available.

## [6.8.0] - 2021-06-21

### Changed
- Updated WordPress pay core library to version 2.7.2.
  - Added payment method to subscription details when cancelling/renewing a subscription.
  - Added refunded amount in payments overview amount column.
  - Fixed using user locale on payment redirect and subscription action pages. #136
  - Improved changing subscription mandate.
- Updated WordPress pay Adyen library to version 1.3.2.
  - Updated to API version 64 and Drop-in SDK version 3.15.0 (adds support for ACH Direct Debit payment method).
  - Updated documentation of the `pronamic_pay_adyen_checkout_head` action.
- Updated WordPress pay Buckaroo library to version 2.2.0.
  - Added initial support for refunds.
  - Added WP-CLI command to retrieve transaction status and refunds info.
  - Updated integration to JSON API.
  - Switched to WordPress REST API for Push URL.
- Updated WordPress pay iDEAL Basic library to version 2.2.0.
  - Switched to REST API for notification URL.
- Updated WordPress pay Ingenico library to version 2.1.3.
  - Fixed updating payment transaction ID from transaction feedback.
- Updated WordPress pay Contact Form 7 library to version 1.1.1.
  - Improved error handling on form submission.
- Updated WordPress pay Easy Digital Downloads library to version 2.2.0.
  - Added initial support for refunds. #129
- Updated WordPress pay Gravity Forms library to version 2.7.0.
  - Added initial support for refunds. #119
- Updated WordPress pay MemberPress library to version 2.3.3.
  - Added subscription mandate selection link to account update page.
  - Fixed updating gateway in subscription/transaction on payment method update (via mandate selection URL).
- Updated WordPress pay WooCommerce library to version 2.3.1.
  - Fixed updating WooCommerce order for refunds on payment update. #130
- Updated WordPress HTTP library to version 1.1.1.
- Updated WordPress pay DigiWallet library to version 1.0.1.
- Updated WordPress pay Mollie library to version 2.2.4.

## [6.7.2] - 2021-05-28

### Added
- Added WordPress pay DigiWallet library version 1.0.0.

### Changed
- Updated WordPress pay core library to version 2.7.1.
  - Added transaction description setting to payment forms.
  - Updated payment methods logos to version 1.6.6.
  - Fixed missing `On Hold` status in payment status map.
- Updated WordPress pay OmniKassa 2.0 library to version 2.3.4.
  - Added support for gateway configuration specific webhook URLs.
  - Improved webhook error handling.
- Updated WordPress pay TargetPay library to version 2.2.0.
  - Deprecated gateway in favor of DigiWallet.
  - Improved error handling.
  - Added documentation.
- Updated WordPress pay Charitable library to version 2.2.3.
  - Improved using default gateway configuration.
- Updated WordPress pay Gravity Forms library to version 2.6.1.
  - Improved Gravity Forms 2.5.3 compatibility.
  - Fixed payment feed conditional logic setting.
  - Fixed loading admin script in form editor.
- Updated WordPress pay MemberPress library to version 2.3.2.
  - Improved setting tax amount and rate in trial phase.
- Updated WordPress pay Ninja Forms library to version 1.5.1.
  - Improved delayed actions.

## [6.7.1] - 2021-05-11

### Fixed
- Updated `pronamic/wp-http` library to version `1.0.1`.
  - Improved 'http_request_args' filter removal related to Query Monitor conflict.
- Updated `wp-pay-extensions/event-espresso` library to version `2.3.2`.
  - Use `$transaction->remaining()` instead of `$transaction->total()` so that incomplete or manual payments are also included.
  - Fixed "Non-static method EventEspressoHelper::get_description() should not be called statically" warning/error.
- Updated `wp-pay-extensions/memberpress` library to version `2.3.1`.
  - Use default gateway configuration setting.
  - Reduced magic in MemberPress payment address transformation function.
  - Improved tax calculation of payment from MemberPress subscription in trial (coupon code).
- Updated `wp-pay-gateways/omnikassa-2` library to version `2.3.3`
  - Improved error and exception handling in webhook controller.
  - Introduced the `InvalidSignatureException` class.
  - Improved documentation of the filters.
- Updated `wp-pay-gateways/payvision` library to version `1.1.2`
  - Fixed "Uncaught Error: Class 'Pronamic\WordPress\Pay\Facades\Http' not found".

## [6.7.0] - 2021-04-26

### Changed
- Updated WordPress pay core library to version 2.7.0.
  - Added initial support for refunds.
  - Added support for creating mandate with free trial periods.
  - Added support for Swish and Vipps payment methods.
  - Fixed setting post author `0` as customer user ID.
  - Fixed subscription memory inconsistencies.
  - Fixed subscription status updated to previous status when using manual payment status check.
  - Improved manually renewing canceled subscriptions.
  - Updated active tab item highlight to use WordPress color scheme.
  - Updated redirect and subscription cancel/renew pages.
  - Removed parameter `$post_id` from `Subscription` constructor (use `get_pronamic_subscription()` instead).
  - Started using `pronamic/wp-html` and `pronamic/wp-http`.
- Updated WordPress pay Adyen library to version 1.3.1.
  - Added support for Swish and Vipps payment methods.
  - Updated redirect/checkout pages.
  - Started using `pronamic/wp-http`.
- Updated WordPress pay iDEAL Basic library to version 2.1.3.
  - Fixed fatal error on handling invalid notification.
- Updated WordPress pay Mollie library to version 2.2.3.
  - Added initial support for refunds.
  - Added support for creating mandate with free trial periods.
  - Started using `pronamic/wp-http`.
- Updated WordPress pay Ingenico library to version 2.1.2.
  - Improved support for bank transfer payment method.
- Updated WordPress pay Payvision library to version 1.1.1.
  - Added Revolut iDEAL issuer.
  - Started using `pronamic/wp-http`.
- Updated WordPress pay Contact Form 7 library to version 1.1.0.
  - Added support for getting submission value by tag name.
  - Fixed handling tag options with non-unique values.
  - Fixed processing form entry for active payment methods only.
  - Improved compatibility with Contact Form 7 Conditional Fields add-on.
- Updated WordPress pay Easy Digital Downloads library to version 2.1.4.
  - Improved adding payment details to 'Thank you' page.
- Updated WordPress pay Event Espresso library to version 2.3.1.
  - Fixed setting payment method.
- Updated WordPress pay Gravity Forms library to version 2.6.0.
  - Improved compatibility with Gravity Forms 2.5.
  - Improved displaying payment methods icons.
  - Removed support for Gravity Forms version < 1.7.
- Updated WordPress pay MemberPress library to version 2.3.0.
  - Added support for single-page checkout.
- Updated WordPress pay Ninja Forms library to version 1.5.0.
  - Added support for delayed actions.
- Updated WordPress pay Restrict Content Pro library to version 2.3.2.
  - Fixed incorrect amount when using registration fees.
- Updated WordPress pay WooCommerce library to version 2.3.0.
  - Added initial support for refunds.
  - Added support for Swish and Vipps payment methods.
  - Fixed using default configuration if not set in gateway settings.
- Updated WordPress DateTime library to version 1.2.1.
- Updated WordPress Money library to version 1.2.6.
- Updated WordPress pay Buckaroo library to version 2.1.2.
- Updated WordPress pay EMS e-Commerce; library to version 2.1.2.
- Updated WordPress pay ICEPAY library to version 2.1.1.
- Updated WordPress pay iDEAL library to version 2.1.1.
- Updated WordPress pay iDEAL Advanced v3 library to version 2.1.4.
- Updated WordPress pay ING Kassa Compleet library to version 2.1.1.
- Updated WordPress pay MultiSafepay library to version 2.1.3.
- Updated WordPress pay OmniKassa 2.0 library to version 2.3.2.
- Updated WordPress pay Pay.nl library to version 2.1.2.
- Updated WordPress pay Sisow library to version 2.1.1.
- Updated WordPress pay TargetPay library to version 2.1.1.
- Updated WordPress pay Charitable library to version 2.2.2.
- Updated WordPress pay Give library to version 2.2.1.
- Updated WordPress pay s2Member library to version 2.2.2.
- Updated WordPress pay WP eCommerce library to version 2.1.3.

## [6.6.4] - 2021-02-08

### Fixed
- Updated WordPress pay Mollie library to version 2.2.2.
  - Fixed "Error validating `/locale`: The property `locale` is required" on some status update (https://github.com/mollie/api-documentation/pull/731).
- Updated WordPress pay MemberPress library to version 2.2.3.
  - Fixed showing payment method specific input fields.

### Changed
- Updated WordPress pay Payvision library to version 1.1.0.
  - Added transaction description.
  - Added advanced purchase ID setting.

## [6.6.3] - 2021-01-21

### Changed
- Updated WordPress pay core library to version 2.6.2.
  - Happy 2021.
  - Added debug mode setting.
  - Improved setting `utm_nooverride` parameter in redirect URL.
- Updated WordPress pay OmniKassa 2.0 library to version 2.3.1.
  - Updated check for response object in client request.
- Updated WordPress pay Formidable Forms library to version 2.2.1.
  - Fixed using undefined variable.
  - Removed debug code.
- Updated WordPress pay Ninja Forms library to version 1.4.0.
  - Added gateway configuration setting to form action.

## [6.6.2] - 2021-01-19

### Fixed
- Updated WordPress pay Event Espresso (legacy) library to version 2.3.2.
  - Fixed using unknown classes.

## [6.6.1] - 2021-01-18

### Changed
- Updated WordPress pay core library to version 2.6.1.
  - Added support for recurring payments with Apple Pay.
- Updated WordPress pay Mollie library to version 2.2.1.
  - Added support for first payment with regular iDEAL/Bancontact/Sofort payment methods.
  - Added support for recurring payments with Apple Pay.
  - Added 'Change Payment State' URL to Mollie payment admin page.
  - Chargebacks now update subscriptions status to 'On hold' (needs manual review).
- Updated WordPress pay MultiSafepay library to version 2.1.2.
  - Added support for In3 payment method.
  - Added partial support for Santander 'Betaal per maand' payment method.
- Updated WordPress pay Payvision library to version 1.0.1.
  - Added business ID to gateway ID column in payments overview.
- Updated WordPress pay Event Espresso (legacy) library to version 2.3.1.
  - Fixed syntax errors.
- Updated WordPress pay MemberPress library to version 2.2.2.
  - Added support for recurring payments with Apple Pay.
  - Updated payment method icons to use wp-pay/logos library.

## [6.6.0] - 2021-01-14

### Changed
- Updated WordPress pay core library to version 2.6.0.
  - Payment Gateway Referral Exclusions in Google Analytics.
  - Added Santander payment method.
  - Ask for confirmation before manually cancelling a subscription.
  - Redirect to new 'Subscription Canceled' status page after cancelling subscriptions.
  - Fixed updating subscription dates on next period payment creation.
  - Only add user agent in payment info meta box if not empty.
  - Added feature to manually start the next subscription payment.
- Updated WordPress pay Charitable library to version 2.2.1.
  - Improved donation total amount value retrieval.
  - Improved user data support, set address line 2 and country code.
- Updated WordPress pay Contact Form 7 to version 1.0.3.
  - Fix redirecting when scripts are disabled through `wpcf7_load_js` filter.
- Updated WordPress pay Formidable Forms to version 2.2.0.
  - Simplified icon hover style.
  - Updated form action icon.
  - Added support for form settings redirect success URL.
- Updated WordPress pay Ninja Forms to version 1.3.0.
  - Fixed notice payment redirect URL.
- Updated WordPress pay Restrict Content Pro to version 2.3.1.
  - Renew inactive membership on successful (retry) payment.
  - Fix not using checkout label setting.
- Updated WordPress pay s2Member to version 2.2.1.
  - Prevent updating eot if (retry) payment period end date is (before) current eot time.
  - Fix using removed payment data class and multiple status update actions.
  - Fix setting subscription next payment date for new subscriptions (removes payment data class).
- Updated WordPress pay WooCommerce to version 2.2.1.
  - Updated logo library to version 1.6.3 for new iDEAL logo.
  - Start subscription payment through subscription module instead of plugin.
  - Move info message up on thank you page.
  - Add Santander payment method.

## [6.5.1] - 2020-11-19

### Fixed
- Updated WordPress pay core library to version 2.5.1.
  - Fixed always setting payment customer details.
  - Fixed setting currency in payment lines amount.
- Updated WordPress pay Gravity Forms library to version 2.5.1.
  - Updated getting subscription from payment period.

### Changed
- Updated WordPress pay Adyen library to version 1.2.1.
  - Removed unused configuration to store card details.

## [6.5.0] - 2020-11-18

### Added
- Added support for Payvision gateway (requires Basic license).

### Fixed
- Updated WordPress pay iDEAL Advanced library to version 2.1.3.
  - Fix regression in payment status retrieval.

### Removed
- Removed deprecated Fibonacci ORANGE gateway.
- Removed deprecated Mollie iDEAL gateway.
- Removed deprecated Nocks gateway.
- Removed deprecated Rabobank OmniKassa gateway.

## [6.4.1] - 2020-11-10

### Fixed
- Updated WordPress pay iDEAL Advanced library to version 2.1.2.
  - Fixed acquirer URL.
- Updated WordPress pay iDEAL Basic library to version 2.1.2.
  - Fixed acquirer URL.

## [6.4.0] - 2020-11-09

### Changed
- Updated WordPress pay core library to version 2.5.0.
  - Added support for subscription phases.
  - Added support for Przelewy24 payment method.
  - Improved data stores, reuse data from memory.
  - Catch money parser exceptions in blocks.
  - Introduced some traits for the DRY principle.
  - Payments can be linked to multiple subscription periods.
  - Improved support for subscription alignment and proration.
  - Added REST API endpoint for subscription phases.
  - Removed `$subscription->get_total_amount()` in favor of getting amount from phases.
  - Removed ability to manually change subscription amount for now.
  - No longer start recurring payments for expired subscriptions.
- Updated WordPress pay Adyen library to version 1.2.0.
  - Added REST route permission callbacks.
- Updated WordPress pay Mollie library to version 2.2.0.
  - Added Przelewy24 payment method.
  - Added REST route permission callback.
  - Improved determining customer if previously used customer has been removed at Mollie.
  - Fixed filtering next payment delivery date.
  - Fixed incorrect check for failed payment bank reason detail.
- Updated WordPress pay Nocks library to version 2.2.0.
  - Deprecated gateway as Nocks no longer exists (https://guldenbites.com/2020/05/15/nocks-announcement/).
- Updated WordPress pay OmniKassa 2.0 library to version 2.3.0.
  - Switched to REST API for webhook.
  - Catch input JSON validation exception in webhook listener.
- Updated WordPress pay Pay.nl library to version 2.1.1.
  - Limited first and last name to 32 characters.
- Updated WordPress pay Charitable library to version 2.1.3.
  - Improved getting user data from donation.
- Updated WordPress pay Contact Form 7 library to version 1.0.2.
  - Fixed getting amount from free text value.
- Updated WordPress pay Formidable Forms library to version 2.1.4.
  - Improved error handling on payment start.
  - Fixed incorrect amount when using product fields.
- Updated WordPress pay Gravity Forms library to version 2.5.0.
  - Changed 'Frequency' to 'Number of Periods' in payment feed subscription settings.
  - Changed 'Synchronized payment date' to 'Fixed Subscription Period' in payment feed subscription settings.
  - Places Euro symbol left of amount in Gravity Forms currency when using Dutch language.
  - Added Dutch address notation for Gravity Forms.
  - Added support for new subscription phases and periods.
  - Fixed unselected options in payment method selector after processing conditional logic.
- Updated WordPress pay MemberPress library to version 2.2.0.
  - Added Przelewy24 payment method.
  - Added support for new subscription phases and periods.
  - Added support for trials and (prorated) upgrades/downgrade.
  - Set Pronamic Pay subscription on hold if non-recurring payment fails.
- Updated WordPress pay Restrict Content Pro library to version 2.3.0.
  - Changed setting the next payment date 1 day earlier, to prevent temporary membership expirations.
  - No longer mark Pronamic Pay subscriptions as expired when a Restrict Content Pro membership expires.
  - Added support for new subscription phases and periods.
  - Added support for trials to credit card and direct debit methods.
  - Added support for payment fees.
- Updated WordPress pay s2Member library to version 2.2.0.
  - Added support for new subscription phases and periods.
  - Fixed processing list servers for recurring payments.
- Updated WordPress pay WooCommerce library to version 2.2.0.
  - Updated iDEAL logo.
  - Added Przelewy24 payment method.
  - Added support for new subscription phases and periods.
  - Fixed incorrect 'Awaiting payment' order note for recurring payments in some cases.
  - Fixed using default payment description if setting is empty.

## [6.3.2] - 2020-08-05

### Fixed
- Updated WordPress pay MemberPress library to version 2.1.3.
  - Fixed reactivating cancelled MemberPress subscription when pending recurring payment completes.
- Updated WordPress pay WooCommerce library to version 2.1.4.
  - Fixed possible error on WooCommerce products admin page.

## [6.3.1] - 2020-07-23

### Fixed
- Updated WordPress pay core library to version 2.4.1.
  - Added email address as fallback for customer name in payments and subscriptions overview and details.
  - Fixed using deprecated `email` and `customer_name` properties.
- Updated WordPress pay Restrict Content Pro library to version 2.2.3.
  - Fixed possible 'Fatal error: Call to a member function `get_id()` on null'.
- Updated WordPress pay s2Member library to version 2.1.3.
  - Fixed creating empty subscriptions.
- Updated WordPress pay WooCommerce library to version 2.1.3.
  - Fixed compatibility with WooCommerce EU VAT Number plugin.

## [6.3.0] - 2020-07-08

### Added
- Added support for Contact Form 7 plugin (requires Basic license).

### Changed
- Updated WordPress pay core library to version 2.4.0.
  - Added support for customer company name.
  - Added support for updating subscription mandate.
  - Added support for VAT number (validation via VIES).
  - Added `get_pronamic_subscriptions_by_source()` function.
  - Fixed possible duplicate payment on upgrade if pending recurring payment exists.
  - Fixed updating subscription status to 'On Hold' only if subscription is not already active, when processing first payment.
  - Improved subscription date calculations.
  - Updated admin tour.
- Updated WordPress Money library to version 1.2.5.
  - Added support for parsing negative amounts and `5,-` notation for amounts without minor units.
  - Updated currency symbols.
- Updated WordPress pay Adyen library to version 1.1.2.
  - Fixed possible conflicting payments caused by double clicking submit button.
  - Removed empty meta data from payment request JSON.
- Updated WordPress pay Mollie library to version 2.1.4.
  - Added filter `pronamic_pay_mollie_payment_metadata` for Mollie payment metadata.
  - Added support for updating subscription mandate.
- Updated WordPress pay Ingenico library to version 2.1.1.
  - Added exception for Ingenico error when retrieving order status.
- Updated WordPress pay OmniKassa 2.0 library to version 2.2.4.
  - Switched to new endpoint at `/order/server/api/v2/order`.
  - Removed obsolete update of payment transaction ID.
- Updated WordPress pay Easy Digital Downloads library to version 2.1.2.
  - Added support for company name and VAT number from the custom Pronamic EDD plugins.
  - Fixed registering `cancelled` post status for use in EDD payments table view filters.
- Updated WordPress pay Gravity Forms library to version 2.4.1.
  - Added support for company name and VAT number.
  - Improved Gravity Forms 2.5 beta compatibility.
- Updated WordPress pay Restrict Content Pro library to version 2.2.2.
  - Added support for subscription frequency.
  - Fixed using existing subscription for membership.
  - Fixed expiring membership if first payment expires but subscription is already active.
- Updated WordPress pay WooCommerce library to version 2.1.2.

## [6.2.0] - 2020-06-03

### Changed
- Updated WordPress pay core library to version 2.3.2.
  - Add support for new fundraising add-on (requires Pro license).
  - Add payment origin post ID.
  - Add 'Pronamic Pay' block category.
  - Fix subscriptions without next payment date.
  - Fix incorrect formatted amount in payment form block.
- Updated WordPress pay Mollie library to version 2.1.3.
  - Add support for Mollie payment billing email and filter `pronamic_pay_mollie_payment_billing_email`.
- Updated WordPress pay OmniKassa 2.0 library to version 2.2.3.
  - Fix incorrect payments order when handling order status notifications.
- Updated WordPress pay Charitable library to version 2.1.2.
  - Add telephone number to payment data.
  - Fix error handling.
- Updated WordPress pay Gravity Forms library to version 2.4.0.
  - Add filter `pronamic_pay_gravityforms_delay_actions` for delayed actions.
  - Fix empty formatted amount in entry notes if value is `0`.
- Updated WordPress pay MultiSafepay library to version 2.1.1.
- Updated WordPress pay Formidable Forms library to version 2.1.3.
- Updated WordPress pay s2Member library to version 2.1.2.

## [6.1.2] - 2020-04-20

### Fixed
- Updated WordPress pay Buckaroo library to version 2.1.1.
  - Fixed HTML entities in payment description resulting in invalid signature error.
- Updated WordPress pay EMS e-Commerce; library to version 2.1.1.
  - Fixed incorrect default tag in description of Order ID settings field.
- Updated WordPress pay Gravity Forms library to version 2.3.1.
  - Fixed PHP notices and warnings.
  - Use integration version number for scripts and styles.
- Updated WordPress pay MemberPress library to version 2.1.2.
  - Fixed setting `complete` transaction status to `pending` again on free downgrade.

### Changed
- Updated WordPress pay Adyen library to version 1.1.1.
  - Fixed not using billing address country code on drop-in payment redirect page.
  - Added support for payment metadata via `pronamic_pay_adyen_payment_metadata` filter.
  - Added advanced gateway configuration setting for `merchantOrderReference` parameter.
  - Added browser information to payment request.
  - Removed shopper reference from payment request.
  - Removed payment status request from drop-in gateway supported features.
- Updated WordPress pay OmniKassa 2.0 library to version 2.2.2.
  - Improved webhook handling if multiple gateway configurations exist.
- Updated WordPress pay Formidable Forms library to version 2.1.2.
  - Updated settings description for delaying email notifications.

## [6.1.1] - 2020-04-06

### Fixed
- Updated deployment script.

## [6.1.0] - 2020-04-06

### Fixed
- Updated WordPress pay Charitable library to version 2.1.1.
  - Fixed incorrect currency symbol filter.
- Updated WordPress pay MemberPress library to version 2.1.1.
  - Fixed "PHP Warning: call_user_func() expects parameter 1 to be a valid callback".

### Changed
- Updated WordPress pay core library to version 2.3.1.
  - Added optional `$args` parameter to `get_pronamic_payment_by_meta()` function.
  - Added active plugin integrations to Site Health debug fields.
  - Fixed unnecessarily showing upgrade button in new installations.
- Updated WordPress pay Mollie library to version 2.1.2.
  - Fixed install issues on some specific WordPress installations.
  - Add initial Apple Pay support.
- Updated WordPress pay OmniKassa 2.0 library to version 2.2.1.
  - Improved webhook handling if multiple payments exist with same merchant order ID.
- Updated WordPress pay Easy Digital Downloads library to version 2.1.1.
  - Improved tax support for Easy Digital Downloads 3.0.
- Updated WordPress pay Gravity Forms library to version 2.3.0.
  - Added payment feed fields settings to auto detect first visible field of type in entry.
  - Added `pronamic_pay_again_url` merge tag, which can be used to pre-populate form after failed payment.
  - Fixed "Warning: Invalid argument supplied for foreach()" in calculation variables select.
  - Improved payment feed conditions with support for all fields and multiple rules.
  - Improved forms list performance.
- Updated WordPress pay Ninja Forms library to version 1.2.0.
  - Added payment status page action settings.
  - Updated action redirect to use payment redirect URL.
- Updated WordPress pay Restrict Content Pro library to version 2.2.1.
  - Improved CLI commands.
  - Improved 2.1.6 upgrade.
- Updated WordPress pay Event Espresso library to version 2.2.1.
- Updated WordPress pay Event Espresso (legacy) library to version 2.2.1.
- Updated WordPress pay Formidable Forms library to version 2.1.1.
- Updated WordPress pay Give library to version 2.1.1.
- Updated WordPress pay s2Member library to version 2.1.1.
- Updated WordPress pay WooCommerce library to version 2.1.1.
- Updated WordPress pay WP eCommerce library to version 2.1.1.

## [6.0.2] - 2020-03-26

### Fixed
- Updated WordPress pay iDEAL Advanced v3 library to version 2.1.1.
  - Fix incomplete gateway settings.
- Updated WordPress pay iDEAL Basic library to version 2.1.1.
  - Fix incomplete gateway settings.

## [6.0.1] - 2020-03-19

### Fixed
- Updated WordPress pay Mollie library to version 2.1.1.
  - Force a specific collate to fix "Illegal mix of collations" error.

## [6.0.0] - 2020-03-19

### Changed
- Updated WordPress pay core library to version 2.3.0.
  - Added Google Pay support.
  - Added Apple Pay payment method.
  - Added support for payment failure reason.
  - Added input fields for consumer bank details name and IBAN.
  - Simplify recurrence details in subscription info meta box.
  - Fixed setting initials if no first and last name are given.
  - Abstracted plugin and gateway integration classes.
- Updated WordPress pay Easy Digital Downloads library to version 2.1.0.
  - Update integration setup with dependencies support.
  - Set Easy Digital Downloads payment status to 'cancelled' in case of a cancelled payment.
  - Extend `Extension` class from `AbstractPluginIntegration`.
- Updated WordPress pay Gravity Forms library to version 2.2.0.
  - Added consumer bank details name and IBAN field settings.
  - Fixed adding payment line for shipping costs only when shipping field is being used.
  - Fixed dynamically setting selected payment method.
  - Fixed feed activation toggle.
  - Improved field visibility check with entry.
  - Improved payment methods field choices in field input (fixes compatibility with `Gravity Forms Entries in Excel` plugin).
  - Extension extends abstract plugin integration with dependency.
- Updated WordPress pay Ninja Forms library to version 1.1.0.
  - Fix incorrect selected payment method in payment methods fields when editing entry.
- Updated WordPress pay WooCommerce library to version 2.1.0.
  - Update integration setup with dependencies support.
  - Use SVG icons.
  - Add Apple Pay payment method.
  - Extension extends \Pronamic\WordPress\Pay\AbstractPluginIntegration.
  - Added Google Pay support.
- Updated WordPress pay Adyen library to version 1.1.0.
  - Fixed unnecessarily showing additional payment details screen in some cases.
  - Only create controllers and actions when dependencies are met.
  - Added Google Pay support.
  - Added Apple Pay support.
- Updated WordPress pay ICEPAY library to version 2.1.0.
  - Fixed "$result is always a sub-type of Icepay_Result".
- Updated WordPress pay Mollie library to version 2.1.0.
  - Added custom tables for Mollie profiles, customers and WordPress users.
  - Added experimental CLI integration.
  - Moved webhook logic to REST API.
  - Improved WordPress user profile Mollie section.
  - Added WordPress admin dashboard page for Mollie customers.
  - Added support for one-off SEPA Direct Debit payment method.
  - Added support for payment failure reason.

## [5.9.0] - 2020-02-03

### Changed
- Updated WordPress pay core library to version 2.2.7.
  - Added Google Analytics e-commerce `pronamic_pay_google_analytics_ecommerce_item_name` and `pronamic_pay_google_analytics_ecommerce_item_category` filters.
  - Improved error handling for manual payment status check.
  - Updated custom gender and date of birth input fields.
  - Clean post cache to prevent duplicate status updates.
  - Fixed duplicate payment for recurring payment.
- Updated WordPress pay Easy Digital Downloads library to version 2.0.7.
  - Improved custom input fields HTML markup and validation.
- Updated WordPress pay Gravity Forms library to version 2.1.15.
  - Only prorate subscription amount when form field has been set for recurring amount.
  - Fixed incorrect currency with multicurrency add-on.
  - Fixed subscription start with zero interval days.
- Updated WordPress pay Adyen library to version 1.0.6.
  - Added support for Drop-in integration (requires 'Origin Key' in gateway settings).
  - Added application info support.
- Updated WordPress pay MultiSafepay library to version 2.0.6.
  - Improved error handling.
- Updated Pronamic WordPress Money library to version 1.2.4.

### Fixed
- Updated WordPress pay Charitable library to version 2.0.4.
  - Fixed processing decimal input amounts.
- Updated WordPress pay MemberPress library to version 2.0.13.
  - Explicitly set transaction expiry date.
- Updated WordPress pay Restrict Content Pro library to version 2.1.7.
  - Fixed possible 'Fatal error: Call to a member function `get_user_id()` on boolean' in updater.
- Updated WordPress pay Mollie library to version 2.0.10.
  - Fixed notice 'Not Found - No customer exists with token cst_XXXXXXXXXX' in some cases.

### Removed
- Removed AppThemes integration.
- Removed ClassiPress integration.
- Removed iThemes Exchange integration (plugin is now Ninja Shop and not supported anymore).
- Removed Jigoshop integration (plugin not under active development anymore).
- Removed Shopp integration (plugin not under active development anymore).
- Removed WPMU DEV Membership integration (plugin has been retired; see https://premium.wpmudev.org/retiring-our-legacy-plugins/).

## [5.8.1] - 2020-01-08

### Changed
- Updated WordPress pay core library to version 2.2.6.
  - Added filter `pronamic_payment_gateway_configuration_id` for payment gateway configuration ID.
  - Added filter `pronamic_pay_return_should_redirect` to move return checks to gateway integrations.
  - Added Polylang home URL support in payment return URL.
  - Added user display name in payment info meta box.
  - Added consumer and bank transfer bank details.
  - Added support for payment expiry date.
  - Added support for gateway manual URL.
  - Added new dependencies system.
  - Added new upgrades system.
  - Fixed incorrect day of month for yearly recurring payments when using synchronized payment date.
  - Fixed not starting recurring payments for gateways which don't support recurring payments.
  - Fixed default payment method in form processor if required.
  - Fixed empty dashboard widgets for untranslated languages.
  - Fixed submit button for manual subscription renewal.
  - Fixed duplicate currency symbol in payment forms.
  - Fixed stylesheet on payment redirect.
  - Improved payment methods tab in gateway settings.
  - Improved updating active payment methods.
  - Improved error handling with exceptions.
  - Improved update routine.
  - Set subscription status 'On hold' for cancelled and expired payments.
  - Do not auto update subscription status when status is 'On hold'.
  - Renamed 'Expiry Date' to 'Paid up to' in subscription info meta box.
- Updated WordPress pay Adyen library to version 1.0.5.
  - Added Site Health test for HTTP authorization header.
  - Added URL to manual in gateway settings.
  - Added shopper email to payment request.
  - Improved support for PHP 5.6.
- Updated WordPress pay ING Kassa Compleet library to version 2.0.3.
  - Added support for payments without method specified.
  - Improved bank transfer payment instructions.
- Updated WordPress pay ICEPAY library to version 2.0.6.
  - Fixed processing ICEPAY postback.
- Updated WordPress pay Mollie library to version 2.0.9.
  - Added advanced setting for bank transfer due date days.
  - Added bank transfer recipient details to payment.
  - Removed Bitcoin payment method (not supported by Mollie anymore).
- Updated WordPress pay OmniKassa 2.0 library to version 2.1.10.
  - Added address fields validation.
- Updated WordPress pay Sisow library to version 2.0.4.
  - Added support for new `pronamic_pay_return_should_redirect` filter for notify and callback processing.
  - Improved status updates for payments without transaction ID (i.e. iDEAL QR and iDEAL without issuer).
  - Improved getting active payment methods for account.
- Updated WordPress pay Easy Digital Downloads library to version 2.0.6.
  - Added payment line ID support with variable price ID.
  - Improved output HTML to match Easy Digital Downloads.
- Updated WordPress pay Give library to version 2.0.4.
  - Updated gateway settings.
- Updated WordPress pay Gravity Forms library to version 2.1.14.
  - Added merge tags for bank transfer recipient details.
  - Added notice about subscription frequency being in addition to the first payment.
  - Fixed synchronized payment date monthday and month settings.
  - Improved payment method field creation.
- Updated WordPress pay Restrict Content Pro library to version 2.1.6.
  - Added support for new dependencies system.
  - Added support for new upgrades system.
  - Added upgrade script for payment and subscriptions source.
- Updated WordPress pay AppThemes library to version 2.0.4.
- Updated WordPress pay Buckaroo library to version 2.0.4.
- Updated WordPress pay Charitable library to version 2.0.3.
- Updated WordPress pay ClassiPress library to version 2.0.3.
- Updated WordPress pay EMS e-Commerce library to version 2.0.4.
- Updated WordPress pay Event Espresso library to version 2.1.3.
- Updated WordPress pay Event Espresso (legacy) library to version 2.1.2.
- Updated WordPress pay Formidable Forms library to version 2.0.4.
- Updated WordPress pay iDEAL Advanced v3 library to version 2.0.5.
- Updated WordPress pay iDEAL Basic library to version 2.0.5.
- Updated WordPress pay iThemes Exchange library to version 2.0.3.
- Updated WordPress pay Jigoshop library to version 2.0.4.
- Updated WordPress pay MemberPress library to version 2.0.12.
- Updated WordPress pay MultiSafepay library to version 2.0.5.
- Updated WordPress pay Ninja Forms library to version 1.0.3.
- Updated WordPress pay Nocks library to version 2.0.3.
- Updated WordPress pay Ogone library to version 2.0.4.
- Updated WordPress pay Pay.nl library to version 2.0.4.
- Updated WordPress pay s2Member library to version 2.0.5.
- Updated WordPress pay Shopp library to version 2.0.3.
- Updated WordPress pay TargetPay library to version 2.0.3.
- Updated WordPress pay WooCommerce library to version 2.0.10.
- Updated WordPress pay WP eCommerce library to version 2.0.4.
- Updated WordPress pay WPMU DEV Membership library to version 2.0.4.

## [5.8.0] - 2019-10-08

### Changed
- Updated WordPress pay core library to version 2.2.4.
  - Updated `viison/address-splitter` library to version `0.3.3`.
  - Move tools to site health debug information and status tests.
  - Read plugin version from plugin file header.
  - Catch money parser exception for test payments.
  - Separated `Statuses` class in `PaymentStatus` and `SubscriptionStatus` class.
  - Require `edit_payments` capability for payments related meta boxes on dashboard page.
  - Set menu page capability to minimum required capability based on submenu pages.
  - Only redirect to about page if not already viewed.
  - Removed Google +1 button.
  - Order payments by ascending date (fixes last payment as result in `Subscription::get_first_payment()`).
  - Added new WordPress Pay icon.
  - Added start, end, expiry, next payment (delivery) date to payment/subscription JSON.
  - Introduced a custom REST API route for payments and subscriptions.
  - Fixed handling settings field `filter` array.
  - Catch and handle error when parsing input value to money object fails (i.e. empty string).
  - Improved getting first subscription payment.
- Updated WordPress pay Adyen library to version 1.0.4.
  - Improved some exception messages.
- Updated WordPress pay ICEPAY library to version 2.0.5.
  - Added support for Klarna (Directebank) payment method.
  - Update ICEPAY library version from 2.4.0 to 2.5.3.
- Updated WordPress pay iDEAL Basic library to version 2.0.4.
  - Fixed setting `deprecated` based on passed arguments.
- Updated WordPress pay Mollie library to version 2.0.8.
  - Added response data to error for unexpected response code.
  - Moved next payment delivery date filter from gateway to integration class.
  - Throw exception when Mollie response is not what we expect.
- Updated WordPress pay OmniKassa 2.0 library to version 2.1.9.
  - Use line 1 as street if address splitting failed (i.e. no house number given).
  - Improved support for merchantOrderId = AN (Strictly)..Max 24 field.
- Updated WordPress pay Gravity Forms library to version 2.1.12.
  - Improved RTL support in 'Synchronized payment date' settings fields.
  - Fixed loading extension in multisite when plugin is network activated and Gravity Forms is activated per site.
- Updated WordPress pay MemberPress library to version 2.0.11.
  - Fixed showing lifetime columns on MemberPress subscriptions page if plugin is loaded before MemberPress.
- Updated WordPress pay Restrict Content Pro library to version 2.1.5.
  - Restrict Content Pro 3.0 is required.
  - Renew membership during `pronamic_pay_new_payment` routine and update membership expiration date and status on cancelled/expired/failed payment status update.
- Updated WordPress pay s2Member library to version 2.0.4.
  - Send user first and last name to list servers.
  - Added s2Member plugin dependency.
  - Added support for list server opt-in.
- Updated WordPress pay WooCommerce library to version 2.0.9.
  - Only update order status if order payment method is a WordPress Pay gateway.
  - No longer disable 'Direct Debit' gateways when WooCommerce subscriptions is active and cart has no subscriptions [read more](https://github.com/wp-pay-extensions/woocommerce#conditional-payment-gateways).
  - Changed redirect URL for cancelled and expired payments from cancel order to order pay URL.
  - Allow payment gateway selection for order pay URL.

## [5.7.4] - 2019-09-02

### Fixed
- Updated WordPress pay Gravity Forms library to version 2.1.11.
  - Fix entry payment fulfillment.
- Updated WordPress pay MemberPress library to version 2.0.10.
  - Fix error "`DatePeriod::__construct()`: The recurrence count '0' is invalid. Needs to be > 0".

## [5.7.3] - 2019-08-30

### Fixed
- Updated WordPress pay Sisow library to version 2.0.3.
  - Fix possible error with tax request parameters.
- Updated WordPress pay iDEAL Advanced v3 library to version 2.0.4.
  - Removed 'Show details...' toggle link in settings.

## [5.7.2] - 2019-08-30

### Fixed
- Updated WordPress pay core library to version 2.2.3.
  - Fix not loading gateways.

## [5.7.1] - 2019-08-30

### Fixed
- Updated WordPress pay core library to version 2.2.2.
  - Improved backwards compatibility for `pronamic_pay_gateways` filter.
- Updated WordPress pay Gravity Forms library to version 2.1.10.
  - Fix possible error with subscriptions "Uncaught Exception: DatePeriod::__construct(): This constructor accepts either...".
  - Improve GF Nested Forms compatibility.
- Updated WordPress pay WooCommerce library to version 2.0.8.
  - Fix error "`DatePeriod::__construct()`: The recurrence count '0' is invalid. Needs to be > 0".

## [5.7.0] - 2019-08-26

### Changed
- Updated WordPress pay Formidable Forms library to version 2.0.3.
  - Improved Formidable Forms v4 compatibility.
- Updated WordPress pay MemberPress library to version 2.0.9.
  - Fix incorrect subscription frequency.
  - No longer start up follow-up payments for paused subscriptions.
- Updated WordPress pay Restrict Content Pro library to version 2.1.4.
  - Fixed support for Restrict Content Pro 3.0.
- Updated WordPress pay Adyen library to version 1.0.2.
  - Set country from billing address.
  - Added action `pronamic_pay_adyen_checkout_head`.
  - Added `pronamic_pay_adyen_config_object` filter and improved documentation.
- Updated WordPress pay ICEPAY library to version 2.0.4.
  - Force language `NL` for unsupported languages (i.e. `EN` for iDEAL).
  - Only force language if payment method is set.
- Updated WordPress pay Sisow library to version 2.0.2.
  - Get available payment methods for merchant from Sisow account.
  - Transform status `Reversed` to WordPress Pay status `Refunded`.
- Updated WordPress pay Nocks library to version 2.0.2.
  - Do not use removed `set_slug()` method.
- Updated WordPress pay Mollie library to version 2.0.2.
  - Updated to Mollie API v2, with multicurrency support.
  - Added EPS payment method.
  - Added filter for subscription 'Next Payment Delivery Date'.

### Removed
- Removed Paytor integration, still supported via the Mollie gateway. For more information see https://www.wp-pay.org/paytor-disappeared-now-part-of-mollie/.
- Removed Qantani (new platform) integration, still supported via the Mollie gateway.
- Removed Postcode.nl integration, for more information see https://github.com/wp-pay-gateways/postcode-ideal/blob/master/DEPRECATED.md.

## [5.6.2] - 2019-05-15

### Fixed
- Updated WordPress pay Adyen library from 1.0.0 to version 1.0.1.
  - Remove path from origin URL in payment session request.
  - Fix API live URL prefix setting not saved.
- Updated WordPress pay ICEPAY library from 2.0.2 to version 2.0.3.
  - Set country from billing address.
- Updated WordPress pay Easy Digital Downloads library from 2.0.3 to version 2.0.4.
  - Improve emptying cart for completed payments.
- Updated WordPress pay Formidable Forms library from 2.0.1 to version 2.0.2.
  - Improve support for AJAX enabled forms.
- Updated WordPress pay Gravity Forms library from 2.1.7 to version 2.1.8.
  - Fix payment method field options deselected when saving from form settings subviews.
  - Update entry payment status when subscription is manually activated.
  - Disable asynchronous feed processing for delayed actions.
- Updated WordPress pay MemberPress library from 2.0.7 to version 2.0.8.
  - Fix subscription source ID bug.
  - Add more payment method icons.
  - Add capabilities to Direct Debit Bancontact/iDEAL/Sofort gateways.
- Updated WordPress pay s2Member library from 2.0.1 to version 2.0.2.
  - Set subscription `total amount` instead of `amount`.

## [5.6.1] - 2019-04-15

### Fixed
- Updated WordPress pay Ninja Forms library from 1.0.0 to version 1.0.1.
  - Fix form builder not loading due to removed 'pricing' field type section since Ninja Forms 3.4.6.
  - Workaround Ninja Forms not passing plugin default currency setting correctly.
- Updated WordPress pay WooCommerce library from 2.0.5 to version 2.0.6.
  - Fix accidentally adding 'Pronamic' to checkout button text.
  - Fix fatal error in checkout settings with WooCommerce Subscriptions.
  - Fix incorrectly filtering available checkout gateways with WooCommerce Subscriptions.

## [5.6.0] - 2019-04-01

### Changed
- Updated WordPress pay core library from 2.1.5 to version 2.1.6.
  - Updated Tippy.js to version 3.4.1.
  - Introduced a `$payment->get_edit_payment_url()` function to easy retrieve the edit payment URL.
  - Introduced a `$payment->get_status_label()` function to retrieve easier a user friendly (translated) status label.
  - Renamed status check event to `pronamic_pay_payment_status_check` without seconds argument and with different delays for recurring payments.
  - Added space between HTML attributes when converting from array.
  - Allow transaction ID to be null.
  - Retrieving payments will now check on payment post type.
  - Introduced Country, HouseNumber and Region classes.
  - Simplify payment redirect (Ogone DirectLink answer moved to gateway).
  - Added key query argument to pay redirect URL.
  - Link recurring icon to subscription post edit.
  - Add support for payment redirect with custom views.
  - Register style pronamic-pay-redirect in plugin.
  - Removed ABN AMRO iDEAL Easy, iDEAL Only Kassa and Internetkassa gateways.
  - Keep main admin menu item active when editing payments/subscriptions/gateways/forms.
  - Added pronamic_pay_gateways filter.
  - Show Adyen and EMS gateway IDs in custom column.
  - Fixed empty admin reports.
- Updated WordPress pay Easy Digital Downloads library from 2.0.2 to version 2.0.3.
  - Always empty cart for completed payments.
  - Simplified adding gateways and payment method icons.
  - Fixed "The call to edd_record_gateway_error() has too many arguments" error.
- Updated WordPress pay WooCommerce library from 2.0.4 to version 2.0.5.
  - Improved order notes and payment status updates.
  - Added/updated gateway icons.
  - More DRY gateway setup.
- Updated WordPress pay WP eCommerce library from 2.0.1 to version 2.0.2.
  - Added support for additional payment data like customer, addresses, payment lines, etc.
  - Added gateway for AfterPay, Bancontact, Bank Transfer, Credit Card, Focum, Giropay, Maestro, PayPal and SOFORT.
- Updated WordPress pay Buckaroo library from 2.0.1 to version 2.0.2.
  - Improved Buckaroo push response handling when payment was not found.
  - Added missing PHP namespace alias usage Pronamic\WordPress\Pay\Core\Server.
- Updated WordPress pay Ingenico library from 2.0.1 to version 2.0.2.
  - Moved custom payment redirect from plugin to gateway.
  - Make use of payment `get_pay_redirect_url()` method.
  - Added initial support for Ogone alias creation.
  - Added HTML/CSS classes to TP parameter settings field.

## [5.5.5] - 2019-02-04

### Added
- Added Handelsbanken issuer icons.

### Fixed
- Updated WordPress pay core library from 2.1.4 to version 2.1.5.
  - Fixed fatal error PaymentInfo expecting taxed money.
  - Improved responsive admin tables for payments and subscriptions.
- Updated WordPress pay Gravity Forms library from 2.1.6 to version 2.1.7.
  - Fixed empty country code for unknown countries.
- Updated WordPress pay MemberPress library from 2.0.6 to version 2.0.7.
  - Fixed "Given country code not ISO 3166-1 alpha-2 value".
- Updated WordPress pay OmniKassa 2.0 library from 2.1.5 to version 2.1.6.
  - Removed workaround for order item name length, Rabobank has resolved the issue.
- Updated WordPress pay Pay.nl library from 2.0.1 to version 2.0.2.
  - Fixed error 'invalid paymentProfileId' if no payment method was specified.

## [5.5.4] - 2019-01-24

### Changed
- Updated WordPress pay core library from 2.1.3 to version 2.1.4.
- Updated WordPress pay MemberPress library from 2.0.5 to version 2.0.6.
  - Fixed fatal error Gateway not found when processing status updates.
- Updated WordPress pay Restrict Content Pro library from 2.1.2 to version 2.1.3.
  - Use taxed money object for subscription amount.
- Updated WordPress pay ICEPAY library from 2.0.1 to version 2.0.2.
  - Improved setting required country and language.
- Updated WordPress pay OmniKassa 2.0 library from 2.1.4 to version 2.1.5.
  - Workaround for OmniKassa 2.0 bug in order item name length.

## [5.5.3] - 2019-01-22

### Changed
- Updated WordPress pay core library from 2.1.2 to version 2.1.3.
  - Fixed empty payment and subscription customer names.
  - Fixed missing user ID in payment customer.
  - Updated storing payments and subscriptions.
  - Allow manual subscription renewal also for gateways which support auto renewal.
- Updated WordPress pay Gravity Forms library from 2.1.5 to version 2.1.6.
  - Fixed fatal error in Gravity Forms recurring payments if plugin is not activated.
  - Fixed issue with prorating amount when synchronized payment dates are not enabled.
  - Enabled placeholder setting for issuers and payment methods field.
  - Added extra field map options.
  - Added support for payment lines.
- Updated WordPress pay Jigoshop library from 2.0.1 to version 2.0.2.
  - Fixed "Fatal error: Uncaught Error: Call to undefined method jigoshop::get_option()".
- Updated WordPress pay MemberPress library from 2.0.4 to version 2.0.5.
  - Added admin Pronamic subscription column to MemberPress subscriptions overview.
  - Updated payment and subscription creation.
- Updated WordPress pay Restrict Content Pro library from 2.1.1 to version 2.1.2.
  - Added support for subscription cancellation.
  - Update member auto renewal setting for first payment too.
  - Use Restrict Content Pro success page return URL only for successful payments.
  - Prevent using direct debit recurring payment methods for non-expiring subscriptions.
- Updated WordPress pay Mollie library from 2.0.5 to version 2.0.6.
  - Name is not required anymore when creating a new Mollie customer.
- Updated WordPress pay OmniKassa 2.0 library from 2.1.3 to version 2.1.4.
  - Workaround for OmniKassa 2.0 bug in order item names with special characters.

## [5.5.2] - 2019-01-03

### Changed
- Updated WordPress pay core library from 2.1.1 to version 2.1.2.
  - Fixed empty payments and subscriptions list tables with 'All' filter since WordPress 5.0.2.
- Updated WordPress pay OmniKassa 2.0 library from 2.1.2 to version 2.1.3.
  - Improved error handling.

## [5.5.1] - 2018-12-19

### Changed
- Updated WordPress pay core library from 2.1.0 to version 2.1.1.
  - Fixed incomplete payment customer from legacy meta.
- Updated WordPress pay OmniKassa 2.0 library from 2.1.1 to version 2.1.2.
  - Limit order item name to 50 characters.
- Updated WordPress pay WooCommerce library from 2.0.2 to version 2.0.4.
  - Fixed WooCommerce admin products table not listing all products.
  - Improved retrieving WooCommerce checkout fields.

## [5.5.0] - 2018-12-17

### Changed
- Updated WordPress pay core library from 2.0.8 to version 2.1.0.
  - Store payment data as JSON.
  - Added support for payment lines.
  - Added support for customer data in payment.
  - Added support for billing and shipping address in payment.
  - Added support for AfterPay anc Capayable payment methods.
  - Added new WordPress 5.0 post type labels.
  - Removed unused payment processing status.
  - Updated Tippy.js to version 3.3.0.
- Updated WordPress pay AppThemes library from 2.0.1 to version 2.0.2.
- Updated WordPress pay Charitable library from 2.0.0 to version 2.0.1.
- Updated WordPress pay ClassiPress library from 2.0.0 to version 2.0.1.
- Updated WordPress pay Easy Digital Downloads library from 2.0.1 to version 2.0.2.
  - Added support for payment lines.
  - Added Billink and Capayable gateways.
- Updated WordPress pay Event Espresso (legacy) library from 2.0.0 to version 2.1.0.
  - Fixed processing status updates.
  - Added source information filters.
- Updated WordPress pay Formidable Forms library from 2.0.0 to version 2.0.1.
- Updated WordPress pay Give library from 2.0.0 to version 2.0.1.
  - Fixed using default gateway setting.
- Updated WordPress pay Gravity Forms library from 2.1.3 to version 2.1.5.
  - Fixed unintended use of synchronized payment date setting for fixed intervals.
  - Fixed delayed feed action for Gravity Forms Zapier add-on.
  - Fixed fatal error when sending renewal notices.
  - Fixed delayed feed actions for free payments.
- Updated WordPress pay iThemes Exchange library from 2.0.0 to version 2.0.1.
- Updated WordPress pay Jigoshop library from 2.0.0 to version 2.0.1.
- Updated WordPress pay MemberPress library from 2.0.3 to version 2.0.4.
  - Added support for trials with the same length as subscription period.
  - Improve upgrading/downgrading subscriptions.
- Updated WordPress pay Membership library from 2.0.1 to version 2.0.2.
- Updated WordPress pay Restrict Content Pro library from 2.1.0 to version 2.1.1.
  - Use correct initial amount.
  - Fixed duplicate renewal.
- Updated WordPress pay s2Member library from 2.0.0 to version 2.0.1.
  - Renamed menu item from 'iDEAL' to 'Pay'.
- Updated WordPress pay Shopp library from 2.0.0 to version 2.0.1.
- Updated WordPress pay WooCommerce library from 2.0.1 to version 2.0.2.
  - Added AfterPay, Capayable, Focum and Klarna Pay Later payment methods.
  - Renamed Capayable to new brand name In3.
  - Added support for payment lines, shipping, billing and customer data.
- Updated WordPress pay WP e-Commerce library from 2.0.0 to version 2.0.1.
- Updated WordPress pay Buckaroo library from 2.0.0 to version 2.0.1.
- Updated WordPress pay Shopp library from 2.0.0 to version 2.0.1.
- Updated WordPress pay EMS e-Commerce library from 2.0.0 to version 2.0.1.
  - Fix using advanced order ID setting.
- Updated WordPress pay ICEPAY library from 2.0.0 to version 2.0.1.
  - Fixed "Fatal error: Uncaught Exception: MerchantID not valid" in test meta box.
- Updated WordPress pay iDEAL Advanced v3 library from 2.0.1 to version 2.0.2.
- Updated WordPress pay iDEAL Basic library from 2.0.0 to version 2.0.1.
- Updated WordPress pay ING Kassa Compleet library from 2.0.0 to version 2.0.1.
- Updated WordPress pay Mollie library from 2.0.4 to version 2.0.5.
  - Set gateway mode based on API key.
- Updated WordPress pay Mollie iDEAL library from 2.0.0 to version 2.0.1.
- Updated WordPress pay MultiSafepay library from 2.0.2 to version 2.0.3.
- Updated WordPress pay Nocks library from 2.0.0 to version 2.0.1.
- Updated WordPress pay Ogone library from 2.0.0 to version 2.0.1.
- Updated WordPress pay OmniKassa library from 2.0.0 to version 2.0.1.
  - Marked library as deprecated.
- Updated WordPress pay OmniKassa 2.0 library from 2.0.4 to version 2.1.1.
  - Added support for payment lines, shipping, billing and customer data.
  - Improved signature handling.
- Updated WordPress pay Pay.nl library from 2.0.0 to version 2.0.1.
  - Added support for payment lines, shipping, billing and customer data.
  - Added support for AfterPay, Focum, In3 and Klarna Pay Later.
- Updated WordPress pay Sisow library from 2.0.0 to version 2.0.1.
  - Added support for payment lines, shipping, billing and customer data.
  - Added support for Billink and Capayable.
- Updated WordPress pay TargetPay library from 2.0.0 to version 2.0.1.

## [5.4.2] - 2018-09-28

### Changed
- Updated WordPress pay core library from 2.0.7 to version 2.0.8.
  - Updated Tippy.js from 2.6.0 to 3.0.2.

### Fixed
- Updated WordPress pay OmniKassa 2 library from 2.0.3 to version 2.0.4.
  - Remove unused `use` statements.
- Updated WordPress pay Event Espresso library from 2.1.0 to version 2.1.1.
  - Use updated iDEAL gateway class name.
  - Use cards icon as default icon for Pronamic payment method too.
- Updated WordPress pay Gravity Forms library from 2.1.2 to version 2.1.3.
  - Trigger events for field on change.

## [5.4.1] - 2018-09-17

### Fixed
- Updated WordPress pay OmniKassa 2 library from 2.0.2 to version 2.0.3.
  - Fixed - Fatal error: Cannot use Pronamic\WordPress\Pay\Core\Gateway as Gateway because the name is already in use.

## [5.4.0] - 2018-09-14

### Added
- Added support for Ninja Forms.

### Changed
- Updated WordPress pay core library from 2.0.4 to version 2.0.6.
  - Set default status of new payments to 'Open'.
  - Improved support for local float values.
  - Updated Tippy.js from version 2.5.4 to 2.6.0.
- Updated Pronamic WordPress DateTime library from 1.0.1 to version 1.0.2.
  - Fixed issue on PHP 5.6 or lower with empty timezone in `create_from_format` function calls.
- Updated WordPress pay Gravity Forms library from 2.1.1 to version 2.1.2.
  - Improved support for addons with delayed payment integration support.
  - Improved support for delayed Gravity Flow workflows.
- Updated WordPress pay MemberPress library from 2.0.1 to version 2.0.3.
  - Create a 'confirmed' 'subscription_confirmation' transaction for a grace period of 15 days.
  - Added error message on registration form for failed payment.
- Updated WordPress pay Restrict Content Pro library from 2.0.2 to version 2.1.0.
  - Complete rewrite of library.

## [5.3.0] - 2018-08-28

### Changed
- Updated WordPress pay core library to version 2.0.3.
  - New payments with amount equal to 0 (or empty) will now directly get the completed status.
  - Use PHP BCMath library for money calculations when available.
  - Use pronamic/wp-money library to parse money strings.
  - Added Maestro to list of payment methods.
- Updated WordPress pay OmniKassa 2 library to version 2.0.2.
  - Improved webhook handler functions and logging.
  - Improved return URL request handler functions and logging.
  - Store OmniKassa 2.0 merchant order ID in the payment.
- Updated WordPress pay Gravity Forms library to version 2.0.2.
  - Added support for synchronized subscription payment dates.
  - Changed Entry ID prefix field to a Order ID field.
  - Set conditional logic dependency for fields used in payment feed conditions.
  - Added Pronamic subscription amount merge tag `{pronamic_subscription_amount}`.
  - Added support for duplicating payment feeds.
  - Added custom display mode field setting.
  - Improved handling delay actions support.
  - Removed support for "Gravity Forms User Registration Add-On" version < 3.0.
  - The `add_pending_payment` action is no longer triggered for entries without pending payments.
- Updated WordPress pay Easy Digital Downloads library to version 2.0.1.
  - Added fallback to the default Pronamic Pay configuration ID.
  - Prefixed the Pronamic gateways with 'Pronamic - '.
  - Added new payment URL for Easy Digital Downloads version 3.0+.
- Updated WordPress pay Restrict Content Pro library to version 2.0.2.
  - Improved subscription upgrades.
- Updated WordPress pay Mollie library to version 2.0.4.
  - Do not allow .local TLD in webhook URL.
  - Added missing `failed` status.
  - Improved the way we create and handle Mollie customers.
- Updated Pronamic WordPress DateTime library to version 1.0.1.
  - Improved support for timezones.
- Updated Pronamic WordPress Money library to version 1.1.0.
  - Added a money parser class.

## [5.2.0] - 2018-06-21

### Added
- Added support for WordPress core privacy export and erasure feature.

### Changed
- Updated Tippy.js library to version 2.5.3.

## [5.1.0] - 2018-06-04

### Added
- MemberPress - Improved support for MemberPress.

### Fixed
- AppThems - Improve Hirebee theme compatibility.
- Gravity Forms - Fixed using merge tag as order ID.
- Membership - Fixed fatal error "Uncaught Exception: DateInterval::__construct(): Unknown or bad format (P)".
- Mollie - Fixed setting issuer for iDEAL payment method.

## [5.0.1] - 2018-05-16

### Fixed
- Updated WordPress pay iDEAL Advanced v3 library to version 2.0.1.
  - Fixed "Fatal error: Uncaught Error: Call to a member function get_amount() on float".

## [5.0.0] - 2018-05-16

### Changed
- Switched to PHP namespaces.
- Updated WordPress pay ING Kassa Compleet library to version 2.0.
  - Added support for Payconiq payment method.
  - Fixed payment redirect for bank transfer payment method.
- Updated WordPress pay Gravity Forms library to version 2.0.
  - Set Gravity Forms add-on capabilities `gravityforms_pronamic_pay` and  `gravityforms_pronamic_pay_uninstall`.
- Updated WordPress pay Restrict Content Pro library to version 2.0.
  - Add PayPal payment method.
  - Add Direct Debit (mandate via Sofort) payment method.
- Updated WordPress pay WooCommerce library to version 2.0.
  - Add specific payment methods only if activated by configuration.
  - Add Direct Debit (mandate via Sofort) payment method.

## [4.7.0] - 2017-12-12

### Added
- Added WordPress pay OmniKassa 2.0 library version 1.0.0.
- Added WordPress pay Restrict Content Pro library version 1.0.0.

### Changed
- Updated WordPress pay Buckaroo library to version 1.2.9.
  - Added support for PayPal payment method.
- Updated WordPress pay ICEPAY library to version 1.3.1.
  - Set payment success and error return URLs.
- Updated WordPress pay iDEAL Advanced v3 library to version 1.1.11.
  - Fix for a incorrect implementation at https://www.ideal-checkout.nl/simulator/.
  - Some acquirers only accept fingerprints in uppercase.
  - Updated WordPress Coding Standards.
- Updated WordPress pay Mollie library to version 1.1.15.
  - Added support for payment method Direct Debit (mandate via Bancontact).
  - No longer create new Mollie customer during recurring (not first) payments.
  - Update payment consumer BIC from Mollie payment details.
  - Update payment consumer name with Mollie payment card holder name.
  - Cancel subscriptions if first payment fails, to prevent future reactivation when a valid customer ID becomes available.
  - Update subscription status on payment start only if it's not a recurring payment for a cancelled subscription.
- Updated WordPress pay MultiSafepay library to version 2.0.1.
  - Added support for first and last name.
- Updated WordPress pay Pay.nl library to version 1.1.8.
  - Set transaction description.
- Updated WordPress pay Sisow library to version 1.2.3.
  - Added support for bunq payment method.
- Updated WordPress pay TargetPay library to version 1.1.1.
  - WordPress Coding Standards optimizations.
- Updated WordPress pay Charitable library to version 1.1.3.
  - Implemented `get_first_name()` and `get_last_name()`.
  - Use default gateway if no configuration has been set.
- Updated WordPress pay Easy Digital Downloads library to version 1.2.7.
  - Implemented `get_first_name()` and `get_last_name()`.
- Updated WordPress pay Give library to version 1.0.6.
  - Implemented `get_first_name()` and `get_last_name()`.
- Updated WordPress pay Gravity Forms library to version 1.6.7.
  - Implemented `get_first_name()` and `get_last_name()`.
  - Fix possible PHP notices for undefined index `id`.
  - Added support for delaying Sliced Invoices feed processing.
  - Filter payment method choices if not in form editor.
  - Added support for delaying Moneybird feed processing.
  - Simplified merge tag replacement.
- Updated WordPress pay iThemes Exchange library to version 1.1.5.
  - Implemented `get_first_name()` and `get_last_name()`.
- Updated WordPress pay Jigoshop library to version 1.0.6.
  - Implemented `get_first_name()` and `get_last_name()`.
- Updated WordPress pay MemberPress library to version 1.0.5.
  - Added Pronamic gateway.
  - Fixed MemberPress v1.3.18 redirect URL compatibility.
  - Added Bitcoin and PayPal gateways.
  - Updated iDEAL and PayPal icons.
- Updated WordPress pay Membership library to version 1.0.8.
  - Implemented `get_first_name()` and `get_last_name()`.
- Updated WordPress pay s2Member library to version 1.2.7.
  - Add support for recurring payments.
- Updated WordPress pay Shopp library to version 1.0.7.
  - Implemented `get_first_name()` and `get_last_name()`.
- Updated WordPress pay WooCommerce library to version 1.2.8.
  - Added credit card payment fields.
  - Added bunq gateway.
  - Implemented `get_first_name()` and `get_last_name()`.
  - Added `Direct Debit (mandate via Bancontact)` gateway.
  - Added a few `order_button_text` labels.
  - Updated subscription payment data.
  - Set subscription payment method on renewal to account for changed payment method.
  - Improved WooCommerce 3.0 compatibility.
  - Added gateway support for amount and date changes.
  - Clear subscription next payment date on gateway error during payment processing.
- Updated WordPress pay WP eCommerce library to version 1.0.5.
  - Implemented `get_first_name()` and `get_last_name()`.

### Removed
- Removed support for old Qantani platform.

## [4.6.0] - 2017-05-01

### Changed
- Changed plugin name from 'Pronamic iDEAL' to 'Pronamic Pay'.
- Use the new bulk actions WordPress 4.7 filter and remove the edit bulk option.
- Use new register WordPress 4.7 setting feature.
- Added `get_user_id()` to payment data for usage as payment `post_author`.
- Updated WordPress pay Buckaroo library to version 1.2.8.
  - Use custom payment ID field in transaction request/response instead of invoice number.
- Updated WordPress pay EMS e-Commerce library to version 1.0.4.
  - Added missing Bancontact payment method transformation.
  - Added leap of faith payment method support.
- Updated WordPress pay Mollie library to version 1.1.14.
  - Set payment status to `Failed` too if `mollie_error` occurs.
- Updated WordPress pay ING Kassa Compleet library to version 1.0.7.
  - Fixed issuer not set if payment method is not empty.
  - Improved error handling for inactive payment methods.
  - Make payment method required.
- Updated WordPress pay Rabobank - iDEAL Professional - v3 library to version 1.0.2.
  - Added new signing certificate.

## [4.5.5] - 2017-04-18

### Changed
- Don't use global post for WP_Query posts traversal, fix for WooCommerce save order empty address details.
- Updated WordPress pay WooCommerce library to version 1.2.6.
  - Improved support for WooCommerce 3.0.

## [4.5.4] - 2017-04-11

### Changed
- Added PayPal config select options.
- Added Sisow to credit card and Sofort config select options.
- Updated WordPress pay Buckaroo library to version 1.2.7.
  - Use `brq_push` parameter for the Buckaroo Push URL.
- Updated WordPress pay iDEAL Advanced v3 library to version 1.1.10.
  - Removed surrounding quotes from subject, these are already added by `escapeshellarg()`.
- Updated WordPress pay ING - iDEAL Advanced - v3 library to version 1.0.3.
  - Added new signing certificate.
- Updated WordPress pay ING - Kassa Compleet library to version 1.0.6.
  - Only set iDEAL payment method if none set yet.
  - Added two extra payment methods.
- Updated WordPress pay OmniKassa library to version 1.2.3.
  - Fixed incorrect seal calculations.
- Updated WordPress pay Sisow library to version 1.2.2.
  - Added support for PayPal, Sofort and 'leap of faith' payment methods.
- Updated WordPress pay Gravity Forms library to version 1.6.5.
  - Fulfill order with payment status 'Paid'.
  - Prevent sending delayed notification twice.

## [4.5.3] - 2017-03-15

### Changed
- Fixed subscription title link in meta payment subscription.
- Removed amount input `required` attribute with choices.
- Added credit card methods to payment.
- Added Ogone DirectLink to credit card config select options.
- Added `ems-e-commerce` to Bancontact config select options.
- Sanitize instead of validate user input in payment form data.
- Increase delay for first scheduled status check from 30s to 15m.
- Updated WordPress pay core library to version 1.3.12.
  - Make sure payment methods are stored as array in transient.
- Updated WordPress pay EMS e-Commerce library to version 1.0.3.
  - Set decimal and group separators for `chargetotal` parameter according to specs.
  - Added support for Bancontact payment method.
  - No longer filter storename and shared secret setting fields.
- Updated WordPress pay Mollie library to version 1.1.13.
  - Return null if the payment method variable is not a scalar type to fix “Warning: Illegal offset type in isset or empty” error.
  - No longer check if $payment_method is a empty string, the compare on the mandate method is enough.
  - Set default payment method to null in `has_valid_mandate` function.
  - Improved getting the first valid mandate date time.
  - Ignore valid mandates for first payments.
- Updated WordPress pay Ogone library to version 1.3.4.
  - Only set credit card data if we have it.
- Updated WordPress pay OmniKassa library to version 1.2.2.
  - Set payment transaction ID to transaction reference (e.g. for payment notes and merge tags).
  - Added support for Maestro payment method.
  - Default order ID uses payment ID in `format_string()`.
- Updated WordPress pay Gravity Forms library to version 1.6.4.
  - Updated new feed URL link in payment fields.
  - Only load the payment methods field if Gravity Forms version is > 1.9.19.
  - Simplified loading and setting up the Gravity Forms extension with a early return.
  - Fixed 'Warning: Missing argument 3 for gf_apply_filters()'.
  - Added support for delaying ActiveCampaign subscriptions.
  - Use version compare helper to prevent fatal errors.
- Updated WordPress pay ClassiPress library to version 1.0.4.
  - Fixed “Fatal error: Uncaught Error: Using $this when not in object context”.
- Updated WordPress pay WooCommerce library to version 1.2.5.
  - Don't set subscriptions 'on hold' due to delay in direct debit status update.
  - Removed gateway description about valid mandate, as these mandates are no longer in use.

## [4.5.2] - 2017-02-13

### Changed
- Updated WordPress pay Gravity Forms library to version 1.6.2.
  - No longer check on the payment feed post ID, a empty payment feed post ID is allowed when creating new payment feeds.
  - Auto enable new payment feeds.
  - Make `is_active` backwards compatible when getting feeds.
  - Added support for No Conflict Mode.

## [4.5.1] - 2017-02-09

### Changed
- Updated WordPress pay Gravity Forms library to version 1.6.1.
  - Only check admin referer for payment feeds and not when saving/testing configurations.

## [4.5.0] - 2017-02-08

### Changed
- Updated WordPress pay core library to version 1.3.11.
  - Added new constant for the KBC/CBC Payment Button payment method.
  - Added new constant for the Belfius Direct Net payment method.
- Updated WordPress pay EMS e-Commerce Gateway library to version 1.0.2.
  - Make sure always the same transaction date time is used.
  - Make sure to not encode quotes.
- Updated WordPress pay ICEPAY library to version 1.3.0.
  - Added order ID setting.
- Updated WordPress pay Mollie library to version 1.1.12.
  - Enabled support for more Mollie payment methods.
  - Auto renew invalid customer IDs.
  - Only update subscription status for subscriptions.
  - Added filter for payment provider URL.
  - Removed deprecated MISTER_CASH from the get_supported_payment_methods function.
- Updated WordPress pay Charitable library to version 1.1.1.
  - Added filter for payment source URL and description.
  - Added process_donation() method to make sure Pronamic gateway works correctly.
- Updated WordPress pay ClassiPress library to version 1.0.3.
  - Updated dev libraries.
  - Simplified adding hooks.
  - Added filter for payment source description and URL.
  - Added a extra filter for the payment redirect URL.
  - Always redirect to the pay redirect URL.
- Updated WordPress pay Easy Digital Downloads library to version 1.2.6.
  - Added Bank Transfer gateway.
  - Added Bitcoin gateway.
  - Added filter for payment source description and URL.
  - Changed to class functions.
  - Added new icons for Bitcoin and Soft.
- Updated WordPress pay Event Espresso library to version 1.1.6.
  - Added filter for payment source description and URL.
- Updated WordPress pay Formidable Forms library to version 1.0.2.
  - Added filter for payment source link and description.
- Updated WordPress pay Give library to version 1.0.5.
  - Added filter for payment source description and URL.
- Updated WordPress pay Gravity Forms library to version 1.6.0.
  - Added support for subscriptions.
  - Added temporary pay feeds moved notice.
  - Added filter function for the payment source description.
  - Added filter for source URL.
- Updated WordPress pay iThemes Exchange library to version 1.1.4.
  - Added filter for payment source description.
- Updated WordPress pay Jigoshop library to version 1.0.5.
  - Added filter for payment source description and URL.
  - Simplified gateway by always redirecting to the pay URL.
- Updated WordPress pay MemberPress library to version 1.0.4.
  - Use MeprUtils class for sending transaction notices (Zendesk #10084).
  - No longer echo invoice in payment redirect function.
  - Added filter payment source description and URL.
  - Use credit card alias instead of Sofort in credit card gateway.
- Updated WordPress pay Membership library to version 1.0.7.
  - Added filter for payment source description and URL.
- Updated WordPress pay s2Member library to version 1.2.6.
  - Added filter payment source description.
- Updated WordPress pay Shopp library to version 1.0.6.
  - Added filter for payment source description and URL.
- Updated WordPress pay WooCommerce library to version 1.2.4.
  - Added KBC/CBC Payment Button gateway.
  - Added Belfius Direct Net gateway.
  - Added filter for payment source description and URL.
- Updated WordPress pay WP eCommerce library to version 1.0.4.
  - Added filter for payment source description and URL.

## [4.4.4] - 2016-11-16

### Added
- Added support for Maestro payment method with OmniKassa.
- Updated WordPress pay core library to version 1.3.10.
  - Added new constant for the Maestro payment method.
- Added custom post updated messages for payment post type.

### Changed
- Improved and simplified SASS/CSS for WordPress admin elements.
- Changed Mastercard icon.
- Improved support for setting default gateway on WP-CLI.
- Simplified `format_string()` replacements.
- Updated WordPress pay iDEAL Advanced v3 library to version 1.1.9.
  - Simplified settings fields.
- Updated WordPress pay Mollie library to version 1.3.3.
  - Improved Client class, DRY improvements.
  - Added constants for some extra methods.
- Updated WordPress pay OmniKassa library to version 1.2.1.
  - Added support for Maestro payment method.
  - Default order ID uses payment ID in `format_string()`.
- Updated WordPress pay Charitable library to version 1.1.0.
  - Updated gateway system to Charitable version 1.3+.
- Updated WordPress pay Gravity Forms library to version 1.5.2.
  - Simplified CSS for WordPress admin elements.
  - Enabled choice values for payment methods field.
- Updated WordPress pay WooCommerce library to version 1.2.2.
  - Added Maestro gateway.
  - Filter gateway description to show mandate notice also when description is empty.

### Fixed
- Updated WordPress pay Give library to version 1.0.4.
  - Display payment input fields also if guest donations are not allowed and registration and/or login forms are displayed.

### Removed
- Removed own definition of the `wp_slash` function, this plugin requires already WordPress 4.3 or higher, this function is part of WordPress since 3.6.
- Updated WordPress pay Ogone library to version 1.3.3.
  - Removed specific ABN AMRO iDEAL Easy PSPID test description.

## [4.4.3] - 2016-11-02

### Changed
- Updated WordPress pay MultiSafepay library to version 2.0.0.

## [4.4.2] - 2016-11-02

### Fixed
- Fix "Fatal error: Can't inherit abstract function Pronamic_Pay_PaymentDataInterface::get_subscription_id() (previously declared abstract in Pronamic_Pay_AbstractPaymentData)".
- Check if subscription id is empty instead of an empty string (can be null too).

## [4.4.1] - 2016-10-28

### Fixed
- Fixed styling of recurring icon in the WordPress admin payments overview page.
- Fixed `format_price` function if a non float value is passed in.
- Updated WordPress pay iDEAL Advanced v3 library to version 1.1.8.
  - Fixed zero days private certificate validity in OpenSSL command.

### Changed
- Changed version number in `wp_register_style` and `wp_register_script` function calls.
- Simplified the status icons CSS and related code.
- Updated WordPress pay Gravity Forms library to version 1.5.1.
  - Changed Gravity Forms admin menu item text 'iDEAL' to 'Payment Feeds'.
  - Changed text 'Payment Form(s)' to 'Payment Feed(s)'.

## [4.4.0] - 2016-10-27

### Added
- Added experimental support for subscriptions / recurring payments (WooCommerce Subscriptions).
- Added check status button on the WordPress admin edit payment page.
- Added custom capabilities for the custom post types.

### Changed
- Changed WordPress admin menu name from 'iDEAL' to 'Pay'.
- Changed WordPress admin menu icon from iDEAL icon to dash icon 'money'.
- Updated WordPress pay core library to version 1.3.9.
- Updated WordPress pay ABN AMRO - iDEAL Easy library to version 1.0.4.
- Updated WordPress pay ABN AMRO - iDEAL Zelfbouw - v3 library to version 1.0.5.
- Updated WordPress pay ABN AMRO - Internetkassa library to version 1.0.2.
- Updated WordPress pay Buckaroo library to version 1.2.6.
  - Fixed unable to use payment method 'All available methods'.
  - Added new Bancontact constant.
  - Fixed `Fatal error: Call to undefined method Pronamic_WP_Pay_Gateways_Buckaroo_Client::get_error().`
- Updated WordPress pay Deutsche Bank - iDEAL Expert - v3 library to version 1.0.3.
- Updated WordPress pay Deutsche Bank - iDEAL via Ogone library to version 1.0.2.
- Updated WordPress pay EMS e-Commerce library to version 1.0.1.
  - Added transaction feedback status setting.
  - Fixed - Too many arguments for function "__".
- Updated WordPress pay ICEPAY library to version 1.2.9.
  - Added support for new Bancontact constant.
- Updated WordPress pay iDEAL library to version 1.1.5.
- Updated WordPress pay iDEAL Advanced v3 library to version 1.1.7.
- Updated WordPress pay iDEAL Basic library to version 1.1.6.
- Updated WordPress pay ING - iDEAL Advanced - v3 library to version 1.0.2.
- Updated WordPress pay ING Kassa Compleet library to version 1.0.5.
- Updated WordPress pay Mollie library to version 1.1.9.
  - Fixed wrong char in switch statement.
  - Added support for new Bancontact constant.
  - Use separate customer IDs for test and live mode.
- Updated WordPress pay Mollie iDEAL library to version 1.0.7.
- Updated WordPress pay MultiSafepay Connect library to version 1.3.0.
  - Improved error reporting.
- Updated WordPress pay Ingenico/Ogone library to version 1.3.2.
  - Added `payment_status_request` feature support.
  - Updated SHA-IN parameters list from ingenico.com.
  - Updated SHA-OUT parameters list from ingenico.com.
  - Removed schedule status check event, this will be part of the Pronamic iDEAL plugin.
  - Use new `$payment->format_string()` function, and remove util function.
  - Added support for new Bancontact constant.
  - Fixed method `get_default_form_action_url()` visibility.
  - Added support for form action URL for OrderStandard Easy.
- Updated WordPress pay OmniKassa library to version 1.2.0.
- Updated WordPress pay Pay.nl library to version 1.1.7.
  - Added `payment_status_request` feature support.
  - Fixed "urlencode should only be used when dealing with legacy applications, rawurlencode() should now be used instead".
  - Removed schedule status check event, this will be part of the Pronamic iDEAL plugin.
  - Added end user name and e-mail address to transaction.
  - Added support new Bancontact constant.
  - Don't schedule `pronamic_ideal_check_transaction_status` event on transaction error.
- Updated WordPress pay Qantani library to version 1.1.0.
- Updated WordPress pay Sisow library to version 1.2.1.
  - Only send status check if transaction ID is not empty.
  - Added feature support payment_status_request.
  - Added support for new Bancontact constant.
- Updated WordPress pay AppThemes library to version 1.0.5.
- Updated WordPress pay Charitable library to version 1.0.5.
  - Added cancel URL.
  - Added Pronamic gateway usage clarification
  - Added transaction description setting.
  - Make use of new Bancontact label and constant.
  - Ensure that the filter returns a value to avoid breaking other Charitable extensions that implement their own custom templates for certain form fields.
- Updated WordPress pay Easy Digital Downloads library to version 1.2.5.
- Updated WordPress pay Event Espresso library to version 1.1.5.
  - Use payment redirect URL.
  - Added help text with available tags.
  - Added support for custom transaction descriptions.
- Updated WordPress pay Give library to version 1.0.3.
  - Use 'donation' instead of 'transaction' in transaction description.
  - Added Pronamic gateway usage clarification.
  - Added transaction description setting.
  - Use new Bancontact label and constant.
- Updated WordPress pay Gravity Forms library to version 1.5.0.
  - Implemented the new pronamic_payment_redirect_url filter and added some early returns.
  - Fixed deprecated usage of GFUserData.
  - Refactored custom payment fields.
- Updated WordPress pay MemberPress library to version 1.0.3.
  - Added membership slug to thank you page URL.
  - Maybe cancel old subscriptions and send notices.
  - Make use of new Bancontact label and constant.
  - Use MemberPress transaction number in 'Thank you' redirect instead of payment source ID.
- Updated WordPress pay Membership library to version 1.0.6.
- Updated WordPress pay s2Member library to version 1.2.5.
  - Added support for payment method in shortcode.
- Updated WordPress pay WooCommerce library to version 1.2.1.
  - Added experimental support for WooCommerce Subscriptions / recurring payments.
  - Restore compatibility with WooCommerce versions < 2.2.0.
  - Switched to new Bancontact logo.
  - Added Bitcoin gateway.
- Updated WordPress pay WP eCommerce library to version 1.3.9.

## [4.3.0] - 2016-07-06

### Added
- Added WordPress pay EMS e-Commerce Gateway library version 1.0.0.

### Changed
- Updated WordPress pay iDEAL Advanced library to version 1.1.6.
  - Adjusted check on required distinguished name keys/values.
  - Added some early returns + escapeshellarg calls.
- Updated WordPress pay Mollie library to version 1.1.8.
  - Added PayPal to gateway methods transformations.
  - Fixed undefined variable `$user_id`.
- Updated WordPress pay Ogone library to version 1.3.1.
  - Get payment ID from request data.
- Updated WordPress pay iThemes Exchange library to version 1.1.3.
  - Fixed Membership add-on support.
- Updated WordPress pay Jigoshop library to version 1.0.4.
  - Use iDEAL payment method when payment method is required, but not set.
- Updated WordPress pay Gravity Forms library to version 1.4.8.
  - Added support for filtering payment data with `gform_post_save`.

## [4.2.3] - 2016-06-14

### Added
- Updated WordPress pay Sisow library to version 1.2.0.
  - Add support for bank transfer payment method

### Fixed
- Updated WordPress pay OmniKassa library to version 1.1.9.
- Updated WordPress pay Buckaroo library to version 1.0.4.

## [4.2.2] - 2016-06-10

### Fixed
- Updated WordPress pay Sisow library to version 1.1.9.

## [4.2.1] - 2016-06-09

### Fixed
- Updated WordPress pay AppThemes library to version 1.0.4.

## [4.2.0] - 2016-06-08

### Changed
- Updated WordPress pay core library to version 1.0.3.
  - Added PayPal payment method constant.
  - Simplified the gateway payment start function.
  - Added new constant for Bancontact payment method.
  - Fixed text domain for translations.
- Updated WordPress pay ICEPAY library to version 1.2.8.
- Updated WordPress pay iDEAL library to version 1.1.4.
- Updated WordPress pay iDEAL Advanced v3 library to version 1.1.5.
- Updated WordPress pay iDEAL Simulator - iDEAL Professional / Advanced / Zelfbouw - v3 library to version 1.0.2.
  - Changed payment URL from `https://www.ideal-simulator.nl/professional/` to `https://www.ideal-checkout.nl/simulator/`.
- Updated WordPress pay ING Kassa Compleet library to version 1.0.4.
- Updated WordPress pay Mollie library to version 1.1.6.
  - Added support for Mollie Checkout.
  - Reduced the use of else expressions.
  - Added WordPress payment method to Mollie method transform function.
  - Added readonly Mollie user profile fields.
  - Simplified the gateway payment start function.
- Updated WordPress pay MultiSafepay Connect library to version 1.2.9.
- Updated WordPress pay Ogone library to version 1.3.0.
- Updated WordPress pay OmniKassa library to version 1.1.8.
- Updated WordPress pay Pay.nl library to version 1.1.6.
- Updated WordPress pay Qantani library to version 1.0.9.
- Updated WordPress pay Sisow library to version 1.1.8.
- Updated WordPress pay TargetPay library to version 1.0.9.
- Updated WordPress pay AppThemes library to version 1.0.3.
  - Added Bancontact gateway.
  - Added Bank Transfer gateway.
  - Added Credit Card gateway.
  - Added Direct Debit gateway.
  - Added SOFORT Banking gateway.
- Updated WordPress pay Give library to version 1.0.2.
- Updated WordPress pay Gravity Forms library to version 1.4.7.
  - Set link type to confirmation if set and no URL or page have been set.
  - Cleaned up feed config (tabs, descriptions, tooltips, update confirmations if form changes).
  - Added icon and 'Add new' link to payment addon settings page.
  - Added Merge Tag button to transaction description field (without AJAX form change support).
  - Switched to use of `GF_Field` class.
  - Fixed text domain, `pronamic-ideal` is `pronamic_ideal`.
- Updated WordPress pay MemberPress library to version 1.0.2.
  - Added support for gateway input fields.
  - Added a iDEAL icon to the iDEAL gateway.
  - Only use MeprTransaction object in payment data constructor, remove unused variable `$product`.
- Updated WordPress pay WooCommerce library to version 1.2.0.
  - Added PayPal gateway.

## [4.1.1] - 2016-05-06

### Changed
- Show gateway errors on the edit gateway configuration admin page.
- Updated WordPress pay core library to version 1.3.6.
- Updated WordPress pay Pay.nl library to version 1.1.5.

## [4.1.0] - 2016-04-13

### Added
- Added support for bulk action check payment status.

### Changed
- Use HTTPS in Facebook iframe source URL
- Updated WordPress pay ABN AMRO - iDEAL Easy library to version 1.0.3.
- Updated WordPress pay Buckaroo library to version 1.2.4.
  - Added support for iDEAL issuer.
- Updated WordPress pay ING - iDEAL Advanced - v3 library to version 1.0.1.
- Updated WordPress pay MultiSafepay Connect library to version 1.2.8.
- Updated WordPress pay Ogone library to version 1.2.8.
  - Added support for custom Ogone e-Commerce form action URL.
  - Renamed OrderStandard to 'e-Commerce'.
- Updated WordPress pay AppThemes library to version 1.0.2.
- Updated WordPress pay Charitable library to version 1.0.4.
- Updated WordPress pay ClassiPress library to version 1.0.2.
- Updated WordPress pay Easy Digital Downloads library to version 1.2.4.
- Updated WordPress pay Event Espresso library to version 1.1.4.
- Updated WordPress pay Event Espresso (legacy) library to version 1.0.3.
- Updated WordPress pay Give library to version 1.1.4.
  - Improved error handling.
  - Refactored class construct gateways.
  - Empty unused get URL functions.
- Updated WordPress pay Gravity Forms library to version 1.4.6.
- Updated WordPress pay iThemes Exchange library to version 1.1.2.
- Updated WordPress pay Jigoshop library to version 1.0.3.
- Updated WordPress pay JobRoller library to version 1.0.1.
- Updated WordPress pay MemberPress library to version 1.0.1.
  - Implemented new redirect system.
  - No longer use camelCase for payment data.
  - Redirect to payment form action if payment was unsuccessful.
  - Fixed number of arguments passed to send_product_welcome_notices().
- Updated WordPress pay Membership library to version 1.0.5.
  - Update URLs in payment data.
  - Extend iDEAL gateway from Pronamic gateway and only use status_update() in Extension.php
  - No longer use camelCase for payment data.
- Updated WordPress pay s2Member library to version 1.2.3.
- Updated WordPress pay Shopp library to version 1.0.4.
- Updated WordPress pay WooCommerce library to version 1.1.8.
  - Check existence of WC_Order::has_status() to support older versions of WooCommerce.
  - No longer use camelCase for payment data.
  - Add clarification to Pronamic gateway with difference compared to regular payment method specific gateways.
  - Fix adding 'Awaiting payment' order note if order status is already pending.
- Updated WordPress pay WP eCommerce library to version 1.0.3.

### Removed
- Removed support for deprecated 'ING - iDEAL Internet Kassa' integration.
- Removed 'bold' font weight from active tab item.
- Removed unused class Pronamic_WP_Pay_PaymentInputData.
- Removed border on div.extra-settings for smaller displays.

## [4.0.0] - 2016-03-24

### Added
- Added experimental support for Give.
- Added tabs to the gateway configuration edit page.
- Added return URL to admin payment detail page.
- Added redirect URL to admin payment detail page.

### Changed
- Updated WordPress pay Gravity Forms library to version 1.4.5.
  - Added support for merge tag 'pronamic_payment_id'.
  - Added ability to use Gravity Forms confirmations (with merge tag support) as payment status page.
- Updated WordPress pay Membership library to version 1.0.4.
  - Always use Membership gateway live mode.
  - Display gateway error messages.
  - Added support for issuer input field.
  - Added support for button image URL and description to iDEAL gateway.
- Updated WordPress pay Jigoshop library to version 1.0.2.
  - Removed status code from redirect in update_status.
- Updated WordPress pay Jigoshop library to version 1.0.1.
  - Removed status code from redirect in status_update.
- Updated WordPress pay WooCommerce library to version 1.1.7.
  - Redirect to payment options instead of 'Order received' if payment is not yet completed.
  - Implemented new payment redirect URL filter.
  - Use the global default config as the WooCommerce default config.
- Updated WordPress pay Formidable Forms library to version 1.0.1.
  - Added support for transaction description.
- Updated WordPress pay Easy Digital Downloads library to version 1.2.3.
  - Tested Easy Digital Downloads version 2.5.9.
  - Set global WordPress gateway config as default config in gateways.
  - Use new redirect URL filter.
  - Return to checkout if there is no gateway found.
- Updated WordPress pay Charitable library to version 1.0.3.
  - Changed the default return URL to the campaign URL.
  - Use new redirect URL filter.
- Updated WordPress pay OmniKassa library to version 1.1.7.
  - Added advanced 'Order ID' setting.
- Updated WordPress pay ING Kassa Compleet library to version 1.0.3.
  - Added webhook listener.
  - Added scheduled events to check transaction status.
- Updated WordPress pay Buckaroo library to version 1.2.3.
  - Updated gateway settings and add support for 'brq_excludedservices' parameter.
  - Added advanced setting for 'brq_invoicenumber' parameter.
- Updated WordPress pay Pay.nl library to version 1.1.4.
  - Added scheduled transaction status request.
- Updated WordPress pay Ogone library to version 1.2.8.
  - Use UTF-8 URL when blog charset is UTF-8.
- Updated WordPress pay Mollie library to version 1.1.5.
  - Added support for bank transfer and direct debit payment methods.
- Updated WordPress pay iDEAL Basic library to version 1.1.4.
  - Fixed typo 'xml_notifaction' in listener parameter.
- Updated WordPress pay iDEAL Advanced v3 library to version 1.1.4.
  - Updated gateway settings, including private key and certificate generation.
  - Added error details to error message.

## [3.9.0] - 2016-03-02

### Added
- Added experimental support for Formidable Forms.
- Added support for new Qantani platform via Mollie.

### Removed
- Removed support for deprecated 'iDEAL Simulator - iDEAL Professional / Advanced / Zelfbouw' integration.
- Removed support for deprecated 'Mollie - iDEAL Advanced' integration.
- Removed support for deprecated 'Sisow - iDEAL Advanced' integration.

## [3.8.9] - 2016-02-12

### Changed
- Do not show 'Add New' button in admin for pronamic_payment post type.

### Fixed
- Updated WordPress pay ABN AMRO - iDEAL Easy library to version 1.0.1.
  - Extend from the Ingenico/Ogone Easy config class.
- Updated WordPress pay Gravity Forms library to version 1.4.2.
  - Renamed 'iDEAL Fields' to 'Payment Fields' since it's more then iDEAL.
  - Fixed typo `sprint` to `sprintf`.
- Updated WordPress pay ClassiPress library to version 1.0.1.
  - Removed status code from redirect in update_status.
- Updated WordPress pay iThemes Exchange library to version 1.1.1.
  - WordPress Coding Standards optimizations.
  - Added escaping functions to improve security.
  - Changed h2 element to h1 element on admin settings page.
  - Add support for payment methods, improve error reporting.
  - Added order ID to payment description.
  - Removed status code from redirect in status_update.
- Updated WordPress pay Shopp library to version 1.0.3.
  - WordPress Coding Standards optimizations.
  - Added support for payment methods, improved error reporting.
  - Removed status code from redirect in status_update.
- Updated WordPress pay WP eCommerce library to version 1.0.2.
  - WordPress Coding Standards optimizations.
  - Removed status code from redirect in status_update.
  - Added Pronamic gateway, with payment method selector in plugin settings.
  - iDEAL gateway now uses the iDEAL payment method.

## [3.8.8] - 2016-02-11

### Fixed
- Updated WordPress pay Sisow library to version 1.1.5.
  - Use iDEAL payment method also if none set in issuer field.
- Updated WordPress pay s2Member library to version 1.2.2.
  - Fixed 'Notice: Undefined index: orderID'.
  - Fixed password not included in registration confirmation.
  - Added support for payment method in shortcode.
  - Removed status code from redirect in status_update.
- Updated WordPress pay Event Espresso library to version 1.1.5.
  - Fix only first payment updates EE transaction.
  - Set default payment method to iDEAL if required.
  - Added iDEAL gateway and payment method.
  - Removed status code from redirect in status_update.
- Updated WordPress pay Event Espresso (legacy 3.1) library to version 1.0.2.
  - Removed status code from redirect.

## [3.8.7] - 2016-02-10

### Changed
- Updated WordPress pay Ogone library to version 1.2.6.
  - Use PARAMPLUS for the payment ID.
- Updated WordPress pay Sisow library to version 1.1.4.
  - Set default payment method to iDEAL if none set.

## [3.8.6] - 2016-02-05

### Fixed
- Updated WordPress pay ABN AMRO - iDEAL Zelfbouw - v3 library to version 1.0.2.
  - Switched test and production URL's in config classes.

## [3.8.5] - 2016-02-05

### Fixed
- Updated WordPress pay ABN AMRO - iDEAL Zelfbouw - v3 library to version 1.0.1.
  - Make sure to use the iDEAL Advanced v3 config class.
- Updated WordPress pay Deutsche Bank - iDEAL Expert - v3 library to version 1.0.1.
  - Make sure to use the iDEAL Advanced v3 config class.

## [3.8.4] - 2016-02-05

### Removed
- Removed the deprecated Rabobank - iDEAL Lite library.
- Removed the deprecated Rabobank - Rabo iDEAL Kassa library.
- Removed the deprecated Rabobank - iDEAL Professional library.
- Removed the deprecated PayDutch library.
- Removed the deprecated NEOS - Internet Kassa library.
- Removed the deprecated ING - iDEAL Advanced library.
- Removed the deprecated Friesland Bank - iDEAL Zakelijk library.
- Removed the deprecated Friesland Bank - iDEAL Zakelijk Plus library.
- Removed the deprecated Friesland Bank - iDEAL Zakelijk Plus - v3 library.
- Removed the deprecated Fortis Bank - iDEAL Integrated library.
- Removed the deprecated Fortis Bank - iDEAL Internet Kassa library.
- Removed the deprecated Fortis Bank - iDEAL Hosted library.
- Removed the deprecated ABN AMRO - iDEAL Zelfbouw library.
- Removed the deprecated ABN AMRO - iDEAL Hosted library.

### Fixed
- Updated WordPress pay Sisow library to version 1.1.3.
  - Fixed 'Fatal error: Call to a member function set_payment_method() on null'.
- Updated WordPress pay Gravity Forms library to version 1.4.1.
  - Fixed 'Warning: Invalid argument supplied for foreach() on line 200'.
- Fixed 'Fatal error: Function name must be a string in admin/meta-box-gateway-config.php on line 285.'

## [3.8.3] - 2016-02-04

### Fixed
- Updated WordPress pay core library to version 1.3.3.
  - Readded the MiniTix payment method constant for backwards compatibility.
- Updated WordPress pay Easy Digital Downloads library to version 1.2.2.
  - Removed discontinued MiniTix gateway.
  - Removed status code from redirect in status_update.
- Updated WordPress pay Charitable library to version 1.0.1.
  - Removed discontinued MiniTix gateway

## [3.8.2] - 2016-02-03

### Fixed
- Updated WordPress pay ING Kassa Compleet library to version 1.0.1.
  - Fixed fatal error 'Can't use function return value in write context'.

## [3.8.1] - 2016-02-02

### Fixed
- Updated WordPress pay Membership library to version 1.0.3.
  - Fixed fatal error 'Can't use function return value in write context'.

### Changed
- Updated WordPress pay WooCommerce library to version 1.1.6.
  - Added support for WooCommerce Deposits plugin.

## [3.8.0] - 2016-02-02

### Changed
- Removed discontinued MiniTix gateway.
- Updated WordPress pay Buckaroo library to version 1.2.0.
  - Renamed namespace prefix from 'class Pronamic_WP_Pay_Buckaroo_' to 'Pronamic_WP_Pay_Gateways_Buckaroo_'.

## [3.7.3] - 2015-10-19

### Fixed
- Fixed Fatal error: Call to a member function get_input_fields() on null on payment form without an valid gateway configuration.

### Changed
- Updated WordPress pay Ogone library to version 1.2.4.
  - Fixed Strict standards: Declaration of Pronamic_WP_Pay_Gateways_Ogone_OrderStandardEasy_Gateway should be compatible with Pronamic_WP_Pay_Gateway::start().
- Updated WordPress pay TargetPay library to version 1.0.4.
  - Fixed some issues on the TargetPay library.
  - Fixed Strict standards: Declaration of Pronamic_WP_Pay_Gateways_TargetPay_Gateway::start().
- Updated WordPress pay Gravity Forms library to version 1.3.2.
  - Fix missing issuer dropdown in form editor and front end for feeds with condition enabled.
  - No longer use an custom query to get the pay Gravity Forms posts.
  - Added an extra parameter to retrieve payments feed with an gateway with iDEAL issuers.
  - No longer redirect with 303 status code.
- Updated WordPress pay WooCommerce library to version 1.1.5.
  - Removed status code 303 from redirect.

## [3.7.2] - 2015-10-19

### Changed
- Also show payments post with the post status 'publish' on the WordPress admin payments page.
- Updated WordPress pay ICEPAY library to version 1.2.4.
  - Fixed fatal error with wrong constant usage.
- Updated WordPress pay Qantani library to version 1.0.5.
  - Fixed strict comparison issue on XML status element.
- Updated WordPress pay Easy Digital Downloads library to version 1.2.1.
  - Set the payment method to use before getting the gateway inputs.

### Fixed
- Fixed NOTICE: Undefined property: Pronamic_WP_Pay_LicenseManager::$response.

## [3.7.1] - 2015-10-15

### Changed
- Updated WordPress pay core library to version 1.2.2.
  - Add payment method 'Bank transfer'.

## [3.7.0] - 2015-10-15
- Fix transaction status checking event not 'renewed'.
- Prevent redirects from within extensions if doing cron, so that events get scheduled in check_status.

### Changed
- Updated WordPress pay Buckaroo library to version 1.1.2.
  - Fix incorrect signature due to slashes in data.
- Updated WordPress pay ICEPAY library to version 1.2.2.
  - Make sure to use language and country values from payment data object.
- Updated WordPress pay Mollie library to version 1.1.2.
  - Add support for direct iDEAL payment method.
- Updated WordPress pay MultiSafepay Connect library to version 1.2.3.
  - Add support for bank transfer as payment method.
- Updated WordPress pay OmniKassa library to version 1.1.3.
  - Add locale helper to prevent sending unsupported language codes.
  - Add filter pronamic_pay_omnikassa_payment_mean_brand_list.
  - Handle response NUMBER_ATTEMPT_EXCEEDED as failure status.
- Updated WordPress pay TargetPay library to version 1.0.3.
  - Add scheduled transaction status request.
- Updated WordPress pay Event Espresso library to version 1.1.2.
  - Fix sending multiple notifications.
- Updated WordPress pay Gravity Forms library to version 1.3.1.
  - Add support for multiple payment feeds with conditions per form.
  - Only use visible issuer dropdowns (allows conditional logic on issuer dropdown field.
- Updated WordPress pay s2Member library to version 1.2.1.
  - Fix incorrect period naming.
- Updated WordPress pay WooCommerce library to version 1.1.3.
  - Order note "iDEAL payment [status]" now includes the gateway title, instead of "iDEAL".
  - Add DirectDebitGateway.
  - Add bank transfer gateway.
- Updated WordPress pay Ogone library to version 1.2.2.
  - Added support for the Ogone TP parameter.
- Updated WordPress pay Ogone library to version 1.2.3.
  - Added support for the direct payment method credit card.
  - Added support for the direct payment method iDEAL.

## [3.6.6] - 2015-06-29

### Changed
- Updated WordPress pay Gravity Forms library to version 1.3.0.
  - Added support for Gravity Forms AWeber Add-On version 2.2.1.
  - Added support for Gravity Forms Campaign Monitor Add-On version 3.3.2.
  - Added support for Gravity Forms MailChimp Add-On version 3.6.3.
- Updated WordPress pay Membership library to version 1.0.1.
  - Fixed WordPress callback for the admin settings section.

## [3.6.5] - 2015-06-15

### Changed
- Improved support for the W3 Total Cache plugin.

### Fixed
- Fix JobRoller class name on admin tab 'Extensions'.

## [3.6.4] - 2015-05-26

### Changed
- Updated WordPress pay AppThemes library to version 1.0.0.
- Updated WordPress pay ClassiPress library to version 1.0.0.
- Updated WordPress pay iThemes Exchange library to version 1.1.0.
- Updated WordPress pay JobRoller library to version 1.0.0.
- Updated WordPress pay Membership library to version 1.0.0.
- Updated WordPress pay WP e-Commerce library to version 1.0.0.
- Updated WordPress pay Gravity Forms library to version 1.2.4.
  - Only process payments if amount is higher than zero.
- Updated WordPress pay Sisow library to version 1.1.0.
  - Added support for Shop ID.
- Updated WordPress pay Shopp library to version 1.0.2.
  - Added missing file GatewayModule.php for Shopp < 1.3 support.
- Minified all images.

## [3.6.3] - 2015-05-08
- No longer include all development Composer packages.
- Updated WordPress pay MultiSafepay Connect library to version 1.2.1.
  - Fix fatal error due to undefined var $result.

## [3.6.2] - 2015-05-06
- Updated WordPress pay core library to version 1.2.1.
  - Added XML utility class.
- Updated WordPress pay WooCommerce library to version 1.1.2.
  - Added general Pronamic gateway so the iDEAL gateway can be used for iDEAL only.
- Updated WordPress pay s2Member library to version 1.2.0.
  - Added experimental support for `ccaps` in shortcode.
  - Added settings field for the signup confirmation email message.
  - Added HTML admin views from the Pronamic iDEAL plugin.
- Updated WordPress pay MultiSafepay Connect library to version 1.2.0.
  - Added support for direct transaction request for iDEAL.

## [3.6.1] - 2015-04-02
- Updated WordPress pay Event Espresso library to version 1.1.1.
  - Updated WordPress pay core library to version 1.2.0.
  - No longer parse HTML input fields but use the new get_output_fields() function.
  - Added workaround for strange behaviour with 2 config select options.
- Updated WordPress pay Gravity Forms library to version 1.2.3.
  - Entry with payment status 'Paid' are now also seen as 'approved'.
  - Use entry ID as default transaction description.
  - WordPress Coding Standards optimizations.
- Updated WordPress pay Qantani library to version 1.0.2.
  - No longer disable SSL verify.

## [3.6.1] - 2015-04-02
- Tweak - Updated WordPress pay Easy Digital Downloads library to version 1.1.0.
  - Added Credit Card gateway.
  - Added Direct Debit gateway.
  - Added iDEAL gateway.
  - Added MiniTix gateway.
  - Added Bancontact/Mister Cash gateway.
  - Added SOFORT Banking gateway.
  - Added gateway setting for the checkout label.
  - Only show transaction ID if set.
  - Added pending payment note with link to payment post.
  - Tested on Easy Digital Downloads version 2.3.
- Tweak - Updated WordPress pay Event Espresso library to version 1.1.0.
  - Added experimental support for Event Espresso 4.6 (or higher).

## [3.5.2] - 2015-03-09
- Tweak - Updated WordPress pay iDEAL library to version 1.1.0.
  - Added an utility class which can create purchase ID's.
- Tweak - Updated WordPress pay iDEAL Basic library to version 1.1.0.
  - Improved support for user defined purchase ID's.
- Tweak - Updated WordPress pay iDEAL Advanced v3 library to version 1.1.0.
  - Improved support for user defined purchase ID's.
- Tweak - Updated WordPress pay iDEAL Advanced library to version 1.1.0.
  - Improved support for user defined purchase ID's.

## [3.5.1] - 2015-03-03
- Tweak - Updated WordPress pay core library to version 1.1.0.
- Tweak - Updated WordPress pay Buckaroo library to version 1.1.0.
- Tweak - Updated WordPress pay MultiSafepay library to version 1.1.0.
- Tweak - Updated WordPress pay MultiSafepay Connect library to version 1.1.0.
- Tweak - Updated WordPress pay Ogone library to version 1.2.0.
- Tweak - Updated WordPress pay Pay.nl library to version 1.1.0.
- Tweak - Updated WordPress pay Gravity Forms library to version 1.2.2.

## [3.5.0] - 2015-02-19
- Tweak - Updated WordPress pay ICEPAY library to version 1.2.0.
- Tweak - Added context to the ICEPAY admin labels and improved Dutch translations.
- Tweak - Changed the ICEPAY login URL's to the new portal login URL's.
- Tweak - Updated WordPress pay core library to version 1.0.1.
- Tweak - Updated WordPress pay Mollie library to version 1.1.0.
- Tweak - Updated Wordpress pay WooCommerce library to version 1.1.0.
- Tweak - Updated Wordpress pay Ogone library to version 1.1.0.
- Tweak - Updated Wordpress pay OmniKassa library to version 1.1.0.
- Tweak - Added obsoleted text to deprecated gateways.

## [3.4.2] - 2015-02-16
- Tweak - Updated WordPress pay Event Espresso library to version 1.0.2.

## [3.4.1] - 2015-02-13
- Tweak - Updated WordPress pay Gravity Forms library to version 1.2.1.

## [3.4.0] - 2015-02-12
- Tweak - Updated WordPress pay s2Member library to version 1.1.0.
- Tweak - Updated WordPress pay Gravity Forms library to version 1.2.0.
- Tweak - Updated WordPress pay Shopp library to version 1.0.0.

## [3.3.3] - 2015-02-12
- Tweak - Updated WordPress pay iDEAL Basic library to version 1.0.1.
- Tweak - Updated WordPress pay iThemes Exchange library to version 1.0.1.

## [3.3.2] - 2015-01-27
- Tweak - Updated WordPress pay WooCommerce library to version 1.0.2.
- Tweak - Updated WordPress pay Event Espresso library to version 1.0.1.

## [3.3.1] - 2015-01-02
- Tweak - Updated WordPress pay Gravity Forms library to version 1.0.1.

## [3.3.0] - 2014-12-30
- Feature - Event Espresso 4 - Added experimental support for Event Espresso 4.
- Tweak - Event Espresso 3 - Improved support for Event Espresso 3.
- Tweak - Added WordPress pay Gravity Forms library version 1.0.0.

## [3.2.4] - 2014-12-19
- Tweak - Updated WordPress pay WooCommerce library to version 1.0.1.
- Test - WordPress - Tested up to version 4.1.

## [3.2.3] - 2014-12-16
- Tweak - Updated WordPress pay Pay.nl library to version 1.0.2.

## [3.2.2] - 2014-12-15
- Tweak - Updated WordPress pay Sisow library to version 1.0.1.
- Tweak - Updated WordPress pay Pay.nl library to version 1.0.1.

## [3.2.1] - 2014-12-10
- Tweak - Sisow - Improved status update handling.
- Tweak - TargetPay - No longer disable SSL verify.
- Tweak - Ogone - Improved retrieving request data.
- Refactor - Rewritten the admin class.

## [3.2.0] - 2014-12-10
- Feature - WooCommerce - Credit Card - Added support for Buckaroo.
- Feature - WooCommerce - Bancontact/Mister Cash - Added support for Sisow.
- Tweak - Sisow - Sanitize Sisow 'purchaseid' and 'entrancecode' parameters.
- Tweak - Buckaroo - Renamed Buckaroo gateway from "Buckaroo - iDEAL" to "Buckaroo - HTML".
- Tweak - Sisow - Renamed Sisow gateway from "Sisow - iDEAL" to "Sisow".
- Tweak - WooCommerce - Auto submit gateways HTML forms on WooCommerce receipt page.

## [3.1.5] - 2014-11-18
- Fix - iDEAL Basic - Fixed fatal error - Call to undefined function Pronamic_WP_Pay_Gateways_IDealBasic_Items(). 
- Fix - iDEAL Basic - Fixed fatal error - Call to undefined method Pronamic_WP_Pay_Gateways_IDealBasic_Item::getNumber().

## [3.1.4] - 2014-11-17
- Fix - iDEAL Advanced v3 - Fixed fatal error with iDEAL Advanced v3 gateway.

## [3.1.3] - 2014-11-14
- Tweak - Pay.nl - Improved error handling.
- Fix - Ogone - Fixed fatal error with Ogone order standard easy gateway.

## [3.1.2] - 2014-11-12
- Fix - iDEAL Basic - Fixed issue with not loading iDEAL Basic gateway.
- Tweak - Added some missing text domains in translation functions.
- Tweak - Easy Digital Downloads - Fixed text domain 'edd' to 'pronamic_ideal'.

## [3.1.1] - 2014-11-12
- Fix - Fatal error: Call to undefined method Pronamic_WP_Pay_Plugin::set_roles.

## [3.1.0] - 2014-11-12
- Feature - WooCommerce - Added MiniTix gateway for OmniKassa.
- Feature - WooCommerce - Added Credit Card gateway for OmniKassa and Mollie.
- Tweak - WooCommerce - Adjusted default payment gateway icons.
- Tweak - Moved all gateway libraries to https://github.com/wp-pay-gateways.
- Tweak - Mollie - Improved support for the Mollie webhook feature.
- Tweak - For a lot of gateways we no longer disable SSL verify.
- Feature - Ogone - Added configuration field for the PARAMVAR field.

## [3.0.0] - 2014-10-31
- Feature - Pay.nl - Added basic support for the Pay.nl payment provider.
- Tweak - Mollie - Added the 'locale' parameter in the create payment request.

## [2.9.4] - 2014-10-20
- Feature - s2Member - Added support for 'button_text' attribute in the `[pronamic_ideal_s2member]` shortcode.
- Test - s2Member - Tested up to version 141007.
- Tweak - Gravity Forms - Improved support for delay AWeber, Campaign Monitor and MailChimp subscription.

## [2.9.3] - 
- Feature - Added an Ogone configuration field for the ORDERID parameter.

## [2.9.2] - 2014-10-07
- Tweak - Payment note comments are always ignored in comment queries.
- Feature - Easy Digital Downloads - Added support for Bancontact/Mister Cash icon.
- Tweak - ICEPAY - Added support for http:// and https://.
- Tweak - Ogone - Moved Ogone gateway to it's own repository (https://github.com/wp-pay-gateways/ogone).
- Tweak - Ogone - Updated the Ogone calculations parameters for SHA-IN and SHA-OUT.
- Feature - Ogone - Add payment notes on Ogone payment status requests.
- Feature - Ogone - Added Ogone Direct HTTP server-to-server request URL fields.
- Tweak - Use the global payment status pages as backup.
- Fix - Jigoshop - Fixed support for Jigoshop version 1.12.
- Test - Jigoshop - Tested up to version 1.12.
- Tweak - Jigoshop - Moved Jigoshop extension to it's own repository (https://github.com/wp-pay-extensions/jigoshop).

## [2.9.1] - 2014-09-18
- Fix - OmniKassa - Fixed fatal error.

## [2.9.0] - 2014-09-18
- Tweak - Easy Digital Downloads - Display gateway errors.
- Feature - Easy Digital Downloads - Added support for iDEAL payment icon.
- Test - Easy Digital Downloads - Tested up to version 2.1.3.
- Tweak - Qantani - Truncate description longer then 30 characters.
- Tweak - Initialize post types on 'init' action priority 0 to fix a notice.
- Tweak - Show 'No logs found.' when no payment logs are found in the logs meta box.
- Tweak - Gravity Forms AWeber Add-On - Improved support for delayed subscriptions.

## [2.8.9] - 2014-09-09
- Test - WordPress - Tested up to version 4.0.
- Test - Gravity Forms - Tested up to version 1.8.13.
- Fix - Sisow - Improved support for Gravity Forms without issuer dropdowns.
- Tweak - Added payment status to the WordPress admin payment details page.
- Tweak - Gravity Forms - Show add-on options only if they are available.

## [2.8.8] - 2014-09-09
- Fix - WooCommerce - Fix fatal error: Class 'Pronamic_WooCommerce_WooCommerce' not found.
- Fix - Shopp - Fix fatal error: Call to undefined method Shopp::resession().

## [2.8.7] - 2014-08-25
- Fix - OmniKassa - Fixed fatal error loading response codes class.
- Fix - Mollie - Fixed fatal error loading config class.

## [2.8.6] - 2014-08-25
- Fix - OmniKassa - Fixed link to the OmniKassa test environment.
- Feature - WooCommerce - Added extra gateway for the Mister Cash payment method.
- Tweak - PayDutch - Improved support for test and production environments.
- Tweak - No longer create custom database tables for payments and gateway configurations.

## [2.8.5] - 2014-07-24
- Fix - Membership - Check if the Membership Premium function 'membership_get_current_coupon' exists.

## [2.8.4] - 2014-07-22
- Feature - Buckaroo - Added support for Buckaroo Push URI.

## [2.8.3] - 2014-07-21
- Tweak - Gravity Forms - Improved support for concept or trashed Gravity Forms payment feeds.
- Fix - Jigoshop - Added support for Jigoshop version 1.9.3.
- Fix - Mollie - Fixed an status error in the deprecated Mollie iDEAL gateway.

## [2.8.2] - 2014-07-15
- Tweak - Removed dot files.
- Tweak - TargetPay - Fixed TargetPay tests.

## [2.8.1] - 2014-07-14
- Tweak - Use Composer and Packagist for some of the payment gateways libraries.
- Tweak - TargetPay - Simplified TargetPay status update code.

## [2.8.0] - 2014-06-24
- Feature - Added support for the Ogone post-sale request.
- Feature - Added support for the Gravity Forms AWeber Add-On.
- Test - Shopp - Tested up to version 1.3.4.

## [2.7.7] - 2014-06-16
- Tweak - WooCommerce - Use the new endpoint URL's for gateways (http://docs.woothemes.com/document/woocommerce-endpoints-2-1/).
- Tweak - WooCommerce - Improved backwards compatibility for WooCommerce < 2.1.0.

## [2.7.6] - 2014-06-16
- Fix - ICEPAY - Removed the issuer field from the gateway.
- Documentation - WooCommerce - Increased requires at least version up to 2.1.0.

## [2.7.5] - 2014-05-14
- Fix - Buckaroo - Fixed parameter sorting with mixed character return.

## [2.7.4] - 2014-05-14
- Tweak - WPMU DEV Membership - Improved loading activated gateways.
- Tweak - WPMU DEV Membership - Display errors if they occur.
- Tweak - Mollie - Improved handling of errors.
- Fix - Gravity Forms - Fixed bug with disabling payment feed condition.
- Fix - WP e-Commerce - Retrieving cart data bug.

## [2.7.3] - 2014-05-07
- Tweak - ICEPAY - Update to API library version 2.4.
- Tweak - Simplified WordPress admin menu iDEAL.

## [2.7.2] - 2014-05-02
- Tweak - Gravity Forms - Fixed some notices and improved saving of payment feed data.

## [2.7.1] - 2014-04-30
- Tweak - WPMU DEV Membership - Make sure the gateway is active check will succeed.
- Test - WPMU DEV Membership - Tested up to version 3.5.1.3.
- Test - Gravity Forms Campaign Monitor Add-On - Tested up to version 2.5.1.
- Test - Gravity Forms MailChimp Add-On - Tested up to version 2.4.1.
- Test - Gravity Forms User Registration Add-On - Tested up to version 1.8.
- Tweak - Marked the gateway "ABN AMRO - iDEAL Hosted" as deprecated.
- Tweak - Added the gateway "ABN AMRO - Internetkassa" for completeness.
- Feature - Vantage - Added support for the Vantage theme from AppThemes.

## [2.7.0] - 2014-04-26
- Tweak - WordPress Coding Standards optimizations thanks to PHP CodeSniffer.
- Tweak - Easy Digital Downloads - Fixed an fatal error (public $payment_id).
- Tweak - WPMU DEV Membership - Use Pronamic capability for iDEAL settings page.
- Tweak - Moved everything from the 'WordPress' namespace to the 'WP' namespace.
- Tweak - Improved the private certificate generate command.

## [2.6.9] - 2014-04-17
- Tweak - s2Member - Require email for not logged in users.
- Tweak - Membership Premium - Added support for version 3.5.1.2.
- Tweak - Buckaroo - Don't generate an one transaction ID, we now use the 'brq_payment' return value from Buckaroo.
- Test - WordPress - Tested up to version 3.9.

## [2.6.8] - 2014-04-03
- Feature - Added support for the [Paytor](http://www.paytor.com/) provider/gateway.
- Tweak - Grayed out deprecated gateways.
- Tweak - Improved backwards compatibility for Gravity Forms 1.6.

## [2.6.7] - 2014-03-24
- Tweak - WPMU DEV Membership - Fixed error after update to Membership 5.3+, we don't support 3.5+ yet.

## [2.6.6] - 2014-03-21
- Tweak - ICEPAY - Use the 'OrderID' in the listener so the correct payment will be updated.
- Fix - Buckaroo - Fixed support for & character in blog name for WooCommerce payment description.
- Test - WooCommerce - Tested up to version 2.1.5.
- Test - ClassiPress - Tested up to version 3.3.3.
- Tweak - AppThemes - Process the order/gateway also in the 'template_redirect' hook, to improve some redirect issues.
- Tweak - ABN AMRO - iDEAL Only Kassa - Updated the dashboard URL's to the new BackOffice version URL's.
- Fix - s2Member - Fixed Fatal error: Call to a member function get_level() on a non-object.
- Test - s2Member - Tested up to version 140105.

## [2.6.5] - 2014-03-07
- Tweak - WooCommerce - Improved the {"result":"failure","messages":"","refresh":"false"} error.

## [2.6.4] - 2014-03-05
- Fix - Gravity Forms - Fixed JavaScript error while editing an payment form post.

## [2.6.3] - 2014-02-28
- Tweak - WooCommerce - Improved usage of WooCommerce gateway/order return URL.
- Test - WooCommerce - Tested up to version 2.1.3.

## [2.6.2] - 2014-02-27
- Tweak - s2Member - Only update user if payment status is changed from 'unknown' to 'success' to prevent double updates.
- Tweak - Did a lot of small adjustments to make this plugin faster.
- Tweak - Automated some tasks with Grunt (PHPLint, JSHint, PHPUnit, makepot.php).
- Test - WooCommerce - Tested up to version 2.1.2.

## [2.6.1] - 2014-02-05
- Tweak - Reduced transient name length to avoid "data too long for column 'option_name'" errors.
- Tweak - Membership - Added support for coupon codes.
- Tweak - Membership - After successful payment redirect user to the "Registration completed page". 
- Tweak - Easy Digital Downloads - Don't display gateway input fieldset if the gateway doesn't require input.

## [2.6.0] - 2014-01-31
- Feature - iThemes Exchange - Added support for the [iThemes Exchange](http://wordpress.org/plugins/ithemes-exchange/) plugin.
- Tweak - Easy Digital Downloads - Improved support for the Pronamic iDEAL gateway.
- Fix - iDEAL Basic - Sisow iDEAL Basic returned error TA3260 when the payment description contained a hash tag.
- Fix - Easy Digital Downloads - Customers weren't redirected to the payment provider upon payment.

## [2.5.0] - 2014-01-23
- Tweak - Rabobank - OmniKassa - Moved listener on payment status up in the WordPress code flow.
- Documentation - Rabobank - OmniKassa - Added OmniKassa documentation v6.0.
- Feature - MultiSafepay - Added support the MultiSafepay gateway.
- Fix - Gravity Forms - Improved support for payment feed description with quotes.
- Feature - Gravity Forms - Added an 'User Registration Delay' setting for the Gravity Forms User Registration Add-On.

## [2.4.3] - 2014-01-16
- Feature - Gravity Forms - Added an entry ID prefix field to the payment feed.

## [2.4.2] - 2014-01-15
- Fix - Buckaroo - When a payment's invoice number was set to "null" the payment would fail.
- Test - Buckaroo - Added unit testing for Buckaroo security methods.
- Feature - Buckaroo - Payment return requests are now logged as a payment note. 

## [2.4.1] - 2014-01-10
- Fix - WordPress.org readme.txt.

## [2.4.0] - 2014-01-10
- Feature - Easy Digital Downloads - Added support for the [Easy Digital Downloads](http://wordpress.org/plugins/easy-digital-downloads/) plugin.
- Fix - s2Member - A probable bug in the s2Member AddOn could cause a user not to be able to upgrade their account after an EOT.
- Fix - s2Member - When no EOT date was set, a successful payment would set the new EOT date on the date of tomorrow regardless of the period paid for.
- Fix - Event Espresso - Gave a warning message when trying to pay, saying you would lose your payment data when leaving the page.
- Tweak - WooCommerce - Improved support for WooCommerce Sequential Order Numbers.
- Tweak - Shopp - Improved support for Shopp 1.3.
- Test - Shopp - Tested up to version 1.3.

## [2.3.1] - 2013-12-20
- Tweak - Gravity Forms - Improved the form check in the Gravity Forms payment processor.

## [2.3.0] - 2013-12-19
- Feature - Added support for the Ogone - DirectLink - 3-D Secure feature.
- Feature - Added payment date the payment details admin meta box.
- Feature - WooCommerce - Added an option field for the gateway icon URL.
- Feature - Mollie - Added support for the new universal Mollie API.
- Feature - Mollie - Added some Mollie badges on the WordPress admin "Branding" page.
- Feature - Mister Cash - Added three Mister Cash icons on the WordPress admin "Branding" page.
- Tweak - Improved support for WordPress lower then 3.6 by adding the wp_slash() function.
- Tweak - Membership - Improved support for "Popup registration form" form type.
- Fix - Membership - Pass in the correct subscription ID in the Membership create_subscription() function.
- Tweak - Gravity Forms - Improved usability for delaying notifications.
- Fix - s2Member - Remove end of time user option if subscription period is lifetime.
- Fix - s2Member - Calculate new end of time based on the previous end of time.
- Test - s2Member - Tested up to version 131126.

## [2.2.4] - 2013-12-12
- Tweak - s2Member - Added a period option to the s2Member iDEAL buttons addon to be able to subscribe for a lifetime.
- Tweak - Membership - Improved activating of the iDEAL gateway.
- Tweak - Jigoshop - Added workaround for the wp_safe_redirect() non AJAX issue to the admin URL.
- Test - WordPress tested up to 3.8.
- Test - ClassiPress tested up to 3.3.1.
- Fix - AppThemes - Fatal error: Class 'Pronamic_WordPress_IDeal_ConfigurationsRepository' not found in classes\Pronamic\AppThemes\IDeal\IDealGateway.php on line 54.
- Fix - AppThemes - Fatal error: Call to undefined method Pronamic_WP_Pay_Payment::getSource() in classes/Pronamic/AppThemes/IDeal/AddOn.php on line 52.
- Tweak - WooCommerce - Strict Standards: call_user_func_array() expects parameter 1 to be a valid callback, non-static method Pronamic_WooCommerce_IDeal_AddOn::payment_gateways() should not be called statically.
- Tweak - Strict Standards: Declaration of Pronamic_Gateways_IDealAdvanced_XML_ErrorResponseMessage::parse() should be compatible with Pronamic_Gateways_IDealAdvanced_XML_ResponseMessage::parse(SimpleXMLElement $xml, Pronamic_Gateways_IDealAdvanced_XML_ResponseMessage $message).
- Tweak - Jigoshop - Strict Standards: call_user_func_array() expects parameter 1 to be a valid callback, non-static method Pronamic_Jigoshop_IDeal_AddOn::payment_gateways() should not be called statically.
- Tweak - Jigoshop - Deprecated: Assigning the return value of new by reference is deprecated in classes/Pronamic/Jigoshop/IDeal/IDealGateway.php on line 153.
- Tweak - Jigoshop - Deprecated: Assigning the return value of new by reference is deprecated in classes/Pronamic/Jigoshop/IDeal/IDealGateway.php on line 172.

## [2.2.3] - 2013-11-28
- Tweak - Gravity Forms - Added an processor class which handles payment forms.
- Fix - Gravity Forms - Improved support for AJAX driven forms.
- Fix - Warning: addslashes() expects parameter 1 to be string, array given.
- Fix - Fatal error: Class Pronamic_Gateways_Ogone_XML_OrderResponseParser cannot extend from interface Pronamic_Gateways_IDealAdvancedV3_XML_Parser.
- Fix - Strict Standards: Non-static method Pronamic_WPeCommerce_IDeal_AddOn::advanced_inputs() should not be called statically.

## [2.2.2] - 2013-11-26
- Fix - Strict Standards: Declaration of 'function' should be compatible with 'function'.
- Tweak - Added support for slashes in the gateway configuration meta values.
- Tweak - Added support for '(' and ')' charachters in private key and certificate commands.
- Tweak - Sisow - Improved support for 'callback' and 'notify' requests to ensure Google Analytics e-commerce tracking.
- Tweak - Shopp - Improved status update. 

## [2.2.1] - 2013-11-22
- Tweak - Added cURL version to system status page (for cURL bug in v7.31.0 http://sourceforge.net/p/curl/bugs/1249/).
- Tweak - Ogone DirectLink - Converted pass phrase and password config fields to password fields.
- Tweak - Ogone DirectLink - Use UTF-8 URL's when WordPress charset is set to UTF-8.
- Fix - Ogone DirectLink - Fixed the API URL's in production mode.
- Fix - ABN AMRO - iDEAL Zelfbouw - v3 - Fixed the gateway URL's.

## [2.2.0] - 2013-11-19
- Feature - WooCommerce - Added support for payment description with WooCommerce tags like {order_number} and {blogname}.
- Tweak - ICEPAY - Use payment ID for the order ID field to prevent "Duplicate IC_OrderID" errors.

## [2.1.0] - 2013-11-14
- Tweak - Added character set to the system status page.
- Tweak - Gravity Forms - Improved delay notifications function after successful payment.
- Tweak - Gravity Forms - Added support for Campaign Monitor Subscription Delay.
- Tweak - Gravity Forms - Added support for MailChimp Subscription Delay.
- Tweak - ABN AMRO - iDEAL Easy - Improved support for multiple payments for same order.
- Tweak - Ogone - DirectLink - Improved payment status update.

## [2.0.7] - 2013-11-06
- Tweak - Sisow - Use order ID as purchase ID if not empty.
- Tweak - Event Espresso - Improved support for e-mail notifications after payment.
- Tweak - iDEAL Advanced v3 - Limit the Directory Request requests.
- Tweak - ICEPAY - Limit the get supported issuers calls.
- Tweak - Qantani - Limit the get banks calls.
- Tweak - Rabobank OmniKassa - Improved upgrade script to convert key version from 1.0 to 2.0.
- Tweak - Ogone DirectLink - Show Ogone error when nc_error is not empty.
- Test - Event Espresso - Tested up to 3.1.35.P.
- Fix - Ogone DirectLink - Added support for Ogone hashing algorithm.
- Fix - Ogone OrderStandard - Improved upgrade function to convert SHA IN and OUT pass phrases.
- Fix - Strict Standards: Non-static method Pronamic_Gateways_IDealBasic_Listener::listen() should not be called statically.
- Fix - Strict Standards: Non-static method Pronamic_Gateways_OmniKassa_Listener::listen() should not be called statically.
- Fix - Strict Standards: Non-static method Pronamic_Gateways_Icepay_Listener::listen() should not be called statically.

## [2.0.6] - 2013-10-30
- Fix - Rabobank OmniKassa - Fixed status update listener.

## [2.0.5] - 2013-10-30
- Fix - Ogone DirectLink - Fatal error: Call to a member function set_transaction_id() on a non-object.
- Fix - Rabobank OmniKassa - Fixed status update listener.
- Tweak - ICEPAY - Improved error handling.

## [2.0.4] - 2013-10-30
- Fix - Gravity Forms - Fatal error: Call to undefined method Pronamic_Pay_Gateway::get_transaction_id().
- Tweak - Improved upgrade function to convert custom tables to custom post types.

## [2.0.3] - 2013-10-28
- Fix - ClassiPress - Improved support for HTML gateways.
- Fix - Jigoshop - Improved support for HTML gateways.
- Fix - WooCommerce - Improved support for HTML gateways.
- Fix - iDEAL Advanced v3 - Improved status update.
- Test - ClassiPress tested up to 3.3.1.

## [2.0.2] - 2013-10-28
- Fix - Improved support for PHP 5.2 (Parse error: syntax error, unexpected T_PAAMAYIM_NEKUDOTAYIM)

## [2.0.1] - 2013-10-28
- Fix - Fixed an issue saving Pronamic iDEAL settings.
- Fix - WooCommerce issue on iDEAL checkout.
- Fix - Jigoshop issue on iDEAL checkout.
- Localization - Danish translation by Pronamic.
- Test - Jigoshop tested up to 1.8.
- Test - WooCommerce tested up to 2.0.18.
- Test - s2Member tested up to 131026.

## [2.0.0] - 2013-10-28
- Refactor - Converted configurations to posts (custom post type).
- Refactor - Converted payments to posts (custom post type).
- Refactor - Converted Gravity Forms pay feeds to posts (custom post type).
- Refactor - Rewritten all gateways, configurations, update status functions and more.
- Refactor - Settings pages now use the WordPress settings API.
- Refactor - s2Member iDEAL gateway rewritten.
- Refactor - Membership iDEAL gateway rewritten.
- Refactor - WP e-Commerce iDEAL gateway rewritten.
- Refactor - WordPress Coding Standards optimizations.
- Feature - Added support for the "Deutsche Bank - iDEAL via Ogone" gateway.
- Feature - Added support for the "Ogone - DirectLink" gateway.
- Feature - Added support for the "Dutch Payment Group - PayDutch" gateway. 
- Feature - Extended the iDEAL Advanced v3 private key and certificate generate commands.
- Feature - Added log/note/comment system to payments using WordPress comment system.
- Feature - Added an dashboard page - latest payments, Pronamic news and more.
- Feature - Added an system status - supported extensions, versions, build status and more.
- Feature - Added settings for global return pages.
- Tweak - Added support for iDEAL Advanced v3 on PHP 5.2 (thanks to ING).
- Tweak - Display ICEPAY return URL's in readonly fields.
- Tweak - Adjusted Ogone dashboard URL's to the new dashboard URL's.
- Tweak - Added support for Ogone hash algorithms (SHA-1, SHA-256 and SHA-512).
- Tweak - Added more unit testing for gateways and XML parsing.
- Localization - Added POT file and use makepot.php

## [1.3.4] - 2013-10-10
- Improved support for cancelled payments in WooCommerce

## [1.3.3] - 2013-10-07
- Fixed bug Fatal error: Class 'Pronamic_WordPress_IDeal_IDealTestDataProxy' not found 
- Added support for the 'Deutsche Bank - iDEAL via Ogone' variant
- Added check on required OpenSSL version 0.9.8 with SHA256 support
- Improved support for Event Espresso 3.1, added iDEAL logo

## [1.3.2] - 2013-09-06
- Updated to Icepay API library v2.3.0

## [1.3.1] - 2013-08-01
- Fixed deprecated notice in Jigoshop Add-On (Assigning the return value of new by reference)

## [1.3.0] - 2013-07-29
- Added support for the Qantani iDEAL payment provider

## [1.2.11] - 2013-07-24
- Fixed saving of private key and certificate

## [1.2.10] - 2013-06-03
- Configuration editor - Removed double private key password field
- iDEAL Advanced v3 - Improved error handling signing documents

## [1.2.9] - 2013-05-31
- Sisow - Added support for Sisow REST API
- Gravity Forms - Improved send notifications after payment
- Configuration editor - Extended v3 with private key and certificate commands

## [1.2.8] - 2013-05-28
- ICEPAY - Added support for the ICEPAY payment provider
- Gravity Forms - Fixed send notifications after payment for Gravity Forms 1.7.2+
- Event Espresso - Fixed double e-mail notifications
- TargetPay - Added support for customer info in callback (direct debit)

## [1.2.7] - 2013-05-07
- Membership - Improved the check for an active iDEAl gateway
- Mollie - Enabled feedback support for the Mollie gateway
- Cleaned up the configuration editor and add support for certificate info with iDEAL v3
- s2Member - Improved support for providers which support an description (Sisow)
- WooCommerce - Improved the check payment e-mail note by using get_order_number()
- Return URL's - Improved use of site_url() and home_url() functions
- Buckaroo - Added support for the Buckaroo payment provider (thanks to Marcel Snoeck)
- iDEAL Easy - Improved return handling
- s2Member - Login is no longer required to pay with iDEAL

## [1.2.6] - 2013-03-25
- s2Member - Added support for the s2Member plugin
- Membership from WPMUDEV.org - Added support for the Membership from WPMUDEV.org plugin
- Mollie - Use transient for issuers/banks list
- Jigoshop - Improved order status check, prevent multiple stock reducing with OmniKassa

## [1.2.5] - 2013-03-04
- iDEAL Advanced - Improved handling of parsing response messages
- TargetPay - Improved handling of payment status return information
- TargetPay - No longer verify SSL
- WordPress - Tested up to version 3.5.1
- Event Espresso - Improved the handling of sending e-mails
- Gravity Forms - Fulfil order callback is no called only once
- Mollie - Improved error handling
- Pages generator pages now have by default no index (WordPress SEO by Yoast)

## [1.2.4] - 2013-02-04
- ClassiPress - Improved URL redirect if payment status was not successful

## [1.2.3] - 2013-02-02
- Event Espresso - Improved support for gateways which have input fields
- ClassiPress - Improved support for gateways which have input fields
- Shopp - Fixed issue with gateways with an issuer input field
- WooCommerce - Fixed issue with no description and gateway input fields
- Display certificate valid from and to values on the configuration editor

## [1.2.2] - 2013-01-27
- Fix - Fatal error on saving settings

## [1.2.1] - 2013-01-22
- WordPress Coding Standards optimizations
- Performance optimizations
- Mollie no longer verify SSL, didn't work on all servers

## [1.2] - 2013-01-15
- Added support for TargetPay iDEAL API
- Added support for Mollie iDEAL API
- InternetKassa - Improved handling of signature IN and OUT creating
- Jigoshop - Improved backwards compatibility for v1.2 or lower
- OmniKassa - Fixed issue with key version error in admin tests page

## [1.1.1] - 2012-12-21
- OmniKassa - Fixed version key issue
- Jigoshop - Improved backwards compatibility for v1.2 or lower
- Improved the configurations selector
- Added ID column to the configurations overview table  

## [1.1] - 2012-12-17
- Added support for iDEAL Advanced version 3.3
- Added support for ABN AMRO - iDEAL Zelfbouw
- Added status page powered by http://www.ideal-status.nl/
- Abstracted the gateways classes
- WooCommerce - Added support for [Sequential Order Numbers Pro](http://wcdocs.woothemes.com/user-guide/extensions/functionality/sequential-order-numbers/#add-compatibility)
- OmniKassa - Added key version field in configuration editor
- Jigoshop - Updated the iDEAL gateway settings section
- ClassiPress - Added support for HTTP redirect gateways

## [1.0] - 2012-09-21
- First official release, removed the 'beta' label.
- Added an 'Branding' page for easy adding iDEAL banners.
- Added English documentation for changes in v3.3.1.
- ClassiPress - Tweak - Improved support for the ClassiPress theme.

## [beta-0.11.1] - 2012-08-09
- WP e-Commerce - Tweak - Improved the support for iDEAL Advanced variants.

## [beta-0.11.0] - 2012-07-24
- Tweak - Improved support for the iDEAL Easy variant, this variant requires an PSP ID
- Shopp - Fix - Force auth only for the iDEAL gateway
- OmniKassa - Removed the optional parameter 'customerLanguage', was giving "Ongeldige waarde  : customerLanguage=NL" error
- OmniKassa - Added documentation "Integration guide Rabo OmniKassa – Version 2.0.1 April 2012"
- Gravity Forms - Added custom merge tags for payment status, date, amount and transaction id

## [beta-0.10.1] - 2012-07-13
- Fix - OmniKassa configuration could net input hash key 

## [beta-0.10] - 2012-07-11
- Tweak - Added extra check in loading certificates files from the iDEAL XML file
- Shopp - Fix - Purchases with discount payments fix
- Tweak - Added ABN AMRO Bank : Parameter Cookbook documentation link
- Feature - Added support for the iDEAL Internet Kassa of Ogone

## [beta-0.9.9] - 2012-06-28
- Shopp - Test - Checked the 1.2.2 changelog (https://shopplugin.net/blog/shopp-1-2-1-release-notes/)
- Shopp - Fix - Shopp is not showing the new payments settings after saving, bug in Shopp
- Tweak - Changed home_url() to site_url() for retrieving license information
- Event Espresso - Tweak - Improved the documentation of some functions and constants
- Event Espresso - Fix - Removed debug information from choose payment option page 
- Jigoshop - Tweak - Return visitor to view order page after expired payment
- WP e-Commerce - Test - Version 3.8.8.2 and 3.8.8.3
- WP e-Commerce - Tweak - Improved the return, cancel, success and error URL's
- Shopp - Tweak - Improved the return, cancel, success and error URL's
- Shopp - Tweak - Improved the automatic status update of purchases
- WordPress - Test - Version 3.4.1

## [beta-0.9.8] - 2012-06-11
- Shopp - Fix - The 'selected' parameter in module settings UI render drop-down menu function is sometimes type sensitive
- Shopp - Fix - Added wrapper code to JavaScript so $ will work for calling jQuery
- Event Espresso - Added support for the Event Espresso plugin

## [beta-0.9.7] - 2012-06-07
- OmniKassa - Added the "Zo werkt het aanvragen en aansluiten van de Rabo OmniKassa" PDF file to the documentation page
- OmniKassa - Added an easy interface to execute the five iDEAL simulation transactions
- Jigoshop - Updated the HTML options table head of the IDEAL gateway to the default Jigoshop format
- iDEAL Advanced - Fixed an issue with an empty WordPress WPLANG constant, causing field generating error: language. Parameter '' has less than 2 characters
- Sisow - Added the "Sisow - Pronamic iDEAL" PDF file to the documentation page
- Gravity Forms - Improved the determination of the status URL
- Sisow - Added support for "Sisow - iDEAL Basic" variant
- Sisow - Added support for "Sisow - iDEAL Advanced" variant
- Gravity Forms - Display error code if something is going wrong with the iDEAL Advanced variant
- Shopp - Added 'keyed' => true parameter to the module settings UI render drop-down menu function
- Tweak - Removed the utility function remove query arguments from URL, no longer used
- Tweak - Improved the utility class and the retrieval of the ISO 639 and ISO 3166 values
- Tweak - Improved the iDEAL Basic test page, the WordPress language value is now used 
- Gravity Forms - Fix - Removed the esc_js() function from the AJAX redirection JavaScript function

## [beta-0.9.6] - 2012-05-10
- Gravity Forms - Fixed bug with hidden conditional field, ignore iDEAL

## [beta-0.9.5] - 2012-05-10
- Gravity Forms - Added extra constants for the payment statuses
- Gravity Forms - Improved the way we update the entry payment status
- WooCommerce - Added WooCommerce utility base class
- Jigoshop - Added Jigoshop utility base class
- OmniKassa - Changed the use of the site_url() function, now called with an slash

## [beta-0.9.4] - 2012-04-27
- Fixed issue with the use of the [dbDelta](http://codex.wordpress.org/Creating_Tables_with_Plugins) function which was causing "WordPress database error: [Multiple primary key defined]" errors
- Fixed check on (un)paid Shopp 1.2+ purchases, in some way this was mixed up.
- Gravity Forms - Added field type title for the issuer drop down field
- Gravity Forms - Changed Dutch translation of "Issuer Drop Down" field to "Banken uitschuifkeuzelijst"
- Gravity Forms - Fixed redirecting issue with an AJAX enabled Gravity Forms form
- ClassiPress - Added experimental iDEAL gateway

## [beta-0.9.3] - 2012-04-17
- Added some icons for the iDEAL banks to create a nicer issuer select element
- Added experimental support for ClassiPress
- Added Gravity Forms delay admin notification option
- Added Gravity Forms delay user notification option
- Added Gravity Forms delay post creation option

## [beta-0.9.2] - 2012-04-05
- Fixed line delimiters which was causing unexpected T_CLASS error in classes/Pronamic/WPeCommerce/IDeal/AddOn.php 
- Added an array_filter() to the optional OmniKassa data fields
- Fixed an issue in the Shopp Add-On caused by an Shopp bug (see ticket https://shopp.lighthouseapp.com/projects/47561/tickets/1536-shoppcheckoutoffline-instructions-tag-seemingly-absent-from-12)
- Added support plugins section to the settings page

## [beta-0.9.1] - 2012-03-30
- Added an overview of the registered hashing algorithms and check for sha1 algorithm
- Fixed plugins_url() function call in the WP e-Commerce Add-On
- Fixed retrieving success URL in the Gravity Forms Add-On from an iDEAL feed 
- Fixed edit order link in check iDEAL payment e-mail in the WooCommerce Add-On
- Added check for unavailable or removed iDEAL variant in Gravity Forms iDEAL feed editor

## [beta-0.9] - 2012-03-22
- Added an data proxy class, all add-ons are now optimized
- Added OmniKassa support for all add-ons
- Added support for the WP e-Commerce plugin
- Improved the redirection if returned from an iDEAL advanced payment to WooCommerce
- Changed the text domain from 'pronamic-ideal' to 'pronamic_ideal'
- Replaced all references to class constant TEXT_DOMAIN to an string

## [beta-0.8.6] - 2012-02-17
- Added documentation for the Rabobank OmniKassa payment method
- Added documentation for the ABN AMRO iDEAL Only Kassa payment method
- WooCommerce iDEAL payment orders now get the status "on-hold" instead of "pending" 
- Changed WooCommerce class 'woocommerce_order' to 'WC_Order'
- Changed WooCommerce class 'woocommerce_payment_gateway' to 'WC_Payment_Gateway'
- Replaced get_permalink(get_option('woocommerce_pay_page_id')) with get_permalink(woocommerce_get_page_id('pay'))
- WooCommerce iDEAL Easy and Basic payments send an check payment mail and add note to order

## [beta-0.8.5] - 2012-01-18
- Fixed an nonce check which was causing a lot "Are you sure you want to do this?" notices
- Added an uninstall hook which will delete all extra database tables and options
- Removed the custom made uninstall block from the iDEAL configurations page
- Fixed database errors / unexpected output while installing the plugin
- Pages generator will now generate pages with comments closed by default

## [beta-0.8.4] - 2012-01-17
- Shopp - Fixed fatal error in Shopp 1.2RC1, the $registry variable in the Settings class is declared as private in version 1.2RC1
- Gravity Forms - Added link to Gravity Forms entry / lead details on the iDEAL payments page
- Shopp - Improved the not paid check for the Shopp iDEAL gateway module, now also works with 1.2+
- Shopp - Changed function for store front JavaScript from 'sanitize_title_with_dashes' to 'sanitize_key'
- Shopp - Changed the 'shopp_order_success' action functions, in 1.2+ the purchase parameter was removed
- Fixed notice and bug while generating security certificates and keys
- Added mandatory tests for the iDEAL advanced variants

## [beta-0.8.3] - 2012-01-04
- Fixed notice wp_register_style was called incorrectly in admin
- Fixed notice undefined variable: nl2br in the Gravity Forms Add-On
- Fixed issue in WooCommerce with building the iDEAL basic success URL, Google Analytics e-commerce tracking was not possible
- Fixed issue with the purchase ID passing through to iDEAL
- Added extra description to the hash key field on the iDEAL configuration edit page 
- Removed the maxlength="32" attribute from the Gravity Forms iDEAL feed transaction description field
- Now it is also possible to search on the amount of an payment
- Moved the return from iDEAL routine form the 'parse_query' routine to the 'template_redirect' routine
- Improved the 'pronamic_ideal_return' and 'pronamic_ideal_status_update' routines with an 'can redirect' parameter
- Improved the status update of WooCommerce and Jigoshop orders after an failure status update (from expired to failed)
- Improved the scheduling of status requests of iDEAL advanced payments
- Fixed the notice if no status pages or URL's are configured in an Gravity Forms iDEAL feed

## [beta-0.8.2] - 2011-12-12
- Replaced the DateTime::getTimestamp() call (PHP 5 >= 5.3.0) with DateTime::format('U') (PHP 5 >= 5.2.0)
- Removed the addItem function from the iDEAL basic class and added an extra items class
- Improved the way we load iDEAL items in the Gravity Forms iDEAL Add-On
- Improved the Shopp add_storefrontjs script to hide / show the iDEAL fields
- Added the ABN AMRO iDEAL Easy variant
- Improved and fixed the WooCommerce iDEAL gateway, the status of orders is now set to pending iDEAL payment
- Moved all the documentation files to an external server, plugin is now much smaller (from 20 MB to 3 MB)

## [beta-0.8.1] - 2011-11-17
- Fixed an issue with the WooCommerce iDEAL gateway, the order status is now updated
- Improved the payment status update of the Shopp and Gravity Forms add-ons

## [beta-0.8] - 2011-11-10
- Fixed an issue with the success, cancel and error URL's in the iDEAL lite variant gateway for WooCommerce
- Added support for the [Shopp plugin](http://shopplugin.net/)
- Added search box on the payments page so you can search on transaction ID, consumer name, account number and city
- Adjusted the default expiration date modifier from +1 hour to +30 minutes

## [beta-0.7.2] - 2011-11-07
- Fixed an issue with character set in the iDEAL lite variant with the decoding of HTML entities
- Added the current time to the iDEAL settings page so users can easily check the server time
- Improved the expiration date of the iDEAL lite variant, now uses UTC timezone
- Changed the iDEAL date format, the Z stands for the timezone offset and should not be the Z character
- Changed the database column width of the entrance code to 40 instead of 32
- For WooCommerce iDEAL Lite payment we now only add one total item, otherwise the cart discount amount is an issue

## [beta-0.7.1] - 2011-10-31
- Fixed issue with loading JavaScripts on the Gravity Forms edit / new form page
- Added some extra data length checks for iDEAL lite payments
- Added an extra role iDEAL Administrator, so you can outsource the configuration of iDEAL
- Added extra capabilities so you can easily grant users to the iDEAL admin pages
- Fixed bug with ordering the iDEAL payment by date
- Added an pages generator to easily create pages for each iDEAL payment status

## [beta-0.7] - 2011-10-21
- Added support for the WooCommerce WordPress plugin
- Improved the payments repository class
- Improved the payments overview page (now with pagination)
- Improved the loading of the admin JavaScripts and stylesheets

## [beta-0.6.2] - 2011-09-15
- Gravity Forms iDEAL Lite button is now translatable
- For iDEAL Lite you can now easily run the mandatory tests
- Added an private key and certificate generator

## [beta-0.6.1] - 2011-09-15
- Improved the calculation of the Gravity Forms price fields and the total amount 

## [beta-0.6] - 2011-09-15
- Added and activated some extra iDEAL banks / variants
- Enabled the Transient API for retrieving the issuers lists, was temporary disabled for debugging

## [beta-0.5] - 2011-09-07
- Fixed some security issues

## [beta-0.4] - 2011-09-07
- Improved the retrieving of license information from the license provider
- Added some extra admin CSS styling like an iDEAL screen icon

## [beta-0.3] - 2011-09-06
- Improved the Gravity Forms confirmation message when an iDEAL basic payment is executed, now working correct with AJAX
- Improved the iDEAL configuration editor and the Gravity Forms iDEAL feed editor, display only necessary input fields
- Fixed the Rabobank iDEAL payment server URLs in the ideal.xml configuration file

## [beta-0.2] - 2011-08-30
- Removed all PHP 5.3+ namespace declarations, the plugin should now be compatible with PHP 5.2+
- Fixed the link to the payment detail page in WordPress admin
- Fixed the link on the payment detail page to the iDEAL configuration page
- Fixed redirection problem with AJAX enabled Gravity Forms  

## [beta-0.1] - 2011-08-20
- Issuers list transient is now deleted after updating an iDEAL configuration
- Added the issuers list to the iDEAL configuration tests page
- The Gravity Forms iDEAL Issuer Drop Down remembers 
- Description and entrance code are automatically truncated on the maximum length
- Added better checks on the output of the OpenSSL functions to prevent PHP warnings
- Use the generic hash() function instead of the md5() and sha1() functions
- Added transaction description to the GravityForms iDEAL feed
- Fixed bug with retrieving feeds with no form or configuration attached (inner join - left join)
- Fixed issue with saving new iDEAL configurations and GravityForms iDEAL feeds
- Added wp_nonce_field() and check_admin_referer() functions to the forms to avoid security exploits
- Improved the feeds repository and the feed model
- Initial release

[unreleased]: https://github.com/pronamic/wp-pronamic-ideal/compare/9.1.3...HEAD
[9.1.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/9.1.2...9.1.3
[9.1.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/9.1.1...9.1.2
[9.1.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/9.1.0...9.1.1
[9.1.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/9.0.1...9.1.0
[9.0.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/9.0.0...9.0.1
[9.0.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/8.5.1...9.0.0
[8.5.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/8.5.0...8.5.1
[8.5.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/8.4.1...8.5.0
[8.4.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/8.4.0...8.4.1
[8.4.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/8.3.0...8.4.0
[8.3.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/8.2.2...8.3.0
[8.2.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/8.2.1...8.2.2
[8.2.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/8.2.0...8.2.1
[8.2.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/8.1.0...8.2.0
[8.1.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/8.0.0...8.1.0
[8.0.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/7.0.2...8.0.0
[7.0.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/7.0.1...7.0.2
[7.0.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/7.0.0...7.0.1
[7.0.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.9.6...7.0.0
[6.9.6]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.9.5...6.9.6
[6.9.5]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.9.4...6.9.5
[6.9.4]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.9.3...6.9.4
[6.9.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.9.2...6.9.3
[6.9.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.9.1...6.9.2
[6.9.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.9.0...6.9.1
[6.9.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.8.0...6.9.0
[6.8.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.7.2...6.8.0
[6.7.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.7.1...6.7.2
[6.7.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.7.0...6.7.1
[6.7.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.6.4...6.7.0
[6.6.4]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.6.3...6.6.4
[6.6.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.6.2...6.6.3
[6.6.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.6.1...6.6.2
[6.6.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.6.0...6.6.1
[6.6.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.5.1...6.6.0
[6.5.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.5.0...6.5.1
[6.5.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.4.1...6.5.0
[6.4.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.4.0...6.4.1
[6.4.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.3.2...6.4.0
[6.3.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.3.1...6.3.2
[6.3.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.3.0...6.3.1
[6.3.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.2.0...6.3.0
[6.2.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.1.2...6.2.0
[6.1.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.1.1...6.1.2
[6.1.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.1.0...6.1.1
[6.1.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.0.2...6.1.0
[6.0.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.0.1...6.0.2
[6.0.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/6.0.0...6.0.1
[6.0.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.9.0...6.0.0
[5.9.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.8.1...5.9.0
[5.8.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.8.0...5.8.1
[5.8.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.7.4...5.8.0
[5.7.4]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.7.3...5.7.4
[5.7.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.7.2...5.7.3
[5.7.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.7.1...5.7.2
[5.7.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.7.0...5.7.1
[5.7.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.6.2...5.7.0
[5.6.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.6.1...5.6.2
[5.6.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.6.0...5.6.1
[5.6.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.5.5...5.6.0
[5.5.5]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.5.4...5.5.5
[5.5.4]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.5.3...5.5.4
[5.5.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.5.2...5.5.3
[5.5.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.5.1...5.5.2
[5.5.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.5.0...5.5.1
[5.5.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.4.2...5.5.0
[5.4.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.4.1...5.4.2
[5.4.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.4.0...5.4.1
[5.4.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.3.0...5.4.0
[5.3.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.2.0...5.3.0
[5.2.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.1.0...5.2.0
[5.1.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.0.1...5.1.0
[5.0.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/5.0.0...5.0.1
[5.0.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/4.7.0...5.0.0
[4.7.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/4.6.0...4.7.0
[4.6.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/4.5.5...4.6.0
[4.5.5]: https://github.com/pronamic/wp-pronamic-ideal/compare/4.5.4...4.5.5
[4.5.4]: https://github.com/pronamic/wp-pronamic-ideal/compare/4.5.3...4.5.4
[4.5.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/4.5.2...4.5.3
[4.5.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/4.5.1...4.5.2
[4.5.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/4.5.0...4.5.1
[4.5.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/4.4.4...4.5.0
[4.4.4]: https://github.com/pronamic/wp-pronamic-ideal/compare/4.4.3...4.4.4
[4.4.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/4.4.2...4.4.3
[4.4.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/4.4.1...4.4.2
[4.4.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/4.4.0...4.4.1
[4.4.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/4.3.0...4.4.0
[4.3.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/4.2.3...4.3.0
[4.2.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/4.2.2...4.2.3
[4.2.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/4.2.1...4.2.2
[4.2.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/4.2.0...4.2.1
[4.2.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/4.1.1...4.2.0
[4.1.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/4.1.0...4.1.1
[4.1.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/4.0.0...4.1.0
[4.0.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.9.0...4.0.0
[3.9.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.8.9...3.9.0
[3.8.9]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.8.8...3.8.9
[3.8.8]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.8.7...3.8.8
[3.8.7]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.8.6...3.8.7
[3.8.6]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.8.5...3.8.6
[3.8.5]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.8.4...3.8.5
[3.8.4]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.8.3...3.8.4
[3.8.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.8.2...3.8.3
[3.8.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.8.1...3.8.2
[3.8.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.8.0...3.8.1
[3.8.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.7.3...3.8.0
[3.7.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.7.2...3.7.3
[3.7.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.7.1...3.7.2
[3.7.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.7.0...3.7.1
[3.7.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.6.6...3.7.0
[3.6.6]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.6.5...3.6.6
[3.6.5]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.6.4...3.6.5
[3.6.4]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.6.3...3.6.4
[3.6.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.6.2...3.6.3
[3.6.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.6.1...3.6.2
[3.6.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.6.1...3.6.1
[3.6.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.5.2...3.6.1
[3.5.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.5.1...3.5.2
[3.5.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.5.0...3.5.1
[3.5.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.4.2...3.5.0
[3.4.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.4.1...3.4.2
[3.4.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.4.0...3.4.1
[3.4.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.3.3...3.4.0
[3.3.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.3.2...3.3.3
[3.3.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.3.1...3.3.2
[3.3.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.3.0...3.3.1
[3.3.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.2.4...3.3.0
[3.2.4]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.2.3...3.2.4
[3.2.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.2.2...3.2.3
[3.2.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.2.1...3.2.2
[3.2.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.2.0...3.2.1
[3.2.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.1.5...3.2.0
[3.1.5]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.1.4...3.1.5
[3.1.4]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.1.3...3.1.4
[3.1.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.1.2...3.1.3
[3.1.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.1.1...3.1.2
[3.1.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.1.0...3.1.1
[3.1.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/3.0.0...3.1.0
[3.0.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.9.4...3.0.0
[2.9.4]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.9.3...2.9.4
[2.9.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.9.2...2.9.3
[2.9.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.9.1...2.9.2
[2.9.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.9.0...2.9.1
[2.9.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.8.9...2.9.0
[2.8.9]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.8.8...2.8.9
[2.8.8]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.8.7...2.8.8
[2.8.7]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.8.6...2.8.7
[2.8.6]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.8.5...2.8.6
[2.8.5]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.8.4...2.8.5
[2.8.4]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.8.3...2.8.4
[2.8.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.8.2...2.8.3
[2.8.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.8.1...2.8.2
[2.8.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.8.0...2.8.1
[2.8.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.7.7...2.8.0
[2.7.7]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.7.6...2.7.7
[2.7.6]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.7.5...2.7.6
[2.7.5]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.7.4...2.7.5
[2.7.4]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.7.3...2.7.4
[2.7.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.7.2...2.7.3
[2.7.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.7.1...2.7.2
[2.7.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.7.0...2.7.1
[2.7.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.6.9...2.7.0
[2.6.9]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.6.8...2.6.9
[2.6.8]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.6.7...2.6.8
[2.6.7]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.6.6...2.6.7
[2.6.6]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.6.5...2.6.6
[2.6.5]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.6.4...2.6.5
[2.6.4]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.6.3...2.6.4
[2.6.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.6.2...2.6.3
[2.6.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.6.1...2.6.2
[2.6.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.6.0...2.6.1
[2.6.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.5.0...2.6.0
[2.5.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.4.3...2.5.0
[2.4.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.4.2...2.4.3
[2.4.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.4.1...2.4.2
[2.4.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.4.0...2.4.1
[2.4.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.3.1...2.4.0
[2.3.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.3.0...2.3.1
[2.3.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.2.4...2.3.0
[2.2.4]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.2.3...2.2.4
[2.2.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.2.2...2.2.3
[2.2.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.2.1...2.2.2
[2.2.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.2.0...2.2.1
[2.2.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.1.0...2.2.0
[2.1.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.0.7...2.1.0
[2.0.7]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.0.6...2.0.7
[2.0.6]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.0.5...2.0.6
[2.0.5]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.0.4...2.0.5
[2.0.4]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.0.3...2.0.4
[2.0.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.0.2...2.0.3
[2.0.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.0.1...2.0.2
[2.0.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/2.0.0...2.0.1
[2.0.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/1.3.4...2.0.0
[1.3.4]: https://github.com/pronamic/wp-pronamic-ideal/compare/1.3.3...1.3.4
[1.3.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/1.3.2...1.3.3
[1.3.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/1.3.1...1.3.2
[1.3.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/1.3.0...1.3.1
[1.3.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/1.2.11...1.3.0
[1.2.11]: https://github.com/pronamic/wp-pronamic-ideal/compare/1.2.10...1.2.11
[1.2.10]: https://github.com/pronamic/wp-pronamic-ideal/compare/1.2.9...1.2.10
[1.2.9]: https://github.com/pronamic/wp-pronamic-ideal/compare/1.2.8...1.2.9
[1.2.8]: https://github.com/pronamic/wp-pronamic-ideal/compare/1.2.7...1.2.8
[1.2.7]: https://github.com/pronamic/wp-pronamic-ideal/compare/1.2.6...1.2.7
[1.2.6]: https://github.com/pronamic/wp-pronamic-ideal/compare/1.2.5...1.2.6
[1.2.5]: https://github.com/pronamic/wp-pronamic-ideal/compare/1.2.4...1.2.5
[1.2.4]: https://github.com/pronamic/wp-pronamic-ideal/compare/1.2.3...1.2.4
[1.2.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/1.2.2...1.2.3
[1.2.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/1.2.1...1.2.2
[1.2.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/1.2...1.2.1
[1.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/1.1.1...1.2
[1.1.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/1.1...1.1.1
[1.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/1.0...1.1
[1.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.11.1...1.0
[beta-0.11.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.11.0...beta-0.11.1
[beta-0.11.0]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.10.1...beta-0.11.0
[beta-0.10.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.10...beta-0.10.1
[beta-0.10]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.9.9...beta-0.10
[beta-0.9.9]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.9.8...beta-0.9.9
[beta-0.9.8]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.9.7...beta-0.9.8
[beta-0.9.7]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.9.6...beta-0.9.7
[beta-0.9.6]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.9.5...beta-0.9.6
[beta-0.9.5]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.9.4...beta-0.9.5
[beta-0.9.4]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.9.3...beta-0.9.4
[beta-0.9.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.9.2...beta-0.9.3
[beta-0.9.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.9.1...beta-0.9.2
[beta-0.9.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.9...beta-0.9.1
[beta-0.9]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.8.6...beta-0.9
[beta-0.8.6]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.8.5...beta-0.8.6
[beta-0.8.5]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.8.4...beta-0.8.5
[beta-0.8.4]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.8.3...beta-0.8.4
[beta-0.8.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.8.2...beta-0.8.3
[beta-0.8.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.8.1...beta-0.8.2
[beta-0.8.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.8...beta-0.8.1
[beta-0.8]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.7.2...beta-0.8
[beta-0.7.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.7.1...beta-0.7.2
[beta-0.7.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.7...beta-0.7.1
[beta-0.7]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.6.2...beta-0.7
[beta-0.6.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.6.1...beta-0.6.2
[beta-0.6.1]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.6...beta-0.6.1
[beta-0.6]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.5...beta-0.6
[beta-0.5]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.4...beta-0.5
[beta-0.4]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.3...beta-0.4
[beta-0.3]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.2...beta-0.3
[beta-0.2]: https://github.com/pronamic/wp-pronamic-ideal/compare/beta-0.1...beta-0.2
