<?php
namespace Ninjalytics\Reporters;

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

include_once(__DIR__.'/base.php');

abstract class OrdersBase extends Base {
	
	public $ordersTypeColumn, $ordersStatusColumn, $ordersDateColumn, $orderItemsTable, $orderItemsOrderIdColumn, $orderItemsTypeColumn, $orderItemsMetaTable, $orderItemsIdColumn, $orderItemsNameColumn, $orderItemsMetaItemIdColumn, $orderItemAjdustmentsTable, $billingStateMetaKey, $orderCustomerFieldIsMeta, $orderCustomerFieldKey, $productPostType, $productCategoryTaxonomy, $productTagTaxonomy, $orderType, $refundOrderType, $productOrderItemsType, $completedOrderStatus, $defaultOrderStatuses, $hiddenOrderItemFields = [];
	
	function getGroupByFields() {
		return ninjalytics_get_groupby_fields();
	}
	
	function getCustomFields($includeDisplay = false, $productFieldsOnly = false) {
		return ninjalytics_getCustomFields($includeDisplay, $productFieldsOnly);
	}
	
	function getBuiltInFields() {
		return ninjalytics_get_default_fields();
	}
	
	function getRow($product, $fields, &$totals, $fieldbuilderFields, $fieldbuilderDependencies) {
		return ninjalytics_get_product_row($product, $fields, $totals, $fieldbuilderFields, $fieldbuilderDependencies);
	}
	
	public function getPrimaryItemsName() {
		return 'Orders';
	}
	
	
	public function getDataParams($baseFields) {
		
		// phpcs:disable WordPress.Security.NonceVerification.Missing -- This is a helper function, to be called after nonce is checked as needed
		
		$groupByProducts = ((int) $_POST['disable_product_grouping'] ?? 0) <= 0;
		$intermediateRounding = !empty( $_POST['intermediate_rounding'] );
		
		$standardFields = $this->getStandardFields();
		$reportVariations = $this->supports(PlatformFeatures::VARIATIONS) && !empty($_POST['variations']);
		
		
		// Based on woocoommerce/includes/admin/reports/class-wc-report-sales-by-product.php
		$dataParams = array(
			
			// Following code provided by and copyright Daniel von Mitschke, released under GNU General Public License (GPL) version 2 or later, used under GPL version 3 or later (see license/LICENSE.TXT)
			// Modified by Jonathan Hall
			$standardFields['order_item_name'][1] => array(
				'type' => $standardFields['order_item_name'][0],
				'function' => 'GROUP_CONCAT',
				'distinct' => true,
				'join_type' => 'LEFT',
				'name' => 'product_name'
			),
			// End code provided by Daniel von Mitschke
			$standardFields['quantity'][1] => array(
				'type' => $standardFields['quantity'][0],
				'order_item_type' => 'line_item',
				'function' => 'SUM',
				'join_type' => 'LEFT',
				'name' => 'quantity'
			),
			$standardFields['line_subtotal'][1] => array(
				'type' => $standardFields['line_subtotal'][0],
				'order_item_type' => 'line_item',
				'function' => $intermediateRounding ? 'PSRSUM' : 'SUM',
				'join_type' => 'LEFT',
				'name' => 'gross'
			),
			$standardFields['line_total'][1] => array(
				'type' => $standardFields['line_total'][0],
				'order_item_type' => 'line_item',
				'function' => $intermediateRounding ? 'PSRSUM' : 'SUM',
				'join_type' => 'LEFT',
				'name' => 'gross_after_discount'
			),
			$standardFields['line_tax'][1] => array(
				'type' => $standardFields['line_tax'][0],
				'order_item_type' => 'line_item',
				'function' => $intermediateRounding ? 'PSRSUM' : 'SUM',
				'join_type' => 'LEFT',
				'name' => 'taxes'
			)
		);
		
		if ($this->supports(PlatformFeatures::LINE_ITEM_ADJUSTMENTS) && !empty($_POST['adjustments'])) {
			$dataParams['order_item_adjustment.subtotal'] = array(
				'type' => 'order_item_adjustment',
				'order_item_type' => 'line_item',
				'function' => $intermediateRounding ? 'PSRSUM' : 'SUM',
				'join_type' => 'LEFT',
				'name' => 'adjustment_subtotal'
			);
			$dataParams['order_item_adjustment.total'] = array(
				'type' => 'order_item_adjustment',
				'order_item_type' => 'line_item',
				'function' => $intermediateRounding ? 'PSRSUM' : 'SUM',
				'join_type' => 'LEFT',
				'name' => 'adjustment_total'
			);
			$dataParams['order_item_adjustment.tax'] = array(
				'type' => 'order_item_adjustment',
				'order_item_type' => 'line_item',
				'function' => $intermediateRounding ? 'PSRSUM' : 'SUM',
				'join_type' => 'LEFT',
				'name' => 'adjustment_tax'
			);
		}
		
		
		if ( $groupByProducts || $_POST['disable_product_grouping'] == 2 ) {
			$dataParams[$standardFields['product_id'][1]] = array(
				'type' => $standardFields['product_id'][0],
				'order_item_type' => 'line_item',
				'function' => $_POST['disable_product_grouping'] == -1 ? 'GROUP_CONCAT' : '',
				'join_type' => 'LEFT',
				'name' => 'product_id'
			);
		}
		
		if ($reportVariations && $groupByProducts) {
			$dataParams[$standardFields['variation_id'][1]] = array(
				'type' => $standardFields['variation_id'][0],
				'order_item_type' => 'line_item',
				'function' => $_POST['disable_product_grouping'] == -1 ? 'GROUP_CONCAT' : '',
				'join_type' => 'LEFT',
				'name' => 'variation_id'
			);
		}

		// Add shipping methods virtual meta field when needed
		if (in_array('builtin::order_shipping_methods', $baseFields)) {
			$dataParams['_order_shipping_method'] = [
				'type' => 'meta',
				'function' => 'GROUP_CONCAT',
				'join_type' => 'LEFT',
				'name' => 'order_shipping_methods'
			];
		}

		if (in_array('builtin::line_item_count', $baseFields) || ninjalytics_hasTaxBreakoutField($baseFields)) {
			$dataParams[$this->orderItemsIdColumn] = array(
				'type' => 'order_item',
				'order_item_type' => 'line_item',
					'function' => 'GROUP_CONCAT',
					'join_type' => 'LEFT',
					'name' => 'order_item_ids'
			);
		}
		
		if ( in_array('builtin::avg_order_total', $baseFields) ) {
			$dataParams[$standardFields['order_total'][1]] = array(
				'type' => $standardFields['order_total'][0],
				'function' => 'AVG',
				'join_type' => 'LEFT',
				'name' => 'avg_order_total'
			);
		}
		foreach ($baseFields as $field) {
			if (substr($field, 0, 18) == 'order_item_total::') {
				$fieldNameRaw = substr($field, 18);
				$fieldName = esc_sql($fieldNameRaw);
				
				$dataParams[$fieldName] = array(
					'type' => 'order_item_meta',
					'order_item_type' => 'line_item',
					'function' => 'SUM',
					'join_type' => 'LEFT',
					'name' => ninjalytics_fixSanitizeKey(sanitize_key('order_item_total__'.$fieldNameRaw))
				);
			} else if (!empty($_POST['enable_custom_segments']) && ($field == 'builtin::groupby_field' || $field == 'builtin::groupby_field2' || $field == 'builtin::groupby_field3' || $field == 'builtin::groupby_field4' || $field == 'builtin::groupby_field5') ) {
				
				$groupbyFieldNum = $field == 'builtin::groupby_field' ? '' : $field[22];
				
				$groupByField = sanitize_text_field(wp_unslash($_POST['groupby'.$groupbyFieldNum] ?? ''));
				if ( !empty($groupByField) && $groupByField != 'i_builtin::item_price' ) {
					if (in_array($groupByField, array('o_builtin::order_month', 'o_builtin::order_quarter', 'o_builtin::order_year', 'o_builtin::order_date', 'o_builtin::order_day'))) {
						switch ($groupByField) {
							case 'o_builtin::order_month':
								$sqlFunction = 'MONTH';
								break;
							case 'o_builtin::order_quarter':
								$sqlFunction = 'QUARTER';
								break;
							case 'o_builtin::order_year':
								$sqlFunction = 'YEAR';
								break;
							case 'o_builtin::order_day':
								$sqlFunction = 'DAY';
								break;
							default:
								$sqlFunction = 'DATE';
						}
						$dataParams[$standardFields['order_date'][1]] = array(
							'type' => $standardFields['order_date'][0],
							'order_item_type' => 'line_item',
							'function' => $sqlFunction,
							'join_type' => 'LEFT',
							'name' => 'groupby_field'.$groupbyFieldNum
						);
					} else if ($this->supports(PlatformFeatures::ORDER_SOURCE) && $groupByField == 'o_builtin::order_source') {
						// Replicated in shipping data function below
						$dataParams['_wc_order_attribution_source_type'] = [
							'type' => 'meta',
							'join_type' => 'LEFT',
							'function' => '',
							'name' => 'groupby_field'.$groupbyFieldNum
						];
						$dataParams['_wc_order_attribution_utm_source'] = [
							'type' => 'meta',
							'join_type' => 'LEFT',
							'function' => '',
							'name' => 'groupby_field'.$groupbyFieldNum.'b'
						];
					} else if ($groupByField[0] != 'p') {
						$fieldName = esc_sql(substr($groupByField, 2));
						
						$dataParams[$fieldName] = array(
							'type' => ($groupByField[0] == 'i' ? 'order_item_meta' : 'meta'),
							'order_item_type' => 'line_item',
							'function' => '',
							'join_type' => 'LEFT',
							'name' => 'groupby_field'.$groupbyFieldNum
						);
						
					}
					
				}
			}
		}
		return $dataParams;
		
		
		// phpcs:enable WordPress.Security.NonceVerification.Missing
	}
	
	public function getGroupByFieldTypes() {
		return [
			'o' => 'Order',
			'i' => 'Order Line Item',
			'p' => 'Product'
		];
	}
	
	function getSelectForField($key, $type) {
			
		switch ( $type ) {
			case 'meta':
				$virtualMeta = $this->getVirtualOrderMeta();
				if (isset($virtualMeta[$key])) {
					return $virtualMeta[$key]['field'];
				}
				break;
			case 'order_item_meta':
				return "order_item_meta_{$key}.meta_value";
			case 'order_item':
				return "order_items.{$key}";
			case 'order_item_adjustment':
				return "order_item_adjustments.{$key}";
		}
		
		return parent::getSelectForField($key, $type);
	}
	
	function addJoinForField($raw_key, $key, $value, &$joins, &$joinParams) {
		$join_type = isset( $value['join_type'] ) ? $value['join_type'] : 'INNER';
		$type      = isset( $value['type'] ) ? $value['type'] : false;
		switch ( $type ) {
			case 'meta':
				$virtualMeta = $this->getVirtualOrderMeta();
				if (isset($virtualMeta[$key])) {
					if (isset($virtualMeta[$key]['joins'])) {
						foreach ($virtualMeta[$key]['joins'] as $joinId => $joinSql) {
							$joins[$joinId] = "{$join_type} JOIN {$joinSql}";
						}
					}
					return;
				}
				break;
			case 'order_item_meta':
				if ( !empty( $value['order_item_type'] )  || !isset($joins['order_items']) ) {
					$joins['order_items'] = "{$join_type} JOIN {$this->orderItemsTable} AS order_items ON (posts.id = order_items.{$this->orderItemsOrderIdColumn})";
	
					if ( ! empty( $value['order_item_type'] ) ) {
						$joins['order_items'] .= " AND (order_items.{$this->orderItemsTypeColumn} = %s)";
						$joinParams['order_items'] = [$value['order_item_type']];
					}
				}

				$joins[ "order_item_meta_{$key}" ] = "{$join_type} JOIN {$this->orderItemsMetaTable} AS order_item_meta_{$key} ON " .
													"(order_items.{$this->orderItemsIdColumn} = order_item_meta_{$key}.{$this->orderItemsMetaItemIdColumn}) " .
													" AND (order_item_meta_{$key}.meta_key = %s)";
				$joinParams["order_item_meta_{$key}"] = [$raw_key];
				return;
			case 'order_item':
				if (!isset($joins['order_items'])) {
					$joins['order_items'] = "{$join_type} JOIN {$this->orderItemsTable} AS order_items ON (posts.id = order_items.{$this->orderItemsOrderIdColumn})";
				}
				return;
			case 'order_item_adjustment':
				$joins['order_item_adjustment'] = "{$join_type} JOIN {$this->orderItemAjdustmentsTable} AS order_item_adjustments ON (order_item_adjustments.object_type='order_item' AND order_item_adjustments.object_id = order_items.{$this->orderItemsIdColumn})";
				return;
		}
		
		parent::addJoinForField($raw_key, $key, $value, $joins, $joinParams);
	}
	
	
	function getWhereMetaField($key, $value) {
		if ( isset( $value['type'] ) && 'order_item_meta' === $value['type'] ) {
			return "order_item_meta_{$key}.meta_value";
		}
		$virtualMeta = $this->getVirtualOrderMeta();
		if ( isset($virtualMeta[$key]) ) {
			return $virtualMeta[$key]['field'];
		}
		return parent::getWhereMetaField($key, $value);
	}
	
}
