/*!
 * # Semantic UI 2.2.12 - Dropdown
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,t,n,i){"use strict";e.fn.dropdown=function(i){var o,a=e(this),s=e(n),r=a.selector||"",l="ontouchstart"in n.documentElement,c=(new Date).getTime(),u=[],d=arguments[0],v="string"==typeof d,m=[].slice.call(arguments,1);return a.each(function(f){var h,g,p,b,w,x,C,S=e.isPlainObject(i)?e.extend(!0,{},e.fn.dropdown.settings,i):e.extend({},e.fn.dropdown.settings),y=S.className,T=S.message,A=S.fields,k=S.keys,L=S.metadata,D=S.namespace,I=S.regExp,R=S.selector,q=S.error,V=S.templates,E="."+D,O="module-"+D,F=e(this),P=e(S.context),M=F.find(R.text),H=F.find(R.search),z=F.find(R.input),j=(F.find(R.icon),F.prev().find(R.text).length>0?F.prev().find(R.text):F.prev()),N=F.children(R.menu),U=N.find(R.item),B=!1,W=!1,K=!1,$=this,Q=F.data(O);C={initialize:function(){C.debug("Initializing dropdown",S),C.is.alreadySetup()?C.setup.reference():(C.setup.layout(),C.refreshData(),C.save.defaults(),C.restore.selected(),C.create.id(),C.bind.events(),C.observeChanges(),C.instantiate())},instantiate:function(){C.verbose("Storing instance of dropdown",C),Q=C,F.data(O,C)},destroy:function(){C.verbose("Destroying previous dropdown",F),C.remove.tabbable(),F.off(E).removeData(O),N.off(E),s.off(p),w&&w.disconnect(),x&&x.disconnect()},observeChanges:function(){"MutationObserver"in t&&(w=new MutationObserver(function(e){C.debug("<select> modified, recreating menu"),C.setup.select()}),x=new MutationObserver(function(e){C.debug("Menu modified, updating selector cache"),C.refresh()}),C.has.input()&&w.observe(z[0],{childList:!0,subtree:!0}),C.has.menu()&&x.observe(N[0],{childList:!0,subtree:!0}),C.debug("Setting up mutation observer",w,x))},create:{id:function(){b=(Math.random().toString(16)+"000000000").substr(2,8),p="."+b,C.verbose("Creating unique id for element",b)},userChoice:function(t){var n,i,o;return!!(t=t||C.get.userValues())&&(t=e.isArray(t)?t:[t],e.each(t,function(t,a){!1===C.get.item(a)&&(o=S.templates.addition(C.add.variables(T.addResult,a)),i=e("<div />").html(o).attr("data-"+L.value,a).attr("data-"+L.text,a).addClass(y.addition).addClass(y.item),n=void 0===n?i:n.add(i),C.verbose("Creating user choices for value",a,i))}),n)},userLabels:function(t){var n=C.get.userValues();n&&(C.debug("Adding user labels",n),e.each(n,function(e,t){C.verbose("Adding custom user value"),C.add.label(t,t)}))},menu:function(){N=e("<div />").addClass(y.menu).appendTo(F)}},search:function(e){e=void 0!==e?e:C.get.query(),C.verbose("Searching for query",e),C.filter(e)},select:{firstUnfiltered:function(){C.verbose("Selecting first non-filtered element"),C.remove.selectedItem(),U.not(R.unselectable).eq(0).addClass(y.selected)},nextAvailable:function(e){var t=(e=e.eq(0)).nextAll(R.item).not(R.unselectable).eq(0),n=e.prevAll(R.item).not(R.unselectable).eq(0);t.length>0?(C.verbose("Moving selection to",t),t.addClass(y.selected)):(C.verbose("Moving selection to",n),n.addClass(y.selected))}},setup:{api:function(){var e={debug:S.debug,on:!1};C.verbose("First request, initializing API"),F.api(e)},layout:function(){F.is("select")&&(C.setup.select(),C.setup.returnedObject()),C.has.menu()||C.create.menu(),C.is.search()&&!C.has.search()&&(C.verbose("Adding search input"),H=e("<input />").addClass(y.search).prop("autocomplete","off").insertBefore(M)),S.allowTab&&C.set.tabbable()},select:function(){var t=C.get.selectValues();C.debug("Dropdown initialized on a select",t),F.is("select")&&(z=F),z.parent(R.dropdown).length>0?(C.debug("ui dropdown already exists. Creating dropdown menu only"),F=z.closest(R.dropdown),C.has.menu()||C.create.menu(),N=F.children(R.menu),C.setup.menu(t)):(C.debug("Creating entire dropdown from select"),F=e("<div />").attr("class",z.attr("class")).addClass(y.selection).addClass(y.dropdown).html(V.dropdown(t)).insertBefore(z),z.hasClass(y.multiple)&&!1===z.prop("multiple")&&(C.error(q.missingMultiple),z.prop("multiple",!0)),z.is("[multiple]")&&C.set.multiple(),z.prop("disabled")&&(C.debug("Disabling dropdown"),F.addClass(y.disabled)),z.removeAttr("class").detach().prependTo(F)),C.refresh()},menu:function(e){N.html(V.menu(e,A)),U=N.find(R.item)},reference:function(){C.debug("Dropdown behavior was called on select, replacing with closest dropdown"),F=F.parent(R.dropdown),C.refresh(),C.setup.returnedObject(),v&&(Q=C,C.invoke(d))},returnedObject:function(){var e=a.slice(0,f),t=a.slice(f+1);a=e.add(F).add(t)}},refresh:function(){C.refreshSelectors(),C.refreshData()},refreshSelectors:function(){C.verbose("Refreshing selector cache"),M=F.find(R.text),H=F.find(R.search),z=F.find(R.input),F.find(R.icon),j=F.prev().find(R.text).length>0?F.prev().find(R.text):F.prev(),N=F.children(R.menu),U=N.find(R.item)},refreshData:function(){C.verbose("Refreshing cached metadata"),U.removeData(L.text).removeData(L.value),F.removeData(L.defaultText).removeData(L.defaultValue).removeData(L.placeholderText)},toggle:function(){C.verbose("Toggling menu visibility"),C.is.active()?C.hide():C.show()},show:function(t){if(t=e.isFunction(t)?t:function(){},C.can.show()&&!C.is.active()){if(C.debug("Showing dropdown"),C.is.multiple()&&!C.has.search()&&C.is.allFiltered())return!0;!C.has.message()||C.has.maxSelections()||C.has.allResultsFiltered()||C.remove.message(),!1!==S.onShow.call($)&&C.animate.show(function(){C.can.click()&&C.bind.intent(),C.set.visible(),t.call($)})}},hide:function(t){t=e.isFunction(t)?t:function(){},C.is.active()&&(C.debug("Hiding dropdown"),!1!==S.onHide.call($)&&C.animate.hide(function(){C.remove.visible(),t.call($)}))},hideOthers:function(){C.verbose("Finding other dropdowns to hide"),a.not(F).has(R.menu+"."+y.visible).dropdown("hide")},hideMenu:function(){C.verbose("Hiding menu  instantaneously"),C.remove.active(),C.remove.visible(),N.transition("hide")},hideSubMenus:function(){var e=N.children(R.item).find(R.menu);C.verbose("Hiding sub menus",e),e.transition("hide")},bind:{events:function(){l&&C.bind.touchEvents(),C.bind.keyboardEvents(),C.bind.inputEvents(),C.bind.mouseEvents()},touchEvents:function(){C.debug("Touch device detected binding additional touch events"),C.is.searchSelection()||C.is.single()&&F.on("touchstart"+E,C.event.test.toggle),N.on("touchstart"+E,R.item,C.event.item.mouseenter)},keyboardEvents:function(){C.verbose("Binding keyboard events"),F.on("keydown"+E,C.event.keydown),C.has.search()&&F.on(C.get.inputEvent()+E,R.search,C.event.input),C.is.multiple()&&s.on("keydown"+p,C.event.document.keydown)},inputEvents:function(){C.verbose("Binding input change events"),F.on("change"+E,R.input,C.event.change)},mouseEvents:function(){C.verbose("Binding mouse events"),C.is.multiple()&&F.on("click"+E,R.label,C.event.label.click).on("click"+E,R.remove,C.event.remove.click),C.is.searchSelection()?(F.on("mousedown"+E,R.menu,C.event.menu.mousedown).on("mouseup"+E,R.menu,C.event.menu.mouseup).on("click"+E,R.icon,C.event.icon.click).on("click"+E,R.search,C.show).on("focus"+E,R.search,C.event.search.focus).on("blur"+E,R.search,C.event.search.blur).on("click"+E,R.text,C.event.text.focus),C.is.multiple()&&F.on("click"+E,C.event.click)):("click"==S.on?F.on("click"+E,R.icon,C.event.icon.click).on("click"+E,C.event.test.toggle):"hover"==S.on?F.on("mouseenter"+E,C.delay.show).on("mouseleave"+E,C.delay.hide):F.on(S.on+E,C.toggle),F.on("mousedown"+E,C.event.mousedown).on("mouseup"+E,C.event.mouseup).on("focus"+E,C.event.focus).on("blur"+E,C.event.blur)),N.on("mouseenter"+E,R.item,C.event.item.mouseenter).on("mouseleave"+E,R.item,C.event.item.mouseleave).on("click"+E,R.item,C.event.item.click)},intent:function(){C.verbose("Binding hide intent event to document"),l&&s.on("touchstart"+p,C.event.test.touch).on("touchmove"+p,C.event.test.touch),s.on("click"+p,C.event.test.hide)}},unbind:{intent:function(){C.verbose("Removing hide intent event from document"),l&&s.off("touchstart"+p).off("touchmove"+p),s.off("click"+p)}},filter:function(e){var t=void 0!==e?e:C.get.query(),n=function(){C.is.multiple()&&C.filterActive(),C.select.firstUnfiltered(),C.has.allResultsFiltered()?S.onNoResults.call($,t)?S.allowAdditions||(C.verbose("All items filtered, showing message",t),C.add.message(T.noResults)):(C.verbose("All items filtered, hiding dropdown",t),C.hideMenu()):C.remove.message(),S.allowAdditions&&C.add.userSuggestion(e),C.is.searchSelection()&&C.can.show()&&C.is.focusedOnSearch()&&C.show()};S.useLabels&&C.has.maxSelections()||(S.apiSettings?C.can.useAPI()?C.queryRemote(t,function(){n()}):C.error(q.noAPI):(C.filterItems(t),n()))},queryRemote:function(t,n){var i={errorDuration:!1,throttle:S.throttle,urlData:{query:t},onError:function(){C.add.message(T.serverError),n()},onFailure:function(){C.add.message(T.serverError),n()},onSuccess:function(e){C.remove.message(),C.setup.menu({values:e[A.remoteValues]}),n()}};F.api("get request")||C.setup.api(),i=e.extend(!0,{},i,S.apiSettings),F.api("setting",i).api("query")},filterItems:function(t){var n=void 0!==t?t:C.get.query(),i=null,o=C.escape.regExp(n),a=new RegExp("^"+o,"igm");C.has.query()&&(i=[],C.verbose("Searching for matching values",n),U.each(function(){var t,o,s=e(this);if("both"==S.match||"text"==S.match){if(-1!==(t=String(C.get.choiceText(s,!1))).search(a))return i.push(this),!0;if(S.fullTextSearch&&C.fuzzySearch(n,t))return i.push(this),!0}if("both"==S.match||"value"==S.match){if(-1!==(o=String(C.get.choiceValue(s,t))).search(a))return i.push(this),!0;if(S.fullTextSearch&&C.fuzzySearch(n,o))return i.push(this),!0}})),C.debug("Showing only matched items",n),C.remove.filteredItem(),i&&U.not(i).addClass(y.filtered)},fuzzySearch:function(e,t){var n=t.length,i=e.length;if(e=e.toLowerCase(),t=t.toLowerCase(),i>n)return!1;if(i===n)return e===t;e:for(var o=0,a=0;o<i;o++){for(var s=e.charCodeAt(o);a<n;)if(t.charCodeAt(a++)===s)continue e;return!1}return!0},filterActive:function(){S.useLabels&&U.filter("."+y.active).addClass(y.filtered)},focusSearch:function(){C.is.search()&&!C.is.focusedOnSearch()&&H[0].focus()},forceSelection:function(){var e=U.not(y.filtered).filter("."+y.selected).eq(0),t=U.not(y.filtered).filter("."+y.active).eq(0),n=e.length>0?e:t,i=n.size()>0;if(C.has.query()){if(i)return C.debug("Forcing partial selection to selected item",n),void C.event.item.click.call(n);C.remove.searchTerm()}C.hide()},event:{change:function(){K||(C.debug("Input changed, updating selection"),C.set.selected())},focus:function(){S.showOnFocus&&!B&&C.is.hidden()&&!g&&C.show()},click:function(t){e(t.target).is(F)&&!C.is.focusedOnSearch()&&C.focusSearch()},blur:function(e){g=n.activeElement===this,B||g||(C.remove.activeLabel(),C.hide())},mousedown:function(){B=!0},mouseup:function(){B=!1},search:{focus:function(){B=!0,C.is.multiple()&&C.remove.activeLabel(),S.showOnFocus&&(C.search(),C.show())},blur:function(e){g=n.activeElement===this,W||g?g&&S.forceSelection&&C.forceSelection():C.is.multiple()?(C.remove.activeLabel(),C.hide()):S.forceSelection?C.forceSelection():C.hide()}},icon:{click:function(e){C.toggle(),e.stopPropagation()}},text:{focus:function(e){B=!0,C.focusSearch()}},input:function(e){(C.is.multiple()||C.is.searchSelection())&&C.set.filtered(),clearTimeout(C.timer),C.timer=setTimeout(C.search,S.delay.search)},label:{click:function(t){var n=e(this),i=F.find(R.label),o=i.filter("."+y.active),a=n.nextAll("."+y.active),s=n.prevAll("."+y.active),r=a.length>0?n.nextUntil(a).add(o).add(n):n.prevUntil(s).add(o).add(n);t.shiftKey?(o.removeClass(y.active),r.addClass(y.active)):t.ctrlKey?n.toggleClass(y.active):(o.removeClass(y.active),n.addClass(y.active)),S.onLabelSelect.apply(this,i.filter("."+y.active))}},remove:{click:function(){var t=e(this).parent();t.hasClass(y.active)?C.remove.activeLabels():C.remove.activeLabels(t)}},test:{toggle:function(e){var t=C.is.multiple()?C.show:C.toggle;C.determine.eventOnElement(e,t)&&e.preventDefault()},touch:function(e){C.determine.eventOnElement(e,function(){"touchstart"==e.type?C.timer=setTimeout(function(){C.hide()},S.delay.touch):"touchmove"==e.type&&clearTimeout(C.timer)}),e.stopPropagation()},hide:function(e){C.determine.eventInModule(e,C.hide)}},menu:{mousedown:function(){W=!0},mouseup:function(){W=!1}},item:{mouseenter:function(t){var n=e(this).children(R.menu),i=e(this).siblings(R.item).children(R.menu);n.length>0&&(clearTimeout(C.itemTimer),C.itemTimer=setTimeout(function(){C.verbose("Showing sub-menu",n),e.each(i,function(){C.animate.hide(!1,e(this))}),C.animate.show(!1,n)},S.delay.show),t.preventDefault())},mouseleave:function(t){var n=e(this).children(R.menu);n.length>0&&(clearTimeout(C.itemTimer),C.itemTimer=setTimeout(function(){C.verbose("Hiding sub-menu",n),C.animate.hide(!1,n)},S.delay.hide))},touchend:function(){},click:function(t){var n=e(this),i=e(t?t.target:""),o=n.find(R.menu),a=C.get.choiceText(n),s=C.get.choiceValue(n,a),r=o.length>0;o.find(i).length>0||r&&!S.allowCategorySelection||(S.useLabels||(C.remove.filteredItem(),C.remove.searchTerm(),C.set.scrollPosition(n)),C.determine.selectAction.call(this,a,s))}},document:{keydown:function(e){var t=e.which;if(C.is.inObject(t,k)){var n=F.find(R.label),i=n.filter("."+y.active),o=(i.data(L.value),n.index(i)),a=n.length,s=i.length>0,r=i.length>1,l=0===o,c=o+1==a,u=C.is.searchSelection(),d=C.is.focusedOnSearch(),v=C.is.focused(),m=d&&0===C.get.caretPosition();if(u&&!s&&!d)return;t==k.leftArrow?!v&&!m||s?s&&(e.shiftKey?C.verbose("Adding previous label to selection"):(C.verbose("Selecting previous label"),n.removeClass(y.active)),l&&!r?i.addClass(y.active):i.prev(R.siblingLabel).addClass(y.active).end(),e.preventDefault()):(C.verbose("Selecting previous label"),n.last().addClass(y.active)):t==k.rightArrow?(v&&!s&&n.first().addClass(y.active),s&&(e.shiftKey?C.verbose("Adding next label to selection"):(C.verbose("Selecting next label"),n.removeClass(y.active)),c?u?d?n.removeClass(y.active):C.focusSearch():r?i.next(R.siblingLabel).addClass(y.active):i.addClass(y.active):i.next(R.siblingLabel).addClass(y.active),e.preventDefault())):t==k.deleteKey||t==k.backspace?s?(C.verbose("Removing active labels"),c&&u&&!d&&C.focusSearch(),i.last().next(R.siblingLabel).addClass(y.active),C.remove.activeLabels(i),e.preventDefault()):m&&!s&&t==k.backspace&&(C.verbose("Removing last label on input backspace"),i=n.last().addClass(y.active),C.remove.activeLabels(i)):i.removeClass(y.active)}}},keydown:function(e){var t=e.which;if(C.is.inObject(t,k)){var n,i=U.not(R.unselectable).filter("."+y.selected).eq(0),o=N.children("."+y.active).eq(0),a=i.length>0?i:o,s=a.length>0?a.siblings(":not(."+y.filtered+")").andSelf():N.children(":not(."+y.filtered+")"),r=a.children(R.menu),l=a.closest(R.menu),c=l.hasClass(y.visible)||l.hasClass(y.animating)||l.parent(R.menu).length>0,u=r.length>0,d=a.length>0,v=a.not(R.unselectable).length>0,m=t==k.delimiter&&S.allowAdditions&&C.is.multiple();if(C.is.visible()){if((t==k.enter||m)&&(t==k.enter&&d&&u&&!S.allowCategorySelection?(C.verbose("Pressed enter on unselectable category, opening sub menu"),t=k.rightArrow):v&&(C.verbose("Selecting item from keyboard shortcut",a),C.event.item.click.call(a,e),C.is.searchSelection()&&C.remove.searchTerm()),e.preventDefault()),t==k.leftArrow&&l[0]!==N[0]&&(C.verbose("Left key pressed, closing sub-menu"),C.animate.hide(!1,l),a.removeClass(y.selected),l.closest(R.item).addClass(y.selected),e.preventDefault()),t==k.rightArrow&&u&&(C.verbose("Right key pressed, opening sub-menu"),C.animate.show(!1,r),a.removeClass(y.selected),r.find(R.item).eq(0).addClass(y.selected),e.preventDefault()),t==k.upArrow){if(n=d&&c?a.prevAll(R.item+":not("+R.unselectable+")").eq(0):U.eq(0),s.index(n)<0)return C.verbose("Up key pressed but reached top of current menu"),void e.preventDefault();C.verbose("Up key pressed, changing active item"),a.removeClass(y.selected),n.addClass(y.selected),C.set.scrollPosition(n),e.preventDefault()}if(t==k.downArrow){if(0===(n=d&&c?n=a.nextAll(R.item+":not("+R.unselectable+")").eq(0):U.eq(0)).length)return C.verbose("Down key pressed but reached bottom of current menu"),void e.preventDefault();C.verbose("Down key pressed, changing active item"),U.removeClass(y.selected),n.addClass(y.selected),C.set.scrollPosition(n),e.preventDefault()}t==k.pageUp&&(C.scrollPage("up"),e.preventDefault()),t==k.pageDown&&(C.scrollPage("down"),e.preventDefault()),t==k.escape&&(C.verbose("Escape key pressed, closing dropdown"),C.hide())}else m&&e.preventDefault(),t==k.downArrow&&(C.verbose("Down key pressed, showing dropdown"),C.show(),e.preventDefault())}else C.is.selection()&&!C.is.search()&&C.set.selectedLetter(String.fromCharCode(t))}},trigger:{change:function(){var e=n.createEvent("HTMLEvents"),t=z[0];t&&(C.verbose("Triggering native change event"),e.initEvent("change",!0,!1),t.dispatchEvent(e))}},determine:{selectAction:function(t,n){C.verbose("Determining action",S.action),e.isFunction(C.action[S.action])?(C.verbose("Triggering preset action",S.action,t,n),C.action[S.action].call(this,t,n)):e.isFunction(S.action)?(C.verbose("Triggering user action",S.action,t,n),S.action.call(this,t,n)):C.error(q.action,S.action)},eventInModule:function(t,i){var o=e(t.target),a=o.closest(n.documentElement).length>0,s=o.closest(F).length>0;return i=e.isFunction(i)?i:function(){},a&&!s?(C.verbose("Triggering event",i),i(),!0):(C.verbose("Event occurred in dropdown, canceling callback"),!1)},eventOnElement:function(t,n){var i=e(t.target),o=i.closest(R.siblingLabel),a=0===F.find(o).length,s=0===i.closest(N).length;return n=e.isFunction(n)?n:function(){},a&&s?(C.verbose("Triggering event",n),n(),!0):(C.verbose("Event occurred in dropdown menu, canceling callback"),!1)}},action:{nothing:function(){},activate:function(t,n){if(n=void 0!==n?n:t,C.can.activate(e(this))){if(C.set.selected(n,e(this)),C.is.multiple()&&!C.is.allFiltered())return;C.hideAndClear()}},select:function(e,t){C.action.activate.call(this)},combo:function(t,n){n=void 0!==n?n:t,C.set.selected(n,e(this)),C.hideAndClear()},hide:function(e,t){C.set.value(t),C.hideAndClear()}},get:{id:function(){return b},defaultText:function(){return F.data(L.defaultText)},defaultValue:function(){return F.data(L.defaultValue)},placeholderText:function(){return F.data(L.placeholderText)||""},text:function(){return M.text()},query:function(){return e.trim(H.val())},searchWidth:function(e){return e*S.glyphWidth+"em"},selectionCount:function(){var t=C.get.values();return C.is.multiple()?e.isArray(t)?t.length:0:""!==C.get.value()?1:0},transition:function(e){return"auto"==S.transition?C.is.upward(e)?"slide up":"slide down":S.transition},userValues:function(){var t=C.get.values();return!!t&&(t=e.isArray(t)?t:[t],e.grep(t,function(e){return!1===C.get.item(e)}))},uniqueArray:function(t){return e.grep(t,function(n,i){return e.inArray(n,t)===i})},caretPosition:function(){var e,t,i=H.get(0);return"selectionStart"in i?i.selectionStart:n.selection?(i.focus(),t=(e=n.selection.createRange()).text.length,e.moveStart("character",-i.value.length),e.text.length-t):void 0},value:function(){var t=z.length>0?z.val():F.data(L.value);return e.isArray(t)&&1===t.length&&""===t[0]?"":t},values:function(){var e=C.get.value();return""===e?"":!C.has.selectInput()&&C.is.multiple()?"string"==typeof e?e.split(S.delimiter):"":e},remoteValues:function(){var t=C.get.values(),n=!1;return t&&("string"==typeof t&&(t=[t]),n={},e.each(t,function(e,t){var i=C.read.remoteData(t);C.verbose("Restoring value from session data",i,t),n[t]=i||t})),n},choiceText:function(t,n){if(n=void 0!==n?n:S.preserveHTML,t)return t.find(R.menu).length>0&&(C.verbose("Retreiving text of element with sub-menu"),(t=t.clone()).find(R.menu).remove(),t.find(R.menuicon).remove()),void 0!==t.data(L.text)?t.data(L.text):n?e.trim(t.html()):e.trim(t.text())},choiceValue:function(t,n){return n=n||C.get.choiceText(t),!!t&&(void 0!==t.data(L.value)?String(t.data(L.value)):"string"==typeof n?e.trim(n.toLowerCase()):String(n))},inputEvent:function(){var e=H[0];return!!e&&(void 0!==e.oninput?"input":void 0!==e.onpropertychange?"propertychange":"keyup")},selectValues:function(){var t={values:[]};return F.find("option").each(function(){var n=e(this),i=n.html(),o=n.attr("disabled"),a=void 0!==n.attr("value")?n.attr("value"):i;"auto"===S.placeholder&&""===a?t.placeholder=i:t.values.push({name:i,value:a,disabled:o})}),S.placeholder&&"auto"!==S.placeholder&&(C.debug("Setting placeholder value to",S.placeholder),t.placeholder=S.placeholder),S.sortSelect?(t.values.sort(function(e,t){return e.name>t.name?1:-1}),C.debug("Retrieved and sorted values from select",t)):C.debug("Retreived values from select",t),t},activeItem:function(){return U.filter("."+y.active)},selectedItem:function(){var e=U.not(R.unselectable).filter("."+y.selected);return e.length>0?e:U.eq(0)},itemWithAdditions:function(e){var t=C.get.item(e),n=C.create.userChoice(e);return n&&n.length>0&&(t=t.length>0?t.add(n):n),t},item:function(t,n){var i,o,a=!1;return t=void 0!==t?t:void 0!==C.get.values()?C.get.values():C.get.text(),i=o?t.length>0:null!=t,o=C.is.multiple()&&e.isArray(t),n=""===t||0===t||(n||!1),i&&U.each(function(){var i=e(this),s=C.get.choiceText(i),r=C.get.choiceValue(i,s);if(null!=r)if(o)-1===e.inArray(String(r),t)&&-1===e.inArray(s,t)||(a=a?a.add(i):i);else if(n){if(C.verbose("Ambiguous dropdown value using strict type check",i,t),r===t||s===t)return a=i,!0}else if(String(r)==String(t)||s==t)return C.verbose("Found select item by value",r,t),a=i,!0}),a}},check:{maxSelections:function(e){return!S.maxSelections||((e=void 0!==e?e:C.get.selectionCount())>=S.maxSelections?(C.debug("Maximum selection count reached"),S.useLabels&&(U.addClass(y.filtered),C.add.message(T.maxSelections)),!0):(C.verbose("No longer at maximum selection count"),C.remove.message(),C.remove.filteredItem(),C.is.searchSelection()&&C.filterItems(),!1))}},restore:{defaults:function(){C.clear(),C.restore.defaultText(),C.restore.defaultValue()},defaultText:function(){var e=C.get.defaultText();e===C.get.placeholderText?(C.debug("Restoring default placeholder text",e),C.set.placeholderText(e)):(C.debug("Restoring default text",e),C.set.text(e))},defaultValue:function(){var e=C.get.defaultValue();void 0!==e&&(C.debug("Restoring default value",e),""!==e?(C.set.value(e),C.set.selected()):(C.remove.activeItem(),C.remove.selectedItem()))},labels:function(){S.allowAdditions&&(S.useLabels||(C.error(q.labels),S.useLabels=!0),C.debug("Restoring selected values"),C.create.userLabels()),C.check.maxSelections()},selected:function(){C.restore.values(),C.is.multiple()?(C.debug("Restoring previously selected values and labels"),C.restore.labels()):C.debug("Restoring previously selected values")},values:function(){C.set.initialLoad(),S.apiSettings?S.saveRemoteData?C.restore.remoteValues():C.clearValue():C.set.selected(),C.remove.initialLoad()},remoteValues:function(){var t=C.get.remoteValues();C.debug("Recreating selected from session data",t),t&&(C.is.single()?e.each(t,function(e,t){C.set.text(t)}):e.each(t,function(e,t){C.add.label(e,t)}))}},read:{remoteData:function(e){var n;if(void 0!==t.Storage)return void 0!==(n=sessionStorage.getItem(e))&&n;C.error(q.noStorage)}},save:{defaults:function(){C.save.defaultText(),C.save.placeholderText(),C.save.defaultValue()},defaultValue:function(){var e=C.get.value();C.verbose("Saving default value as",e),F.data(L.defaultValue,e)},defaultText:function(){var e=C.get.text();C.verbose("Saving default text as",e),F.data(L.defaultText,e)},placeholderText:function(){var e;!1!==S.placeholder&&M.hasClass(y.placeholder)&&(e=C.get.text(),C.verbose("Saving placeholder text as",e),F.data(L.placeholderText,e))},remoteData:function(e,n){void 0!==t.Storage?(C.verbose("Saving remote data to session storage",n,e),sessionStorage.setItem(n,e)):C.error(q.noStorage)}},clear:function(){C.is.multiple()?C.remove.labels():(C.remove.activeItem(),C.remove.selectedItem()),C.set.placeholderText(),C.clearValue()},clearValue:function(){C.set.value("")},scrollPage:function(e,t){var n,i,o=t||C.get.selectedItem(),a=o.closest(R.menu),s=a.outerHeight(),r=a.scrollTop(),l=U.eq(0).outerHeight(),c=Math.floor(s/l),u=(a.prop("scrollHeight"),"up"==e?r-l*c:r+l*c),d=U.not(R.unselectable);i="up"==e?d.index(o)-c:d.index(o)+c,(n=("up"==e?i>=0:i<d.length)?d.eq(i):"up"==e?d.first():d.last()).length>0&&(C.debug("Scrolling page",e,n),o.removeClass(y.selected),n.addClass(y.selected),a.scrollTop(u))},set:{filtered:function(){var e=C.is.multiple(),t=C.is.searchSelection(),n=e&&t,i=t?C.get.query():"",o="string"==typeof i&&i.length>0,a=C.get.searchWidth(i.length),s=""!==i;e&&o&&(C.verbose("Adjusting input width",a,S.glyphWidth),H.css("width",a)),o||n&&s?(C.verbose("Hiding placeholder text"),M.addClass(y.filtered)):(!e||n&&!s)&&(C.verbose("Showing placeholder text"),M.removeClass(y.filtered))},loading:function(){F.addClass(y.loading)},placeholderText:function(e){e=e||C.get.placeholderText(),C.debug("Setting placeholder text",e),C.set.text(e),M.addClass(y.placeholder)},tabbable:function(){C.has.search()?(C.debug("Added tabindex to searchable dropdown"),H.val("").attr("tabindex",0),N.attr("tabindex",-1)):(C.debug("Added tabindex to dropdown"),void 0===F.attr("tabindex")&&(F.attr("tabindex",0),N.attr("tabindex",-1)))},initialLoad:function(){C.verbose("Setting initial load"),h=!0},activeItem:function(e){S.allowAdditions&&e.filter(R.addition).length>0?e.addClass(y.filtered):e.addClass(y.active)},scrollPosition:function(e,t){var n,i,o,a,s,r;n=(e=e||C.get.selectedItem()).closest(R.menu),i=e&&e.length>0,t=void 0!==t&&t,e&&n.length>0&&i&&(e.position().top,n.addClass(y.loading),o=(a=n.scrollTop())-n.offset().top+e.offset().top,t||(r=a+n.height()<o+5,s=o-5<a),C.debug("Scrolling to active item",o),(t||s||r)&&n.scrollTop(o),n.removeClass(y.loading))},text:function(e){"select"!==S.action&&("combo"==S.action?(C.debug("Changing combo button text",e,j),S.preserveHTML?j.html(e):j.text(e)):(e!==C.get.placeholderText()&&M.removeClass(y.placeholder),C.debug("Changing text",e,M),M.removeClass(y.filtered),S.preserveHTML?M.html(e):M.text(e)))},selectedLetter:function(t){var n,i=U.filter("."+y.selected),o=i.length>0&&C.has.firstLetter(i,t),a=!1;o&&(n=i.nextAll(U).eq(0),C.has.firstLetter(n,t)&&(a=n)),a||U.each(function(){if(C.has.firstLetter(e(this),t))return a=e(this),!1}),a&&(C.verbose("Scrolling to next value with letter",t),C.set.scrollPosition(a),i.removeClass(y.selected),a.addClass(y.selected))},direction:function(e){"auto"==S.direction?C.is.onScreen(e)?C.remove.upward(e):C.set.upward(e):"upward"==S.direction&&C.set.upward(e)},upward:function(e){(e||F).addClass(y.upward)},value:function(e,t,n){var i=z.length>0,o=(C.has.value(e),C.get.values()),a=void 0!==e?String(e):e;if(i){if(a==o&&(C.verbose("Skipping value update already same value",e,o),!C.is.initialLoad()))return;C.is.single()&&C.has.selectInput()&&C.can.extendSelect()&&(C.debug("Adding user option",e),C.add.optionValue(e)),C.debug("Updating input value",e,o),K=!0,z.val(e),!1===S.fireOnInit&&C.is.initialLoad()?C.debug("Input native change event ignored on initial load"):C.trigger.change(),K=!1}else C.verbose("Storing value in metadata",e,z),e!==o&&F.data(L.value,a);!1===S.fireOnInit&&C.is.initialLoad()?C.verbose("No callback on initial load",S.onChange):S.onChange.call($,e,t,n)},active:function(){F.addClass(y.active)},multiple:function(){F.addClass(y.multiple)},visible:function(){F.addClass(y.visible)},exactly:function(e,t){C.debug("Setting selected to exact values"),C.clear(),C.set.selected(e,t)},selected:function(t,n){var i=C.is.multiple();(n=S.allowAdditions?n||C.get.itemWithAdditions(t):n||C.get.item(t))&&(C.debug("Setting selected menu item to",n),C.is.single()?(C.remove.activeItem(),C.remove.selectedItem()):S.useLabels&&C.remove.selectedItem(),n.each(function(){var t=e(this),o=C.get.choiceText(t),a=C.get.choiceValue(t,o),s=t.hasClass(y.filtered),r=t.hasClass(y.active),l=t.hasClass(y.addition),c=i&&1==n.length;i?!r||l?(S.apiSettings&&S.saveRemoteData&&C.save.remoteData(o,a),S.useLabels?(C.add.value(a,o,t),C.add.label(a,o,c),C.set.activeItem(t),C.filterActive(),C.select.nextAvailable(n)):(C.add.value(a,o,t),C.set.text(C.add.variables(T.count)),C.set.activeItem(t))):s||(C.debug("Selected active value, removing label"),C.remove.selected(a)):(S.apiSettings&&S.saveRemoteData&&C.save.remoteData(o,a),C.set.text(o),C.set.value(a,o,t),t.addClass(y.active).addClass(y.selected))}))}},add:{label:function(t,n,i){var o,a=C.is.searchSelection()?H:M;o=e("<a />").addClass(y.label).attr("data-value",t).html(V.label(t,n)),o=S.onLabelCreate.call(o,t,n),C.has.label(t)?C.debug("Label already exists, skipping",t):(S.label.variation&&o.addClass(S.label.variation),!0===i?(C.debug("Animating in label",o),o.addClass(y.hidden).insertBefore(a).transition(S.label.transition,S.label.duration)):(C.debug("Adding selection label",o),o.insertBefore(a)))},message:function(t){var n=N.children(R.message),i=S.templates.message(C.add.variables(t));n.length>0?n.html(i):n=e("<div/>").html(i).addClass(y.message).appendTo(N)},optionValue:function(t){z.find('option[value="'+t+'"]').length>0||(w&&(w.disconnect(),C.verbose("Temporarily disconnecting mutation observer",t)),C.is.single()&&(C.verbose("Removing previous user addition"),z.find("option."+y.addition).remove()),e("<option/>").prop("value",t).addClass(y.addition).html(t).appendTo(z),C.verbose("Adding user addition as an <option>",t),w&&w.observe(z[0],{childList:!0,subtree:!0}))},userSuggestion:function(e){var t,n=N.children(R.addition),i=C.get.item(e),o=i&&i.not(R.addition).length,a=n.length>0;S.useLabels&&C.has.maxSelections()||(""===e||o?n.remove():(U.removeClass(y.selected),a?(t=S.templates.addition(C.add.variables(T.addResult,e)),n.html(t).attr("data-"+L.value,e).attr("data-"+L.text,e).removeClass(y.filtered).addClass(y.selected),C.verbose("Replacing user suggestion with new value",n)):((n=C.create.userChoice(e)).prependTo(N).addClass(y.selected),C.verbose("Adding item choice to menu corresponding with user choice addition",n))))},variables:function(e,t){var n,i,o=-1!==e.search("{count}"),a=-1!==e.search("{maxCount}"),s=-1!==e.search("{term}");return C.verbose("Adding templated variables to message",e),o&&(n=C.get.selectionCount(),e=e.replace("{count}",n)),a&&(n=C.get.selectionCount(),e=e.replace("{maxCount}",S.maxSelections)),s&&(i=t||C.get.query(),e=e.replace("{term}",i)),e},value:function(t,n,i){var o,a=C.get.values();""!==t?(e.isArray(a)?(o=a.concat([t]),o=C.get.uniqueArray(o)):o=[t],C.has.selectInput()?C.can.extendSelect()&&(C.debug("Adding value to select",t,o,z),C.add.optionValue(t)):(o=o.join(S.delimiter),C.debug("Setting hidden input to delimited value",o,z)),!1===S.fireOnInit&&C.is.initialLoad()?C.verbose("Skipping onadd callback on initial load",S.onAdd):S.onAdd.call($,t,n,i),C.set.value(o,t,n,i),C.check.maxSelections()):C.debug("Cannot select blank values from multiselect")}},remove:{active:function(){F.removeClass(y.active)},activeLabel:function(){F.find(R.label).removeClass(y.active)},loading:function(){F.removeClass(y.loading)},initialLoad:function(){h=!1},upward:function(e){(e||F).removeClass(y.upward)},visible:function(){F.removeClass(y.visible)},activeItem:function(){U.removeClass(y.active)},filteredItem:function(){S.useLabels&&C.has.maxSelections()||(S.useLabels&&C.is.multiple()?U.not("."+y.active).removeClass(y.filtered):U.removeClass(y.filtered))},optionValue:function(e){var t=z.find('option[value="'+e+'"]');t.length>0&&t.hasClass(y.addition)&&(w&&(w.disconnect(),C.verbose("Temporarily disconnecting mutation observer",e)),t.remove(),C.verbose("Removing user addition as an <option>",e),w&&w.observe(z[0],{childList:!0,subtree:!0}))},message:function(){N.children(R.message).remove()},searchTerm:function(){C.verbose("Cleared search term"),H.val(""),C.set.filtered()},selected:function(t,n){if(!(n=S.allowAdditions?n||C.get.itemWithAdditions(t):n||C.get.item(t)))return!1;n.each(function(){var t=e(this),n=C.get.choiceText(t),i=C.get.choiceValue(t,n);C.is.multiple()?S.useLabels?(C.remove.value(i,n,t),C.remove.label(i)):(C.remove.value(i,n,t),0===C.get.selectionCount()?C.set.placeholderText():C.set.text(C.add.variables(T.count))):C.remove.value(i,n,t),t.removeClass(y.filtered).removeClass(y.active),S.useLabels&&t.removeClass(y.selected)})},selectedItem:function(){U.removeClass(y.selected)},value:function(e,t,n){var i,o=C.get.values();C.has.selectInput()?(C.verbose("Input is <select> removing selected option",e),i=C.remove.arrayValue(e,o),C.remove.optionValue(e)):(C.verbose("Removing from delimited values",e),i=(i=C.remove.arrayValue(e,o)).join(S.delimiter)),!1===S.fireOnInit&&C.is.initialLoad()?C.verbose("No callback on initial load",S.onRemove):S.onRemove.call($,e,t,n),C.set.value(i,t,n),C.check.maxSelections()},arrayValue:function(t,n){return e.isArray(n)||(n=[n]),n=e.grep(n,function(e){return t!=e}),C.verbose("Removed value from delimited string",t,n),n},label:function(e,t){var n=F.find(R.label).filter('[data-value="'+e+'"]');C.verbose("Removing label",n),n.remove()},activeLabels:function(e){e=e||F.find(R.label).filter("."+y.active),C.verbose("Removing active label selections",e),C.remove.labels(e)},labels:function(t){t=t||F.find(R.label),C.verbose("Removing labels",t),t.each(function(){var t=e(this),n=t.data(L.value),i=void 0!==n?String(n):n,o=C.is.userValue(i);!1!==S.onLabelRemove.call(t,n)?o?(C.remove.value(i),C.remove.label(i)):C.remove.selected(i):C.debug("Label remove callback cancelled removal")})},tabbable:function(){C.has.search()?(C.debug("Searchable dropdown initialized"),H.removeAttr("tabindex"),N.removeAttr("tabindex")):(C.debug("Simple selection dropdown initialized"),F.removeAttr("tabindex"),N.removeAttr("tabindex"))}},has:{search:function(){return H.length>0},selectInput:function(){return z.is("select")},firstLetter:function(e,t){var n;return!(!e||0===e.length||"string"!=typeof t)&&(n=C.get.choiceText(e,!1),(t=t.toLowerCase())==String(n).charAt(0).toLowerCase())},input:function(){return z.length>0},items:function(){return U.length>0},menu:function(){return N.length>0},message:function(){return 0!==N.children(R.message).length},label:function(e){return F.find(R.label).filter('[data-value="'+e+'"]').length>0},maxSelections:function(){return S.maxSelections&&C.get.selectionCount()>=S.maxSelections},allResultsFiltered:function(){return U.filter(R.unselectable).length===U.length},query:function(){return""!==C.get.query()},value:function(t){var n=C.get.values();return!!(e.isArray(n)?n&&-1!==e.inArray(t,n):n==t)}},is:{active:function(){return F.hasClass(y.active)},alreadySetup:function(){return F.is("select")&&F.parent(R.dropdown).length>0&&0===F.prev().length},animating:function(e){return e?e.transition&&e.transition("is animating"):N.transition&&N.transition("is animating")},disabled:function(){return F.hasClass(y.disabled)},focused:function(){return n.activeElement===F[0]},focusedOnSearch:function(){return n.activeElement===H[0]},allFiltered:function(){return(C.is.multiple()||C.has.search())&&!C.has.message()&&C.has.allResultsFiltered()},hidden:function(e){return!C.is.visible(e)},initialLoad:function(){return h},onScreen:function(e){var t,n,i=e||N,o=!0;return i.addClass(y.loading),(t={above:(n={context:{scrollTop:P.scrollTop(),height:P.outerHeight()},menu:{offset:i.offset(),height:i.outerHeight()}}).context.scrollTop<=n.menu.offset.top-n.menu.height,below:n.context.scrollTop+n.context.height>=n.menu.offset.top+n.menu.height}).below?(C.verbose("Dropdown can fit in context downward",t),o=!0):t.below||t.above?(C.verbose("Dropdown cannot fit below, opening upward",t),o=!1):(C.verbose("Dropdown cannot fit in either direction, favoring downward",t),o=!0),i.removeClass(y.loading),o},inObject:function(t,n){var i=!1;return e.each(n,function(e,n){if(n==t)return i=!0,!0}),i},multiple:function(){return F.hasClass(y.multiple)},single:function(){return!C.is.multiple()},selectMutation:function(t){var n=!1;return e.each(t,function(t,i){if(i.target&&e(i.target).is("select"))return n=!0,!0}),n},search:function(){return F.hasClass(y.search)},searchSelection:function(){return C.has.search()&&1===H.parent(R.dropdown).length},selection:function(){return F.hasClass(y.selection)},userValue:function(t){return-1!==e.inArray(t,C.get.userValues())},upward:function(e){return(e||F).hasClass(y.upward)},visible:function(e){return e?e.hasClass(y.visible):N.hasClass(y.visible)}},can:{activate:function(e){return!!S.useLabels||(!C.has.maxSelections()||!(!C.has.maxSelections()||!e.hasClass(y.active)))},click:function(){return l||"click"==S.on},extendSelect:function(){return S.allowAdditions||S.apiSettings},show:function(){return!C.is.disabled()&&(C.has.items()||C.has.message())},useAPI:function(){return void 0!==e.fn.api}},animate:{show:function(t,n){var i,o=n||N,a=n?function(){}:function(){C.hideSubMenus(),C.hideOthers(),C.set.active()};t=e.isFunction(t)?t:function(){},C.verbose("Doing menu show animation",o),C.set.direction(n),i=C.get.transition(n),C.is.selection()&&C.set.scrollPosition(C.get.selectedItem(),!0),(C.is.hidden(o)||C.is.animating(o))&&("none"==i?(a(),o.transition("show"),t.call($)):void 0!==e.fn.transition&&F.transition("is supported")?o.transition({animation:i+" in",debug:S.debug,verbose:S.verbose,duration:S.duration,queue:!0,onStart:a,onComplete:function(){t.call($)}}):C.error(q.noTransition,i))},hide:function(t,n){var i=n||N,o=(n?S.duration:S.duration,n?function(){}:function(){C.can.click()&&C.unbind.intent(),C.remove.active()}),a=C.get.transition(n);t=e.isFunction(t)?t:function(){},(C.is.visible(i)||C.is.animating(i))&&(C.verbose("Doing menu hide animation",i),"none"==a?(o(),i.transition("hide"),t.call($)):void 0!==e.fn.transition&&F.transition("is supported")?i.transition({animation:a+" out",duration:S.duration,debug:S.debug,verbose:S.verbose,queue:!0,onStart:o,onComplete:function(){"auto"==S.direction&&C.remove.upward(n),t.call($)}}):C.error(q.transition))}},hideAndClear:function(){C.remove.searchTerm(),C.has.maxSelections()||(C.has.search()?C.hide(function(){C.remove.filteredItem()}):C.hide())},delay:{show:function(){C.verbose("Delaying show event to ensure user intent"),clearTimeout(C.timer),C.timer=setTimeout(C.show,S.delay.show)},hide:function(){C.verbose("Delaying hide event to ensure user intent"),clearTimeout(C.timer),C.timer=setTimeout(C.hide,S.delay.hide)}},escape:{regExp:function(e){return(e=String(e)).replace(I.escape,"\\$&")}},setting:function(t,n){if(C.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,S,t);else{if(void 0===n)return S[t];S[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,C,t);else{if(void 0===n)return C[t];C[t]=n}},debug:function(){S.debug&&(S.performance?C.performance.log(arguments):(C.debug=Function.prototype.bind.call(console.info,console,S.name+":"),C.debug.apply(console,arguments)))},verbose:function(){S.verbose&&S.debug&&(S.performance?C.performance.log(arguments):(C.verbose=Function.prototype.bind.call(console.info,console,S.name+":"),C.verbose.apply(console,arguments)))},error:function(){C.error=Function.prototype.bind.call(console.error,console,S.name+":"),C.error.apply(console,arguments)},performance:{log:function(e){var t,n;S.performance&&(n=(t=(new Date).getTime())-(c||t),c=t,u.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:$,"Execution Time":n})),clearTimeout(C.performance.timer),C.performance.timer=setTimeout(C.performance.display,500)},display:function(){var t=S.name+":",n=0;c=!1,clearTimeout(C.performance.timer),e.each(u,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",r&&(t+=" '"+r+"'"),(void 0!==console.group||void 0!==console.table)&&u.length>0&&(console.groupCollapsed(t),console.table?console.table(u):e.each(u,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),u=[]}},invoke:function(t,n,i){var a,s,r,l=Q;return n=n||m,i=$||i,"string"==typeof t&&void 0!==l&&(t=t.split(/[\. ]/),a=t.length-1,e.each(t,function(n,i){var o=n!=a?i+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[o])&&n!=a)l=l[o];else{if(void 0!==l[o])return s=l[o],!1;if(!e.isPlainObject(l[i])||n==a)return void 0!==l[i]?(s=l[i],!1):(C.error(q.method,t),!1);l=l[i]}})),e.isFunction(s)?r=s.apply(i,n):void 0!==s&&(r=s),e.isArray(o)?o.push(r):void 0!==o?o=[o,r]:void 0!==r&&(o=r),s}},v?(void 0===Q&&C.initialize(),C.invoke(d)):(void 0!==Q&&Q.invoke("destroy"),C.initialize())}),void 0!==o?o:a},e.fn.dropdown.settings={debug:!1,verbose:!1,performance:!0,on:"click",action:"activate",apiSettings:!1,saveRemoteData:!0,throttle:200,context:t,direction:"auto",keepOnScreen:!0,match:"both",fullTextSearch:!1,placeholder:"auto",preserveHTML:!0,sortSelect:!1,forceSelection:!0,allowAdditions:!1,maxSelections:!1,useLabels:!0,delimiter:",",showOnFocus:!0,allowTab:!0,allowCategorySelection:!1,fireOnInit:!1,transition:"auto",duration:200,glyphWidth:1.0714,label:{transition:"scale",duration:200,variation:!1},delay:{hide:300,show:200,search:20,touch:50},onChange:function(e,t,n){},onAdd:function(e,t,n){},onRemove:function(e,t,n){},onLabelSelect:function(e){},onLabelCreate:function(t,n){return e(this)},onLabelRemove:function(e){return!0},onNoResults:function(e){return!0},onShow:function(){},onHide:function(){},name:"Dropdown",namespace:"dropdown",message:{addResult:"Add <b>{term}</b>",count:"{count} selected",maxSelections:"Max {maxCount} selections",noResults:"No results found.",serverError:"There was an error contacting the server"},error:{action:"You called a dropdown action that was not defined",alreadySetup:"Once a select has been initialized behaviors must be called on the created ui dropdown",labels:"Allowing user additions currently requires the use of labels.",missingMultiple:"<select> requires multiple property to be set to correctly preserve multiple values",method:"The method you called is not defined.",noAPI:"The API module is required to load resources remotely",noStorage:"Saving remote data requires session storage",noTransition:"This module requires ui transitions <https://github.com/Semantic-Org/ui-Transition>"},regExp:{escape:/[-[\]{}()*+?.,\\^$|#\s]/g},metadata:{defaultText:"defaultText",defaultValue:"defaultValue",placeholderText:"placeholder",text:"text",value:"value"},fields:{remoteValues:"results",values:"values",name:"name",value:"value"},keys:{backspace:8,delimiter:188,deleteKey:46,enter:13,escape:27,pageUp:33,pageDown:34,leftArrow:37,upArrow:38,rightArrow:39,downArrow:40},selector:{addition:".addition",dropdown:".ui.dropdown",icon:"> .dropdown.icon",input:'> input[type="hidden"], > select',item:".item",label:"> .label",remove:"> .label > .delete.icon",siblingLabel:".label",menu:".menu",message:".message",menuicon:".dropdown.icon",search:"input.search, .menu > .search > input",text:"> .text:not(.icon)",unselectable:".disabled, .filtered"},className:{active:"active",addition:"addition",animating:"animating",disabled:"disabled",dropdown:"vi-ui dropdown",filtered:"filtered",hidden:"hidden transition",item:"item",label:"vi-ui label",loading:"loading",menu:"menu",message:"message",multiple:"multiple",placeholder:"default",search:"search",selected:"selected",selection:"selection",upward:"upward",visible:"visible"}},e.fn.dropdown.settings.templates={dropdown:function(t){var n=t.placeholder||!1,i=(t.values,"");return i+='<i class="dropdown icon"></i>',t.placeholder?i+='<div class="default text">'+n+"</div>":i+='<div class="text"></div>',i+='<div class="menu">',e.each(t.values,function(e,t){i+=t.disabled?'<div class="disabled item" data-value="'+t.value+'">'+t.name+"</div>":'<div class="item" data-value="'+t.value+'">'+t.name+"</div>"}),i+="</div>"},menu:function(t,n){var i=t[n.values]||{},o="";return e.each(i,function(e,t){o+='<div class="item" data-value="'+t[n.value]+'">'+t[n.name]+"</div>"}),o},label:function(e,t){return t+'<i class="delete icon"></i>'},message:function(e){return e},addition:function(e){return e}}}(jQuery,window,document);