"use strict";!function(blocks,components,blockEditor,i18n,element){var el=element.createElement,registerBlockType=blocks.registerBlockType,TextControl=components.TextControl,SelectControl=components.SelectControl,RangeControl=(components.ToggleControl,components.RangeControl),SVG=(components.Button,components.SVG),Path=components.Path,InspectorControls=wp.blockEditor.InspectorControls,apiFetch=wp.apiFetch,useEffect=wp.element.useEffect;registerBlockType("getbowtied/scattered-product-list",{title:i18n.__("Scattered Product List"),icon:el(SVG,{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 24 24"},el(Path,{d:"M 7.1875 2.9941406 C 6.409 3.0139688 5.6767969 3.4902656 5.3730469 4.2597656 L 4.2929688 7 L 6.4433594 7 L 7.234375 4.9921875 L 12.326172 7 L 17.779297 7 L 7.96875 3.1328125 C 7.713 3.0320625 7.447 2.9875312 7.1875 2.9941406 z M 5 9 C 3.9069372 9 3 9.9069372 3 11 L 3 19 C 3 20.093063 3.9069372 21 5 21 L 19 21 C 20.093063 21 21 20.093063 21 19 L 21 11 C 21 9.9069372 20.093063 9 19 9 L 5 9 z M 5 11 L 14 11 L 14 19 L 5 19 L 5 11 z M 16 11 L 19 11 L 19 19 L 16 19 L 16 11 z"})),category:"product_blocks",description:i18n.__("Display a scattered grid of products from your store."),keywords:[i18n.__("products"),i18n.__("grid"),i18n.__("thumbs")],supports:{align:["center","wide","full"]},attributes:{queryProducts:{type:"string",default:"/wc/v2/products?per_page=10"},queryProductsLast:{type:"string",default:""},queryDisplayType:{type:"string",default:"all_products"},selectedIDS:{type:"string",default:""},productIDs:{type:"string",default:""},querySearchSelected:{type:"array",default:[]},queryCategoryOptions:{type:"array",default:""},queryCategorySelected:{type:"array",default:[]},queryFilterSelected:{type:"string",default:""},queryAttributesSelected:{type:"string",default:""},queryAttributesOptions:{type:"array",default:[]},queryAttributesOptionsValues:{type:"array",default:[]},queryAttributesSelectedSlug:{type:"string",default:""},queryAttributesOptionsSelected:{type:"array",default:[]},queryOrder:{type:"string",default:""},limit:{type:"integer",default:10}},edit:function(props){function _categoryClassName(parent,value){return 0==parent?"parent parent-"+value:"child child-"+parent}function toArray(s){var ret=[];0<s.length&&(ret=s.split(","));for(var i=0;i<ret.length;i++)""==ret[i]?ret.splice(i,1):ret[i]=Number(ret[i]);return ret}function _destroyQuery(){props.setAttributes({queryOrder:""}),props.setAttributes({queryProducts:""}),props.setAttributes({querySearchString:""}),props.setAttributes({querySearchResults:[]}),props.setAttributes({querySearchSelected:[]}),props.setAttributes({selectedIDS:[]}),props.setAttributes({queryAttributesOptionsSelected:[]}),props.setAttributes({queryCategorySelected:[]}),props.setAttributes({result:[]})}function _isChecked(needle,haystack){return-1!=haystack.indexOf(needle.toString())}function getQuery(query){return"/wc/v2/products"+query}function getProducts(query){null===query&&(query=attributes.queryProducts,useEffect(function(){props.setAttributes({queryProductsLast:query})})),""!=query&&apiFetch({path:query}).then(function(products){props.setAttributes({result:products}),props.setAttributes({isLoading:!1}),!1===attributes.doneFirstLoad&&props.setAttributes({querySearchSelected:products}),props.setAttributes({doneFirstLoad:!0});for(var IDs="",i=0;i<products.length;i++)IDs+=products[i].id+",";props.setAttributes({productIDs:IDs}),props.setAttributes({selectedSlide:0})})}function _getQueryOrder(){if(attributes.queryOrder.length<1)return"";var order="";switch(attributes.queryOrder){case"date_desc":order="&orderby=date&order=desc";break;case"date_asc":order="&orderby=date&order=asc";break;case"title_desc":order="&orderby=title&order=desc";break;case"title_asc":order="&orderby=title&order=asc"}return order}function renderOrderby(){var _returnArr=[];return _returnArr.push(el(SelectControl,{key:"query-panel-orderby",label:i18n.__("Order By:"),value:attributes.queryOrder,className:"orderby-wrapper",options:[{label:i18n.__("Newness - newest first"),value:"date_desc"},{label:i18n.__("Newness - oldest first"),value:"date_asc"},{label:i18n.__("Title - ascending"),value:"title_asc"},{label:i18n.__("Title - descending"),value:"title_desc"}],onChange:function(value){props.setAttributes({queryOrder:value}),function(value){var query=attributes.queryProducts;if(!(query.length<1)){var idx=query.indexOf("&orderby");switch(-1<idx&&(query=query.substring(idx,-25)),value){case"date_desc":query+="&orderby=date&order=desc";break;case"date_asc":query+="&orderby=date&order=asc";break;case"title_desc":query+="&orderby=title&order=desc";break;case"title_asc":query+="&orderby=title&order=asc"}props.setAttributes({queryProducts:query})}}(value)}})),_returnArr}function getCategories(){var query=getQuery("/categories?&per_page=100"),options=[],sorted=[];apiFetch({path:query}).then(function(categories){for(var i=0;i<categories.length;i++)options[i]={label:categories[i].name.replace(/&amp;/g,"&"),value:categories[i].id,parent:categories[i].parent,count:categories[i].count};for(var _i4=0;_i4<options.length;_i4++);sorted=function _sortCategories(index,arr){for(var newarr=2<arguments.length&&void 0!==arguments[2]?arguments[2]:[],level=3<arguments.length&&void 0!==arguments[3]?arguments[3]:0,i=0;i<arr.length;i++)arr[i].parent==index&&(arr[i].level=level,newarr.push(arr[i]),_sortCategories(arr[i].value,arr,newarr,level+1));return newarr}(0,options),props.setAttributes({queryCategoryOptions:sorted})})}var attributes=props.attributes;return attributes.selectedSlide=attributes.selectedSlide||0,attributes.result=attributes.result||[],attributes.isLoading=attributes.isLoading||!1,attributes.querySearchString=attributes.querySearchString||"",attributes.querySearchResults=attributes.querySearchResults||[],attributes.querySearchNoResults=attributes.querySearchNoResults||!1,attributes.doneFirstLoad=attributes.doneFirstLoad||!1,[el(InspectorControls,{key:"gbt-scattered-list-products-main-inspector"},el("div",{key:"gbt-scattered-list-products-main-inspector-wrapper",className:"products-main-inspector-wrapper"},el(SelectControl,{key:"query-panel-select",label:i18n.__("Source:"),value:attributes.queryDisplayType,options:[{label:i18n.__("Choose an Option"),value:"default"},{label:i18n.__("Manually pick products"),value:"specific"},{label:i18n.__("Display by Category"),value:"by_category"},{label:i18n.__("Filter Products"),value:"filter_by"},{label:i18n.__("All Products"),value:"all_products"}],onChange:function(value){if(""==attributes.queryProducts||!1!==window.confirm(i18n.__("Changing the product source will lose the current selection."))){if(_destroyQuery(),"by_category"===value&&getCategories(),"all_products"===value){var query=getQuery("?per_page="+attributes.limit);props.setAttributes({queryProducts:query})}return props.setAttributes({queryDisplayType:value})}}}),"specific"===attributes.queryDisplayType&&el("div",{className:"products-ajax-search-wrapper"},el(TextControl,{key:"query-panel-string",type:"search",className:"products-ajax-search",value:attributes.querySearchString,placeholder:i18n.__("Search for products to display"),onChange:function(newQuery){if(props.setAttributes({querySearchString:newQuery}),!(newQuery.length<3)){var query=getQuery("?per_page=10&search="+newQuery);apiFetch({path:query}).then(function(products){0==products.length?props.setAttributes({querySearchNoResults:!0}):props.setAttributes({querySearchNoResults:!1}),props.setAttributes({querySearchResults:products})})}}})),"specific"===attributes.queryDisplayType&&0<attributes.querySearchResults.length&&""!=attributes.querySearchString&&el("div",{className:"products-ajax-search-results"},function(){var productElements=[];if(!0===attributes.querySearchNoResults)return el("span",{key:"gbt-scattered-list-search-results-noresults",className:"no-results"},i18n.__("No products matching."));for(var theID,products=attributes.querySearchResults,i=0;i<products.length;i++){var img="";img=void 0!==products[i].images[0]&&""!=products[i].images[0].src?el("span",{key:"gbt-scattered-list-search-results-img-wrapper",className:"img-wrapper",dangerouslySetInnerHTML:{__html:'<span class="img" style="background-image: url(\''+products[i].images[0].src+"')\"></span>"}}):el("span",{key:"gbt-scattered-list-search-results-img-wrapper",className:"img-wrapper",dangerouslySetInnerHTML:{__html:'<span class="img" style="background-image: url(\''+getbowtied_pbw.woo_placeholder_image+"')\"></span>"}}),productElements.push(el("span",{key:"gbt-scattered-list-search-item-"+products[i].id,className:(theID=products[i].id,-1==toArray(attributes.selectedIDS).indexOf(theID)?"single-result":"single-result selected"),title:products[i].name,"data-index":i},img,el("label",{key:"gbt-scattered-list-search-item-label-"+i,className:"title-wrapper"},el("input",{key:"gbt-scattered-list-search-item-input-"+i,type:"checkbox",value:i,onChange:function(evt){evt.target;var qSR=toArray(attributes.selectedIDS),index=qSR.indexOf(products[evt.target.value].id);-1==index?qSR.push(products[evt.target.value].id):qSR.splice(index,1),props.setAttributes({selectedIDS:qSR.join(",")});var query=getQuery("?include="+qSR.join(",")+"&orderby=include");0<qSR.length?props.setAttributes({queryProducts:query}):props.setAttributes({queryProducts:""}),apiFetch({path:query}).then(function(products){props.setAttributes({querySearchSelected:products})})}}),products[i].name,el("span",{key:"gbt-scattered-list-search-item-dashicon-yes-"+i,className:"dashicons dashicons-yes"}),el("span",{key:"gbt-scattered-list-search-item-dashicon-noalt-"+i,className:"dashicons dashicons-no-alt"}))))}return productElements}()),"specific"===attributes.queryDisplayType&&0<attributes.querySearchSelected.length&&el("div",{className:"products-selected-results-wrapper"},el("label",{},i18n.__("Selected Products:")),el("div",{className:"products-selected-results"},function(){for(var productElements=[],products=attributes.querySearchSelected,_i2=0;_i2<products.length;_i2++){var img="";img=void 0!==products[_i2].images[0]&&""!=products[_i2].images[0].src?el("span",{key:"gbt-scattered-list-search-selected-img-wrapper",className:"img-wrapper",dangerouslySetInnerHTML:{__html:'<span class="img" style="background-image: url(\''+products[_i2].images[0].src+"')\"></span>"}}):el("span",{key:"gbt-scattered-list-search-selected-img-wrapper",className:"img-wrapper",dangerouslySetInnerHTML:{__html:'<span class="img" style="background-image: url(\''+getbowtied_pbw.woo_placeholder_image+"')\"></span>"}}),productElements.push(el("span",{key:"gbt-scattered-list-search-selected-item-"+products[_i2].id,className:"single-result",title:products[_i2].name},img,el("label",{key:"gbt-scattered-list-search-selected-item-label-"+_i2,className:"title-wrapper"},el("input",{key:"gbt-scattered-list-search-selected-item-input-"+_i2,type:"checkbox",value:_i2,onChange:function(evt){evt.target;var qSS=toArray(attributes.selectedIDS);if(qSS.length<1&&0<attributes.querySearchSelected.length)for(var _i3=0;_i3<attributes.querySearchSelected.length;_i3++)qSS.push(attributes.querySearchSelected[_i3].id);var index=qSS.indexOf(products[evt.target.value].id);-1!=index&&qSS.splice(index,1),props.setAttributes({selectedIDS:qSS.join(",")});var query=getQuery("?include="+qSS.join(",")+"&orderby=include");0<qSS.length?(props.setAttributes({queryProducts:query}),apiFetch({path:query}).then(function(products){props.setAttributes({querySearchSelected:products})})):(props.setAttributes({queryProducts:""}),props.setAttributes({querySearchSelected:[]}))}}),products[_i2].name,el("span",{key:"gbt-scattered-list-search-selected-item-dashicon-no-alt-"+_i2,className:"dashicons dashicons-no-alt"}))))}return productElements}())),"by_category"===attributes.queryDisplayType&&el("div",{className:"category-result-wrapper"},function renderCategories(){var parent=0<arguments.length&&void 0!==arguments[0]?arguments[0]:0,level=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0,categoryElements=[],catArr=attributes.queryCategoryOptions;if(0<catArr.length)for(var i=0;i<catArr.length;i++)catArr[i].parent==parent&&categoryElements.push(el("li",{key:"gbt-scattered-list-category-item-"+catArr[i].value,className:"level-"+catArr[i].level},el("label",{key:"gbt-scattered-list-category-label-"+i,className:_categoryClassName(catArr[i].parent,catArr[i].value)+" "+catArr[i].level},el("input",{type:"checkbox",key:"category-checkbox-"+catArr[i].value,value:catArr[i].value,"data-index":i,"data-parent":catArr[i].parent,checked:_isChecked(catArr[i].value,attributes.queryCategorySelected),onChange:function(evt){var idx=Number(evt.target.dataset.index);if(!0===evt.target.checked){var qCS=attributes.queryCategorySelected;-1==qCS.indexOf(evt.target.value)&&qCS.push(evt.target.value);for(var j=idx+1;j<catArr.length-1&&catArr[idx].level<catArr[j].level;j++)-1==qCS.indexOf(catArr[j].value.toString())&&qCS.push(catArr[j].value.toString());props.setAttributes({queryCategorySelected:qCS})}else{var _qCS=attributes.queryCategorySelected,_index=_qCS.indexOf(evt.target.value);-1<_index&&_qCS.splice(_index,1);for(var _j=idx+1;_j<catArr.length-1&&catArr[idx].level<catArr[_j].level;_j++){var _index2=_qCS.indexOf(catArr[_j].value.toString());-1<_index2&&_qCS.splice(_index2,1)}props.setAttributes({queryCategorySelected:_qCS})}if(0<attributes.queryCategorySelected.length){var query=getQuery("?per_page="+attributes.limit+"&category="+attributes.queryCategorySelected.join(","));query+=_getQueryOrder(),props.setAttributes({queryProducts:query})}else props.setAttributes({queryProducts:""})}}),catArr[i].label,el("sup",{},catArr[i].count)),renderCategories(catArr[i].value,level+1)));return 0<categoryElements.length?el("ul",{className:"level-"+level},categoryElements):void 0}()),"by_category"===attributes.queryDisplayType&&renderOrderby(),"filter_by"===attributes.queryDisplayType&&el(SelectControl,{key:"query-panel-filter",value:attributes.queryFilterSelected,options:[{label:"Filter by",value:""},{label:i18n.__("Featured products"),value:"featured"},{label:i18n.__("On sale"),value:"sale"},{label:i18n.__("Attributes"),value:"attributes"}],onChange:function(value){if(_destroyQuery(),props.setAttributes({queryFilterSelected:value}),"attributes"===value)!function(){var query=getQuery("/attributes"),options=[];options.push({label:"Choose",value:" "}),apiFetch({path:query}).then(function(categories){for(var i=0;i<categories.length;i++)options.push({label:categories[i].name.replace(/&amp;/g,"&"),value:categories[i].id});props.setAttributes({queryAttributesOptions:options})})}();else{var query=getQuery("?per_page="+attributes.limit+"&"+value+"=1");props.setAttributes({queryProducts:query})}}}),"filter_by"===attributes.queryDisplayType&&"attributes"===attributes.queryFilterSelected&&el(SelectControl,{key:"query-panel-attributes",value:attributes.queryAttributesSelected,options:attributes.queryAttributesOptions,onChange:function(value){_destroyQuery(),props.setAttributes({queryAttributesSelected:value}),function(term){var query=getQuery("/attributes/"+term+"/terms"),options=[];apiFetch({path:query}).then(function(attributes){for(var i=0;i<attributes.length;i++)options[i]={label:attributes[i].name.replace(/&amp;/g,"&"),value:attributes[i].id,count:attributes[i].count};props.setAttributes({queryAttributesOptionsValues:options})});var query2=getQuery("/attributes/"+term);apiFetch({path:query2}).then(function(attributes){props.setAttributes({queryAttributesSelectedSlug:attributes.slug})})}(value)}}),"filter_by"===attributes.queryDisplayType&&"attributes"===attributes.queryFilterSelected&&""!==attributes.queryAttributesSelected&&el("div",{className:"attributes-results-wrapper"},function(){var attributeElements=[],attArr=attributes.queryAttributesOptionsValues;if(0<attArr.length)for(var i=0;i<attArr.length;i++)attributeElements.push(el("label",{key:"gbt-scattered-list-attribute-item-"+attArr[i].value,className:"attribute-label"},el("input",{type:"checkbox",key:"attribute-checkbox-"+attArr[i].value,value:attArr[i].value,checked:_isChecked(attArr[i].value,attributes.queryAttributesOptionsSelected),onChange:function(evt){if(!0===evt.target.checked){var qCS=attributes.queryAttributesOptionsSelected;-1==qCS.indexOf(evt.target.value)&&qCS.push(evt.target.value),props.setAttributes({queryAttributesOptionsSelected:qCS})}else{var _qCS2=attributes.queryAttributesOptionsSelected,_index3=_qCS2.indexOf(evt.target.value);-1<_index3&&_qCS2.splice(_index3,1),props.setAttributes({queryAttributesOptionsSelected:_qCS2})}if(0<attributes.queryAttributesOptionsSelected.length){var query=getQuery("?per_page="+attributes.limit+"&attribute="+attributes.queryAttributesSelectedSlug+"&attribute_term="+attributes.queryAttributesOptionsSelected.join(","));query+=_getQueryOrder(),props.setAttributes({queryProducts:query})}else props.setAttributes({queryProducts:""})}}),attArr[i].label,el("sup",{},attArr[i].count)));return attributeElements}()),"filter_by"===attributes.queryDisplayType&&""!=attributes.queryFilterSelected&&renderOrderby(),"all_products"===attributes.queryDisplayType&&renderOrderby(),"specific"!==attributes.queryDisplayType&&el(RangeControl,{value:attributes.limit,allowReset:!1,initialPosition:10,min:2,max:20,label:i18n.__("Number of Products"),onChange:function(value){props.setAttributes({limit:value}),function(limit){var buildQ=attributes.queryProducts,newQ=void 0;buildQ=(buildQ=buildQ.replace("/wc/v2/products?","")).split("&");for(var flag=!1,j=0;j<buildQ.length;j++)if("per_page"===buildQ[j].split("=")[0]){buildQ[j]="per_page="+limit,flag=!0;break}newQ=!0===flag?"/wc/v2/products?"+buildQ.join("&"):"/wc/v2/products?per_page="+limit+"&"+buildQ.join("&"),props.setAttributes({queryProducts:newQ})}(value)}}),el("button",{className:"render-results components-button is-button is-default is-primary is-large "+(!0===attributes.isLoading?"is-busy":""),disabled:0==attributes.queryProducts.length||attributes.queryProducts===attributes.queryProductsLast,onClick:function(e){var query=attributes.queryProducts;props.setAttributes({isLoading:!0}),props.setAttributes({querySearchString:""}),props.setAttributes({querySearchResults:[]}),props.setAttributes({queryProductsLast:query}),getProducts(query)}},!1===attributes.isLoading?i18n.__("Update"):i18n.__("Updating")))),el("div",{key:"gbt-scattered-list-main-wrapper"},attributes.result.length<1&&!1===attributes.doneFirstLoad&&getProducts(null),function(){var products=attributes.result,productElements=[],wrapper=[];if(0<products.length){for(var class_prefix="gbt_18_grid_product",i=0;i<products.length;i++){var img="";img=void 0!==products[i].images[0]&&""!=products[i].images[0].src?products[i].images[0].src:getbowtied_pbw.woo_placeholder_image,productElements.push(el("li",{key:class_prefix+"_item-"+products[i].id,className:class_prefix+" item-"+products[i].id},el("div",{key:class_prefix+"_content_wrapper"+i,className:class_prefix+"_content_wrapper"},el("img",{key:class_prefix+"_thumbnail"+i,className:class_prefix+"_thumbnail",src:img}),el("h2",{key:class_prefix+"_title"+i,className:class_prefix+"_title"},products[i].name),el("span",{key:class_prefix+"_price"+i,className:class_prefix+"_price",dangerouslySetInnerHTML:{__html:products[i].price_html}}))))}wrapper.push(el("div",{key:"gbt_18_expanding_grid_wrapper",className:"gbt_18_expanding_grid_wrapper"},el("ul",{key:"gbt_18_expanding_grid_products ",className:"gbt_18_expanding_grid_products "},productElements)))}else{for(var _class_prefix="gbt_18_placeholder_grid_product",_i=0;_i<2;_i++)productElements.push(el("li",{key:_class_prefix+"_item-"+_i,className:_class_prefix+" item-"+_i},el("div",{key:_class_prefix+"_content_wrapper"+_i,className:_class_prefix+"_content_wrapper"},el("div",{key:_class_prefix+"_thumbnail"+_i,className:_class_prefix+"_thumbnail"}),el("div",{key:_class_prefix+"_title"+_i,className:_class_prefix+"_title"}),el("div",{key:_class_prefix+"_price"+_i,className:_class_prefix+"_price"}))));wrapper.push(el("div",{key:"gbt_18_placeholder_expanding_grid_wrapper",className:"gbt_18_placeholder_expanding_grid_wrapper"},el("ul",{key:"gbt_18_placeholder_expanding_grid_products ",className:"gbt_18_placeholder_expanding_grid_products "},productElements)))}return wrapper}())]},save:function(){return null}})}(window.wp.blocks,window.wp.components,window.wp.editor,window.wp.i18n,window.wp.element,jQuery);