jQuery(document).ready(function () {
  var tblId = 'ptsPagesTbl';
  jQuery('#' + tblId).jqGrid({
    url: ptsTblDataUrl
    , datatype: 'json'
    , autowidth: true
    , shrinkToFit: true
    , colNames: [toeLangPts('ID'), toeLangPts('Label'), toeLangPts('Date Created')]
    , colModel: [
      { name: 'id', index: 'id', searchoptions: { sopt: ['eq'] }, width: '50', align: 'center' }
      , { name: 'label', index: 'label', searchoptions: { sopt: ['eq'] }, align: 'center' }
      , { name: 'date_created', index: 'date_created', searchoptions: { sopt: ['eq'] }, align: 'center' }
      //,	{name: 'actions', index: 'actions', searchoptions: {sopt: ['eq']}, align: 'center'}
    ]
    , postData: {
      search: {
        text_like: jQuery('#' + tblId + 'SearchTxt').val()
      }
    }
    , rowNum: 10
    , rowList: [10, 20, 30, 1000]
    , pager: '#' + tblId + 'Nav'
    , sortname: 'id'
    , viewrecords: true
    , sortorder: 'desc'
    , jsonReader: { repeatitems: false, id: '0' }
    , caption: toeLangPts('Current Table')
    , height: '100%'
    , emptyrecords: ''//toeLangPts('You have no Tables for now.')
    , multiselect: true
    , onSelectRow: function (rowid, e) {
      var tblId = jQuery(this).attr('id')
        , selectedRowIds = jQuery('#' + tblId).jqGrid('getGridParam', 'selarrrow')
        , totalRows = jQuery('#' + tblId).getGridParam('reccount')
        , totalRowsSelected = selectedRowIds.length;
      if (totalRowsSelected) {
        jQuery('#ptsPagesRemoveGroupBtn').removeAttr('disabled');
        if (totalRowsSelected == totalRows) {
          jQuery('#cb_' + tblId).prop('indeterminate', false);
          jQuery('#cb_' + tblId).attr('checked', 'checked');
        } else {
          jQuery('#cb_' + tblId).prop('indeterminate', true);
        }
      } else {
        jQuery('#ptsPagesRemoveGroupBtn').attr('disabled', 'disabled');
        jQuery('#cb_' + tblId).prop('indeterminate', false);
        jQuery('#cb_' + tblId).removeAttr('checked');
      }
    }
    , gridComplete: function (a, b, c) {
      var tblId = jQuery(this).attr('id');
      jQuery('#ptsPagesRemoveGroupBtn').attr('disabled', 'disabled');
      jQuery('#cb_' + tblId).prop('indeterminate', false);
      jQuery('#cb_' + tblId).removeAttr('checked');
    }
    , loadComplete: function () {
      var tblId = jQuery(this).attr('id');
      if (this.p.reccount === 0) {
        jQuery(this).hide();
        jQuery('#' + tblId + 'Nav_right').hide();
        jQuery('#' + tblId + 'EmptyMsg').show();
      } else {
        jQuery(this).show();
        jQuery('#' + tblId + 'EmptyMsg').hide();
      }
    }
  });
  jQuery('#' + tblId + 'NavShell').append(jQuery('#' + tblId + 'Nav'));
  jQuery('#' + tblId + 'Nav').find('.ui-pg-selbox').insertAfter(jQuery('#' + tblId + 'Nav').find('.ui-paging-info'));
  jQuery('#' + tblId + 'Nav').find('.ui-pg-table td:first').remove();
  // Make navigation tabs to be with our additional buttons - in one row
  jQuery('#' + tblId + 'Nav_center').prepend(jQuery('#' + tblId + 'NavBtnsShell')).css({
    'width': '80%'
    , 'white-space': 'normal'
    , 'padding-top': '8px'
  });
  jQuery('#' + tblId + 'SearchTxt').keyup(function () {
    var searchVal = jQuery.trim(jQuery(this).val());
    if (searchVal && searchVal != '') {
      ptsGridDoListSearch({
        text_like: searchVal
      }, tblId);
    }
  });

  jQuery('#' + tblId + 'EmptyMsg').insertAfter(jQuery('#' + tblId + '').parent());
  jQuery('#' + tblId + '').jqGrid('navGrid', '#' + tblId + 'Nav', { edit: false, add: false, del: false });
  jQuery('#cb_' + tblId + '').change(function () {
    jQuery(this).attr('checked')
      ? jQuery('#ptsPagesRemoveGroupBtn').removeAttr('disabled')
      : jQuery('#ptsPagesRemoveGroupBtn').attr('disabled', 'disabled');
  });
  jQuery('#ptsPagesRemoveGroupBtn').click(function () {
    var selectedRowIds = jQuery('#ptsPagesTbl').jqGrid('getGridParam', 'selarrrow')
      , listIds = [];
    for (var i in selectedRowIds) {
      var rowData = jQuery('#ptsPagesTbl').jqGrid('getRowData', selectedRowIds[i]);
      listIds.push(rowData.id);
    }
    var popupLabel = '';
    if (listIds.length == 1) {	// In table label cell there can be some additional links
      var labelCellData = ptsGetGridColDataById(listIds[0], 'label', 'ptsPagesTbl');
      popupLabel = jQuery(labelCellData).text();
    }
    var confirmMsg = listIds.length > 1
      ? toeLangPts('Are you sur want to remove ' + listIds.length + ' Tables?')
      : toeLangPts('Are you sure want to remove "' + popupLabel + '" Table?')
    if (confirm(confirmMsg)) {
      jQuery.sendFormPts({
        btn: this
        , data: { mod: 'tables', action: 'removeGroup', pts_nonce: PTS_NONCE['pts_nonce'], listIds: listIds }
        , onSuccess: function (res) {
          if (!res.error) {
            jQuery('#ptsPagesTbl').trigger('reloadGrid');
          }
        }
      });
    }
    return false;
  });
});
