<?php
/**
 * Plugin Name: Prevent XSS Vulnerability
 * Plugin URI: https://www.yasglobal.com/web-design-development/wordpress/prevent-xss-vulnerability/
 * Description: This WordPress plugin enhances website security by preventing Cross-Site Scripting (XSS) vulnerabilities. It blocks and encodes malicious characters in URLs, escapes HTML in `$_GET` variables, and provides customizable settings for website owners.
 * Version: 2.1.0
 * Requires at least: 3.5
 * Requires PHP: 5.6
 * Author: Sami Ahmed Siddiqui
 * Author URI: https://www.linkedin.com/in/sami-ahmed-siddiqui/
 * License: GPLv3
 * License URI: https://www.gnu.org/licenses/gpl-3.0.html
 *
 * Text Domain: prevent-xss-vulnerability
 * Domain Path: /languages/
 *
 * @package PreventXSSVulnerability
 */

/**
 *  Prevent XSS Vulnerability - Secure your website from XSS Attacks.
 *  Copyright (C) 2017-2025, Sami Ahmed Siddiqui <sami.siddiqui@yasglobal.com>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! defined( 'PREVENT_XSS_VULNERABILITY_FILE' ) ) {
	define( 'PREVENT_XSS_VULNERABILITY_FILE', __FILE__ );
}

// Include the main Prevent XSS Vulnerability class.
require_once plugin_dir_path( PREVENT_XSS_VULNERABILITY_FILE ) . 'includes/class-prevent-xss-vulnerability.php';
