<?php
/**
 * Prevent XSS Vulnerability setup.
 *
 * @package PreventXSSVulnerability
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Main Class that defines constant and include other files.
 */
final class Prevent_XSS_Vulnerability {
	/**
	 * Prevent XSS Vulnerability version.
	 *
	 * @var string
	 */
	public $version = '2.1.0';

	/**
	 * Class constructor.
	 */
	public function __construct() {
		$this->define_constants();
		$this->includes();
		$this->init_hooks();
	}

	/**
	 * Define Prevent XSS Vulnerability constants.
	 *
	 * @access private
	 * @since 0.1
	 *
	 * @return void
	 */
	private function define_constants() {
		$this->define( 'PREVENT_XSS_VULNERABILITY_BASENAME', plugin_basename( PREVENT_XSS_VULNERABILITY_FILE ) );
		$this->define( 'PREVENT_XSS_VULNERABILITY_PATH', plugin_dir_path( PREVENT_XSS_VULNERABILITY_FILE ) );
		$this->define( 'PREVENT_XSS_VULNERABILITY_VERSION', $this->version );
	}

	/**
	 * Define constant if not set already.
	 *
	 * @since 1.1.0
	 * @access private
	 *
	 * @param string      $name  Constant name.
	 * @param string|bool $value Constant value.
	 *
	 * @return void
	 */
	private function define( $name, $value ) {
		if ( ! defined( $name ) ) {
			define( $name, $value );
		}
	}

	/**
	 * Include required core files used in admin and on the frontend.
	 *
	 * @access private
	 * @since 0.1
	 *
	 * @return void
	 */
	private function includes() {
		include_once PREVENT_XSS_VULNERABILITY_PATH . 'includes/class-prevent-xss-vulnerability-frontend.php';
		include_once PREVENT_XSS_VULNERABILITY_PATH . 'admin/class-prevent-xss-vulnerability-admin.php';

		$prevent_xss_frontend = new Prevent_XSS_Vulnerability_Frontend();
		$prevent_xss_frontend->init();
	}

	/**
	 * Hook into actions and filters.
	 *
	 * @since 1.1.0
	 * @access private
	 */
	private function init_hooks() {
		add_action( 'plugins_loaded', array( $this, 'load_textdomain' ) );
	}

	/**
	 * Loads the plugin language files to support different languages.
	 *
	 * @access public
	 * @since 0.1
	 *
	 * @return void
	 */
	public function load_textdomain() {
		$dirname = rtrim( PREVENT_XSS_VULNERABILITY_PATH, '/' );

		load_plugin_textdomain(
			'prevent-xss-vulnerability',
			false,
			wp_basename( $dirname ) . '/languages/'
		);
	}
}

new Prevent_XSS_Vulnerability();
