﻿___TERMS_OF_SERVICE___

By creating or modifying this file you agree to Google Tag Manager's Community
Template Gallery Developer Terms of Service available at
https://developers.google.com/tag-manager/gallery-tos (or such other URL as
Google may provide), as modified from time to time.


___INFO___

{
  "type": "TAG",
  "id": "cvt_temp_public_id",
  "version": 1,
  "securityGroups": [],
  "displayName": "Pressidium Cookie Consent",
  "categories": ["TAG_MANAGEMENT", "PERSONALIZATION"],
  "brand": {
    "id": "brand_dummy",
    "displayName": "",
    "thumbnail": "data:image/png;base64,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\u003d"
  },
  "description": "Lightweight, user-friendly and customizable cookie consent template to help you comply with the EU GDPR cookie law and CCPA regulations.",
  "containerContexts": [
    "WEB"
  ]
}


___TEMPLATE_PARAMETERS___

[
  {
    "type": "PARAM_TABLE",
    "name": "default_consent_states",
    "displayName": "Default consent states",
    "paramTableColumns": [
      {
        "param": {
          "type": "TEXT",
          "name": "region",
          "displayName": "Regions",
          "simpleValueType": true,
          "help": "Comma-separated ISO 3166-2 regions (leave blank to have selections apply to all regions)"
        },
        "isUnique": true
      },
      {
        "param": {
          "type": "CHECKBOX",
          "name": "ad_storage",
          "checkboxText": "Ad storage",
          "simpleValueType": true,
          "help": "Enables storage, such as cookies, related to advertising"
        },
        "isUnique": false
      },
      {
        "param": {
          "type": "CHECKBOX",
          "name": "ad_user_data",
          "checkboxText": "Ad user data",
          "simpleValueType": true,
          "help": "Sets consent for sending user data to Google for online advertising purposes"
        },
        "isUnique": false
      },
      {
        "param": {
          "type": "CHECKBOX",
          "name": "ad_personalization",
          "checkboxText": "Ad personalization",
          "simpleValueType": true,
          "help": "Sets consent for personalized advertising"
        },
        "isUnique": false
      },
      {
        "param": {
          "type": "CHECKBOX",
          "name": "analytics_storage",
          "checkboxText": "Analytics storage",
          "simpleValueType": true,
          "help": "Enables storage, such as cookies, related to analytics (for example, visit duration)"
        },
        "isUnique": false
      },
      {
        "param": {
          "type": "CHECKBOX",
          "name": "functionality_storage",
          "checkboxText": "Functionality storage",
          "simpleValueType": true,
          "help": "Enables storage that supports the functionality of the website such as language settings"
        },
        "isUnique": false
      },
      {
        "param": {
          "type": "CHECKBOX",
          "name": "personalization_storage",
          "checkboxText": "Personalization storage",
          "simpleValueType": true,
          "help": "Enables storage related to personalization such as video recommendations"
        },
        "isUnique": false
      },
      {
        "param": {
          "type": "CHECKBOX",
          "name": "security_storage",
          "checkboxText": "Security storage",
          "simpleValueType": true,
          "help": "Enables storage related to security such as authentication functionality, fraud prevention, and other user protection"
        },
        "isUnique": false
      }
    ]
  },
  {
    "type": "CHECKBOX",
    "name": "ads_data_redaction",
    "checkboxText": "Ads data redaction",
    "simpleValueType": true,
    "help": "When the \u0027Ad storage\u0027 consent type is denied, ad click identifiers sent in network requests by Google Ads and Floodlight tags will be redacted. Network requests will also be sent through a cookieless domain"
  },
  {
    "type": "CHECKBOX",
    "name": "url_passthrough",
    "checkboxText": "URL passthrough",
    "simpleValueType": true,
    "help": "Will pass through ad click, client ID, and session ID information in URLs"
  }
]


___SANDBOXED_JS_FOR_WEB_TEMPLATE___

/*
 * Pressidium Cookie Consent
 * (Google Tag Manager consent template)
 *
 * Copyright (c) 2024 Pressidium
 */

const setDefaultConsentState = require('setDefaultConsentState');
const updateConsentState = require('updateConsentState');
const getCookieValues = require('getCookieValues');
const callInWindow = require('callInWindow');
const gtagSet = require('gtagSet');
const JSON = require('JSON');

const COOKIE_NAME = 'pressidium_cookie_consent';

const CONSENT_TYPES = [
  'ad_storage',
  'ad_user_data',
  'ad_personalization',
  'analytics_storage',
  'functionality_storage',
  'personalization_storage',
  'security_storage',
];

const ALLOWED_CATEGORIES = [
  'necessary',
  'analytics',
  'targeting',
  'preferences',
];

/**
 * Split the input string using comma as a delimiter, returning an array of strings.
 *
 * @param {string} input
 *
 * @return {string[]}
 */
const splitInput = (input) => {
  return input
    .split(',')
    .map((entry) => entry.trim())
    .filter((entry) => entry.length !== 0);
};

/**
 * Process a row of input from the default settings table, returning an object
 * which can be passed as an argument to `setDefaultConsentState`.
 *
 * @param {object} settings
 *
 * @return {void}
 */
const parseCommandData = (settings) => {
  const regions = splitInput(settings.region);

  const commandData = {
    ad_storage: 'denied',
    ad_user_data: 'denied',
    ad_personalization: 'denied',
    analytics_storage: 'denied',
    functionality_storage: 'denied',
    personalization_storage: 'denied',
    security_storage: 'denied',
  };

  CONSENT_TYPES.forEach((consentType) => {
    commandData[consentType] = settings[consentType] ? 'granted' : 'denied';
  });

  if (regions.length > 0) {
    commandData.region = regions;
  }

  return commandData;
};

/**
 * Called when consent changes. Assumes that consent object contains keys which
 * directly correspond to Google consent types.
 *
 * @param {object} consentModeStates
 *
 * @return {void}
 */
const onUserConsent = (consentModeStates) => {
  updateConsentState(consentModeStates);
};

/**
 * Return the GCM consent states based on the given accepted cookie categories.
 *
 * @param {string[]} categories Accepted cookie categories.
 *
 * @return {{
 *   ad_storage: string,
 *   ad_user_data: string,
 *   security_storage: string,
 *   functionality_storage: string,
 *   personalization_storage: string,
 *   ad_personalization: string,
 *   analytics_storage: string
 * }}
 */
const getConsentStatesByCategories = (categories) => {
  const consentModeStates = {
    ad_storage: 'denied',
    ad_user_data: 'denied',
    ad_personalization: 'denied',
    analytics_storage: 'denied',
    functionality_storage: 'denied',
    personalization_storage: 'denied',
    security_storage: 'denied',
  };

  const mapCategoryToType = {
    necessary: ['functionality_storage', 'security_storage'],
    preferences: ['personalization_storage'],
    analytics: ['analytics_storage'],
    targeting: ['ad_storage', 'ad_user_data', 'ad_personalization'],
  };

  categories.forEach((category) => {
    if (!mapCategoryToType.hasOwnProperty(category)) {
      return;
    }

    mapCategoryToType[category].forEach((consentType) => {
      consentModeStates[consentType] = 'granted';
    });
  });

  return consentModeStates;
};

/**
 * Return the GCM consent states based on the given cookie name.
 *
 * @param {string} cookieName Name of the cookie.
 *
 * @return {{
 *   ad_storage: string,
 *   ad_user_data: string,
 *   security_storage: string,
 *   functionality_storage: string,
 *   personalization_storage: string,
 *   ad_personalization: string,
 *   analytics_storage: string
 * }|null}
 */
const getConsentStatesByCookie = (cookieName) => {
  const cookieValues = getCookieValues(COOKIE_NAME) || [];

  if (cookieValues.length === 0) {
    // No cookie set, bail early
    return null;
  }

  const cookie = JSON.parse(cookieValues[0]);

  if (typeof cookie !== 'object') {
    // Invalid cookie, fail, and bail early
    data.gtmOnFailure();
    return null;
  }

  if (!cookie.hasOwnProperty('categories')) {
    // No categories set, bail early
    return null;
  }

  // Validate the cookie categories
  const categories = cookie.categories
    .map((category) => category.toLowerCase())
    .filter((category) => ALLOWED_CATEGORIES.indexOf(category) !== -1);

  // Return an object with the consent states formatted for GCM
  return getConsentStatesByCategories(categories);
};

/**
 * Execute the default command, and set up the consent update callback.
 *
 * @param {object} data
 *
 * @return {void}
 */
const main = (data) => {
  // Optional settings using `gtagSet()`
  gtagSet('ads_data_redaction', data.ads_data_redaction);
  gtagSet('url_passthrough', data.url_passthrough);

  // Set default consent states
  if (data.hasOwnProperty('default_consent_states')) {
    data.default_consent_states.forEach((settings) => {
      const defaultData = parseCommandData(settings);
      // `wait_for_update` (ms) allows for time to receive visitor choices
      defaultData.wait_for_update = 500;
      setDefaultConsentState(defaultData);
    });
  }

  /*
   * Check if cookie is set and has values that correspond to
   * Google consent types. If it does, run `onUserConsent()`.
   */
  const consentModeStates = getConsentStatesByCookie(COOKIE_NAME);
  if (consentModeStates !== null) {
    onUserConsent(consentModeStates);
  }

  /*
   * Add event listener to trigger update when consent changes.
   *
   * References an external method on the window object which accepts a
   * function as an argument. If you do not have such a method, you will need
   * to create one before continuing. This method should add the function
   * that is passed as an argument as a callback for an event emitted when
   * the user updates their consent. The callback should be called with an
   * object containing fields that correspond to the five built-in Google
   * consent types.
   */
  callInWindow('addPressidiumGCMConsentListener', onUserConsent);
};

main(data);
data.gtmOnSuccess();


___WEB_PERMISSIONS___

[
  {
    "instance": {
      "key": {
        "publicId": "access_globals",
        "versionId": "1"
      },
      "param": [
        {
          "key": "keys",
          "value": {
            "type": 2,
            "listItem": [
              {
                "type": 3,
                "mapKey": [
                  {
                    "type": 1,
                    "string": "key"
                  },
                  {
                    "type": 1,
                    "string": "read"
                  },
                  {
                    "type": 1,
                    "string": "write"
                  },
                  {
                    "type": 1,
                    "string": "execute"
                  }
                ],
                "mapValue": [
                  {
                    "type": 1,
                    "string": "addPressidiumGCMConsentListener"
                  },
                  {
                    "type": 8,
                    "boolean": false
                  },
                  {
                    "type": 8,
                    "boolean": false
                  },
                  {
                    "type": 8,
                    "boolean": true
                  }
                ]
              }
            ]
          }
        }
      ]
    },
    "clientAnnotations": {
      "isEditedByUser": true
    },
    "isRequired": true
  },
  {
    "instance": {
      "key": {
        "publicId": "write_data_layer",
        "versionId": "1"
      },
      "param": [
        {
          "key": "keyPatterns",
          "value": {
            "type": 2,
            "listItem": [
              {
                "type": 1,
                "string": "ads_data_redaction"
              },
              {
                "type": 1,
                "string": "url_passthrough"
              }
            ]
          }
        }
      ]
    },
    "clientAnnotations": {
      "isEditedByUser": true
    },
    "isRequired": true
  },
  {
    "instance": {
      "key": {
        "publicId": "get_cookies",
        "versionId": "1"
      },
      "param": [
        {
          "key": "cookieAccess",
          "value": {
            "type": 1,
            "string": "specific"
          }
        },
        {
          "key": "cookieNames",
          "value": {
            "type": 2,
            "listItem": [
              {
                "type": 1,
                "string": "pressidium_cookie_consent"
              }
            ]
          }
        }
      ]
    },
    "clientAnnotations": {
      "isEditedByUser": true
    },
    "isRequired": true
  },
  {
    "instance": {
      "key": {
        "publicId": "access_consent",
        "versionId": "1"
      },
      "param": [
        {
          "key": "consentTypes",
          "value": {
            "type": 2,
            "listItem": [
              {
                "type": 3,
                "mapKey": [
                  {
                    "type": 1,
                    "string": "consentType"
                  },
                  {
                    "type": 1,
                    "string": "read"
                  },
                  {
                    "type": 1,
                    "string": "write"
                  }
                ],
                "mapValue": [
                  {
                    "type": 1,
                    "string": "ad_storage"
                  },
                  {
                    "type": 8,
                    "boolean": false
                  },
                  {
                    "type": 8,
                    "boolean": true
                  }
                ]
              },
              {
                "type": 3,
                "mapKey": [
                  {
                    "type": 1,
                    "string": "consentType"
                  },
                  {
                    "type": 1,
                    "string": "read"
                  },
                  {
                    "type": 1,
                    "string": "write"
                  }
                ],
                "mapValue": [
                  {
                    "type": 1,
                    "string": "ad_user_data"
                  },
                  {
                    "type": 8,
                    "boolean": false
                  },
                  {
                    "type": 8,
                    "boolean": true
                  }
                ]
              },
              {
                "type": 3,
                "mapKey": [
                  {
                    "type": 1,
                    "string": "consentType"
                  },
                  {
                    "type": 1,
                    "string": "read"
                  },
                  {
                    "type": 1,
                    "string": "write"
                  }
                ],
                "mapValue": [
                  {
                    "type": 1,
                    "string": "ad_personalization"
                  },
                  {
                    "type": 8,
                    "boolean": false
                  },
                  {
                    "type": 8,
                    "boolean": true
                  }
                ]
              },
              {
                "type": 3,
                "mapKey": [
                  {
                    "type": 1,
                    "string": "consentType"
                  },
                  {
                    "type": 1,
                    "string": "read"
                  },
                  {
                    "type": 1,
                    "string": "write"
                  }
                ],
                "mapValue": [
                  {
                    "type": 1,
                    "string": "analytics_storage"
                  },
                  {
                    "type": 8,
                    "boolean": false
                  },
                  {
                    "type": 8,
                    "boolean": true
                  }
                ]
              },
              {
                "type": 3,
                "mapKey": [
                  {
                    "type": 1,
                    "string": "consentType"
                  },
                  {
                    "type": 1,
                    "string": "read"
                  },
                  {
                    "type": 1,
                    "string": "write"
                  }
                ],
                "mapValue": [
                  {
                    "type": 1,
                    "string": "functionality_storage"
                  },
                  {
                    "type": 8,
                    "boolean": false
                  },
                  {
                    "type": 8,
                    "boolean": true
                  }
                ]
              },
              {
                "type": 3,
                "mapKey": [
                  {
                    "type": 1,
                    "string": "consentType"
                  },
                  {
                    "type": 1,
                    "string": "read"
                  },
                  {
                    "type": 1,
                    "string": "write"
                  }
                ],
                "mapValue": [
                  {
                    "type": 1,
                    "string": "personalization_storage"
                  },
                  {
                    "type": 8,
                    "boolean": false
                  },
                  {
                    "type": 8,
                    "boolean": true
                  }
                ]
              },
              {
                "type": 3,
                "mapKey": [
                  {
                    "type": 1,
                    "string": "consentType"
                  },
                  {
                    "type": 1,
                    "string": "read"
                  },
                  {
                    "type": 1,
                    "string": "write"
                  }
                ],
                "mapValue": [
                  {
                    "type": 1,
                    "string": "security_storage"
                  },
                  {
                    "type": 8,
                    "boolean": false
                  },
                  {
                    "type": 8,
                    "boolean": true
                  }
                ]
              }
            ]
          }
        }
      ]
    },
    "clientAnnotations": {
      "isEditedByUser": true
    },
    "isRequired": true
  }
]


___TESTS___

scenarios: []


___NOTES___

== Changelog ==

= GTM Template 1.0.0: Mar 21, 2024 =

* Initial version


