<?php

use Premmerce\Filter\Admin\Tabs\BundleAndSave;

if (! defined('ABSPATH')) {
	exit;
}

$bundlesFAQs = [
	[
		'question' => __('How does the domain limit work?', 'premmerce-filter'),
		'answer'   => __('Once you choose a plan, you get access to the products described in the package and a specific number of domain licenses. You can activate any of the premium products (themes or plugins) on the domains where you have an active license.', 'premmerce-filter'),
	],
	[
		'question' => __('What will happen if I if I don’t renew my license in a year?', 'premmerce-filter'),
		'answer'   => __('Your domain license will become invalid in 12 months period. The product will continue to work.However, after your license expires, the access to security updates, support requests, and new features is discontinued until the new license is activated. For lifetime membership this is not the case, only for the annual plans.', 'premmerce-filter'),
	],
	[
		'question' => __('How often do I have to pay?', 'premmerce-filter'),
		'answer'   => __('With the annual membership, you will have to renew after the first year if you want to continue receiving security updates and support. The product will continue to work even if you cancel immediately, but you won’t get the updates and support after the license expires. You are free to upgrade/cancel anytime. Lifetime is a one-time payment, and as long as the product is maintained, you will get support and security updates.', 'premmerce-filter'),
	],
	[
		'question' => __('Do you offer refunds?', 'premmerce-filter'),
		'answer'   => __('Yes, if you have an issue that cannot be resolved via our support service within 14 days from the purchase date, you will be offered a full refund.', 'premmerce-filter'),
	],
	[
		'question' => __('Will my subscription renew automatically?', 'premmerce-filter'),
		'answer'   => __('Yes, your subscription will renew automatically every year, until its cancellation.', 'premmerce-filter'),
	],
	[
		'question' => __('Can I use my licence in a development environment?', 'premmerce-filter'),
		'answer'   => __('Yes. Most development environments will not count towards your site limit.', 'premmerce-filter'),
	],
	[
		'question' => __('How do I download the plugins?', 'premmerce-filter'),
		'answer'   => __('Once you place your order, you\'ll be sent an email containing the download links to all the purchased plugins and themes.', 'premmerce-filter'),
	],
	[
		'question' => __('How much money am I saving with a Premmerce Suite bundle?', 'premmerce-filter'),
		'answer'   => __('You will save at least 70% when you buy a bundle. This percentage is even higher if you opt to pay annually.', 'premmerce-filter'),
	],
	[
		'question' => __('Are there any hidden fees and what do we have to pay for after the project has been delivered?', 'premmerce-filter'),
		'answer'   => __('There are no hidden or recurring charges to be paid after a project delivery. However, you need a hosting platform and a domain name for your website which are usually paid on a regular basis. You can buy them from our company or elsewhere. The most important thing is that your hosting platform must adhere to our software minimal requirements.', 'premmerce-filter'),
	],
];
?>

<div class="c-section">
	<div class="c-section__container">
		<div class="c-section__title"><span style="font-weight: 400;">Frequently Asked Questions</span></div>
		<div class="c-section__desc"><span style="font-weight: 400;">
				<?php esc_attr_e('If you have any further questions, don’t hesitate to ask us via the online chat or by e-mail', 'premmerce-filter'); ?>
			</span>
			<a href="mailto:info@premmerce.com">
				<span style="font-weight: 400;">
					info@premmerce.com
				</span>
			</a>
		</div>
		<div class="c-section__content">
			<?php
				$rowCount  = 0;
				$numOfCols = 2;
			foreach ($bundlesFAQs as $faq) :
				if (0 === $rowCount % $numOfCols ) {

					?>
				 <div class="row">
				<?php
				}
				$rowCount++;
				?>
				<div class="col-sm-6">
					<div class="pc-qa" data-qa-scope="">
						<div class="pc-qa__header" data-qa-toggle="">
							<div class="pc-qa__title">
								<?php echo esc_attr($faq['question']); ?>
							</div>
							<div class="pc-qa__arrow">
								<svg class="svg-icon">
								<?php BundleAndSave::premmerce_use_svg_symbol($svg, 'arrow-bootom'); ?>
								</svg>
							</div>
						</div>
						<div class="pc-qa__content" data-qa-content="" style="display: none;">
						<?php echo esc_attr($faq['answer']); ?>
						</div>
					</div>
				</div>
				<?php
				if (0 === $rowCount % $numOfCols ) :
					?>
</div> <?php endif; ?>
			<?php endforeach; ?>
		</div>
	</div>
</div>
