<?php
/**
 * Pro Designs and Plugins Feed
 *
 * @package Preloader for Website - WPOS
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
} ?>

<div class="wrap plwao-wrap">
<h2>
	<?php esc_html_e( 'How It Works', 'preloader-for-website' ); ?>
</h2>
	<style type="text/css">
		.wpos-pro-box .hndle{background-color:#0073AA; color:#fff;}
		.wpos-pro-box .postbox{background:#dbf0fa none repeat scroll 0 0; border:1px solid #0073aa; color:#191e23;}
		.postbox-container .wpos-list li:before{font-family: dashicons; content: "\f139"; font-size:20px; color: #0073aa; vertical-align: middle;}
		.plwao-wrap .wpos-button-full{display:block; text-align:center; box-shadow:none; border-radius:0;}
		.plwao-shortcode-preview{background-color: #e7e7e7; font-weight: bold; padding: 2px 5px; display: inline-block; margin:0 0 2px 0;}
	</style>

	<div class="post-box-container">
		<div id="poststuff">
			<div id="post-body" class="metabox-holder columns-2">
				<div id="post-body-content">
					<div class="metabox-holder">
						<div class="meta-box-sortables ui-sortable">
							<div class="postbox">
								<div class="postbox-header">
									<h2 class="hndle">
										<span><?php esc_html_e( 'How It Works', 'preloader-for-website' ); ?></span>
									</h2>
								</div>

								<div class="inside">
									<table class="form-table">
										<tbody>
											<tr>
												<th>
													<label><?php esc_html_e('Getting Started', 'preloader-for-website'); ?></label>
												</th>
												<td>
													<ul>
														<li><?php esc_html_e('Step-1: This plugin creates a Preloader - WPOS tab in WordPress menu section.', 'preloader-for-website'); ?></li>
														<li><?php esc_html_e('Step-2: Go to Preloader - WPOS and enable preloader then select your spinner.', 'preloader-for-website'); ?></li>
														<li><?php esc_html_e('Step-3: Now you can see pre loader on your website !!!', 'preloader-for-website'); ?></li>
													</ul>
												</td>
											</tr>
										</tbody>
									</table>
								</div><!-- .inside -->
							</div><!-- .postbox -->

							<div class="postbox">
								<div class="postbox-header">
									<h3 class="hndle">
										<span><?php esc_html_e( 'Help to improve this plugin!', 'preloader-for-website' ); ?></span>
									</h3>
								</div>

								<div class="inside">
									<p>Enjoyed this plugin? You can help by rate this plugin <a href="https://wordpress.org/support/plugin/preloader-for-website/reviews/?filter=5" target="_blank">5 stars!</a></p>
								</div><!-- .inside -->
							</div><!-- #general -->
						</div><!-- .meta-box-sortables -->
					</div><!-- .metabox-holder -->
				</div><!-- .post-body-content -->

				<!--Upgrad to Pro HTML -->
				<div id="postbox-container-1" class="postbox-container">
					<div class="metabox-holder wpos-pro-box">
						<div class="meta-box-sortables ui-sortable">
							<div class="postbox">

								<h3 class="hndle">
									<span><?php esc_html_e( 'Go for Pro Version', 'preloader-for-website' ); ?></span>
								</h3>

								<div class="inside">
									<ul class="wpos-list">
										<li>Additional Enable Preloader Options</li>
										<li>Preloader Type</li>
										<li>Preloader Visibility</li>
										<li>17 Predefined Spinner</li>
										<li>3 Preloader sizes</li>
										<li>Add your own loader image</li>
										<li>Preloader Minimum Runtime</li>
										<li>Preloader Disappear Time</li>
										<li>Custom Content</li>
										<li>Hide On Locations</li>
										<li>Preloader area background image</li>
										<li>Templating</li>
									</ul>

									<p><a class="button button-primary wpos-button-full" href="<?php echo esc_url(PAOC_SITE_LINK); ?>/pricing/?utm_source=WP&utm_medium=Preloader&utm_campaign=How-It-Work" target="_blank"><?php esc_html_e('Grab Now ', 'preloader-for-website'); ?></a></p>
									<p><a class="button button-primary wpos-button-full" href="https://demo.essentialplugin.com/prodemo/preloader-for-website-demo/?utm_source=WP&utm_medium=Preloader&utm_campaign=PRO-Demo" target="_blank"><?php esc_html_e('View PRO Demo ', 'preloader-for-website'); ?></a></p> 
								</div><!-- .inside -->
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>