<?php

namespace PPRH;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class SettingsView extends SettingsSave {

	public static function markup( $on_pprh_admin ) {
		?>
        <div class="pprh-content settings">
            <form method="post" action="">
				<?php
				\wp_nonce_field( 'pprh_save_admin_options', 'pprh_admin_options_nonce' );

				if ( $on_pprh_admin ) {
					\wp_nonce_field( 'closedpostboxes', 'closedpostboxesnonce', false );
					\do_meta_boxes( PPRH_ADMIN_SCREEN, 'normal', null );
				}
				?>
                <div class="text-center">
                    <input type="submit" name="pprh_save_options" class="button button-primary" value="<?php esc_attr_e( 'Save Changes', 'pre-party-browser-hints' ); ?>" />
                </div>
            </form>
        </div>
		<?php
	}

	public function general_markup() {
		$selected = 'selected="selected"';
		$disable_wp_hints = $this->does_option_match( 'pprh_disable_wp_hints', 'true', 'checked' );
		?>
		<table class="form-table">
			<tbody>

			<tr>
				<th scope="row"><?php esc_html_e( 'Disable automatically generated WordPress resource hints?', 'pre-party-browser-hints' ); ?></th>
				<td>
                    <label for="pprh_disable_wp_hints">
                        <input type="checkbox" name="pprh_disable_wp_hints" value="true" <?php echo $disable_wp_hints; ?>/>
                    </label>
					<p><?php esc_html_e( 'This option will remove three resource hints automatically generated by WordPress, as of 4.8.2.', 'pre-party-browser-hints' ); ?></p>
				</td>
			</tr>

			<tr>
				<th scope="row"><?php esc_html_e( 'Send resource hints in HTML head or HTTP header?', 'pre-party-browser-hints' ); ?></th>
				<td>
                    <label for="pprh_html_head">
                        <select id="pprhHintLocation" name="pprh_html_head">
                            <option value="true" <?php echo $this->does_option_match( 'pprh_html_head', 'true', $selected ); ?>><?php esc_html_e( 'HTML &lt;head&gt;', 'pre-party-browser-hints' ); ?></option>
                            <option value="false" <?php echo $this->does_option_match( 'pprh_html_head', 'false', $selected ); ?>><?php esc_html_e( 'HTTP Header', 'pre-party-browser-hints' ); ?></option>
                        </select>
                    </label>
					<p><?php esc_html_e( 'Send hints in the HTML &lt;head&gt; or the HTTP header.', 'pre-party-browser-hints' ); ?></p>
				</td>
			</tr>

			<?php \do_action( 'pprh_sc_general_settings' ); ?>

			</tbody>
		</table>
		<?php
	}

	public function preconnect_markup() {
		$autoload = $this->does_option_match( 'pprh_preconnect_autoload', 'true', 'checked' );
		?>
		<table class="form-table">
			<tbody>

                <tr>
                    <th scope="row"><?php esc_html_e( 'Enable Auto Preconnect?', 'pre-party-browser-hints' ); ?></th>
                    <td>
                        <label for="pprh_preconnect_autoload">
                            <input type="checkbox" name="pprh_preconnect_autoload" value="true" <?php echo $autoload; ?>/>
                        </label>
                        <p><?php esc_html_e( 'This feature allows preconnect hints to be automatically created. JavaScript, CSS, and images loaded from external domains will preconnect automatically.', 'pre-party-browser-hints' ); ?></p>
                    </td>
                </tr>

			<?php $this->load_reset_settings(); ?>

			</tbody>
		</table>
		<?php
	}

	public function load_reset_settings() {
		$result       = \apply_filters( 'pprh_load_pro_metabox', 'preconnect' );
		$allow_unauth = $this->does_option_match( 'pprh_preconnect_allow_unauth', 'true', 'checked' );

		if ( is_string( $result ) ) { ?>
            <tr>
				<th scope="row"><?php esc_html_e( 'Allow unauthenticated users to automatically set preconnect hints via Ajax?', 'pre-party-browser-hints' ); ?></th>
				<td>
                    <label for="pprh_preconnect_allow_unauth">
                        <input type="checkbox" name="pprh_preconnect_allow_unauth" value="true" <?php echo $allow_unauth; ?>/>
                    </label>
					<p><?php esc_html_e( 'This plugin has a feature which allows preconnect hints to be automatically created asynchronously in the background with Ajax by the first user to visit a page (assuming the user has that option to be reset). There is an extremely remote possibility that if a visitor knew the hints would be set, they could choose to manually load many external scripts, which could trick the plugin script into accepting these as valid preconnect hints. But again this is a very remote possiblity and only a nuisance, not a vulnerability, due to the strict sanitization procedures in place.', 'pre-party-browser-hints' ); ?></p>
				</td>
			</tr>

            <tr>
                <th scope="row"><?php esc_html_e( 'Reset automatically created preconnect links?', 'pre-party-browser-hints' ); ?></th>
                <td>
                    <input type="submit" name="pprh_preconnect_set" class="pprh-reset button-primary" data-text="reset auto-preconnect hints?" value="Reset">
                    <p><?php esc_html_e( 'This will reset automatically created preconnect hints, allowing new preconnect hints to be generated when your front end is loaded.', 'pre-party-browser-hints' ); ?></p>
                </td>
            </tr>

		<?php }
		return false;
	}

	public function prefetch_markup() {
		$prefetch_enabled                 = $this->does_option_match( 'pprh_prefetch_enabled', 'true', 'checked' );
		$prefetch_disableForLoggedInUsers = $this->does_option_match( 'pprh_prefetch_disableForLoggedInUsers', 'true', 'checked' );
		$prefetch_initialization_delay    = $this->esc_get_option( 'pprh_prefetch_delay' );
		$ignore_keywords                  = implode( ', ', \get_option( 'pprh_prefetch_ignoreKeywords', array() ) );
		$prefetch_max_prefetches          = $this->esc_get_option( 'pprh_prefetch_max_prefetches' );
		?>
        <table class="form-table"><tbody>

            <tr>
                <th scope="row"><?php esc_html_e( 'Enable Auto Prefetch?', 'pre-party-browser-hints' ); ?></th>
                <td>
                    <label for="pprh_prefetch_enabled">
                        <input type="checkbox" name="pprh_prefetch_enabled" class="toggleMetaBox" value="true" <?php echo $prefetch_enabled; ?>/>
                    </label>
                    <p><?php esc_html_e( 'This allows for navigation links to be automatically prefetched while in viewport. When navigation (anchor) links are being moused over, this feature will initiate a prefetch request for the URL in the link. Select No (default) to disable this feature.', 'pre-party-browser-hints' ); ?></p>
                </td>
            </tr>

            <tr>
                <th scope="row"><?php esc_html_e( 'Disable prefetching for logged in users?', 'pre-party-browser-hints' ); ?></th>
                <td>
                    <label for="pprh_prefetch_disableForLoggedInUsers">
                        <input type="checkbox" name="pprh_prefetch_disableForLoggedInUsers" value="true" <?php echo $prefetch_disableForLoggedInUsers; ?>/>
                    </label>
                    <p><?php esc_html_e( 'It usually is not necessary for logged in users to prefetch content. This will save some server resources.', 'pre-party-browser-hints' ); ?></p>
                </td>
            </tr>

            <tr>
                <th scope="row"><?php esc_html_e( 'Prefetch initiation delay (seconds):', 'pre-party-browser-hints' ); ?></th>
                <td>
                    <label for="pprh_prefetch_delay">
                        <input type="number" step="1" min="0" max="30" name="pprh_prefetch_delay" value="<?php echo $prefetch_initialization_delay; ?>">
                    </label>
                    <p><?php esc_html_e( 'Start prefetching after a short delay. Will be started when the browser becomes idle. Default is 0 seconds.', 'pre-party-browser-hints' ); ?></p>
                </td>
            </tr>

            <tr>
                <th scope="row"><?php esc_html_e( 'Ignore these keywords:', 'pre-party-browser-hints' ); ?></th>
                <td>
                    <label for="pprh_prefetch_ignoreKeywords">
                        <textarea name="pprh_prefetch_ignoreKeywords" rows="6"><?php echo $this->get_each_keyword( $ignore_keywords ); ?></textarea>
                    </label>
                    <p><?php esc_html_e( 'A list of keywords to ignore from prefetching. One keyword per line. You may use an astericks (*) after a keyword (ex: "/products*") to act as a wildcard, preventing links with that value from being prefetched.', 'pre-party-browser-hints'); ?></p>
                </td>
            </tr>

            <tr>
                <th scope="row"><?php esc_html_e( 'Maximum requests per second:', 'pre-party-browser-hints' ); ?></th>
                <td>
                    <label for="pprh_prefetch_maxRPS">
                        <input type="number" step="1" min="1" max="100" name="pprh_prefetch_maxRPS" value="<?php echo $this->esc_get_option( 'pprh_prefetch_maxRPS' ); ?>">
                    </label>
                    <p><?php esc_html_e( 'Number of prefetch hints that can be created per second. Default is 3 per second.', 'pre-party-browser-hints' ); ?></p>
                </td>
            </tr>

            <tr>
                <th scope="row"><?php esc_html_e( 'Delay in prefetching links on mouse hover (milliseconds)', 'pre-party-browser-hints' ); ?></th>
                <td>
                    <label for="pprh_prefetch_hoverDelay">
                        <input type="number" min="0" max="1000" step="1" name="pprh_prefetch_hoverDelay" value="<?php echo $this->esc_get_option( 'pprh_prefetch_hoverDelay' ); ?>">
                    </label>
                    <p><?php esc_html_e( 'Set a short pause after the mouse hovers over a link before the prefetch hint is created. Default is 50 milliseconds.', 'pre-party-browser-hints' ); ?></p>
                </td>
            </tr>

            <tr>
                <th scope="row"><?php esc_html_e( 'Maximum number of prefetch hints loaded? (Excluding mouse hover or touch events)', 'pre-party-browser-hints' ); ?></th>
                <td>
                    <label for="pprh_prefetch_max_prefetches">
                        <input type="number" step="1" min="1" max="100" name="pprh_prefetch_max_prefetches" value="<?php echo $prefetch_max_prefetches; ?>">
                    </label>
                    <p><?php esc_html_e( 'Set the maximum number of prefetch hints you would like to be loaded. This can save some server resources. Default is 10.', 'pre-party-browser-hints' ); ?></p>
                </td>
            </tr>

        </tbody></table>
		<?php
        return true;
	}

	private function get_each_keyword( $keywords ) {
		if ( is_null( $keywords ) ) {
			return '';
		}

		$keywords = explode( ', ', $keywords );
		$str   = '';
		$count = count( $keywords );
		$idx   = 0;

		foreach ( $keywords as $keyword ) {
			$idx++;
			$str .= $keyword;

			if ( $idx < $count ) {
				$str .= "\n";
			}
		}

		return $str;
	}

}
