<?php
/**
 * DefaultApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Plausible\Analytics\WP\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Plausible Plugins API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0-rc
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Plausible\Analytics\WP\Client\Api;

use Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Client;
use Plausible\Analytics\WP\Client\Lib\GuzzleHttp\ClientInterface;
use Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Exception\ConnectException;
use Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Exception\RequestException;
use Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Psr7\MultipartStream;
use Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Psr7\Request;
use Plausible\Analytics\WP\Client\Lib\GuzzleHttp\RequestOptions;
use Plausible\Analytics\WP\Client\ApiException;
use Plausible\Analytics\WP\Client\Configuration;
use Plausible\Analytics\WP\Client\HeaderSelector;
use Plausible\Analytics\WP\Client\ObjectSerializer;

/**
 * DefaultApi Class Doc Comment
 *
 * @category Class
 * @package  Plausible\Analytics\WP\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class DefaultApi {
	/** @var string[] $contentTypes * */
	public const contentTypes = [
		'plausibleWebPluginsAPIControllersCapabilitiesIndex'  => [
			'application/json',
		],
		'plausibleWebPluginsAPIControllersCustomPropsDisable' => [
			'application/json',
		],
		'plausibleWebPluginsAPIControllersCustomPropsEnable'  => [
			'application/json',
		],
		'plausibleWebPluginsAPIControllersFunnelsCreate'      => [
			'application/json',
		],
		'plausibleWebPluginsAPIControllersFunnelsGet'         => [
			'application/json',
		],
		'plausibleWebPluginsAPIControllersFunnelsIndex'       => [
			'application/json',
		],
		'plausibleWebPluginsAPIControllersGoalsCreate'        => [
			'application/json',
		],
		'plausibleWebPluginsAPIControllersGoalsDelete'        => [
			'application/json',
		],
		'plausibleWebPluginsAPIControllersGoalsDeleteBulk'    => [
			'application/json',
		],
		'plausibleWebPluginsAPIControllersGoalsGet'           => [
			'application/json',
		],
		'plausibleWebPluginsAPIControllersGoalsIndex'         => [
			'application/json',
		],
		'plausibleWebPluginsAPIControllersSharedLinksCreate'  => [
			'application/json',
		],
		'plausibleWebPluginsAPIControllersSharedLinksGet'     => [
			'application/json',
		],
		'plausibleWebPluginsAPIControllersSharedLinksIndex'   => [
			'application/json',
		],
	];

	/**
	 * @var ClientInterface
	 */
	protected $client;

	/**
	 * @var Configuration
	 */
	protected $config;

	/**
	 * @var HeaderSelector
	 */
	protected $headerSelector;

	/**
	 * @var int Host index
	 */
	protected $hostIndex;

	/**
	 * @param ClientInterface $client
	 * @param Configuration   $config
	 * @param HeaderSelector  $selector
	 * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
	 */
	public function __construct(
		?ClientInterface $client = null,
		?Configuration $config = null,
		?HeaderSelector $selector = null,
		$hostIndex = 0
	) {
		$this->client         = $client ?: new Client();
		$this->config         = $config ?: new Configuration();
		$this->headerSelector = $selector ?: new HeaderSelector();
		$this->hostIndex      = $hostIndex;
	}

	/**
	 * Get the host index
	 *
	 * @return int Host index
	 */
	public function getHostIndex() {
		return $this->hostIndex;
	}

	/**
	 * Set the host index
	 *
	 * @param int $hostIndex Host index (required)
	 */
	public function setHostIndex( $hostIndex ): void {
		$this->hostIndex = $hostIndex;
	}

	/**
	 * @return Configuration
	 */
	public function getConfig() {
		return $this->config;
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersCapabilitiesIndex
	 *
	 * Retrieve Capabilities
	 *
	 * @param string $contentType The value for the Content-Type header. Check
	 *                            self::contentTypes['plausibleWebPluginsAPIControllersCapabilitiesIndex'] to see the possible values for this
	 *                            operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Model\Capabilities
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersCapabilitiesIndex(
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersCapabilitiesIndex' ][ 0 ]
	) {
		[ $response ] = $this->plausibleWebPluginsAPIControllersCapabilitiesIndexWithHttpInfo( $contentType );

		return $response;
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersCapabilitiesIndexWithHttpInfo
	 *
	 * Retrieve Capabilities
	 *
	 * @param string $contentType The value for the Content-Type header. Check
	 *                            self::contentTypes['plausibleWebPluginsAPIControllersCapabilitiesIndex'] to see the possible values for this
	 *                            operation
	 *
	 * @return array of \Plausible\Analytics\WP\Client\Model\Capabilities, HTTP status code, HTTP response headers (array of strings)
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersCapabilitiesIndexWithHttpInfo(
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersCapabilitiesIndex' ][ 0 ]
	) {
		$request = $this->plausibleWebPluginsAPIControllersCapabilitiesIndexRequest( $contentType );

		try {
			$options = $this->createHttpClientOption();
			try {
				$response = $this->client->send( $request, $options );
			} catch ( RequestException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}",
					(int) $e->getCode(),
					$e->getResponse() ? $e->getResponse()->getHeaders() : null,
					$e->getResponse() ? (string) $e->getResponse()->getBody() : null
				);
			} catch ( ConnectException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}", (int) $e->getCode(), null, null
				);
			}

			$statusCode = $response->getStatusCode();

			if ( $statusCode < 200 || $statusCode > 299 ) {
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						(string) $request->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}

			switch ( $statusCode ) {
				case 200:
					if ( '\Plausible\Analytics\WP\Client\Model\Capabilities' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\Capabilities' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\Capabilities', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
			}

			$returnType = '\Plausible\Analytics\WP\Client\Model\Capabilities';
			if ( $returnType === '\SplFileObject' ) {
				$content = $response->getBody(); //stream goes to serializer
			} else {
				$content = (string) $response->getBody();
				if ( $returnType !== 'string' ) {
					$content = json_decode( $content );
				}
			}

			return [
				ObjectSerializer::deserialize( $content, $returnType, [] ),
				$response->getStatusCode(),
				$response->getHeaders(),
			];

		} catch ( ApiException $e ) {
			switch ( $e->getCode() ) {
				case 200:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\Capabilities',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
			}
			throw $e;
		}
	}

	/**
	 * Create request for operation 'plausibleWebPluginsAPIControllersCapabilitiesIndex'
	 *
	 * @param string $contentType The value for the Content-Type header. Check
	 *                            self::contentTypes['plausibleWebPluginsAPIControllersCapabilitiesIndex'] to see the possible values for this
	 *                            operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Psr7\Request
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersCapabilitiesIndexRequest(
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersCapabilitiesIndex' ][ 0 ]
	) {

		$resourcePath = '/api/plugins/v1/capabilities';
		$formParams   = [];
		$queryParams  = [];
		$headerParams = [];
		$httpBody     = '';
		$multipart    = false;

		$headers = $this->headerSelector->selectHeaders(
			[ 'application/json', ],
			$contentType,
			$multipart
		);

		// for model (json/xml)
		if ( count( $formParams ) > 0 ) {
			if ( $multipart ) {
				$multipartContents = [];
				foreach ( $formParams as $formParamName => $formParamValue ) {
					$formParamValueItems = is_array( $formParamValue ) ? $formParamValue : [ $formParamValue ];
					foreach ( $formParamValueItems as $formParamValueItem ) {
						$multipartContents[] = [
							'name'     => $formParamName,
							'contents' => $formParamValueItem,
						];
					}
				}
				// for HTTP post (form)
				$httpBody = new MultipartStream( $multipartContents );

			} elseif ( stripos( $headers[ 'Content-Type' ], 'application/json' ) !== false ) {
				# if Content-Type contains "application/json", json_encode the form parameters
				$httpBody = \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Utils::jsonEncode( $formParams );
			} else {
				// for HTTP post (form)
				$httpBody = ObjectSerializer::buildQuery( $formParams );
			}
		}

		// this endpoint requires HTTP basic authentication
		if ( ! empty( $this->config->getUsername() ) || ! ( empty( $this->config->getPassword() ) ) ) {
			$headers[ 'Authorization' ] = 'Basic ' . base64_encode( $this->config->getUsername() . ":" . $this->config->getPassword() );
		}

		$defaultHeaders = [];
		if ( $this->config->getUserAgent() ) {
			$defaultHeaders[ 'User-Agent' ] = $this->config->getUserAgent();
		}

		$headers = array_merge(
			$defaultHeaders,
			$headerParams,
			$headers
		);

		$operationHost = $this->config->getHost();
		$query         = ObjectSerializer::buildQuery( $queryParams );

		return new Request(
			'GET', $operationHost . $resourcePath . ( $query ? "?{$query}" : '' ), $headers, $httpBody
		);
	}

	/**
	 * Create http client option
	 *
	 * @return array of http client options
	 * @throws \RuntimeException on file opening failure
	 */
	protected function createHttpClientOption() {
		$options = [];
		if ( $this->config->getDebug() ) {
			$options[ RequestOptions::DEBUG ] = fopen( $this->config->getDebugFile(), 'a' );
			if ( ! $options[ RequestOptions::DEBUG ] ) {
				throw new \RuntimeException( 'Failed to open the debug file: ' . $this->config->getDebugFile() );
			}
		}

		return $options;
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersCapabilitiesIndexAsync
	 *
	 * Retrieve Capabilities
	 *
	 * @param string $contentType The value for the Content-Type header. Check
	 *                            self::contentTypes['plausibleWebPluginsAPIControllersCapabilitiesIndex'] to see the possible values for this
	 *                            operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersCapabilitiesIndexAsync(
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersCapabilitiesIndex' ][ 0 ]
	) {
		return $this->plausibleWebPluginsAPIControllersCapabilitiesIndexAsyncWithHttpInfo( $contentType )->then(
			function ( $response ) {
				return $response[ 0 ];
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersCapabilitiesIndexAsyncWithHttpInfo
	 *
	 * Retrieve Capabilities
	 *
	 * @param string $contentType The value for the Content-Type header. Check
	 *                            self::contentTypes['plausibleWebPluginsAPIControllersCapabilitiesIndex'] to see the possible values for this
	 *                            operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersCapabilitiesIndexAsyncWithHttpInfo(
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersCapabilitiesIndex' ][ 0 ]
	) {
		$returnType = '\Plausible\Analytics\WP\Client\Model\Capabilities';
		$request    = $this->plausibleWebPluginsAPIControllersCapabilitiesIndexRequest( $contentType );

		return $this->client->sendAsync( $request, $this->createHttpClientOption() )->then(
			function ( $response ) use ( $returnType ) {
				if ( $returnType === '\SplFileObject' ) {
					$content = $response->getBody(); //stream goes to serializer
				} else {
					$content = (string) $response->getBody();
					if ( $returnType !== 'string' ) {
						$content = json_decode( $content );
					}
				}

				return [
					ObjectSerializer::deserialize( $content, $returnType, [] ),
					$response->getStatusCode(),
					$response->getHeaders(),
				];
			},
			function ( $exception ) {
				$response   = $exception->getResponse();
				$statusCode = $response->getStatusCode();
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						$exception->getRequest()->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersCustomPropsDisable
	 *
	 * Disable CustomProp(s)
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\CustomPropDisableRequest $custom_prop_disable_request CustomProp disable params (optional)
	 * @param string                                                        $contentType                 The value for the Content-Type header. Check
	 *                                                                                                   self::contentTypes['plausibleWebPluginsAPIControllersCustomPropsDisable']
	 *                                                                                                   to see the possible values for this
	 *                                                                                                   operation
	 *
	 * @return void
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersCustomPropsDisable(
		$custom_prop_disable_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersCustomPropsDisable' ][ 0 ]
	) {
		$this->plausibleWebPluginsAPIControllersCustomPropsDisableWithHttpInfo( $custom_prop_disable_request, $contentType );
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersCustomPropsDisableWithHttpInfo
	 *
	 * Disable CustomProp(s)
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\CustomPropDisableRequest $custom_prop_disable_request CustomProp disable params (optional)
	 * @param string                                                        $contentType                 The value for the Content-Type header. Check
	 *                                                                                                   self::contentTypes['plausibleWebPluginsAPIControllersCustomPropsDisable']
	 *                                                                                                   to see the possible values for this
	 *                                                                                                   operation
	 *
	 * @return array of null, HTTP status code, HTTP response headers (array of strings)
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersCustomPropsDisableWithHttpInfo(
		$custom_prop_disable_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersCustomPropsDisable' ][ 0 ]
	) {
		$request = $this->plausibleWebPluginsAPIControllersCustomPropsDisableRequest( $custom_prop_disable_request, $contentType );

		try {
			$options = $this->createHttpClientOption();
			try {
				$response = $this->client->send( $request, $options );
			} catch ( RequestException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}",
					(int) $e->getCode(),
					$e->getResponse() ? $e->getResponse()->getHeaders() : null,
					$e->getResponse() ? (string) $e->getResponse()->getBody() : null
				);
			} catch ( ConnectException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}", (int) $e->getCode(), null, null
				);
			}

			$statusCode = $response->getStatusCode();

			if ( $statusCode < 200 || $statusCode > 299 ) {
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						(string) $request->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}

			return [ null, $statusCode, $response->getHeaders() ];

		} catch ( ApiException $e ) {
			switch ( $e->getCode() ) {
				case 401:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\UnauthorizedError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 402:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\PaymentRequiredError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 422:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
			}
			throw $e;
		}
	}

	/**
	 * Create request for operation 'plausibleWebPluginsAPIControllersCustomPropsDisable'
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\CustomPropDisableRequest $custom_prop_disable_request CustomProp disable params (optional)
	 * @param string                                                        $contentType                 The value for the Content-Type header. Check
	 *                                                                                                   self::contentTypes['plausibleWebPluginsAPIControllersCustomPropsDisable']
	 *                                                                                                   to see the possible values for this
	 *                                                                                                   operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Psr7\Request
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersCustomPropsDisableRequest(
		$custom_prop_disable_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersCustomPropsDisable' ][ 0 ]
	) {

		$resourcePath = '/api/plugins/v1/custom_props';
		$formParams   = [];
		$queryParams  = [];
		$headerParams = [];
		$httpBody     = '';
		$multipart    = false;

		$headers = $this->headerSelector->selectHeaders(
			[ 'application/json', ],
			$contentType,
			$multipart
		);

		// for model (json/xml)
		if ( isset( $custom_prop_disable_request ) ) {
			if ( stripos( $headers[ 'Content-Type' ], 'application/json' ) !== false ) {
				# if Content-Type contains "application/json", json_encode the body
				$httpBody = \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Utils::jsonEncode(
					ObjectSerializer::sanitizeForSerialization( $custom_prop_disable_request )
				);
			} else {
				$httpBody = $custom_prop_disable_request;
			}
		} elseif ( count( $formParams ) > 0 ) {
			if ( $multipart ) {
				$multipartContents = [];
				foreach ( $formParams as $formParamName => $formParamValue ) {
					$formParamValueItems = is_array( $formParamValue ) ? $formParamValue : [ $formParamValue ];
					foreach ( $formParamValueItems as $formParamValueItem ) {
						$multipartContents[] = [
							'name'     => $formParamName,
							'contents' => $formParamValueItem,
						];
					}
				}
				// for HTTP post (form)
				$httpBody = new MultipartStream( $multipartContents );

			} elseif ( stripos( $headers[ 'Content-Type' ], 'application/json' ) !== false ) {
				# if Content-Type contains "application/json", json_encode the form parameters
				$httpBody = \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Utils::jsonEncode( $formParams );
			} else {
				// for HTTP post (form)
				$httpBody = ObjectSerializer::buildQuery( $formParams );
			}
		}

		// this endpoint requires HTTP basic authentication
		if ( ! empty( $this->config->getUsername() ) || ! ( empty( $this->config->getPassword() ) ) ) {
			$headers[ 'Authorization' ] = 'Basic ' . base64_encode( $this->config->getUsername() . ":" . $this->config->getPassword() );
		}

		$defaultHeaders = [];
		if ( $this->config->getUserAgent() ) {
			$defaultHeaders[ 'User-Agent' ] = $this->config->getUserAgent();
		}

		$headers = array_merge(
			$defaultHeaders,
			$headerParams,
			$headers
		);

		$operationHost = $this->config->getHost();
		$query         = ObjectSerializer::buildQuery( $queryParams );

		return new Request(
			'DELETE', $operationHost . $resourcePath . ( $query ? "?{$query}" : '' ), $headers, $httpBody
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersCustomPropsDisableAsync
	 *
	 * Disable CustomProp(s)
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\CustomPropDisableRequest $custom_prop_disable_request CustomProp disable params (optional)
	 * @param string                                                        $contentType                 The value for the Content-Type header. Check
	 *                                                                                                   self::contentTypes['plausibleWebPluginsAPIControllersCustomPropsDisable']
	 *                                                                                                   to see the possible values for this
	 *                                                                                                   operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersCustomPropsDisableAsync(
		$custom_prop_disable_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersCustomPropsDisable' ][ 0 ]
	) {
		return $this->plausibleWebPluginsAPIControllersCustomPropsDisableAsyncWithHttpInfo( $custom_prop_disable_request, $contentType )->then(
			function ( $response ) {
				return $response[ 0 ];
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersCustomPropsDisableAsyncWithHttpInfo
	 *
	 * Disable CustomProp(s)
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\CustomPropDisableRequest $custom_prop_disable_request CustomProp disable params (optional)
	 * @param string                                                        $contentType                 The value for the Content-Type header. Check
	 *                                                                                                   self::contentTypes['plausibleWebPluginsAPIControllersCustomPropsDisable']
	 *                                                                                                   to see the possible values for this
	 *                                                                                                   operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersCustomPropsDisableAsyncWithHttpInfo(
		$custom_prop_disable_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersCustomPropsDisable' ][ 0 ]
	) {
		$returnType = '';
		$request    = $this->plausibleWebPluginsAPIControllersCustomPropsDisableRequest( $custom_prop_disable_request, $contentType );

		return $this->client->sendAsync( $request, $this->createHttpClientOption() )->then(
			function ( $response ) use ( $returnType ) {
				return [ null, $response->getStatusCode(), $response->getHeaders() ];
			},
			function ( $exception ) {
				$response   = $exception->getResponse();
				$statusCode = $response->getStatusCode();
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						$exception->getRequest()->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersCustomPropsEnable
	 *
	 * Get or enable CustomProp(s)
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\CustomPropEnableRequest $custom_prop_enable_request CustomProp enable params (optional)
	 * @param string                                                       $contentType                The value for the Content-Type header. Check
	 *                                                                                                 self::contentTypes['plausibleWebPluginsAPIControllersCustomPropsEnable']
	 *                                                                                                 to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Model\CustomPropListResponse|\Plausible\Analytics\WP\Client\Model\UnauthorizedError|\Plausible\Analytics\WP\Client\Model\PaymentRequiredError|\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersCustomPropsEnable(
		$custom_prop_enable_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersCustomPropsEnable' ][ 0 ]
	) {
		[ $response ] = $this->plausibleWebPluginsAPIControllersCustomPropsEnableWithHttpInfo( $custom_prop_enable_request, $contentType );

		return $response;
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersCustomPropsEnableWithHttpInfo
	 *
	 * Get or enable CustomProp(s)
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\CustomPropEnableRequest $custom_prop_enable_request CustomProp enable params (optional)
	 * @param string                                                       $contentType                The value for the Content-Type header. Check
	 *                                                                                                 self::contentTypes['plausibleWebPluginsAPIControllersCustomPropsEnable']
	 *                                                                                                 to see the possible values for this operation
	 *
	 * @return array of
	 *               \Plausible\Analytics\WP\Client\Model\CustomPropListResponse|\Plausible\Analytics\WP\Client\Model\UnauthorizedError|\Plausible\Analytics\WP\Client\Model\PaymentRequiredError|\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError,
	 *               HTTP status code, HTTP response headers (array of strings)
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersCustomPropsEnableWithHttpInfo(
		$custom_prop_enable_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersCustomPropsEnable' ][ 0 ]
	) {
		$request = $this->plausibleWebPluginsAPIControllersCustomPropsEnableRequest( $custom_prop_enable_request, $contentType );

		try {
			$options = $this->createHttpClientOption();
			try {
				$response = $this->client->send( $request, $options );
			} catch ( RequestException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}",
					(int) $e->getCode(),
					$e->getResponse() ? $e->getResponse()->getHeaders() : null,
					$e->getResponse() ? (string) $e->getResponse()->getBody() : null
				);
			} catch ( ConnectException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}", (int) $e->getCode(), null, null
				);
			}

			$statusCode = $response->getStatusCode();

			if ( $statusCode < 200 || $statusCode > 299 ) {
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						(string) $request->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}

			switch ( $statusCode ) {
				case 201:
					if ( '\Plausible\Analytics\WP\Client\Model\CustomPropListResponse' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\CustomPropListResponse' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\CustomPropListResponse', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 401:
					if ( '\Plausible\Analytics\WP\Client\Model\UnauthorizedError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\UnauthorizedError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\UnauthorizedError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 402:
					if ( '\Plausible\Analytics\WP\Client\Model\PaymentRequiredError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\PaymentRequiredError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\PaymentRequiredError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 422:
					if ( '\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
			}

			$returnType = '\Plausible\Analytics\WP\Client\Model\CustomPropListResponse';
			if ( $returnType === '\SplFileObject' ) {
				$content = $response->getBody(); //stream goes to serializer
			} else {
				$content = (string) $response->getBody();
				if ( $returnType !== 'string' ) {
					$content = json_decode( $content );
				}
			}

			return [
				ObjectSerializer::deserialize( $content, $returnType, [] ),
				$response->getStatusCode(),
				$response->getHeaders(),
			];

		} catch ( ApiException $e ) {
			switch ( $e->getCode() ) {
				case 201:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\CustomPropListResponse',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 401:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\UnauthorizedError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 402:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\PaymentRequiredError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 422:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
			}
			throw $e;
		}
	}

	/**
	 * Create request for operation 'plausibleWebPluginsAPIControllersCustomPropsEnable'
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\CustomPropEnableRequest $custom_prop_enable_request CustomProp enable params (optional)
	 * @param string                                                       $contentType                The value for the Content-Type header. Check
	 *                                                                                                 self::contentTypes['plausibleWebPluginsAPIControllersCustomPropsEnable']
	 *                                                                                                 to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Psr7\Request
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersCustomPropsEnableRequest(
		$custom_prop_enable_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersCustomPropsEnable' ][ 0 ]
	) {

		$resourcePath = '/api/plugins/v1/custom_props';
		$formParams   = [];
		$queryParams  = [];
		$headerParams = [];
		$httpBody     = '';
		$multipart    = false;

		$headers = $this->headerSelector->selectHeaders(
			[ 'application/json', ],
			$contentType,
			$multipart
		);

		// for model (json/xml)
		if ( isset( $custom_prop_enable_request ) ) {
			if ( stripos( $headers[ 'Content-Type' ], 'application/json' ) !== false ) {
				# if Content-Type contains "application/json", json_encode the body
				$httpBody = \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Utils::jsonEncode(
					ObjectSerializer::sanitizeForSerialization( $custom_prop_enable_request )
				);
			} else {
				$httpBody = $custom_prop_enable_request;
			}
		} elseif ( count( $formParams ) > 0 ) {
			if ( $multipart ) {
				$multipartContents = [];
				foreach ( $formParams as $formParamName => $formParamValue ) {
					$formParamValueItems = is_array( $formParamValue ) ? $formParamValue : [ $formParamValue ];
					foreach ( $formParamValueItems as $formParamValueItem ) {
						$multipartContents[] = [
							'name'     => $formParamName,
							'contents' => $formParamValueItem,
						];
					}
				}
				// for HTTP post (form)
				$httpBody = new MultipartStream( $multipartContents );

			} elseif ( stripos( $headers[ 'Content-Type' ], 'application/json' ) !== false ) {
				# if Content-Type contains "application/json", json_encode the form parameters
				$httpBody = \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Utils::jsonEncode( $formParams );
			} else {
				// for HTTP post (form)
				$httpBody = ObjectSerializer::buildQuery( $formParams );
			}
		}

		// this endpoint requires HTTP basic authentication
		if ( ! empty( $this->config->getUsername() ) || ! ( empty( $this->config->getPassword() ) ) ) {
			$headers[ 'Authorization' ] = 'Basic ' . base64_encode( $this->config->getUsername() . ":" . $this->config->getPassword() );
		}

		$defaultHeaders = [];
		if ( $this->config->getUserAgent() ) {
			$defaultHeaders[ 'User-Agent' ] = $this->config->getUserAgent();
		}

		$headers = array_merge(
			$defaultHeaders,
			$headerParams,
			$headers
		);

		$operationHost = $this->config->getHost();
		$query         = ObjectSerializer::buildQuery( $queryParams );

		return new Request(
			'PUT', $operationHost . $resourcePath . ( $query ? "?{$query}" : '' ), $headers, $httpBody
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersCustomPropsEnableAsync
	 *
	 * Get or enable CustomProp(s)
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\CustomPropEnableRequest $custom_prop_enable_request CustomProp enable params (optional)
	 * @param string                                                       $contentType                The value for the Content-Type header. Check
	 *                                                                                                 self::contentTypes['plausibleWebPluginsAPIControllersCustomPropsEnable']
	 *                                                                                                 to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersCustomPropsEnableAsync(
		$custom_prop_enable_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersCustomPropsEnable' ][ 0 ]
	) {
		return $this->plausibleWebPluginsAPIControllersCustomPropsEnableAsyncWithHttpInfo( $custom_prop_enable_request, $contentType )->then(
			function ( $response ) {
				return $response[ 0 ];
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersCustomPropsEnableAsyncWithHttpInfo
	 *
	 * Get or enable CustomProp(s)
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\CustomPropEnableRequest $custom_prop_enable_request CustomProp enable params (optional)
	 * @param string                                                       $contentType                The value for the Content-Type header. Check
	 *                                                                                                 self::contentTypes['plausibleWebPluginsAPIControllersCustomPropsEnable']
	 *                                                                                                 to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersCustomPropsEnableAsyncWithHttpInfo(
		$custom_prop_enable_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersCustomPropsEnable' ][ 0 ]
	) {
		$returnType = '\Plausible\Analytics\WP\Client\Model\CustomPropListResponse';
		$request    = $this->plausibleWebPluginsAPIControllersCustomPropsEnableRequest( $custom_prop_enable_request, $contentType );

		return $this->client->sendAsync( $request, $this->createHttpClientOption() )->then(
			function ( $response ) use ( $returnType ) {
				if ( $returnType === '\SplFileObject' ) {
					$content = $response->getBody(); //stream goes to serializer
				} else {
					$content = (string) $response->getBody();
					if ( $returnType !== 'string' ) {
						$content = json_decode( $content );
					}
				}

				return [
					ObjectSerializer::deserialize( $content, $returnType, [] ),
					$response->getStatusCode(),
					$response->getHeaders(),
				];
			},
			function ( $exception ) {
				$response   = $exception->getResponse();
				$statusCode = $response->getStatusCode();
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						$exception->getRequest()->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersFunnelsCreate
	 *
	 * Get or create Funnel
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\FunnelCreateRequest $funnel_create_request Funnel params (optional)
	 * @param string                                                   $contentType           The value for the Content-Type header. Check
	 *                                                                                        self::contentTypes['plausibleWebPluginsAPIControllersFunnelsCreate']
	 *                                                                                        to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Model\Funnel|\Plausible\Analytics\WP\Client\Model\UnauthorizedError|\Plausible\Analytics\WP\Client\Model\PaymentRequiredError|\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersFunnelsCreate(
		$funnel_create_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersFunnelsCreate' ][ 0 ]
	) {
		[ $response ] = $this->plausibleWebPluginsAPIControllersFunnelsCreateWithHttpInfo( $funnel_create_request, $contentType );

		return $response;
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersFunnelsCreateWithHttpInfo
	 *
	 * Get or create Funnel
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\FunnelCreateRequest $funnel_create_request Funnel params (optional)
	 * @param string                                                   $contentType           The value for the Content-Type header. Check
	 *                                                                                        self::contentTypes['plausibleWebPluginsAPIControllersFunnelsCreate']
	 *                                                                                        to see the possible values for this operation
	 *
	 * @return array of
	 *               \Plausible\Analytics\WP\Client\Model\Funnel|\Plausible\Analytics\WP\Client\Model\UnauthorizedError|\Plausible\Analytics\WP\Client\Model\PaymentRequiredError|\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError,
	 *               HTTP status code, HTTP response headers (array of strings)
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersFunnelsCreateWithHttpInfo(
		$funnel_create_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersFunnelsCreate' ][ 0 ]
	) {
		$request = $this->plausibleWebPluginsAPIControllersFunnelsCreateRequest( $funnel_create_request, $contentType );

		try {
			$options = $this->createHttpClientOption();
			try {
				$response = $this->client->send( $request, $options );
			} catch ( RequestException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}",
					(int) $e->getCode(),
					$e->getResponse() ? $e->getResponse()->getHeaders() : null,
					$e->getResponse() ? (string) $e->getResponse()->getBody() : null
				);
			} catch ( ConnectException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}", (int) $e->getCode(), null, null
				);
			}

			$statusCode = $response->getStatusCode();

			if ( $statusCode < 200 || $statusCode > 299 ) {
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						(string) $request->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}

			switch ( $statusCode ) {
				case 201:
					if ( '\Plausible\Analytics\WP\Client\Model\Funnel' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\Funnel' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\Funnel', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 401:
					if ( '\Plausible\Analytics\WP\Client\Model\UnauthorizedError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\UnauthorizedError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\UnauthorizedError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 402:
					if ( '\Plausible\Analytics\WP\Client\Model\PaymentRequiredError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\PaymentRequiredError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\PaymentRequiredError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 422:
					if ( '\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
			}

			$returnType = '\Plausible\Analytics\WP\Client\Model\Funnel';
			if ( $returnType === '\SplFileObject' ) {
				$content = $response->getBody(); //stream goes to serializer
			} else {
				$content = (string) $response->getBody();
				if ( $returnType !== 'string' ) {
					$content = json_decode( $content );
				}
			}

			return [
				ObjectSerializer::deserialize( $content, $returnType, [] ),
				$response->getStatusCode(),
				$response->getHeaders(),
			];

		} catch ( ApiException $e ) {
			switch ( $e->getCode() ) {
				case 201:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\Funnel',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 401:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\UnauthorizedError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 402:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\PaymentRequiredError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 422:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
			}
			throw $e;
		}
	}

	/**
	 * Create request for operation 'plausibleWebPluginsAPIControllersFunnelsCreate'
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\FunnelCreateRequest $funnel_create_request Funnel params (optional)
	 * @param string                                                   $contentType           The value for the Content-Type header. Check
	 *                                                                                        self::contentTypes['plausibleWebPluginsAPIControllersFunnelsCreate']
	 *                                                                                        to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Psr7\Request
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersFunnelsCreateRequest(
		$funnel_create_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersFunnelsCreate' ][ 0 ]
	) {

		$resourcePath = '/api/plugins/v1/funnels';
		$formParams   = [];
		$queryParams  = [];
		$headerParams = [];
		$httpBody     = '';
		$multipart    = false;

		$headers = $this->headerSelector->selectHeaders(
			[ 'application/json', ],
			$contentType,
			$multipart
		);

		// for model (json/xml)
		if ( isset( $funnel_create_request ) ) {
			if ( stripos( $headers[ 'Content-Type' ], 'application/json' ) !== false ) {
				# if Content-Type contains "application/json", json_encode the body
				$httpBody = \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Utils::jsonEncode(
					ObjectSerializer::sanitizeForSerialization( $funnel_create_request )
				);
			} else {
				$httpBody = $funnel_create_request;
			}
		} elseif ( count( $formParams ) > 0 ) {
			if ( $multipart ) {
				$multipartContents = [];
				foreach ( $formParams as $formParamName => $formParamValue ) {
					$formParamValueItems = is_array( $formParamValue ) ? $formParamValue : [ $formParamValue ];
					foreach ( $formParamValueItems as $formParamValueItem ) {
						$multipartContents[] = [
							'name'     => $formParamName,
							'contents' => $formParamValueItem,
						];
					}
				}
				// for HTTP post (form)
				$httpBody = new MultipartStream( $multipartContents );

			} elseif ( stripos( $headers[ 'Content-Type' ], 'application/json' ) !== false ) {
				# if Content-Type contains "application/json", json_encode the form parameters
				$httpBody = \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Utils::jsonEncode( $formParams );
			} else {
				// for HTTP post (form)
				$httpBody = ObjectSerializer::buildQuery( $formParams );
			}
		}

		// this endpoint requires HTTP basic authentication
		if ( ! empty( $this->config->getUsername() ) || ! ( empty( $this->config->getPassword() ) ) ) {
			$headers[ 'Authorization' ] = 'Basic ' . base64_encode( $this->config->getUsername() . ":" . $this->config->getPassword() );
		}

		$defaultHeaders = [];
		if ( $this->config->getUserAgent() ) {
			$defaultHeaders[ 'User-Agent' ] = $this->config->getUserAgent();
		}

		$headers = array_merge(
			$defaultHeaders,
			$headerParams,
			$headers
		);

		$operationHost = $this->config->getHost();
		$query         = ObjectSerializer::buildQuery( $queryParams );

		return new Request(
			'PUT', $operationHost . $resourcePath . ( $query ? "?{$query}" : '' ), $headers, $httpBody
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersFunnelsCreateAsync
	 *
	 * Get or create Funnel
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\FunnelCreateRequest $funnel_create_request Funnel params (optional)
	 * @param string                                                   $contentType           The value for the Content-Type header. Check
	 *                                                                                        self::contentTypes['plausibleWebPluginsAPIControllersFunnelsCreate']
	 *                                                                                        to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersFunnelsCreateAsync(
		$funnel_create_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersFunnelsCreate' ][ 0 ]
	) {
		return $this->plausibleWebPluginsAPIControllersFunnelsCreateAsyncWithHttpInfo( $funnel_create_request, $contentType )->then(
			function ( $response ) {
				return $response[ 0 ];
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersFunnelsCreateAsyncWithHttpInfo
	 *
	 * Get or create Funnel
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\FunnelCreateRequest $funnel_create_request Funnel params (optional)
	 * @param string                                                   $contentType           The value for the Content-Type header. Check
	 *                                                                                        self::contentTypes['plausibleWebPluginsAPIControllersFunnelsCreate']
	 *                                                                                        to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersFunnelsCreateAsyncWithHttpInfo(
		$funnel_create_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersFunnelsCreate' ][ 0 ]
	) {
		$returnType = '\Plausible\Analytics\WP\Client\Model\Funnel';
		$request    = $this->plausibleWebPluginsAPIControllersFunnelsCreateRequest( $funnel_create_request, $contentType );

		return $this->client->sendAsync( $request, $this->createHttpClientOption() )->then(
			function ( $response ) use ( $returnType ) {
				if ( $returnType === '\SplFileObject' ) {
					$content = $response->getBody(); //stream goes to serializer
				} else {
					$content = (string) $response->getBody();
					if ( $returnType !== 'string' ) {
						$content = json_decode( $content );
					}
				}

				return [
					ObjectSerializer::deserialize( $content, $returnType, [] ),
					$response->getStatusCode(),
					$response->getHeaders(),
				];
			},
			function ( $exception ) {
				$response   = $exception->getResponse();
				$statusCode = $response->getStatusCode();
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						$exception->getRequest()->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersFunnelsGet
	 *
	 * Retrieve Funnel by ID
	 *
	 * @param int    $id          Funnel ID (required)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersFunnelsGet'] to
	 *                            see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Model\Funnel|\Plausible\Analytics\WP\Client\Model\UnauthorizedError|\Plausible\Analytics\WP\Client\Model\NotFoundError|\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersFunnelsGet(
		$id,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersFunnelsGet' ][ 0 ]
	) {
		[ $response ] = $this->plausibleWebPluginsAPIControllersFunnelsGetWithHttpInfo( $id, $contentType );

		return $response;
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersFunnelsGetWithHttpInfo
	 *
	 * Retrieve Funnel by ID
	 *
	 * @param int    $id          Funnel ID (required)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersFunnelsGet'] to
	 *                            see the possible values for this operation
	 *
	 * @return array of
	 *               \Plausible\Analytics\WP\Client\Model\Funnel|\Plausible\Analytics\WP\Client\Model\UnauthorizedError|\Plausible\Analytics\WP\Client\Model\NotFoundError|\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError,
	 *               HTTP status code, HTTP response headers (array of strings)
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersFunnelsGetWithHttpInfo(
		$id,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersFunnelsGet' ][ 0 ]
	) {
		$request = $this->plausibleWebPluginsAPIControllersFunnelsGetRequest( $id, $contentType );

		try {
			$options = $this->createHttpClientOption();
			try {
				$response = $this->client->send( $request, $options );
			} catch ( RequestException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}",
					(int) $e->getCode(),
					$e->getResponse() ? $e->getResponse()->getHeaders() : null,
					$e->getResponse() ? (string) $e->getResponse()->getBody() : null
				);
			} catch ( ConnectException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}", (int) $e->getCode(), null, null
				);
			}

			$statusCode = $response->getStatusCode();

			if ( $statusCode < 200 || $statusCode > 299 ) {
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						(string) $request->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}

			switch ( $statusCode ) {
				case 200:
					if ( '\Plausible\Analytics\WP\Client\Model\Funnel' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\Funnel' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\Funnel', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 401:
					if ( '\Plausible\Analytics\WP\Client\Model\UnauthorizedError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\UnauthorizedError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\UnauthorizedError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 404:
					if ( '\Plausible\Analytics\WP\Client\Model\NotFoundError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\NotFoundError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\NotFoundError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 422:
					if ( '\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
			}

			$returnType = '\Plausible\Analytics\WP\Client\Model\Funnel';
			if ( $returnType === '\SplFileObject' ) {
				$content = $response->getBody(); //stream goes to serializer
			} else {
				$content = (string) $response->getBody();
				if ( $returnType !== 'string' ) {
					$content = json_decode( $content );
				}
			}

			return [
				ObjectSerializer::deserialize( $content, $returnType, [] ),
				$response->getStatusCode(),
				$response->getHeaders(),
			];

		} catch ( ApiException $e ) {
			switch ( $e->getCode() ) {
				case 200:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\Funnel',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 401:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\UnauthorizedError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 404:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\NotFoundError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 422:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
			}
			throw $e;
		}
	}

	/**
	 * Create request for operation 'plausibleWebPluginsAPIControllersFunnelsGet'
	 *
	 * @param int    $id          Funnel ID (required)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersFunnelsGet'] to
	 *                            see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Psr7\Request
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersFunnelsGetRequest(
		$id,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersFunnelsGet' ][ 0 ]
	) {

		// verify the required parameter 'id' is set
		if ( $id === null || ( is_array( $id ) && count( $id ) === 0 ) ) {
			throw new \InvalidArgumentException(
				'Missing the required parameter $id when calling plausibleWebPluginsAPIControllersFunnelsGet'
			);
		}

		$resourcePath = '/api/plugins/v1/funnels/{id}';
		$formParams   = [];
		$queryParams  = [];
		$headerParams = [];
		$httpBody     = '';
		$multipart    = false;

		// path params
		if ( $id !== null ) {
			$resourcePath = str_replace(
				'{' . 'id' . '}',
				ObjectSerializer::toPathValue( $id ),
				$resourcePath
			);
		}

		$headers = $this->headerSelector->selectHeaders(
			[ 'application/json', ],
			$contentType,
			$multipart
		);

		// for model (json/xml)
		if ( count( $formParams ) > 0 ) {
			if ( $multipart ) {
				$multipartContents = [];
				foreach ( $formParams as $formParamName => $formParamValue ) {
					$formParamValueItems = is_array( $formParamValue ) ? $formParamValue : [ $formParamValue ];
					foreach ( $formParamValueItems as $formParamValueItem ) {
						$multipartContents[] = [
							'name'     => $formParamName,
							'contents' => $formParamValueItem,
						];
					}
				}
				// for HTTP post (form)
				$httpBody = new MultipartStream( $multipartContents );

			} elseif ( stripos( $headers[ 'Content-Type' ], 'application/json' ) !== false ) {
				# if Content-Type contains "application/json", json_encode the form parameters
				$httpBody = \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Utils::jsonEncode( $formParams );
			} else {
				// for HTTP post (form)
				$httpBody = ObjectSerializer::buildQuery( $formParams );
			}
		}

		// this endpoint requires HTTP basic authentication
		if ( ! empty( $this->config->getUsername() ) || ! ( empty( $this->config->getPassword() ) ) ) {
			$headers[ 'Authorization' ] = 'Basic ' . base64_encode( $this->config->getUsername() . ":" . $this->config->getPassword() );
		}

		$defaultHeaders = [];
		if ( $this->config->getUserAgent() ) {
			$defaultHeaders[ 'User-Agent' ] = $this->config->getUserAgent();
		}

		$headers = array_merge(
			$defaultHeaders,
			$headerParams,
			$headers
		);

		$operationHost = $this->config->getHost();
		$query         = ObjectSerializer::buildQuery( $queryParams );

		return new Request(
			'GET', $operationHost . $resourcePath . ( $query ? "?{$query}" : '' ), $headers, $httpBody
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersFunnelsGetAsync
	 *
	 * Retrieve Funnel by ID
	 *
	 * @param int    $id          Funnel ID (required)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersFunnelsGet'] to
	 *                            see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersFunnelsGetAsync(
		$id,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersFunnelsGet' ][ 0 ]
	) {
		return $this->plausibleWebPluginsAPIControllersFunnelsGetAsyncWithHttpInfo( $id, $contentType )->then(
			function ( $response ) {
				return $response[ 0 ];
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersFunnelsGetAsyncWithHttpInfo
	 *
	 * Retrieve Funnel by ID
	 *
	 * @param int    $id          Funnel ID (required)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersFunnelsGet'] to
	 *                            see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersFunnelsGetAsyncWithHttpInfo(
		$id,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersFunnelsGet' ][ 0 ]
	) {
		$returnType = '\Plausible\Analytics\WP\Client\Model\Funnel';
		$request    = $this->plausibleWebPluginsAPIControllersFunnelsGetRequest( $id, $contentType );

		return $this->client->sendAsync( $request, $this->createHttpClientOption() )->then(
			function ( $response ) use ( $returnType ) {
				if ( $returnType === '\SplFileObject' ) {
					$content = $response->getBody(); //stream goes to serializer
				} else {
					$content = (string) $response->getBody();
					if ( $returnType !== 'string' ) {
						$content = json_decode( $content );
					}
				}

				return [
					ObjectSerializer::deserialize( $content, $returnType, [] ),
					$response->getStatusCode(),
					$response->getHeaders(),
				];
			},
			function ( $exception ) {
				$response   = $exception->getResponse();
				$statusCode = $response->getStatusCode();
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						$exception->getRequest()->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersFunnelsIndex
	 *
	 * Retrieve Funnels
	 *
	 * @param int    $limit       Maximum entries per page (optional)
	 * @param string $after       Cursor value to seek after - generated internally (optional)
	 * @param string $before      Cursor value to seek before - generated internally (optional)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersFunnelsIndex'] to
	 *                            see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Model\FunnelListResponse|\Plausible\Analytics\WP\Client\Model\UnauthorizedError
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersFunnelsIndex(
		$limit = null,
		$after = null,
		$before = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersFunnelsIndex' ][ 0 ]
	) {
		[ $response ] = $this->plausibleWebPluginsAPIControllersFunnelsIndexWithHttpInfo( $limit, $after, $before, $contentType );

		return $response;
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersFunnelsIndexWithHttpInfo
	 *
	 * Retrieve Funnels
	 *
	 * @param int    $limit       Maximum entries per page (optional)
	 * @param string $after       Cursor value to seek after - generated internally (optional)
	 * @param string $before      Cursor value to seek before - generated internally (optional)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersFunnelsIndex'] to
	 *                            see the possible values for this operation
	 *
	 * @return array of \Plausible\Analytics\WP\Client\Model\FunnelListResponse|\Plausible\Analytics\WP\Client\Model\UnauthorizedError, HTTP status
	 *               code, HTTP response headers (array of strings)
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersFunnelsIndexWithHttpInfo(
		$limit = null,
		$after = null,
		$before = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersFunnelsIndex' ][ 0 ]
	) {
		$request = $this->plausibleWebPluginsAPIControllersFunnelsIndexRequest( $limit, $after, $before, $contentType );

		try {
			$options = $this->createHttpClientOption();
			try {
				$response = $this->client->send( $request, $options );
			} catch ( RequestException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}",
					(int) $e->getCode(),
					$e->getResponse() ? $e->getResponse()->getHeaders() : null,
					$e->getResponse() ? (string) $e->getResponse()->getBody() : null
				);
			} catch ( ConnectException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}", (int) $e->getCode(), null, null
				);
			}

			$statusCode = $response->getStatusCode();

			if ( $statusCode < 200 || $statusCode > 299 ) {
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						(string) $request->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}

			switch ( $statusCode ) {
				case 200:
					if ( '\Plausible\Analytics\WP\Client\Model\FunnelListResponse' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\FunnelListResponse' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\FunnelListResponse', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 401:
					if ( '\Plausible\Analytics\WP\Client\Model\UnauthorizedError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\UnauthorizedError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\UnauthorizedError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
			}

			$returnType = '\Plausible\Analytics\WP\Client\Model\FunnelListResponse';
			if ( $returnType === '\SplFileObject' ) {
				$content = $response->getBody(); //stream goes to serializer
			} else {
				$content = (string) $response->getBody();
				if ( $returnType !== 'string' ) {
					$content = json_decode( $content );
				}
			}

			return [
				ObjectSerializer::deserialize( $content, $returnType, [] ),
				$response->getStatusCode(),
				$response->getHeaders(),
			];

		} catch ( ApiException $e ) {
			switch ( $e->getCode() ) {
				case 200:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\FunnelListResponse',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 401:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\UnauthorizedError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
			}
			throw $e;
		}
	}

	/**
	 * Create request for operation 'plausibleWebPluginsAPIControllersFunnelsIndex'
	 *
	 * @param int    $limit       Maximum entries per page (optional)
	 * @param string $after       Cursor value to seek after - generated internally (optional)
	 * @param string $before      Cursor value to seek before - generated internally (optional)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersFunnelsIndex'] to
	 *                            see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Psr7\Request
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersFunnelsIndexRequest(
		$limit = null,
		$after = null,
		$before = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersFunnelsIndex' ][ 0 ]
	) {

		$resourcePath = '/api/plugins/v1/funnels';
		$formParams   = [];
		$queryParams  = [];
		$headerParams = [];
		$httpBody     = '';
		$multipart    = false;

		// query params
		$queryParams = array_merge(
			$queryParams,
			ObjectSerializer::toQueryValue(
				$limit,
				'limit', // param base name
				'integer', // openApiType
				'form', // style
				true, // explode
				false // required
			) ?? []
		);
		// query params
		$queryParams = array_merge(
			$queryParams,
			ObjectSerializer::toQueryValue(
				$after,
				'after', // param base name
				'string', // openApiType
				'form', // style
				true, // explode
				false // required
			) ?? []
		);
		// query params
		$queryParams = array_merge(
			$queryParams,
			ObjectSerializer::toQueryValue(
				$before,
				'before', // param base name
				'string', // openApiType
				'form', // style
				true, // explode
				false // required
			) ?? []
		);

		$headers = $this->headerSelector->selectHeaders(
			[ 'application/json', ],
			$contentType,
			$multipart
		);

		// for model (json/xml)
		if ( count( $formParams ) > 0 ) {
			if ( $multipart ) {
				$multipartContents = [];
				foreach ( $formParams as $formParamName => $formParamValue ) {
					$formParamValueItems = is_array( $formParamValue ) ? $formParamValue : [ $formParamValue ];
					foreach ( $formParamValueItems as $formParamValueItem ) {
						$multipartContents[] = [
							'name'     => $formParamName,
							'contents' => $formParamValueItem,
						];
					}
				}
				// for HTTP post (form)
				$httpBody = new MultipartStream( $multipartContents );

			} elseif ( stripos( $headers[ 'Content-Type' ], 'application/json' ) !== false ) {
				# if Content-Type contains "application/json", json_encode the form parameters
				$httpBody = \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Utils::jsonEncode( $formParams );
			} else {
				// for HTTP post (form)
				$httpBody = ObjectSerializer::buildQuery( $formParams );
			}
		}

		// this endpoint requires HTTP basic authentication
		if ( ! empty( $this->config->getUsername() ) || ! ( empty( $this->config->getPassword() ) ) ) {
			$headers[ 'Authorization' ] = 'Basic ' . base64_encode( $this->config->getUsername() . ":" . $this->config->getPassword() );
		}

		$defaultHeaders = [];
		if ( $this->config->getUserAgent() ) {
			$defaultHeaders[ 'User-Agent' ] = $this->config->getUserAgent();
		}

		$headers = array_merge(
			$defaultHeaders,
			$headerParams,
			$headers
		);

		$operationHost = $this->config->getHost();
		$query         = ObjectSerializer::buildQuery( $queryParams );

		return new Request(
			'GET', $operationHost . $resourcePath . ( $query ? "?{$query}" : '' ), $headers, $httpBody
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersFunnelsIndexAsync
	 *
	 * Retrieve Funnels
	 *
	 * @param int    $limit       Maximum entries per page (optional)
	 * @param string $after       Cursor value to seek after - generated internally (optional)
	 * @param string $before      Cursor value to seek before - generated internally (optional)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersFunnelsIndex'] to
	 *                            see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersFunnelsIndexAsync(
		$limit = null,
		$after = null,
		$before = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersFunnelsIndex' ][ 0 ]
	) {
		return $this->plausibleWebPluginsAPIControllersFunnelsIndexAsyncWithHttpInfo( $limit, $after, $before, $contentType )->then(
			function ( $response ) {
				return $response[ 0 ];
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersFunnelsIndexAsyncWithHttpInfo
	 *
	 * Retrieve Funnels
	 *
	 * @param int    $limit       Maximum entries per page (optional)
	 * @param string $after       Cursor value to seek after - generated internally (optional)
	 * @param string $before      Cursor value to seek before - generated internally (optional)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersFunnelsIndex'] to
	 *                            see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersFunnelsIndexAsyncWithHttpInfo(
		$limit = null,
		$after = null,
		$before = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersFunnelsIndex' ][ 0 ]
	) {
		$returnType = '\Plausible\Analytics\WP\Client\Model\FunnelListResponse';
		$request    = $this->plausibleWebPluginsAPIControllersFunnelsIndexRequest( $limit, $after, $before, $contentType );

		return $this->client->sendAsync( $request, $this->createHttpClientOption() )->then(
			function ( $response ) use ( $returnType ) {
				if ( $returnType === '\SplFileObject' ) {
					$content = $response->getBody(); //stream goes to serializer
				} else {
					$content = (string) $response->getBody();
					if ( $returnType !== 'string' ) {
						$content = json_decode( $content );
					}
				}

				return [
					ObjectSerializer::deserialize( $content, $returnType, [] ),
					$response->getStatusCode(),
					$response->getHeaders(),
				];
			},
			function ( $exception ) {
				$response   = $exception->getResponse();
				$statusCode = $response->getStatusCode();
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						$exception->getRequest()->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersGoalsCreate
	 *
	 * Get or create Goal
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\GoalCreateRequest $goal_create_request Goal params (optional)
	 * @param string                                                 $contentType         The value for the Content-Type header. Check
	 *                                                                                    self::contentTypes['plausibleWebPluginsAPIControllersGoalsCreate']
	 *                                                                                    to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Model\GoalListResponse|\Plausible\Analytics\WP\Client\Model\UnauthorizedError|\Plausible\Analytics\WP\Client\Model\PaymentRequiredError|\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersGoalsCreate(
		$goal_create_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsCreate' ][ 0 ]
	) {
		[ $response ] = $this->plausibleWebPluginsAPIControllersGoalsCreateWithHttpInfo( $goal_create_request, $contentType );

		return $response;
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersGoalsCreateWithHttpInfo
	 *
	 * Get or create Goal
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\GoalCreateRequest $goal_create_request Goal params (optional)
	 * @param string                                                 $contentType         The value for the Content-Type header. Check
	 *                                                                                    self::contentTypes['plausibleWebPluginsAPIControllersGoalsCreate']
	 *                                                                                    to see the possible values for this operation
	 *
	 * @return array of
	 *               \Plausible\Analytics\WP\Client\Model\GoalListResponse|\Plausible\Analytics\WP\Client\Model\UnauthorizedError|\Plausible\Analytics\WP\Client\Model\PaymentRequiredError|\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError,
	 *               HTTP status code, HTTP response headers (array of strings)
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersGoalsCreateWithHttpInfo(
		$goal_create_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsCreate' ][ 0 ]
	) {
		$request = $this->plausibleWebPluginsAPIControllersGoalsCreateRequest( $goal_create_request, $contentType );

		try {
			$options = $this->createHttpClientOption();
			try {
				$response = $this->client->send( $request, $options );
			} catch ( RequestException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}",
					(int) $e->getCode(),
					$e->getResponse() ? $e->getResponse()->getHeaders() : null,
					$e->getResponse() ? (string) $e->getResponse()->getBody() : null
				);
			} catch ( ConnectException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}", (int) $e->getCode(), null, null
				);
			}

			$statusCode = $response->getStatusCode();

			if ( $statusCode < 200 || $statusCode > 299 ) {
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						(string) $request->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}

			switch ( $statusCode ) {
				case 201:
					if ( '\Plausible\Analytics\WP\Client\Model\GoalListResponse' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\GoalListResponse' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\GoalListResponse', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 401:
					if ( '\Plausible\Analytics\WP\Client\Model\UnauthorizedError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\UnauthorizedError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\UnauthorizedError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 402:
					if ( '\Plausible\Analytics\WP\Client\Model\PaymentRequiredError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\PaymentRequiredError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\PaymentRequiredError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 422:
					if ( '\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
			}

			$returnType = '\Plausible\Analytics\WP\Client\Model\GoalListResponse';
			if ( $returnType === '\SplFileObject' ) {
				$content = $response->getBody(); //stream goes to serializer
			} else {
				$content = (string) $response->getBody();
				if ( $returnType !== 'string' ) {
					$content = json_decode( $content );
				}
			}

			return [
				ObjectSerializer::deserialize( $content, $returnType, [] ),
				$response->getStatusCode(),
				$response->getHeaders(),
			];

		} catch ( ApiException $e ) {
			switch ( $e->getCode() ) {
				case 201:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\GoalListResponse',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 401:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\UnauthorizedError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 402:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\PaymentRequiredError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 422:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
			}
			throw $e;
		}
	}

	/**
	 * Create request for operation 'plausibleWebPluginsAPIControllersGoalsCreate'
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\GoalCreateRequest $goal_create_request Goal params (optional)
	 * @param string                                                 $contentType         The value for the Content-Type header. Check
	 *                                                                                    self::contentTypes['plausibleWebPluginsAPIControllersGoalsCreate']
	 *                                                                                    to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Psr7\Request
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersGoalsCreateRequest(
		$goal_create_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsCreate' ][ 0 ]
	) {

		$resourcePath = '/api/plugins/v1/goals';
		$formParams   = [];
		$queryParams  = [];
		$headerParams = [];
		$httpBody     = '';
		$multipart    = false;

		$headers = $this->headerSelector->selectHeaders(
			[ 'application/json', ],
			$contentType,
			$multipart
		);

		// for model (json/xml)
		if ( isset( $goal_create_request ) ) {
			if ( stripos( $headers[ 'Content-Type' ], 'application/json' ) !== false ) {
				# if Content-Type contains "application/json", json_encode the body
				$httpBody = \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Utils::jsonEncode(
					ObjectSerializer::sanitizeForSerialization( $goal_create_request )
				);
			} else {
				$httpBody = $goal_create_request;
			}
		} elseif ( count( $formParams ) > 0 ) {
			if ( $multipart ) {
				$multipartContents = [];
				foreach ( $formParams as $formParamName => $formParamValue ) {
					$formParamValueItems = is_array( $formParamValue ) ? $formParamValue : [ $formParamValue ];
					foreach ( $formParamValueItems as $formParamValueItem ) {
						$multipartContents[] = [
							'name'     => $formParamName,
							'contents' => $formParamValueItem,
						];
					}
				}
				// for HTTP post (form)
				$httpBody = new MultipartStream( $multipartContents );

			} elseif ( stripos( $headers[ 'Content-Type' ], 'application/json' ) !== false ) {
				# if Content-Type contains "application/json", json_encode the form parameters
				$httpBody = \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Utils::jsonEncode( $formParams );
			} else {
				// for HTTP post (form)
				$httpBody = ObjectSerializer::buildQuery( $formParams );
			}
		}

		// this endpoint requires HTTP basic authentication
		if ( ! empty( $this->config->getUsername() ) || ! ( empty( $this->config->getPassword() ) ) ) {
			$headers[ 'Authorization' ] = 'Basic ' . base64_encode( $this->config->getUsername() . ":" . $this->config->getPassword() );
		}

		$defaultHeaders = [];
		if ( $this->config->getUserAgent() ) {
			$defaultHeaders[ 'User-Agent' ] = $this->config->getUserAgent();
		}

		$headers = array_merge(
			$defaultHeaders,
			$headerParams,
			$headers
		);

		$operationHost = $this->config->getHost();
		$query         = ObjectSerializer::buildQuery( $queryParams );

		return new Request(
			'PUT', $operationHost . $resourcePath . ( $query ? "?{$query}" : '' ), $headers, $httpBody
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersGoalsCreateAsync
	 *
	 * Get or create Goal
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\GoalCreateRequest $goal_create_request Goal params (optional)
	 * @param string                                                 $contentType         The value for the Content-Type header. Check
	 *                                                                                    self::contentTypes['plausibleWebPluginsAPIControllersGoalsCreate']
	 *                                                                                    to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersGoalsCreateAsync(
		$goal_create_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsCreate' ][ 0 ]
	) {
		return $this->plausibleWebPluginsAPIControllersGoalsCreateAsyncWithHttpInfo( $goal_create_request, $contentType )->then(
			function ( $response ) {
				return $response[ 0 ];
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersGoalsCreateAsyncWithHttpInfo
	 *
	 * Get or create Goal
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\GoalCreateRequest $goal_create_request Goal params (optional)
	 * @param string                                                 $contentType         The value for the Content-Type header. Check
	 *                                                                                    self::contentTypes['plausibleWebPluginsAPIControllersGoalsCreate']
	 *                                                                                    to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersGoalsCreateAsyncWithHttpInfo(
		$goal_create_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsCreate' ][ 0 ]
	) {
		$returnType = '\Plausible\Analytics\WP\Client\Model\GoalListResponse';
		$request    = $this->plausibleWebPluginsAPIControllersGoalsCreateRequest( $goal_create_request, $contentType );

		return $this->client->sendAsync( $request, $this->createHttpClientOption() )->then(
			function ( $response ) use ( $returnType ) {
				if ( $returnType === '\SplFileObject' ) {
					$content = $response->getBody(); //stream goes to serializer
				} else {
					$content = (string) $response->getBody();
					if ( $returnType !== 'string' ) {
						$content = json_decode( $content );
					}
				}

				return [
					ObjectSerializer::deserialize( $content, $returnType, [] ),
					$response->getStatusCode(),
					$response->getHeaders(),
				];
			},
			function ( $exception ) {
				$response   = $exception->getResponse();
				$statusCode = $response->getStatusCode();
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						$exception->getRequest()->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersGoalsDelete
	 *
	 * Delete Goal by ID
	 *
	 * @param int    $id          Goal ID (required)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersGoalsDelete'] to
	 *                            see the possible values for this operation
	 *
	 * @return void
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersGoalsDelete(
		$id,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsDelete' ][ 0 ]
	) {
		$this->plausibleWebPluginsAPIControllersGoalsDeleteWithHttpInfo( $id, $contentType );
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersGoalsDeleteWithHttpInfo
	 *
	 * Delete Goal by ID
	 *
	 * @param int    $id          Goal ID (required)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersGoalsDelete'] to
	 *                            see the possible values for this operation
	 *
	 * @return array of null, HTTP status code, HTTP response headers (array of strings)
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersGoalsDeleteWithHttpInfo(
		$id,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsDelete' ][ 0 ]
	) {
		$request = $this->plausibleWebPluginsAPIControllersGoalsDeleteRequest( $id, $contentType );

		try {
			$options = $this->createHttpClientOption();
			try {
				$response = $this->client->send( $request, $options );
			} catch ( RequestException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}",
					(int) $e->getCode(),
					$e->getResponse() ? $e->getResponse()->getHeaders() : null,
					$e->getResponse() ? (string) $e->getResponse()->getBody() : null
				);
			} catch ( ConnectException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}", (int) $e->getCode(), null, null
				);
			}

			$statusCode = $response->getStatusCode();

			if ( $statusCode < 200 || $statusCode > 299 ) {
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						(string) $request->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}

			return [ null, $statusCode, $response->getHeaders() ];

		} catch ( ApiException $e ) {
			switch ( $e->getCode() ) {
				case 401:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\UnauthorizedError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
			}
			throw $e;
		}
	}

	/**
	 * Create request for operation 'plausibleWebPluginsAPIControllersGoalsDelete'
	 *
	 * @param int    $id          Goal ID (required)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersGoalsDelete'] to
	 *                            see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Psr7\Request
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersGoalsDeleteRequest(
		$id,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsDelete' ][ 0 ]
	) {

		// verify the required parameter 'id' is set
		if ( $id === null || ( is_array( $id ) && count( $id ) === 0 ) ) {
			throw new \InvalidArgumentException(
				'Missing the required parameter $id when calling plausibleWebPluginsAPIControllersGoalsDelete'
			);
		}

		$resourcePath = '/api/plugins/v1/goals/{id}';
		$formParams   = [];
		$queryParams  = [];
		$headerParams = [];
		$httpBody     = '';
		$multipart    = false;

		// path params
		if ( $id !== null ) {
			$resourcePath = str_replace(
				'{' . 'id' . '}',
				ObjectSerializer::toPathValue( $id ),
				$resourcePath
			);
		}

		$headers = $this->headerSelector->selectHeaders(
			[ 'application/json', ],
			$contentType,
			$multipart
		);

		// for model (json/xml)
		if ( count( $formParams ) > 0 ) {
			if ( $multipart ) {
				$multipartContents = [];
				foreach ( $formParams as $formParamName => $formParamValue ) {
					$formParamValueItems = is_array( $formParamValue ) ? $formParamValue : [ $formParamValue ];
					foreach ( $formParamValueItems as $formParamValueItem ) {
						$multipartContents[] = [
							'name'     => $formParamName,
							'contents' => $formParamValueItem,
						];
					}
				}
				// for HTTP post (form)
				$httpBody = new MultipartStream( $multipartContents );

			} elseif ( stripos( $headers[ 'Content-Type' ], 'application/json' ) !== false ) {
				# if Content-Type contains "application/json", json_encode the form parameters
				$httpBody = \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Utils::jsonEncode( $formParams );
			} else {
				// for HTTP post (form)
				$httpBody = ObjectSerializer::buildQuery( $formParams );
			}
		}

		// this endpoint requires HTTP basic authentication
		if ( ! empty( $this->config->getUsername() ) || ! ( empty( $this->config->getPassword() ) ) ) {
			$headers[ 'Authorization' ] = 'Basic ' . base64_encode( $this->config->getUsername() . ":" . $this->config->getPassword() );
		}

		$defaultHeaders = [];
		if ( $this->config->getUserAgent() ) {
			$defaultHeaders[ 'User-Agent' ] = $this->config->getUserAgent();
		}

		$headers = array_merge(
			$defaultHeaders,
			$headerParams,
			$headers
		);

		$operationHost = $this->config->getHost();
		$query         = ObjectSerializer::buildQuery( $queryParams );

		return new Request(
			'DELETE', $operationHost . $resourcePath . ( $query ? "?{$query}" : '' ), $headers, $httpBody
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersGoalsDeleteAsync
	 *
	 * Delete Goal by ID
	 *
	 * @param int    $id          Goal ID (required)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersGoalsDelete'] to
	 *                            see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersGoalsDeleteAsync(
		$id,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsDelete' ][ 0 ]
	) {
		return $this->plausibleWebPluginsAPIControllersGoalsDeleteAsyncWithHttpInfo( $id, $contentType )->then(
			function ( $response ) {
				return $response[ 0 ];
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersGoalsDeleteAsyncWithHttpInfo
	 *
	 * Delete Goal by ID
	 *
	 * @param int    $id          Goal ID (required)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersGoalsDelete'] to
	 *                            see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersGoalsDeleteAsyncWithHttpInfo(
		$id,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsDelete' ][ 0 ]
	) {
		$returnType = '';
		$request    = $this->plausibleWebPluginsAPIControllersGoalsDeleteRequest( $id, $contentType );

		return $this->client->sendAsync( $request, $this->createHttpClientOption() )->then(
			function ( $response ) use ( $returnType ) {
				return [ null, $response->getStatusCode(), $response->getHeaders() ];
			},
			function ( $exception ) {
				$response   = $exception->getResponse();
				$statusCode = $response->getStatusCode();
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						$exception->getRequest()->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersGoalsDeleteBulk
	 *
	 * Delete Goals in bulk
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\GoalDeleteBulkRequest $goal_delete_bulk_request Goal params (optional)
	 * @param string                                                     $contentType              The value for the Content-Type header. Check
	 *                                                                                             self::contentTypes['plausibleWebPluginsAPIControllersGoalsDeleteBulk']
	 *                                                                                             to see the possible values for this operation
	 *
	 * @return void
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersGoalsDeleteBulk(
		$goal_delete_bulk_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsDeleteBulk' ][ 0 ]
	) {
		$this->plausibleWebPluginsAPIControllersGoalsDeleteBulkWithHttpInfo( $goal_delete_bulk_request, $contentType );
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersGoalsDeleteBulkWithHttpInfo
	 *
	 * Delete Goals in bulk
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\GoalDeleteBulkRequest $goal_delete_bulk_request Goal params (optional)
	 * @param string                                                     $contentType              The value for the Content-Type header. Check
	 *                                                                                             self::contentTypes['plausibleWebPluginsAPIControllersGoalsDeleteBulk']
	 *                                                                                             to see the possible values for this operation
	 *
	 * @return array of null, HTTP status code, HTTP response headers (array of strings)
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersGoalsDeleteBulkWithHttpInfo(
		$goal_delete_bulk_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsDeleteBulk' ][ 0 ]
	) {
		$request = $this->plausibleWebPluginsAPIControllersGoalsDeleteBulkRequest( $goal_delete_bulk_request, $contentType );

		try {
			$options = $this->createHttpClientOption();
			try {
				$response = $this->client->send( $request, $options );
			} catch ( RequestException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}",
					(int) $e->getCode(),
					$e->getResponse() ? $e->getResponse()->getHeaders() : null,
					$e->getResponse() ? (string) $e->getResponse()->getBody() : null
				);
			} catch ( ConnectException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}", (int) $e->getCode(), null, null
				);
			}

			$statusCode = $response->getStatusCode();

			if ( $statusCode < 200 || $statusCode > 299 ) {
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						(string) $request->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}

			return [ null, $statusCode, $response->getHeaders() ];

		} catch ( ApiException $e ) {
			switch ( $e->getCode() ) {
				case 401:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\UnauthorizedError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
			}
			throw $e;
		}
	}

	/**
	 * Create request for operation 'plausibleWebPluginsAPIControllersGoalsDeleteBulk'
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\GoalDeleteBulkRequest $goal_delete_bulk_request Goal params (optional)
	 * @param string                                                     $contentType              The value for the Content-Type header. Check
	 *                                                                                             self::contentTypes['plausibleWebPluginsAPIControllersGoalsDeleteBulk']
	 *                                                                                             to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Psr7\Request
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersGoalsDeleteBulkRequest(
		$goal_delete_bulk_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsDeleteBulk' ][ 0 ]
	) {

		$resourcePath = '/api/plugins/v1/goals';
		$formParams   = [];
		$queryParams  = [];
		$headerParams = [];
		$httpBody     = '';
		$multipart    = false;

		$headers = $this->headerSelector->selectHeaders(
			[ 'application/json', ],
			$contentType,
			$multipart
		);

		// for model (json/xml)
		if ( isset( $goal_delete_bulk_request ) ) {
			if ( stripos( $headers[ 'Content-Type' ], 'application/json' ) !== false ) {
				# if Content-Type contains "application/json", json_encode the body
				$httpBody = \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Utils::jsonEncode(
					ObjectSerializer::sanitizeForSerialization( $goal_delete_bulk_request )
				);
			} else {
				$httpBody = $goal_delete_bulk_request;
			}
		} elseif ( count( $formParams ) > 0 ) {
			if ( $multipart ) {
				$multipartContents = [];
				foreach ( $formParams as $formParamName => $formParamValue ) {
					$formParamValueItems = is_array( $formParamValue ) ? $formParamValue : [ $formParamValue ];
					foreach ( $formParamValueItems as $formParamValueItem ) {
						$multipartContents[] = [
							'name'     => $formParamName,
							'contents' => $formParamValueItem,
						];
					}
				}
				// for HTTP post (form)
				$httpBody = new MultipartStream( $multipartContents );

			} elseif ( stripos( $headers[ 'Content-Type' ], 'application/json' ) !== false ) {
				# if Content-Type contains "application/json", json_encode the form parameters
				$httpBody = \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Utils::jsonEncode( $formParams );
			} else {
				// for HTTP post (form)
				$httpBody = ObjectSerializer::buildQuery( $formParams );
			}
		}

		// this endpoint requires HTTP basic authentication
		if ( ! empty( $this->config->getUsername() ) || ! ( empty( $this->config->getPassword() ) ) ) {
			$headers[ 'Authorization' ] = 'Basic ' . base64_encode( $this->config->getUsername() . ":" . $this->config->getPassword() );
		}

		$defaultHeaders = [];
		if ( $this->config->getUserAgent() ) {
			$defaultHeaders[ 'User-Agent' ] = $this->config->getUserAgent();
		}

		$headers = array_merge(
			$defaultHeaders,
			$headerParams,
			$headers
		);

		$operationHost = $this->config->getHost();
		$query         = ObjectSerializer::buildQuery( $queryParams );

		return new Request(
			'DELETE', $operationHost . $resourcePath . ( $query ? "?{$query}" : '' ), $headers, $httpBody
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersGoalsDeleteBulkAsync
	 *
	 * Delete Goals in bulk
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\GoalDeleteBulkRequest $goal_delete_bulk_request Goal params (optional)
	 * @param string                                                     $contentType              The value for the Content-Type header. Check
	 *                                                                                             self::contentTypes['plausibleWebPluginsAPIControllersGoalsDeleteBulk']
	 *                                                                                             to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersGoalsDeleteBulkAsync(
		$goal_delete_bulk_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsDeleteBulk' ][ 0 ]
	) {
		return $this->plausibleWebPluginsAPIControllersGoalsDeleteBulkAsyncWithHttpInfo( $goal_delete_bulk_request, $contentType )->then(
			function ( $response ) {
				return $response[ 0 ];
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersGoalsDeleteBulkAsyncWithHttpInfo
	 *
	 * Delete Goals in bulk
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\GoalDeleteBulkRequest $goal_delete_bulk_request Goal params (optional)
	 * @param string                                                     $contentType              The value for the Content-Type header. Check
	 *                                                                                             self::contentTypes['plausibleWebPluginsAPIControllersGoalsDeleteBulk']
	 *                                                                                             to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersGoalsDeleteBulkAsyncWithHttpInfo(
		$goal_delete_bulk_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsDeleteBulk' ][ 0 ]
	) {
		$returnType = '';
		$request    = $this->plausibleWebPluginsAPIControllersGoalsDeleteBulkRequest( $goal_delete_bulk_request, $contentType );

		return $this->client->sendAsync( $request, $this->createHttpClientOption() )->then(
			function ( $response ) use ( $returnType ) {
				return [ null, $response->getStatusCode(), $response->getHeaders() ];
			},
			function ( $exception ) {
				$response   = $exception->getResponse();
				$statusCode = $response->getStatusCode();
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						$exception->getRequest()->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersGoalsGet
	 *
	 * Retrieve Goal by ID
	 *
	 * @param int    $id          Goal ID (required)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersGoalsGet'] to see
	 *                            the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Model\Goal|\Plausible\Analytics\WP\Client\Model\UnauthorizedError|\Plausible\Analytics\WP\Client\Model\NotFoundError|\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersGoalsGet(
		$id,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsGet' ][ 0 ]
	) {
		[ $response ] = $this->plausibleWebPluginsAPIControllersGoalsGetWithHttpInfo( $id, $contentType );

		return $response;
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersGoalsGetWithHttpInfo
	 *
	 * Retrieve Goal by ID
	 *
	 * @param int    $id          Goal ID (required)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersGoalsGet'] to see
	 *                            the possible values for this operation
	 *
	 * @return array of
	 *               \Plausible\Analytics\WP\Client\Model\Goal|\Plausible\Analytics\WP\Client\Model\UnauthorizedError|\Plausible\Analytics\WP\Client\Model\NotFoundError|\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError,
	 *               HTTP status code, HTTP response headers (array of strings)
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersGoalsGetWithHttpInfo(
		$id,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsGet' ][ 0 ]
	) {
		$request = $this->plausibleWebPluginsAPIControllersGoalsGetRequest( $id, $contentType );

		try {
			$options = $this->createHttpClientOption();
			try {
				$response = $this->client->send( $request, $options );
			} catch ( RequestException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}",
					(int) $e->getCode(),
					$e->getResponse() ? $e->getResponse()->getHeaders() : null,
					$e->getResponse() ? (string) $e->getResponse()->getBody() : null
				);
			} catch ( ConnectException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}", (int) $e->getCode(), null, null
				);
			}

			$statusCode = $response->getStatusCode();

			if ( $statusCode < 200 || $statusCode > 299 ) {
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						(string) $request->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}

			switch ( $statusCode ) {
				case 200:
					if ( '\Plausible\Analytics\WP\Client\Model\Goal' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\Goal' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\Goal', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 401:
					if ( '\Plausible\Analytics\WP\Client\Model\UnauthorizedError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\UnauthorizedError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\UnauthorizedError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 404:
					if ( '\Plausible\Analytics\WP\Client\Model\NotFoundError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\NotFoundError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\NotFoundError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 422:
					if ( '\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
			}

			$returnType = '\Plausible\Analytics\WP\Client\Model\Goal';
			if ( $returnType === '\SplFileObject' ) {
				$content = $response->getBody(); //stream goes to serializer
			} else {
				$content = (string) $response->getBody();
				if ( $returnType !== 'string' ) {
					$content = json_decode( $content );
				}
			}

			return [
				ObjectSerializer::deserialize( $content, $returnType, [] ),
				$response->getStatusCode(),
				$response->getHeaders(),
			];

		} catch ( ApiException $e ) {
			switch ( $e->getCode() ) {
				case 200:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\Goal',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 401:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\UnauthorizedError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 404:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\NotFoundError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 422:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
			}
			throw $e;
		}
	}

	/**
	 * Create request for operation 'plausibleWebPluginsAPIControllersGoalsGet'
	 *
	 * @param int    $id          Goal ID (required)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersGoalsGet'] to see
	 *                            the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Psr7\Request
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersGoalsGetRequest(
		$id,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsGet' ][ 0 ]
	) {

		// verify the required parameter 'id' is set
		if ( $id === null || ( is_array( $id ) && count( $id ) === 0 ) ) {
			throw new \InvalidArgumentException(
				'Missing the required parameter $id when calling plausibleWebPluginsAPIControllersGoalsGet'
			);
		}

		$resourcePath = '/api/plugins/v1/goals/{id}';
		$formParams   = [];
		$queryParams  = [];
		$headerParams = [];
		$httpBody     = '';
		$multipart    = false;

		// path params
		if ( $id !== null ) {
			$resourcePath = str_replace(
				'{' . 'id' . '}',
				ObjectSerializer::toPathValue( $id ),
				$resourcePath
			);
		}

		$headers = $this->headerSelector->selectHeaders(
			[ 'application/json', ],
			$contentType,
			$multipart
		);

		// for model (json/xml)
		if ( count( $formParams ) > 0 ) {
			if ( $multipart ) {
				$multipartContents = [];
				foreach ( $formParams as $formParamName => $formParamValue ) {
					$formParamValueItems = is_array( $formParamValue ) ? $formParamValue : [ $formParamValue ];
					foreach ( $formParamValueItems as $formParamValueItem ) {
						$multipartContents[] = [
							'name'     => $formParamName,
							'contents' => $formParamValueItem,
						];
					}
				}
				// for HTTP post (form)
				$httpBody = new MultipartStream( $multipartContents );

			} elseif ( stripos( $headers[ 'Content-Type' ], 'application/json' ) !== false ) {
				# if Content-Type contains "application/json", json_encode the form parameters
				$httpBody = \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Utils::jsonEncode( $formParams );
			} else {
				// for HTTP post (form)
				$httpBody = ObjectSerializer::buildQuery( $formParams );
			}
		}

		// this endpoint requires HTTP basic authentication
		if ( ! empty( $this->config->getUsername() ) || ! ( empty( $this->config->getPassword() ) ) ) {
			$headers[ 'Authorization' ] = 'Basic ' . base64_encode( $this->config->getUsername() . ":" . $this->config->getPassword() );
		}

		$defaultHeaders = [];
		if ( $this->config->getUserAgent() ) {
			$defaultHeaders[ 'User-Agent' ] = $this->config->getUserAgent();
		}

		$headers = array_merge(
			$defaultHeaders,
			$headerParams,
			$headers
		);

		$operationHost = $this->config->getHost();
		$query         = ObjectSerializer::buildQuery( $queryParams );

		return new Request(
			'GET', $operationHost . $resourcePath . ( $query ? "?{$query}" : '' ), $headers, $httpBody
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersGoalsGetAsync
	 *
	 * Retrieve Goal by ID
	 *
	 * @param int    $id          Goal ID (required)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersGoalsGet'] to see
	 *                            the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersGoalsGetAsync(
		$id,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsGet' ][ 0 ]
	) {
		return $this->plausibleWebPluginsAPIControllersGoalsGetAsyncWithHttpInfo( $id, $contentType )->then(
			function ( $response ) {
				return $response[ 0 ];
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersGoalsGetAsyncWithHttpInfo
	 *
	 * Retrieve Goal by ID
	 *
	 * @param int    $id          Goal ID (required)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersGoalsGet'] to see
	 *                            the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersGoalsGetAsyncWithHttpInfo(
		$id,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsGet' ][ 0 ]
	) {
		$returnType = '\Plausible\Analytics\WP\Client\Model\Goal';
		$request    = $this->plausibleWebPluginsAPIControllersGoalsGetRequest( $id, $contentType );

		return $this->client->sendAsync( $request, $this->createHttpClientOption() )->then(
			function ( $response ) use ( $returnType ) {
				if ( $returnType === '\SplFileObject' ) {
					$content = $response->getBody(); //stream goes to serializer
				} else {
					$content = (string) $response->getBody();
					if ( $returnType !== 'string' ) {
						$content = json_decode( $content );
					}
				}

				return [
					ObjectSerializer::deserialize( $content, $returnType, [] ),
					$response->getStatusCode(),
					$response->getHeaders(),
				];
			},
			function ( $exception ) {
				$response   = $exception->getResponse();
				$statusCode = $response->getStatusCode();
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						$exception->getRequest()->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersGoalsIndex
	 *
	 * Retrieve Goals
	 *
	 * @param int    $limit       Maximum entries per page (optional)
	 * @param string $after       Cursor value to seek after - generated internally (optional)
	 * @param string $before      Cursor value to seek before - generated internally (optional)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersGoalsIndex'] to
	 *                            see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Model\GoalListResponse|\Plausible\Analytics\WP\Client\Model\UnauthorizedError
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersGoalsIndex(
		$limit = null,
		$after = null,
		$before = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsIndex' ][ 0 ]
	) {
		[ $response ] = $this->plausibleWebPluginsAPIControllersGoalsIndexWithHttpInfo( $limit, $after, $before, $contentType );

		return $response;
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersGoalsIndexWithHttpInfo
	 *
	 * Retrieve Goals
	 *
	 * @param int    $limit       Maximum entries per page (optional)
	 * @param string $after       Cursor value to seek after - generated internally (optional)
	 * @param string $before      Cursor value to seek before - generated internally (optional)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersGoalsIndex'] to
	 *                            see the possible values for this operation
	 *
	 * @return array of \Plausible\Analytics\WP\Client\Model\GoalListResponse|\Plausible\Analytics\WP\Client\Model\UnauthorizedError, HTTP status
	 *               code, HTTP response headers (array of strings)
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersGoalsIndexWithHttpInfo(
		$limit = null,
		$after = null,
		$before = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsIndex' ][ 0 ]
	) {
		$request = $this->plausibleWebPluginsAPIControllersGoalsIndexRequest( $limit, $after, $before, $contentType );

		try {
			$options = $this->createHttpClientOption();
			try {
				$response = $this->client->send( $request, $options );
			} catch ( RequestException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}",
					(int) $e->getCode(),
					$e->getResponse() ? $e->getResponse()->getHeaders() : null,
					$e->getResponse() ? (string) $e->getResponse()->getBody() : null
				);
			} catch ( ConnectException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}", (int) $e->getCode(), null, null
				);
			}

			$statusCode = $response->getStatusCode();

			if ( $statusCode < 200 || $statusCode > 299 ) {
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						(string) $request->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}

			switch ( $statusCode ) {
				case 200:
					if ( '\Plausible\Analytics\WP\Client\Model\GoalListResponse' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\GoalListResponse' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\GoalListResponse', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 401:
					if ( '\Plausible\Analytics\WP\Client\Model\UnauthorizedError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\UnauthorizedError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\UnauthorizedError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
			}

			$returnType = '\Plausible\Analytics\WP\Client\Model\GoalListResponse';
			if ( $returnType === '\SplFileObject' ) {
				$content = $response->getBody(); //stream goes to serializer
			} else {
				$content = (string) $response->getBody();
				if ( $returnType !== 'string' ) {
					$content = json_decode( $content );
				}
			}

			return [
				ObjectSerializer::deserialize( $content, $returnType, [] ),
				$response->getStatusCode(),
				$response->getHeaders(),
			];

		} catch ( ApiException $e ) {
			switch ( $e->getCode() ) {
				case 200:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\GoalListResponse',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 401:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\UnauthorizedError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
			}
			throw $e;
		}
	}

	/**
	 * Create request for operation 'plausibleWebPluginsAPIControllersGoalsIndex'
	 *
	 * @param int    $limit       Maximum entries per page (optional)
	 * @param string $after       Cursor value to seek after - generated internally (optional)
	 * @param string $before      Cursor value to seek before - generated internally (optional)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersGoalsIndex'] to
	 *                            see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Psr7\Request
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersGoalsIndexRequest(
		$limit = null,
		$after = null,
		$before = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsIndex' ][ 0 ]
	) {

		$resourcePath = '/api/plugins/v1/goals';
		$formParams   = [];
		$queryParams  = [];
		$headerParams = [];
		$httpBody     = '';
		$multipart    = false;

		// query params
		$queryParams = array_merge(
			$queryParams,
			ObjectSerializer::toQueryValue(
				$limit,
				'limit', // param base name
				'integer', // openApiType
				'form', // style
				true, // explode
				false // required
			) ?? []
		);
		// query params
		$queryParams = array_merge(
			$queryParams,
			ObjectSerializer::toQueryValue(
				$after,
				'after', // param base name
				'string', // openApiType
				'form', // style
				true, // explode
				false // required
			) ?? []
		);
		// query params
		$queryParams = array_merge(
			$queryParams,
			ObjectSerializer::toQueryValue(
				$before,
				'before', // param base name
				'string', // openApiType
				'form', // style
				true, // explode
				false // required
			) ?? []
		);

		$headers = $this->headerSelector->selectHeaders(
			[ 'application/json', ],
			$contentType,
			$multipart
		);

		// for model (json/xml)
		if ( count( $formParams ) > 0 ) {
			if ( $multipart ) {
				$multipartContents = [];
				foreach ( $formParams as $formParamName => $formParamValue ) {
					$formParamValueItems = is_array( $formParamValue ) ? $formParamValue : [ $formParamValue ];
					foreach ( $formParamValueItems as $formParamValueItem ) {
						$multipartContents[] = [
							'name'     => $formParamName,
							'contents' => $formParamValueItem,
						];
					}
				}
				// for HTTP post (form)
				$httpBody = new MultipartStream( $multipartContents );

			} elseif ( stripos( $headers[ 'Content-Type' ], 'application/json' ) !== false ) {
				# if Content-Type contains "application/json", json_encode the form parameters
				$httpBody = \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Utils::jsonEncode( $formParams );
			} else {
				// for HTTP post (form)
				$httpBody = ObjectSerializer::buildQuery( $formParams );
			}
		}

		// this endpoint requires HTTP basic authentication
		if ( ! empty( $this->config->getUsername() ) || ! ( empty( $this->config->getPassword() ) ) ) {
			$headers[ 'Authorization' ] = 'Basic ' . base64_encode( $this->config->getUsername() . ":" . $this->config->getPassword() );
		}

		$defaultHeaders = [];
		if ( $this->config->getUserAgent() ) {
			$defaultHeaders[ 'User-Agent' ] = $this->config->getUserAgent();
		}

		$headers = array_merge(
			$defaultHeaders,
			$headerParams,
			$headers
		);

		$operationHost = $this->config->getHost();
		$query         = ObjectSerializer::buildQuery( $queryParams );

		return new Request(
			'GET', $operationHost . $resourcePath . ( $query ? "?{$query}" : '' ), $headers, $httpBody
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersGoalsIndexAsync
	 *
	 * Retrieve Goals
	 *
	 * @param int    $limit       Maximum entries per page (optional)
	 * @param string $after       Cursor value to seek after - generated internally (optional)
	 * @param string $before      Cursor value to seek before - generated internally (optional)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersGoalsIndex'] to
	 *                            see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersGoalsIndexAsync(
		$limit = null,
		$after = null,
		$before = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsIndex' ][ 0 ]
	) {
		return $this->plausibleWebPluginsAPIControllersGoalsIndexAsyncWithHttpInfo( $limit, $after, $before, $contentType )->then(
			function ( $response ) {
				return $response[ 0 ];
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersGoalsIndexAsyncWithHttpInfo
	 *
	 * Retrieve Goals
	 *
	 * @param int    $limit       Maximum entries per page (optional)
	 * @param string $after       Cursor value to seek after - generated internally (optional)
	 * @param string $before      Cursor value to seek before - generated internally (optional)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersGoalsIndex'] to
	 *                            see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersGoalsIndexAsyncWithHttpInfo(
		$limit = null,
		$after = null,
		$before = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersGoalsIndex' ][ 0 ]
	) {
		$returnType = '\Plausible\Analytics\WP\Client\Model\GoalListResponse';
		$request    = $this->plausibleWebPluginsAPIControllersGoalsIndexRequest( $limit, $after, $before, $contentType );

		return $this->client->sendAsync( $request, $this->createHttpClientOption() )->then(
			function ( $response ) use ( $returnType ) {
				if ( $returnType === '\SplFileObject' ) {
					$content = $response->getBody(); //stream goes to serializer
				} else {
					$content = (string) $response->getBody();
					if ( $returnType !== 'string' ) {
						$content = json_decode( $content );
					}
				}

				return [
					ObjectSerializer::deserialize( $content, $returnType, [] ),
					$response->getStatusCode(),
					$response->getHeaders(),
				];
			},
			function ( $exception ) {
				$response   = $exception->getResponse();
				$statusCode = $response->getStatusCode();
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						$exception->getRequest()->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersSharedLinksCreate
	 *
	 * Get or create Shared Link
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\SharedLinkCreateRequest $shared_link_create_request Shared Link params (optional)
	 * @param string                                                       $contentType                The value for the Content-Type header. Check
	 *                                                                                                 self::contentTypes['plausibleWebPluginsAPIControllersSharedLinksCreate']
	 *                                                                                                 to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Model\SharedLink|\Plausible\Analytics\WP\Client\Model\UnauthorizedError|\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersSharedLinksCreate(
		$shared_link_create_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersSharedLinksCreate' ][ 0 ]
	) {
		[ $response ] = $this->plausibleWebPluginsAPIControllersSharedLinksCreateWithHttpInfo( $shared_link_create_request, $contentType );

		return $response;
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersSharedLinksCreateWithHttpInfo
	 *
	 * Get or create Shared Link
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\SharedLinkCreateRequest $shared_link_create_request Shared Link params (optional)
	 * @param string                                                       $contentType                The value for the Content-Type header. Check
	 *                                                                                                 self::contentTypes['plausibleWebPluginsAPIControllersSharedLinksCreate']
	 *                                                                                                 to see the possible values for this operation
	 *
	 * @return array of
	 *               \Plausible\Analytics\WP\Client\Model\SharedLink|\Plausible\Analytics\WP\Client\Model\UnauthorizedError|\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError,
	 *               HTTP status code, HTTP response headers (array of strings)
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersSharedLinksCreateWithHttpInfo(
		$shared_link_create_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersSharedLinksCreate' ][ 0 ]
	) {
		$request = $this->plausibleWebPluginsAPIControllersSharedLinksCreateRequest( $shared_link_create_request, $contentType );

		try {
			$options = $this->createHttpClientOption();
			try {
				$response = $this->client->send( $request, $options );
			} catch ( RequestException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}",
					(int) $e->getCode(),
					$e->getResponse() ? $e->getResponse()->getHeaders() : null,
					$e->getResponse() ? (string) $e->getResponse()->getBody() : null
				);
			} catch ( ConnectException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}", (int) $e->getCode(), null, null
				);
			}

			$statusCode = $response->getStatusCode();

			if ( $statusCode < 200 || $statusCode > 299 ) {
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						(string) $request->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}

			switch ( $statusCode ) {
				case 201:
					if ( '\Plausible\Analytics\WP\Client\Model\SharedLink' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\SharedLink' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\SharedLink', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 401:
					if ( '\Plausible\Analytics\WP\Client\Model\UnauthorizedError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\UnauthorizedError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\UnauthorizedError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 422:
					if ( '\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
			}

			$returnType = '\Plausible\Analytics\WP\Client\Model\SharedLink';
			if ( $returnType === '\SplFileObject' ) {
				$content = $response->getBody(); //stream goes to serializer
			} else {
				$content = (string) $response->getBody();
				if ( $returnType !== 'string' ) {
					$content = json_decode( $content );
				}
			}

			return [
				ObjectSerializer::deserialize( $content, $returnType, [] ),
				$response->getStatusCode(),
				$response->getHeaders(),
			];

		} catch ( ApiException $e ) {
			switch ( $e->getCode() ) {
				case 201:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\SharedLink',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 401:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\UnauthorizedError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 422:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
			}
			throw $e;
		}
	}

	/**
	 * Create request for operation 'plausibleWebPluginsAPIControllersSharedLinksCreate'
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\SharedLinkCreateRequest $shared_link_create_request Shared Link params (optional)
	 * @param string                                                       $contentType                The value for the Content-Type header. Check
	 *                                                                                                 self::contentTypes['plausibleWebPluginsAPIControllersSharedLinksCreate']
	 *                                                                                                 to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Psr7\Request
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersSharedLinksCreateRequest(
		$shared_link_create_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersSharedLinksCreate' ][ 0 ]
	) {

		$resourcePath = '/api/plugins/v1/shared_links';
		$formParams   = [];
		$queryParams  = [];
		$headerParams = [];
		$httpBody     = '';
		$multipart    = false;

		$headers = $this->headerSelector->selectHeaders(
			[ 'application/json', ],
			$contentType,
			$multipart
		);

		// for model (json/xml)
		if ( isset( $shared_link_create_request ) ) {
			if ( stripos( $headers[ 'Content-Type' ], 'application/json' ) !== false ) {
				# if Content-Type contains "application/json", json_encode the body
				$httpBody = \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Utils::jsonEncode(
					ObjectSerializer::sanitizeForSerialization( $shared_link_create_request )
				);
			} else {
				$httpBody = $shared_link_create_request;
			}
		} elseif ( count( $formParams ) > 0 ) {
			if ( $multipart ) {
				$multipartContents = [];
				foreach ( $formParams as $formParamName => $formParamValue ) {
					$formParamValueItems = is_array( $formParamValue ) ? $formParamValue : [ $formParamValue ];
					foreach ( $formParamValueItems as $formParamValueItem ) {
						$multipartContents[] = [
							'name'     => $formParamName,
							'contents' => $formParamValueItem,
						];
					}
				}
				// for HTTP post (form)
				$httpBody = new MultipartStream( $multipartContents );

			} elseif ( stripos( $headers[ 'Content-Type' ], 'application/json' ) !== false ) {
				# if Content-Type contains "application/json", json_encode the form parameters
				$httpBody = \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Utils::jsonEncode( $formParams );
			} else {
				// for HTTP post (form)
				$httpBody = ObjectSerializer::buildQuery( $formParams );
			}
		}

		// this endpoint requires HTTP basic authentication
		if ( ! empty( $this->config->getUsername() ) || ! ( empty( $this->config->getPassword() ) ) ) {
			$headers[ 'Authorization' ] = 'Basic ' . base64_encode( $this->config->getUsername() . ":" . $this->config->getPassword() );
		}

		$defaultHeaders = [];
		if ( $this->config->getUserAgent() ) {
			$defaultHeaders[ 'User-Agent' ] = $this->config->getUserAgent();
		}

		$headers = array_merge(
			$defaultHeaders,
			$headerParams,
			$headers
		);

		$operationHost = $this->config->getHost();
		$query         = ObjectSerializer::buildQuery( $queryParams );

		return new Request(
			'PUT', $operationHost . $resourcePath . ( $query ? "?{$query}" : '' ), $headers, $httpBody
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersSharedLinksCreateAsync
	 *
	 * Get or create Shared Link
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\SharedLinkCreateRequest $shared_link_create_request Shared Link params (optional)
	 * @param string                                                       $contentType                The value for the Content-Type header. Check
	 *                                                                                                 self::contentTypes['plausibleWebPluginsAPIControllersSharedLinksCreate']
	 *                                                                                                 to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersSharedLinksCreateAsync(
		$shared_link_create_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersSharedLinksCreate' ][ 0 ]
	) {
		return $this->plausibleWebPluginsAPIControllersSharedLinksCreateAsyncWithHttpInfo( $shared_link_create_request, $contentType )->then(
			function ( $response ) {
				return $response[ 0 ];
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersSharedLinksCreateAsyncWithHttpInfo
	 *
	 * Get or create Shared Link
	 *
	 * @param \Plausible\Analytics\WP\Client\Model\SharedLinkCreateRequest $shared_link_create_request Shared Link params (optional)
	 * @param string                                                       $contentType                The value for the Content-Type header. Check
	 *                                                                                                 self::contentTypes['plausibleWebPluginsAPIControllersSharedLinksCreate']
	 *                                                                                                 to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersSharedLinksCreateAsyncWithHttpInfo(
		$shared_link_create_request = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersSharedLinksCreate' ][ 0 ]
	) {
		$returnType = '\Plausible\Analytics\WP\Client\Model\SharedLink';
		$request    = $this->plausibleWebPluginsAPIControllersSharedLinksCreateRequest( $shared_link_create_request, $contentType );

		return $this->client->sendAsync( $request, $this->createHttpClientOption() )->then(
			function ( $response ) use ( $returnType ) {
				if ( $returnType === '\SplFileObject' ) {
					$content = $response->getBody(); //stream goes to serializer
				} else {
					$content = (string) $response->getBody();
					if ( $returnType !== 'string' ) {
						$content = json_decode( $content );
					}
				}

				return [
					ObjectSerializer::deserialize( $content, $returnType, [] ),
					$response->getStatusCode(),
					$response->getHeaders(),
				];
			},
			function ( $exception ) {
				$response   = $exception->getResponse();
				$statusCode = $response->getStatusCode();
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						$exception->getRequest()->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersSharedLinksGet
	 *
	 * Retrieve Shared Link by ID
	 *
	 * @param int    $id          Shared Link ID (required)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersSharedLinksGet']
	 *                            to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Model\SharedLink|\Plausible\Analytics\WP\Client\Model\UnauthorizedError|\Plausible\Analytics\WP\Client\Model\NotFoundError|\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersSharedLinksGet(
		$id,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersSharedLinksGet' ][ 0 ]
	) {
		[ $response ] = $this->plausibleWebPluginsAPIControllersSharedLinksGetWithHttpInfo( $id, $contentType );

		return $response;
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersSharedLinksGetWithHttpInfo
	 *
	 * Retrieve Shared Link by ID
	 *
	 * @param int    $id          Shared Link ID (required)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersSharedLinksGet']
	 *                            to see the possible values for this operation
	 *
	 * @return array of
	 *               \Plausible\Analytics\WP\Client\Model\SharedLink|\Plausible\Analytics\WP\Client\Model\UnauthorizedError|\Plausible\Analytics\WP\Client\Model\NotFoundError|\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError,
	 *               HTTP status code, HTTP response headers (array of strings)
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersSharedLinksGetWithHttpInfo(
		$id,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersSharedLinksGet' ][ 0 ]
	) {
		$request = $this->plausibleWebPluginsAPIControllersSharedLinksGetRequest( $id, $contentType );

		try {
			$options = $this->createHttpClientOption();
			try {
				$response = $this->client->send( $request, $options );
			} catch ( RequestException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}",
					(int) $e->getCode(),
					$e->getResponse() ? $e->getResponse()->getHeaders() : null,
					$e->getResponse() ? (string) $e->getResponse()->getBody() : null
				);
			} catch ( ConnectException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}", (int) $e->getCode(), null, null
				);
			}

			$statusCode = $response->getStatusCode();

			if ( $statusCode < 200 || $statusCode > 299 ) {
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						(string) $request->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}

			switch ( $statusCode ) {
				case 201:
					if ( '\Plausible\Analytics\WP\Client\Model\SharedLink' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\SharedLink' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\SharedLink', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 401:
					if ( '\Plausible\Analytics\WP\Client\Model\UnauthorizedError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\UnauthorizedError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\UnauthorizedError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 404:
					if ( '\Plausible\Analytics\WP\Client\Model\NotFoundError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\NotFoundError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\NotFoundError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 422:
					if ( '\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
			}

			$returnType = '\Plausible\Analytics\WP\Client\Model\SharedLink';
			if ( $returnType === '\SplFileObject' ) {
				$content = $response->getBody(); //stream goes to serializer
			} else {
				$content = (string) $response->getBody();
				if ( $returnType !== 'string' ) {
					$content = json_decode( $content );
				}
			}

			return [
				ObjectSerializer::deserialize( $content, $returnType, [] ),
				$response->getStatusCode(),
				$response->getHeaders(),
			];

		} catch ( ApiException $e ) {
			switch ( $e->getCode() ) {
				case 201:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\SharedLink',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 401:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\UnauthorizedError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 404:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\NotFoundError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 422:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\UnprocessableEntityError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
			}
			throw $e;
		}
	}

	/**
	 * Create request for operation 'plausibleWebPluginsAPIControllersSharedLinksGet'
	 *
	 * @param int    $id          Shared Link ID (required)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersSharedLinksGet']
	 *                            to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Psr7\Request
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersSharedLinksGetRequest(
		$id,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersSharedLinksGet' ][ 0 ]
	) {

		// verify the required parameter 'id' is set
		if ( $id === null || ( is_array( $id ) && count( $id ) === 0 ) ) {
			throw new \InvalidArgumentException(
				'Missing the required parameter $id when calling plausibleWebPluginsAPIControllersSharedLinksGet'
			);
		}

		$resourcePath = '/api/plugins/v1/shared_links/{id}';
		$formParams   = [];
		$queryParams  = [];
		$headerParams = [];
		$httpBody     = '';
		$multipart    = false;

		// path params
		if ( $id !== null ) {
			$resourcePath = str_replace(
				'{' . 'id' . '}',
				ObjectSerializer::toPathValue( $id ),
				$resourcePath
			);
		}

		$headers = $this->headerSelector->selectHeaders(
			[ 'application/json', ],
			$contentType,
			$multipart
		);

		// for model (json/xml)
		if ( count( $formParams ) > 0 ) {
			if ( $multipart ) {
				$multipartContents = [];
				foreach ( $formParams as $formParamName => $formParamValue ) {
					$formParamValueItems = is_array( $formParamValue ) ? $formParamValue : [ $formParamValue ];
					foreach ( $formParamValueItems as $formParamValueItem ) {
						$multipartContents[] = [
							'name'     => $formParamName,
							'contents' => $formParamValueItem,
						];
					}
				}
				// for HTTP post (form)
				$httpBody = new MultipartStream( $multipartContents );

			} elseif ( stripos( $headers[ 'Content-Type' ], 'application/json' ) !== false ) {
				# if Content-Type contains "application/json", json_encode the form parameters
				$httpBody = \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Utils::jsonEncode( $formParams );
			} else {
				// for HTTP post (form)
				$httpBody = ObjectSerializer::buildQuery( $formParams );
			}
		}

		// this endpoint requires HTTP basic authentication
		if ( ! empty( $this->config->getUsername() ) || ! ( empty( $this->config->getPassword() ) ) ) {
			$headers[ 'Authorization' ] = 'Basic ' . base64_encode( $this->config->getUsername() . ":" . $this->config->getPassword() );
		}

		$defaultHeaders = [];
		if ( $this->config->getUserAgent() ) {
			$defaultHeaders[ 'User-Agent' ] = $this->config->getUserAgent();
		}

		$headers = array_merge(
			$defaultHeaders,
			$headerParams,
			$headers
		);

		$operationHost = $this->config->getHost();
		$query         = ObjectSerializer::buildQuery( $queryParams );

		return new Request(
			'GET', $operationHost . $resourcePath . ( $query ? "?{$query}" : '' ), $headers, $httpBody
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersSharedLinksGetAsync
	 *
	 * Retrieve Shared Link by ID
	 *
	 * @param int    $id          Shared Link ID (required)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersSharedLinksGet']
	 *                            to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersSharedLinksGetAsync(
		$id,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersSharedLinksGet' ][ 0 ]
	) {
		return $this->plausibleWebPluginsAPIControllersSharedLinksGetAsyncWithHttpInfo( $id, $contentType )->then(
			function ( $response ) {
				return $response[ 0 ];
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersSharedLinksGetAsyncWithHttpInfo
	 *
	 * Retrieve Shared Link by ID
	 *
	 * @param int    $id          Shared Link ID (required)
	 * @param string $contentType The value for the Content-Type header. Check self::contentTypes['plausibleWebPluginsAPIControllersSharedLinksGet']
	 *                            to see the possible values for this operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersSharedLinksGetAsyncWithHttpInfo(
		$id,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersSharedLinksGet' ][ 0 ]
	) {
		$returnType = '\Plausible\Analytics\WP\Client\Model\SharedLink';
		$request    = $this->plausibleWebPluginsAPIControllersSharedLinksGetRequest( $id, $contentType );

		return $this->client->sendAsync( $request, $this->createHttpClientOption() )->then(
			function ( $response ) use ( $returnType ) {
				if ( $returnType === '\SplFileObject' ) {
					$content = $response->getBody(); //stream goes to serializer
				} else {
					$content = (string) $response->getBody();
					if ( $returnType !== 'string' ) {
						$content = json_decode( $content );
					}
				}

				return [
					ObjectSerializer::deserialize( $content, $returnType, [] ),
					$response->getStatusCode(),
					$response->getHeaders(),
				];
			},
			function ( $exception ) {
				$response   = $exception->getResponse();
				$statusCode = $response->getStatusCode();
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						$exception->getRequest()->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersSharedLinksIndex
	 *
	 * Retrieve Shared Links
	 *
	 * @param int    $limit       Maximum entries per page (optional)
	 * @param string $after       Cursor value to seek after - generated internally (optional)
	 * @param string $before      Cursor value to seek before - generated internally (optional)
	 * @param string $contentType The value for the Content-Type header. Check
	 *                            self::contentTypes['plausibleWebPluginsAPIControllersSharedLinksIndex'] to see the possible values for this
	 *                            operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Model\SharedLinkListResponse|\Plausible\Analytics\WP\Client\Model\UnauthorizedError
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersSharedLinksIndex(
		$limit = null,
		$after = null,
		$before = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersSharedLinksIndex' ][ 0 ]
	) {
		[ $response ] = $this->plausibleWebPluginsAPIControllersSharedLinksIndexWithHttpInfo( $limit, $after, $before, $contentType );

		return $response;
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersSharedLinksIndexWithHttpInfo
	 *
	 * Retrieve Shared Links
	 *
	 * @param int    $limit       Maximum entries per page (optional)
	 * @param string $after       Cursor value to seek after - generated internally (optional)
	 * @param string $before      Cursor value to seek before - generated internally (optional)
	 * @param string $contentType The value for the Content-Type header. Check
	 *                            self::contentTypes['plausibleWebPluginsAPIControllersSharedLinksIndex'] to see the possible values for this
	 *                            operation
	 *
	 * @return array of \Plausible\Analytics\WP\Client\Model\SharedLinkListResponse|\Plausible\Analytics\WP\Client\Model\UnauthorizedError, HTTP
	 *               status code, HTTP response headers (array of strings)
	 * @throws \InvalidArgumentException
	 * @throws \Plausible\Analytics\WP\Client\ApiException on non-2xx response
	 */
	public function plausibleWebPluginsAPIControllersSharedLinksIndexWithHttpInfo(
		$limit = null,
		$after = null,
		$before = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersSharedLinksIndex' ][ 0 ]
	) {
		$request = $this->plausibleWebPluginsAPIControllersSharedLinksIndexRequest( $limit, $after, $before, $contentType );

		try {
			$options = $this->createHttpClientOption();
			try {
				$response = $this->client->send( $request, $options );
			} catch ( RequestException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}",
					(int) $e->getCode(),
					$e->getResponse() ? $e->getResponse()->getHeaders() : null,
					$e->getResponse() ? (string) $e->getResponse()->getBody() : null
				);
			} catch ( ConnectException $e ) {
				throw new ApiException(
					"[{$e->getCode()}] {$e->getMessage()}", (int) $e->getCode(), null, null
				);
			}

			$statusCode = $response->getStatusCode();

			if ( $statusCode < 200 || $statusCode > 299 ) {
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						(string) $request->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}

			switch ( $statusCode ) {
				case 200:
					if ( '\Plausible\Analytics\WP\Client\Model\SharedLinkListResponse' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\SharedLinkListResponse' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\SharedLinkListResponse', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
				case 401:
					if ( '\Plausible\Analytics\WP\Client\Model\UnauthorizedError' === '\SplFileObject' ) {
						$content = $response->getBody(); //stream goes to serializer
					} else {
						$content = (string) $response->getBody();
						if ( '\Plausible\Analytics\WP\Client\Model\UnauthorizedError' !== 'string' ) {
							$content = json_decode( $content );
						}
					}

					return [
						ObjectSerializer::deserialize( $content, '\Plausible\Analytics\WP\Client\Model\UnauthorizedError', [] ),
						$response->getStatusCode(),
						$response->getHeaders(),
					];
			}

			$returnType = '\Plausible\Analytics\WP\Client\Model\SharedLinkListResponse';
			if ( $returnType === '\SplFileObject' ) {
				$content = $response->getBody(); //stream goes to serializer
			} else {
				$content = (string) $response->getBody();
				if ( $returnType !== 'string' ) {
					$content = json_decode( $content );
				}
			}

			return [
				ObjectSerializer::deserialize( $content, $returnType, [] ),
				$response->getStatusCode(),
				$response->getHeaders(),
			];

		} catch ( ApiException $e ) {
			switch ( $e->getCode() ) {
				case 200:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\SharedLinkListResponse',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
				case 401:
					$data = ObjectSerializer::deserialize(
						$e->getResponseBody(),
						'\Plausible\Analytics\WP\Client\Model\UnauthorizedError',
						$e->getResponseHeaders()
					);
					$e->setResponseObject( $data );
					break;
			}
			throw $e;
		}
	}

	/**
	 * Create request for operation 'plausibleWebPluginsAPIControllersSharedLinksIndex'
	 *
	 * @param int    $limit       Maximum entries per page (optional)
	 * @param string $after       Cursor value to seek after - generated internally (optional)
	 * @param string $before      Cursor value to seek before - generated internally (optional)
	 * @param string $contentType The value for the Content-Type header. Check
	 *                            self::contentTypes['plausibleWebPluginsAPIControllersSharedLinksIndex'] to see the possible values for this
	 *                            operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Psr7\Request
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersSharedLinksIndexRequest(
		$limit = null,
		$after = null,
		$before = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersSharedLinksIndex' ][ 0 ]
	) {

		$resourcePath = '/api/plugins/v1/shared_links';
		$formParams   = [];
		$queryParams  = [];
		$headerParams = [];
		$httpBody     = '';
		$multipart    = false;

		// query params
		$queryParams = array_merge(
			$queryParams,
			ObjectSerializer::toQueryValue(
				$limit,
				'limit', // param base name
				'integer', // openApiType
				'form', // style
				true, // explode
				false // required
			) ?? []
		);
		// query params
		$queryParams = array_merge(
			$queryParams,
			ObjectSerializer::toQueryValue(
				$after,
				'after', // param base name
				'string', // openApiType
				'form', // style
				true, // explode
				false // required
			) ?? []
		);
		// query params
		$queryParams = array_merge(
			$queryParams,
			ObjectSerializer::toQueryValue(
				$before,
				'before', // param base name
				'string', // openApiType
				'form', // style
				true, // explode
				false // required
			) ?? []
		);

		$headers = $this->headerSelector->selectHeaders(
			[ 'application/json', ],
			$contentType,
			$multipart
		);

		// for model (json/xml)
		if ( count( $formParams ) > 0 ) {
			if ( $multipart ) {
				$multipartContents = [];
				foreach ( $formParams as $formParamName => $formParamValue ) {
					$formParamValueItems = is_array( $formParamValue ) ? $formParamValue : [ $formParamValue ];
					foreach ( $formParamValueItems as $formParamValueItem ) {
						$multipartContents[] = [
							'name'     => $formParamName,
							'contents' => $formParamValueItem,
						];
					}
				}
				// for HTTP post (form)
				$httpBody = new MultipartStream( $multipartContents );

			} elseif ( stripos( $headers[ 'Content-Type' ], 'application/json' ) !== false ) {
				# if Content-Type contains "application/json", json_encode the form parameters
				$httpBody = \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Utils::jsonEncode( $formParams );
			} else {
				// for HTTP post (form)
				$httpBody = ObjectSerializer::buildQuery( $formParams );
			}
		}

		// this endpoint requires HTTP basic authentication
		if ( ! empty( $this->config->getUsername() ) || ! ( empty( $this->config->getPassword() ) ) ) {
			$headers[ 'Authorization' ] = 'Basic ' . base64_encode( $this->config->getUsername() . ":" . $this->config->getPassword() );
		}

		$defaultHeaders = [];
		if ( $this->config->getUserAgent() ) {
			$defaultHeaders[ 'User-Agent' ] = $this->config->getUserAgent();
		}

		$headers = array_merge(
			$defaultHeaders,
			$headerParams,
			$headers
		);

		$operationHost = $this->config->getHost();
		$query         = ObjectSerializer::buildQuery( $queryParams );

		return new Request(
			'GET', $operationHost . $resourcePath . ( $query ? "?{$query}" : '' ), $headers, $httpBody
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersSharedLinksIndexAsync
	 *
	 * Retrieve Shared Links
	 *
	 * @param int    $limit       Maximum entries per page (optional)
	 * @param string $after       Cursor value to seek after - generated internally (optional)
	 * @param string $before      Cursor value to seek before - generated internally (optional)
	 * @param string $contentType The value for the Content-Type header. Check
	 *                            self::contentTypes['plausibleWebPluginsAPIControllersSharedLinksIndex'] to see the possible values for this
	 *                            operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersSharedLinksIndexAsync(
		$limit = null,
		$after = null,
		$before = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersSharedLinksIndex' ][ 0 ]
	) {
		return $this->plausibleWebPluginsAPIControllersSharedLinksIndexAsyncWithHttpInfo( $limit, $after, $before, $contentType )->then(
			function ( $response ) {
				return $response[ 0 ];
			}
		);
	}

	/**
	 * Operation plausibleWebPluginsAPIControllersSharedLinksIndexAsyncWithHttpInfo
	 *
	 * Retrieve Shared Links
	 *
	 * @param int    $limit       Maximum entries per page (optional)
	 * @param string $after       Cursor value to seek after - generated internally (optional)
	 * @param string $before      Cursor value to seek before - generated internally (optional)
	 * @param string $contentType The value for the Content-Type header. Check
	 *                            self::contentTypes['plausibleWebPluginsAPIControllersSharedLinksIndex'] to see the possible values for this
	 *                            operation
	 *
	 * @return \Plausible\Analytics\WP\Client\Lib\GuzzleHttp\Promise\PromiseInterface
	 * @throws \InvalidArgumentException
	 */
	public function plausibleWebPluginsAPIControllersSharedLinksIndexAsyncWithHttpInfo(
		$limit = null,
		$after = null,
		$before = null,
		string $contentType = self::contentTypes[ 'plausibleWebPluginsAPIControllersSharedLinksIndex' ][ 0 ]
	) {
		$returnType = '\Plausible\Analytics\WP\Client\Model\SharedLinkListResponse';
		$request    = $this->plausibleWebPluginsAPIControllersSharedLinksIndexRequest( $limit, $after, $before, $contentType );

		return $this->client->sendAsync( $request, $this->createHttpClientOption() )->then(
			function ( $response ) use ( $returnType ) {
				if ( $returnType === '\SplFileObject' ) {
					$content = $response->getBody(); //stream goes to serializer
				} else {
					$content = (string) $response->getBody();
					if ( $returnType !== 'string' ) {
						$content = json_decode( $content );
					}
				}

				return [
					ObjectSerializer::deserialize( $content, $returnType, [] ),
					$response->getStatusCode(),
					$response->getHeaders(),
				];
			},
			function ( $exception ) {
				$response   = $exception->getResponse();
				$statusCode = $response->getStatusCode();
				throw new ApiException(
					sprintf(
						'[%d] Error connecting to the API (%s)',
						$statusCode,
						$exception->getRequest()->getUri()
					), $statusCode, $response->getHeaders(), (string) $response->getBody()
				);
			}
		);
	}
}
