<?php
/**
 * Payment Gateways per Products for WooCommerce - Settings
 *
 * @version 1.8.2
 * @since   1.0.0
 * @author  WPFactory
 */

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Alg_WC_Settings_PGPP' ) ) :

class Alg_WC_Settings_PGPP extends WC_Settings_Page {

	/**
	 * Constructor.
	 *
	 * @version 1.8.2
	 * @since   1.0.0
	 */
	function __construct() {
		$this->id    = 'alg_wc_pgpp';
		$this->label = __( 'Payment Gateways per Products', 'payment-gateways-per-product-categories-for-woocommerce' );
		parent::__construct();
		require_once plugin_dir_path( __FILE__ ) . 'class-alg-wc-pgpp-settings-section.php';
		require_once plugin_dir_path( __FILE__ ) . 'class-alg-wc-pgpp-settings-general.php';
		require_once plugin_dir_path( __FILE__ ) . 'class-alg-wc-pgpp-settings-cats.php';
		require_once plugin_dir_path( __FILE__ ) . 'class-alg-wc-pgpp-settings-tags.php';
		require_once plugin_dir_path( __FILE__ ) . 'class-alg-wc-pgpp-settings-products.php';
		require_once plugin_dir_path( __FILE__ ) . 'class-alg-wc-pgpp-settings-countries.php';
	}

	/**
	 * get_settings.
	 *
	 * @version 1.1.0
	 * @since   1.0.0
	 */
	function get_settings() {
		global $current_section;
		return array_merge( apply_filters( 'woocommerce_get_settings_' . $this->id . '_' . $current_section, array() ), array(
			array(
				'title'     => __( 'Reset Section', 'payment-gateways-per-product-categories-for-woocommerce' ),
				'type'      => 'title',
				'id'        => $this->id . '_' . $current_section . '_reset_options',
			),
			array(
				'title'     => __( 'Reset settings', 'payment-gateways-per-product-categories-for-woocommerce' ),
				'desc'      => '<strong>' . __( 'Reset', 'payment-gateways-per-product-categories-for-woocommerce' ) . '</strong>',
				'id'        => $this->id . '_' . $current_section . '_reset',
				'default'   => 'no',
				'type'      => 'checkbox',
			),
			array(
				'type'      => 'sectionend',
				'id'        => $this->id . '_' . $current_section . '_reset_options',
			),
		) );
	}

	/**
	 * maybe_reset_settings.
	 *
	 * @version 1.1.1
	 * @since   1.0.0
	 */
	function maybe_reset_settings() {
		global $current_section;
		if ( 'yes' === get_option( $this->id . '_' . $current_section . '_reset', 'no' ) ) {
			foreach ( $this->get_settings() as $value ) {
				if ( isset( $value['id'] ) ) {
					$id = explode( '[', $value['id'] );
					delete_option( $id[0] );
				}
			}
			add_action( 'admin_notices', array( $this, 'admin_notice_settings_reset' ) );
		}
	}

	/**
	 * admin_notice_settings_reset.
	 *
	 * @version 1.1.1
	 * @since   1.1.1
	 */
	function admin_notice_settings_reset() {
		echo '<div class="notice notice-warning is-dismissible"><p><strong>' .
			__( 'Your settings have been reset.', 'payment-gateways-per-product-categories-for-woocommerce' ) . '</strong></p></div>';
	}

	/**
	 * Save settings.
	 *
	 * @version 1.0.0
	 * @since   1.0.0
	 */
	function save() {
		parent::save();
		$this->maybe_reset_settings();
	}

}

endif;

return new Alg_WC_Settings_PGPP();
