<?php if ( ! defined( 'ABSPATH' )  ) { die; } 

$prefix = '_bppivimages_';

CSF::createMetabox( $prefix, array(
  'title'        => 'Panorama Settings',
  'post_type'    => 'bppiv-image-viewer',
  'show_restore' => true,
  'footer_credit'    => ' ',
) );

CSF::createSection( $prefix, array(
  'fields' => array(
    array(
      'id'       => 'bppiv_type',
      'type'     => 'button_set',
      'title'    => 'Panorama Type.',
      'subtitle' => 'Choose Panorama Type',
      'desc'     => 'Select Panorama, Default- Image.',
      'multiple' => false,
      'options'  => array(
        'image'   => 'Image 3D',
        'image360'=> 'Image 360°',
        'video'   => 'Video',
        'video2'   => 'Video 360°',
        'gallery'  => 'Gallery',
        'tour360'  => 'Tour 360°',
        'gstreet'  => 'Google Street View',
      ),
      'default'  => 'image'
    ),
    array(
      'id'           => 'bppiv_content',
      'type'         => 'content',
      'title'        => ' ',
      'content'         => __('We have a new 360° Virtual Tour Viewer. <a href="edit.php?post_type=virtual_tour">click here</a> to create', 'panorama-viewer'),
      'dependency'   => array( 'bppiv_type', '==', 'tour360' ),
    ),
    array(
      'id'           => 'bppiv_image_src',
      'type'         => 'media',
      'library'      => 'image',
      'button_title' => 'Upload Image',
      'title'        => 'Image Source.',
      'desc'         => 'To create an image panorama, Panoramic image is Recommended is Recommended.',
      'dependency'   => array( 'bppiv_type', '==', 'image' ),
    ),
    array(
      'id'           => 'image_src_360',
      'type'         => 'upload',
      'library'      => 'image',
      'button_title' => 'Upload Image',
      'title'        => '360° Image Source.',
      'desc'         => 'To create an image panorama, Panoramic image is Recommended. You can also use external Panoramic Image link here.',
      'dependency'   => array( 'bppiv_type', '==', 'image360' ),
    ),
    array(
      'id'           => 'previewImgUrl',
      'type'         => 'upload',
      'library'      => 'image',
      'button_title' => __('Upload Image', 'panorama-viewer'),
      'title'        => __('Preview Image (Optional)', 'panorama-viewer'),
      'desc'         => __('Shown before the panorama loads (especially useful when Autoload is OFF).', 'panorama-viewer'),
      'dependency'   => array( 'bppiv_type', 'any', 'image360,tour360' ),
      'class'     => 'panorama-readonly', 
    ),
    array(
      'id'       => 'loadButtonText',
      'type'     => 'text',
      'title'    => __('Load Button Text', 'panorama-viewer'),
      'desc'     => __("This text replaces the default 'Click to Load Panorama' button when Autoload is OFF", "panorama-viewer"),
      'placeholder' => "Enter your load button text here",
      'default' => "Click to Load Panorama",
      'dependency'   => array('bppiv_type', 'any', 'image360,tour360' ),
      'class'     => 'panorama-readonly',  
    ),
    array(
      'id'           => 'bppiv_video_src',
      'type'         => 'media',
      'library'      => 'video',
      'button_title' => 'Upload Video',
      'title'        => 'Video Source.',
      'desc'         => 'Upload Panoramic Video',
      'dependency'   => array( 'bppiv_type', 'any', 'video,video2' ),
    ),
    array(
      'id'           => 'bppiv_pan_gallery',
      'type'         => 'group',
      'library'      => 'video',
      'button_title' => 'Add New Gallery Item',
      'title'        => 'Panorama Gallery.',
      'subtitle'     => 'Show multiple items according to your need .',
      'desc'         => 'Create Panorama Gallery, Supports panoramic image and Video Both',
      'fields'    => array(
        array(
          'id'    => 'panoramic_img',
          'type'  => 'media',
          'title' => 'Panoramic Images',
          'library' => 'image',
        ),
        array(
          'id'    => 'gal_type_cheek',
          'type'  => 'checkbox',
          'title' => 'Set Video',
          'default' => true,
          'desc'    => 'If you want to Set Video for this item please checked it',
        ),
        array(
          'id'    => 'gal_type_video',
          'type'  => 'media',
          'title' => 'Gallery Video',
          'desc'  => 'Upload Panoramic Video',
          'library' => 'video',
          'dependency'   => array( 'gal_type_cheek', '==', '1' ),
        ),
      ),
      'class'     => 'panorama-readonly',  
      'dependency'   => array( 'bppiv_type', '==', 'gallery' ),
    ),
    array(
      'id'           => 'bppiv_gallery_limit',
      'type'         => 'spinner',
      'title'        => 'Gallery Limits',
      'subtitle'     => 'Number of items to show in primary gallery',
      'desc'         => 'How much item do you want to show ?',
      'default'  => 6,
      'class'     => 'panorama-readonly',  
      'dependency'   => array( 'bppiv_type', '==', 'gallery' ),
    ),
    array(
      'id'           => 'bppiv_gallery_column',
      'type'         => 'spinner',
      'title'        => 'Number of Columns',
      'desc'         => 'Number of Columns in Gallery Items',
      'default'  => 2,
       'class'     => 'panorama-readonly', 
      'dependency'   => array( 'bppiv_type', '==', 'gallery' ),
    ),
    array(
      'id'           => 'bppiv_gallery_column_gap',
      'type'         => 'dimensions',
      'title'        => 'Spacing Between Columns',
      'desc'         => 'Spacing Between Columns of Gallery Items',
      'default'      => array(
          'width'  => '10',
          'unit'   => 'px', 
      ),
       'class'     => 'panorama-readonly', 
      'height'       => false,
      'dependency'   => array( 'bppiv_type', '==', 'gallery' ),
      'choices'      => array(
          'units' => array('px'),
      ),
    ),
    array(
      'id'         => 'loadMore_btn_text',
      'type'       => 'text',
      'title'      => 'LoadMore Button Text',
      'subtitle'   => 'You can use Custom Text in Button',
      'desc'       => 'Input LoadMore Button Text',
      'default'    => 'Load More',
      'class'     => 'panorama-readonly', 
      'dependency'   => array( 'bppiv_type', '==', 'gallery' ),
    ),
    array(
      'id'         => 'loadMore_text_color',
      'type'       => 'color',
      'title'      => 'LoadMore Text Color',
      'subtitle'   => 'You can use Custom Color',
      'desc'       => 'Choose LoadMore Button Text Color',
      'default'    => '#fff',
      'class'     => 'panorama-readonly', 
      'dependency'   => array( 'bppiv_type', '==', 'gallery' ),
    ),
    array(
      'id'         => 'loadMore_btn_bg',
      'type'       => 'color',
      'title'      => 'LoadMore Button Background',
      'desc'       => 'Choose LoadMore Button Background Color',
      'default'    => '#000',
      'class'     => 'panorama-readonly', 
      'dependency'   => array( 'bppiv_type', '==', 'gallery' ),
    ),
    array(
      'id'         => 'loadMore_hover_bg',
      'type'       => 'color',
      'title'      => 'LoadMore Hover Background',
      'desc'       => 'Choose LoadMore Hover Background Color',
      'default'    => '#222',
      'class'     => 'panorama-readonly', 
      'dependency'   => array( 'bppiv_type', '==', 'gallery' ),
    ),
    array(
      'id'        => 'tour_360',
      'type'      => 'group',
      'title'     => 'Tour 360°',
      'subtitle'  => 'Multiple panoramas can be joined together into a virtual tour using this tour feature.',
      'class'     => 'panorama-readonly', 
      'fields'    => array(
        array(
          'id'    => 'tour_id',
          'type'  => 'text',
          'title'    => 'Tour ID',
          'subtitle'    => 'Use Tour Unique ID. For example: house, house123.',
          'desc'    => 'Input Your Unique ID here. Don\'t use space !!',
          'default' => 'house'
        ),
        array(
          'id'    => 'tour_img',
          'type'  => 'upload',
          'library'      => 'image',
          'title'  => 'Tour Image',
          'subtitle'=>'Use Tour Image',
          'desc'    =>'Upload Your Tour Image or Use External Image Link',
        ),
        // Title Author
        array(
          'id'       => 'tourTitleAuthor',
          'type'     => 'switcher',
          'title'    => 'Title & Author ',
          'subtitle' => 'Show or Hide Title and Author.',
          'desc'     => 'Choose Show or Hide. Default is "Show"',
          'text_on'   => 'Show',
          'text_off'  => 'Hide',
          'text_width' => 70,
          'default'  => true,
        ),
        array(
          'id'    => 'title',
          'type'  => 'text',
          'title'  => 'Title',
          'subtitle'=> 'Use Tour Title',
          'desc'    => 'Input Your Tour Title here.',
          'default' => 'Spring House or Dairy',
          'dependency'   => array( 'tourTitleAuthor', '==', '1' )
        ),
        array(
          'id'    => 'author',
          'type'  => 'text',
          'title'  => 'Author',
          'subtitle'=> 'Use Tour Author/Location Name',
          'desc'    => 'Input Tour Author/Location Name here.',
          'default' => 'bPlugins',
          'dependency'   => array( 'tourTitleAuthor', '==', '1' )
        ),
        array(
          'id'        => 'tour_by_prefix',
          'type'      => 'switcher',
          'title'     => '“by” Prefix',
          'subtitle'  => 'Show or Hide the “by” text before the author name.',
          'desc'      => 'Enable to show “by” before the author (e.g., by Alex Doe). Disable to hide it. Default is "Show".',
          'text_on'   => 'Yes',
          'text_off'  => 'No',
          'default'   => true,
          'dependency'=> array(
            array( 'tourTitleAuthor', '==', '1' ),
            array( 'author', '!=', '' ),
        ),
      ),

        // hotspot
        array(
          'id'       => 'tour_hotSpot',
          'type'     => 'switcher',
          'title'    => 'HotSpot ',
          'subtitle' => 'Choose HotSpot Option. OFF or ON ',
          'desc'     => 'OFF or ON HotSpot. Default "ON"',
          'text_on'   => 'ON',
          'text_off'  => 'OFF',
          'default'  => true,
        ),
        array(
          'id'    => 'hotSpot_txt',
          'type'  => 'text',
          'title'  => 'HotSpot Text',
          'subtitle'=>'Use HotSpot Text That will display during mouse hover',
          'desc'    =>'Input Your HotSpot Text Here',
          'default' => 'Spring House',
          'dependency'   => array( 'tour_hotSpot', '==', '1' ),
        ),
        array(
          'id'    => 'target_id',
          'type'  => 'text',
          'title'  => 'Target ID',
          'subtitle'=>'Use Targeted ID That will create HotSpot relation between two Scene / Tour Image',
          'desc'    =>'Input Targeted Tour name here. Tour name will work like ID',
          'dependency'   => array( 'tour_hotSpot', '==', '1' )
        ),
        array(
          'id'    => 'default_data',
          'type'  => 'switcher',
          'title'  => 'Default',
          'subtitle'=>'Set as default to display Primary Scene',
          'desc'    =>'Choose Yes to set as default Scene. If you don\'t Choose automatically will Display first Item',
          'text_on'   => 'Yes',
          'text_off'  => 'No',
          'default'  => false,
        ),
      ),
      'dependency'   => array( 'bppiv_type', '==', 'tour360' ),
    ), 
    array(
      'id'           => 'bppiv_pano_id',
      'type'         => 'text',
      'title'        => 'Panorama ID',
      'desc'         => 'Input here Google Street View Panorama Id <a href="https://e4youth.org/blog/2019/02/05/snapping-360-images-from-google-street-view/" target="_blank">Click here for Panorama ID Details</a>',
      'placeholder'  => 'Paste here panorama id',
      'default'      => 'JmSoPsBPhqWvaBmOqfFzgA',
      'class'     => 'panorama-readonly', 
      'dependency'   => array( 'bppiv_type', '==', 'gstreet' ),
    ),
    array(
      'id'           => 'bppiv_image_width',
      'type'         => 'dimensions',
      'title'        => 'Width',
      'desc'         => 'Panorama Viewer Width',
      'default'  => array(
        'width'  => '100',
        'unit'   => '%',
      ),
      'height'   => false,
      'dependency'   => array( 'bppiv_type', '!=', 'gallery' ),
    ),
    array(
      'id'           => 'bppiv_image_height',
      'type'         => 'dimensions',
      'title'        => 'Height',
      'desc'         => 'Panorama Viewer height',
      'units'        => ['px', 'em', 'pt'],
      'default'  => array(
        'height' => '320',
        'unit'   => 'px',
      ),
      'width'   => false,
      'dependency'   => array( 'bppiv_type', '!=', 'gallery' ),
    ),
    array(
      'id'       => 'bppiv_alignment',
      'type'     => 'select',
      'title'    => 'Viewer Alignment',
      'subtitle' => 'Choose the alignment of the viewer.',
      'desc'     => 'Set the viewer alignment: Left, Right, or Center.',
      'options'  => array(
        'start'   => 'Left',
        'center' => 'Center',
        'end'  => 'Right',
      ),
      'default'  => 'center',
      'dependency'   => array( 'bppiv_type', '!=', 'gallery'  ),
    ),
    array(
      'id'       => 'bppiv_auto_rotate',
      'type'     => 'switcher',
      'title'    => 'Auto Rotate ?',
      'desc'     => 'Enable or Disable Auto Rotate',
      'text_on'  => 'Yes',
      'text_off' => 'No',
      'default'  => true,
      'dependency'   => array( 'bppiv_type', 'any', 'image,image360,tour360,gstreet' ),
    ),
    array(
      'id'       => 'bppiv_speed',
      'type'     => 'spinner',
      'title'    => 'Auto Rotate Speed',
      'subtitle' => 'Choose Auto Rotate Speed',
      'desc'     => 'Auto rotate speed as in degree per second. Positive is counter-clockwise and negative is clockwise.', 
      'default'  => 2.0,
      'dependency' => array( 'bppiv_type|bppiv_auto_rotate', 'any|==', 'image,image360,tour360,gstreet|true' ),
    ),
    array(
      'id'       => 'auto_rotate_inactivity_delay',
      'type'     => 'spinner',
      'title'    => 'Auto Rotate Inactivity Delay',
      'subtitle' => 'Choose Auto Rotate Inactivity Delay',
      'desc'     => 'Delay before auto-rotation starts after inactivity (in milliseconds).', 
      'default'  => 3000,
      'step'     => 1000, 
      'min'      => 1000,
      'max'      => 60000,
      'class'     => 'panorama-readonly',
      'dependency' => array( 'bppiv_type|bppiv_auto_rotate', 'any|==', 'image,image360,tour360,gstreet|true' ),
    ),
    array(
      'id'       => 'control_show_hide',
      'type'     => 'switcher',
      'title'    => 'Hide Default Control ?',
      'subtitle' => 'Hide Switch for Default Control.',
      'desc'     => 'Show or Hide Control',
      'text_on'  => 'Yes',
      'text_off' => 'No',
      'default'  => false,
      'dependency'   => array( 'bppiv_type', 'any', 'image,image360,tour360,gstreet' ),
    ),
    array(
      'id'       => 'initial_view',
      'type'     => 'switcher',
      'title'    => 'Initial View',
      'subtitle' => 'Choose Custom Angle of View for Initial Viewing ',
      'desc'     => 'Enable or Disable Initial Viewe. Default "OFF"',
      'text_on'  => 'Yes',
      'text_off' => 'No',
      'default'  => false,
      'class'     => 'panorama-readonly',  
      'dependency'   => array( 'bppiv_type', 'any', 'image,image360,tour360,gstreet' ),
    ),
    array(
      'id'    => 'initial_view_property',
      'type'  => 'spacing',
      'title' => 'Initial Values',
      'subtitle'=> 'Set The Custom values for Initial View. Default Initial Values are ("X=2.3 Y=-360.4 Z=120")',
      'desc'    => 'Set Your Desire Values. (X= Horizontal Position, Y= Vertical Position, Z= Zoom Level/Position) ',
      'class'     => 'panorama-readonly',
      'default'  => array(
        'top'    => 2.3,
        'right'  => -360.4,
        'bottom' => 120,
      ),
      'left'   => false,
      'show_units' => false,
      'top_icon'    => 'pitch',
      'right_icon'  => 'yaw',
      'bottom_icon' => 'hfov',
      'dependency' => array( 
          array('initial_view', '==', '1'),
          array('bppiv_type', 'any', 'image360,tour360')
         ),
    ),
    array(
      'id'    => 'initial_view_image_property',
      'type'  => 'spacing',
      'title' => 'Initial Values',
      'subtitle'=> 'Set The Custom values for Initial View. Default Initial Values are ("X=-61.42 Y=-8.95 Z=120")',
      'desc'    => 'Set Your Desire Values. (X= Horizontal Position, Y= Vertical Position, Z= Zoom Level/Position) ',
      'default'  => array(
        'top'    => -61.42,
        'right'  => -8.95,
        'bottom' => 120,
      ),
      'class'     => 'panorama-readonly', 
      'left'   => false,
      'show_units' => false,
      'top_icon'    => 'x',
      'right_icon'  => 'y',
      'bottom_icon' => 'z',
      'dependency' => array(
        array('initial_view', '==', '1'),
        array('bppiv_type', 'any', 'image,gstreet'),
      ),
    ),
    array(
      'id'       => 'initial_view_video',
      'type'     => 'switcher',
      'title'    => 'Initial View',
      'subtitle' => 'Choose Custom Angle of View for Initial Viewing ',
      'desc'     => 'Enable or Disable Initial Viewe. Default "OFF"',
      'text_on'  => 'Yes',
      'text_off' => 'No',
      'default'  => false,
      'class'     => 'panorama-readonly', 
      'dependency'   => array( 'bppiv_type', 'any', 'video,video2' ),
    ),
    array(
      'id'    => 'initial_view_video_property',
      'type'  => 'spacing',
      'title' => 'Initial Values',
      'subtitle'=> 'Set The Custom values for Initial View. Default Initial Values are ("X=0 Y=0 Z=120")',
      'desc'    => 'Set Your Desire Values. (X= Horizontal Position, Y= Vertical Position, Z= Zoom Level/Position) ',
      'default'  => array(
        'top'    => 0,
        'right'  => 0,
        'bottom' => 120,
      ),
      'class'     => 'panorama-readonly', 
      'left'   => false,
      'show_units' => false,
      'top_icon'    => 'x',
      'right_icon'  => 'y',
      'bottom_icon' => 'z',
      'dependency' => array( 'initial_view_video|bppiv_type', '==|any', '1|video,video2' ),
    ),
    array(
      'id'       => 'custom_control',
      'type'     => 'switcher',
      'title'    => 'Custom Control',
      'subtitle' => 'Custom Control will replace default control bar',
      'desc'     => 'Show or Hide Custom Control. Default "NO"',
      'class'     => 'panorama-readonly',  
      'text_on'  => 'Yes',
      'text_off' => 'No',
      'default'  => false,
      'dependency'   => array( 'bppiv_type', '==', 'image360' ),
    ),
     array(
      'id'       => 'is_motion_button',
      'type'     => 'switcher',
      'title'    => 'Device Motion Button',
      'subtitle' => 'Disable or Enable Device Motion Button',
      'desc'     => 'Show or Hide Custom Control. Default "NO"',
      'text_on'  => 'Yes',
      'text_off' => 'No',
      'default'  => false,
      'class'     => 'panorama-readonly', 
      'dependency'   => array( 'bppiv_type', '==', 'image' ),
    ),
     array(
      'id'         => 'motion_button_text_color',
      'type'       => 'color',
      'title'      => 'Device Motion Button Text Color',
      'subtitle'   => 'You can use Custom Color',
      'desc'       => 'Choose Device Motion  Button Text Color',
      'default'    => '#fff',
      'dependency'   => array( array('is_motion_button', '==', '1'),array('bppiv_type', '==', 'image') ),
    ),
    array(
      'id'         => 'motion_button_btn_bg',
      'type'       => 'color',
      'title'      => 'Device Motion Button Background Color',
      'desc'       => 'Choose Device Motion Button Background Color',
      'default'    => '#000000B3',
     'dependency'   => array( array('is_motion_button', '==', '1'),array('bppiv_type', '==', 'image') ),
    ),
    array(
      'id'         => 'hover_motion_button_text_color',
      'type'       => 'color',
      'title'      => 'Device Motion Button Text Hover Color',
      'subtitle'   => 'You can use Custom Color',
      'desc'       => 'Choose Device Motion  Button Text Hover Color',
      'default'    => '#fff',
      'dependency'   => array( array('is_motion_button', '==', '1'),array('bppiv_type', '==', 'image') ),
    ),
    array(
      'id'         => 'hover_motion_button_btn_bg',
      'type'       => 'color',
      'title'      => 'Device Motion Button Background Hover Color',
      'desc'       => 'Choose Device Motion Button Background Hover Color',
      'default'    => '#000000E6',
      'dependency'   => array( array('is_motion_button', '==', '1'),array('bppiv_type', '==', 'image') ),
    ),
    array(
      'id'       => 'bppiv_auto_load',
      'type'     => 'switcher',
      'title'    => 'Auto Load',
      'desc'     => 'Enable or Disable Autoload',
      'subtitle'     => 'Image will be automatically load without click',
      'class'     => 'panorama-readonly',  
      'text_on'  => 'Yes',
      'text_off' => 'No',
      'default'  => true,
      'dependency'   => array( 'bppiv_type', 'any', 'image360,tour360' ),
    ),
    array(
      'id'       => 'draggable_360',
      'type'     => 'switcher',
      'title'    => 'Draggable ',
      'desc'     => 'Enable or Disable mouse and touch dragging',
      'subtitle'     => 'Image will be Draggable with this feature',
      'class'     => 'panorama-readonly',  
      'text_on'  => 'Yes',
      'text_off' => 'No',
      'default'  => true,
      'dependency'   => array( 'bppiv_type', 'any', 'image360,tour360' ),
    ),
    array(
      'id'       => 'compass_360',
      'type'     => 'switcher',
      'title'    => 'Compass ',
      'desc'     => 'Show or Hide Compass.',
      'subtitle' => 'Enable or Disable Compass. Default "No"',
      'class'     => 'panorama-readonly',  
      'text_on'  => 'Yes',
      'text_off' => 'No',
      'default'  => false,
      'dependency'   => array( 'bppiv_type', 'any', 'image360,tour360' ),
    ),
    array(
      'id'       => 'bppiv_auto_play',
      'type'     => 'switcher',
      'title'    => 'Auto Play ?',
      'desc'     => 'To enable autoplay, please make sure "Muted" is also turned on.',
      'text_on'  => 'Yes',
      'text_off' => 'No',
      'default'  => false,
      'dependency'   => array( 'bppiv_type', '==', 'video' ),
    ),
    array(
      'id'       => 'bppiv_video_mute',
      'type'     => 'switcher',
      'title'    => 'Video Mute ?',
      'subtitle' => 'Enable or Disable Video Mute',
      'desc'     => 'Specify if the video should auto play',
      'text_on'  => 'Yes',
      'text_off' => 'No',
      'default'  => false,
      'dependency'   => array( 'bppiv_type', '==', 'video' ),
    ),
    array(
      'id'       => 'bppiv_video_autoplay',
      'type'     => 'switcher',
      'title'    => 'Video Auto Play',
      'desc'     => 'Enable or Disable Video Auto Play',
      'text_on'  => 'Yes',
      'text_off' => 'No',
      'default'  => true,
      'dependency'   => array( 'bppiv_type', '==', 'video2' ),
    ),
    array(
      'id'       => 'bppiv_video_loop',
      'type'     => 'switcher',
      'title'    => 'Video Loop ?',
      'desc'     => 'Enable or Disable Video Loop',
      'text_on'  => 'Yes',
      'text_off' => 'No',
      'default'  => true,
      'dependency'   => array( 'bppiv_type', 'any', 'video,video2' ),
    ),
    array(
      'id'       => 'control_show_hide_video',
      'type'     => 'switcher',
      'title'    => 'Control Bar',
      'desc'     => 'Choose "No" to Hide Control. Default "Yes"',
      'desc'     => 'Show or Hide Control',
      'text_on'  => 'Yes',
      'text_off' => 'No',
      'default'  => true,
      'dependency'   => array( 'bppiv_type', '==', 'video' ),
    ),
    array(
      'id'       => 'video_fullscreen_ctrl',
      'type'     => 'switcher',
      'title'    => 'Fullscreen Control',
      'desc'     => 'Show or Hide Fullscreene Control',
      'text_on'  => 'Yes',
      'text_off' => 'No', 
      'default'  => true,
      'class'     => 'panorama-readonly', 
      'dependency'   => array( 
        array('control_show_hide_video', '==', '1'),
        array('bppiv_type', '==', 'video')
      ),
    ),
     array(
      'id'       => 'video_setting_ctrl',
      'type'     => 'switcher',
      'title'    => 'Setting Control',
      'desc'     => 'Show or Hide Setting Control',
      'text_on'  => 'Yes',
      'text_off' => 'No', 
      'default'  => true,
      'class'     => 'panorama-readonly', 
      'dependency'   => array( array('control_show_hide_video', '==', '1') ,array('bppiv_type', '==', 'video') ),
    ),
    array(
      'id'       => 'video_video_range_ctrl',
      'type'     => 'switcher',
      'title'    => 'Video Range & Play/Pause Control',
      'desc'     => 'Show or Hide Video Range & Play/Pause Control',
      'text_on'  => 'Yes',
      'text_off' => 'No', 
      'default'  => true,
      'class'     => 'panorama-readonly', 
      'dependency'   => array( array('control_show_hide_video', '==', '1') ,array('bppiv_type', '==', 'video') ),
    ),
    array(
      'id'       => 'video_play_pause_ctrl',
      'type'     => 'switcher',
      'title'    => 'Video  Play/Pause Control',
      'desc'     => 'Show or Hide Video Play/Pause Control',
      'text_on'  => 'Yes',
      'text_off' => 'No', 
      'default'  => true,
      'dependency'   => array( 
        array('bppiv_type', '==', 'video2') 
      ),
    ),
    array(
      'id'       => 'video_progress_ctrl',
      'type'     => 'switcher',
      'title'    => 'Progress Control',
      'desc'     => 'Show or Hide Progress Control',
      'text_on'  => 'Yes',
      'text_off' => 'No', 
      'default'  => true,
      'class'     => 'panorama-readonly', 
      'dependency'   => array( 
        array('bppiv_type', '==', 'video2') 
      ),
    ),
    array(
      'id'       => 'video_volume_ctrl',
      'type'     => 'switcher',
      'title'    => 'Volume Control',
      'desc'     => 'Show or Hide Volume Control',
      'text_on'  => 'Yes',
      'text_off' => 'No', 
      'default'  => true,
      'dependency'   => array( 
        array('bppiv_type', '==', 'video2') 
      ),
    ),
    array(
      'id'       => 'video2_fullscreen_ctrl',
      'type'     => 'switcher',
      'title'    => 'Fullscreen Control',
      'desc'     => 'Show or Hide Fullscreene Control',
      'text_on'  => 'Yes',
      'text_off' => 'No', 
      'default'  => false,
      'class'     => 'panorama-readonly', 
      'dependency'   => array( 
        array('bppiv_type', '==', 'video2')
      ),
    ),
    array(
      'id'       => 'video_remaining_time_ctrl',
      'type'     => 'switcher',
      'title'    => 'Remaining Time Control',
      'desc'     => 'Show or Hide Remaining Time Control',
      'text_on'  => 'Yes',
      'text_off' => 'No', 
      'default'  => false,
      'class'     => 'panorama-readonly', 
      'dependency'   => array( 
        array('bppiv_type', '==', 'video2') 
      ),
    ),
    array(
      'id'       => 'video_pip_ctrl',
      'type'     => 'switcher',
      'title'    => 'Picture in Picture Control',
      'desc'     => 'Show or Hide Picture in Picture Control',
      'text_on'  => 'Yes',
      'text_off' => 'No', 
      'default'  => false,
      'class'     => 'panorama-readonly', 
      'dependency'   => array( 
        array('bppiv_type', '==', 'video2') 
      ),
    ),
    array(
      'id'       => 'video_playback_speed_ctrl',
      'type'     => 'switcher',
      'title'    => 'Playback Speed Control',
      'desc'     => 'Show or Hide Playback Speed Control',
      'text_on'  => 'Yes',
      'text_off' => 'No', 
      'default'  => false,
      'class'     => 'panorama-readonly', 
      'dependency'   => array( 
        array('bppiv_type', '==', 'video2') 
      ),
    ),
    array(
      'id'       => 'title_author',
      'type'     => 'switcher',
      'title'    => 'Title & Author',
      'subtitle' => 'Display Title & Author Text. Default "No"',
      'desc'     => 'Show or Hide Title, Author Name',
      'class'     => 'panorama-readonly',  
      'text_on'  => 'Yes',
      'text_off' => 'No',
      'default'  => true,
      'dependency'   => array( 'bppiv_type', '==', 'image360' ),
    ),
    array(
      'id'       => 'title_360',
      'type'     => 'text',
      'title'    => 'Title',
      'subtitle' => 'Display Title Text.',
      'desc'     => 'Input Title Text',
      'class'     => 'panorama-readonly',  
      'placeholder' => "360° Image",
      'default' => "360° Panorama",
      'dependency'   => array( 'bppiv_type|title_author', '==|==', 'image360|1' ),
    ),
    array(
      'id'       => 'author_360',
      'type'     => 'text',
      'title'    => 'Author',
      'subtitle' => 'Display Author Name."',
      'desc'     => 'Input Author Name',
      'placeholder' => "bPlugins",
      'default' => '<a href="https://bplugins.com/">bPlugins</a>',
      'class'     => 'panorama-readonly',  
      'dependency'   => array( 'bppiv_type|title_author', '==|==', 'image360|1' ),
    ),
    array(
      'id'        => 'showByPrefix',
      'type'      => 'switcher',
      'title'     => '“by” Prefix',
      'subtitle'  => 'Show or Hide the “by” text before the author name.',
      'desc'      => 'Enable to show “by” before the author (e.g., by Alex Doe). Disable to hide it. Default is "Show".',
      'text_on'   => 'Yes',
      'text_off'  => 'No',
      'default'   => true,
      'class'     => 'panorama-readonly', 
      'dependency'=> array(
          array( 'bppiv_type', '==', 'image360' ),
          array( 'title_author', '==', '1' ),
          array( 'author_360', '!=', '' ),
      ),
  ),
  
  // Option 2: bppiv_type = tour360
  array(
      'id'        => 'tourShowByPrefix',
      'type'      => 'switcher',
      'title'     => '“by” Prefix',
      'subtitle'  => 'Show or Hide the “by” text before the author name.',
      'desc'      => 'Enable to show “by” before the author (e.g., by Alex Doe). Disable to hide it. Default is "Show".',
      'text_on'   => 'Yes',
      'text_off'  => 'No',
      'default'   => true,
      'class'     => 'panorama-readonly', 
      'dependency'=> array(
          array( 'bppiv_type', '==', 'tour360' ),
          array( 'tourTitleAuthor', '==', '1' ),
          array( 'author', '!=', '' ),
      ),
  ),
    array(
      'id'       => 'mouse_zoom',
      'type'     => 'switcher',
      'title'    => 'Mouse Zoom',
      'subtitle' => 'Disable/Enable Mouse Zoom. Default "Yes"',
      'desc'     => 'Show or Hide Mouse Zoom',
      'text_on'  => 'Yes',
      'text_off' => 'No',
      'default'  => true,
      'class'     => 'panorama-readonly', 
      'dependency'   => array( 'bppiv_type', 'any', 'image360,tour360' ),
    ),
    array(
      'id'       => 'disable_keyboard_ctrl',
      'type'     => 'switcher',
      'title'    => 'Disable Keyboard Control',
      'subtitle' => 'Disable/Enable Keyboard Control. Default "No"',
      'desc'     => 'Show or Hide Keyboard Control',
      'text_on'  => 'Yes',
      'text_off' => 'No',
      'default'  => false,
      'class'     => 'panorama-readonly', 
      'dependency'   => array( 'bppiv_type', 'any', 'image360,tour360' ),
    ),
    array(
      'id'       => 'double_click_zoom',
      'type'     => 'switcher',
      'title'    => 'Double Click Zoom',
      'subtitle' => 'Disable/Enable Double Click Zoom. Default "Yes"',
      'desc'     => 'Show or Hide Double Click Zoom',
      'text_on'  => 'Yes',
      'text_off' => 'No',
      'default'  => true,
      'class'     => 'panorama-readonly', 
      'dependency'   => array( 'bppiv_type', 'any', 'image360,tour360' ),
    ),
  )
) );


function bppiv_exclude_fields_before_save( $data ) {

$exclude = array(
  'bppiv_pan_gallery',
  'bppiv_gallery_limit',
  'loadMore_btn_text',
  'loadMore_text_color',
  'loadMore_btn_bg',
  'loadMore_hover_bg',
  'bppiv_pano_id',

);

foreach ( $exclude as $id ) {
unset( $data[$id] );
}

return $data;

}

add_filter( 'csf_sc__save', 'bppiv_exclude_fields_before_save', 10, 1 );