<?php
/** @noinspection PhpUnused */

namespace RM_PagBank\Object;

use JsonSerializable;

/**
 * Class TokenData
 * Containing the additional data of Flag Tokenization.
 * ⚠ Must be sent when a Credit or Debit Card Tokenized by Visa or Mastercard is used. ⚠
 *
 * @see https://dev.pagbank.uol.com.br/reference/criar-pagar-pedido-com-token-bandeira#gere-o-token-de-bandeira
 * @author    Ricardo Martins
 * @copyright 2023 Magenteiro
 * @package   RM_PagBank\Object
 */
class TokenData implements JsonSerializable
{
	//Who generated the Token (Token Requestor)
    protected string $requestor_id;

	//Wallet type that stored the Flag Token. (APPLE_PAY, GOOGLE_PAY, SAMSUNG_PAY, MERCHANT_TOKENIZATION_PROGRAM)
    protected string $wallet;

	//Cryptogram generated by the flag tokenization service.
    protected string $cryptogram;

	//Origin domain identifier of the transaction, commonly characterized in a reverse domain format.
	// Example: br.com.pagseguro
    protected string $ecommerce_domain;

	//Assurance level of the tokenized card.
    protected int $assurance_level;

    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return get_object_vars($this);
    }

    /**
     * @return string
     */
    public function getRequestorId(): string
    {
        return $this->requestor_id;
    }

    /**
     * @param string $requestor_id
     */
    public function setRequestorId(string $requestor_id): void
    {
        $this->requestor_id = $requestor_id;
    }

    /**
     * @return string
     */
    public function getWallet(): string
    {
        return $this->wallet;
    }

    /**
     * @param string $wallet
     */
    public function setWallet(string $wallet): void
    {
        $this->wallet = $wallet;
    }

    /**
     * @return string
     */
    public function getCryptogram(): string
    {
        return $this->cryptogram;
    }

    /**
     * @param string $cryptogram
     */
    public function setCryptogram(string $cryptogram): void
    {
        $this->cryptogram = $cryptogram;
    }

    /**
     * @return string
     */
    public function getEcommerceDomain(): string
    {
        return $this->ecommerce_domain;
    }

    /**
     * @param string $ecommerce_domain
     */
    public function setEcommerceDomain(string $ecommerce_domain): void
    {
        $this->ecommerce_domain = $ecommerce_domain;
    }

    /**
     * @return string
     */
    public function getAssuranceLevel(): int
    {
        return $this->assurance_level;
    }

    /**
     * @param string $assurance_level
     */
    public function setAssuranceLevel(int $assurance_level): void
    {
        $this->assurance_level = $assurance_level;
    }

}
