jQuery(document).ready(function ($) {
    window.ps_cc_bin = '';

    //region Encrypt card method
    /**
     * Encrypts the card and sets the encrypted card in the hidden input and window.ps_cc_* variables for number and cvv
     * @returns {boolean}
     */
    let encryptCard = function () {
        let cardHasChanged = (window.ps_cc_has_changed === true);
        console.debug('PagBank: encryptCard', cardHasChanged);
        let card, cc_number, cc_cvv;
        //replace trim and remove duplicated spaces from holder name
        let holder_name = jQuery('#rm-pagbank-card-holder-name').val().trim().replace(/\s+/g, ' '); //dupl spaces
        holder_name = holder_name.trim().replace(/[^A-Za-zÀ-ÖØ-öø-ÿ\s]/g, ''); //specials
        try {
            cc_number = cardHasChanged ? jQuery('#rm-pagbank-card-number').val().replace(/\s/g, '') : window.ps_cc_number;
            cc_cvv = cardHasChanged ? jQuery('#rm-pagbank-card-cvc').val().replace(/\s/g, '') : window.ps_cc_cvv;
            card = PagSeguro.encryptCard({
                publicKey: pagseguro_connect_public_key,
                holder: holder_name,
                number: cc_number,
                expMonth: jQuery('#rm-pagbank-card-expiry').val().split('/')[0].replace(/\s/g, ''),
                expYear: '20' + jQuery('#rm-pagbank-card-expiry').val().split('/')[1].slice(-2).replace(/\s/g, ''),
                securityCode: cc_cvv,
            });
        } catch (e) {
            alert("Erro ao criptografar o cartão.\nVerifique se os dados digitados estão corretos.");
            return false;
        }
        if (card.hasErrors) {
            let error_codes = [
            {code: 'INVALID_NUMBER', message: 'Número do cartão inválido'},
            {
                code: 'INVALID_SECURITY_CODE',
                message: 'CVV Inválido. Você deve passar um valor com 3, 4 ou mais dígitos.'
            },
            {
                code: 'INVALID_EXPIRATION_MONTH',
                message: 'Mês de expiração incorreto. Passe um valor entre 1 e 12.'
            },
            {code: 'INVALID_EXPIRATION_YEAR', message: 'Ano de expiração inválido.'},
            {code: 'INVALID_PUBLIC_KEY', message: 'Chave Pública inválida.'},
            {code: 'INVALID_HOLDER', message: 'Nome do titular do cartão inválido.'},
            ]
            //extract error message
            let error = '';
            for (let i = 0; i < card.errors.length; i++) {
                //loop through error codes to find the message
                for (let j = 0; j < error_codes.length; j++) {
                    if (error_codes[j].code === card.errors[i].code) {
                        error += error_codes[j].message + '\n';
                        break;
                    }
                }
            }
            alert('Erro ao criptografar cartão.\n' + error);
            throw new Error('Erro ao criptografar cartão');
            // return false;
        }
        
        jQuery('#rm-pagbank-card-encrypted').val(card.encryptedCard);
        // window.ps_cc_has_changed = false;
        // window.ps_cc_number = cc_number;
        // window.ps_cc_cvv = cc_cvv;
        return true;
    }
    //endregion
    
    /*region extending cards and card types from jqueryPayment to support new types*/
    const typesPagBank = [
    {
        title: 'MasterCard',
        type: 'mastercard',
        pattern: '^(?:5[1-5][0-9]{2}|222[1-9]|22[3-9][0-9]|2[3-6][0-9]{2}|27[01][0-9]|2720)[0-9]{12}$',
        gaps: [4, 8, 12],
        lengths: [16],
        code: {
            name: 'CVC',
            size: 3
        }
    },
    {
        title: 'American Express',
        type: 'amex',
        pattern: '^3([47]\\d*)?$',
        isAmex: true,
        gaps: [4, 10],
        lengths: [15],
        code: {
            name: 'CID',
            size: 4
        }
    },
    {
        title: 'Diners',
        type: 'dinnersclub',
        pattern: '^(3(0[0-5]|095|6|[8-9]))\\d*$',
        gaps: [4, 10],
        lengths: [14, 16, 17, 18, 19],
        code: {
            name: 'CVV',
            size: 3
        }
    },
    {
        title: 'Elo',
        type: 'elo',
        pattern: '^((451416)|(509091)|(636368)|(636297)|(504175)|(438935)|(40117[8-9])|(45763[1-2])|' +
            '(457393)|(431274)|(50990[0-2])|(5099[7-9][0-9])|(50996[4-9])|(509[1-8][0-9][0-9])|' +
            '(5090(0[0-2]|0[4-9]|1[2-9]|[24589][0-9]|3[1-9]|6[0-46-9]|7[0-24-9]))|' +
            '(5067(0[0-24-8]|1[0-24-9]|2[014-9]|3[0-379]|4[0-9]|5[0-3]|6[0-5]|7[0-8]))|' +
            '(6504(0[5-9]|1[0-9]|2[0-9]|3[0-9]))|' +
            '(6504(8[5-9]|9[0-9])|6505(0[0-9]|1[0-9]|2[0-9]|3[0-8]))|' +
            '(6505(4[1-9]|5[0-9]|6[0-9]|7[0-9]|8[0-9]|9[0-8]))|' +
            '(6507(0[0-9]|1[0-8]))|(65072[0-7])|(6509(0[1-9]|1[0-9]|20))|' +
            '(6516(5[2-9]|6[0-9]|7[0-9]))|(6550(0[0-9]|1[0-9]))|' +
            '(6550(2[1-9]|3[0-9]|4[0-9]|5[0-8])))\\d*$',
        gaps: [4, 8, 12],
        lengths: [16],
        code: {
            name: 'CVC',
            size: 3
        }
    },
    {
        title: 'Hipercard',
        type: 'hipercard',
        pattern: '^((606282)|(637095)|(637568)|(637599)|(637609)|(637612))\\d*$',
        gaps: [4, 8, 12],
        lengths: [13, 16],
        code: {
            name: 'CVC',
            size: 3
        }
    },
    {
        title: 'Aura',
        type: 'aura',
        pattern: '^5078\\d*$',
        gaps: [4, 8, 12],
        lengths: [19],
        code: {
            name: 'CVC',
            size: 3
        }
    }];

    //cardsFriendly is used only to allow setCardType to remove incorrect cards, but not to check the card
    const cardsFriendly = [
        {type: 'elo', patterns: [], length: [], cssLength: [], format: '', luhn: false},
        {type: 'aura', patterns: [], length: [], cssLength: [], format: '', luhn: false},
        {type: 'hipercard', patterns: [], length: [], cssLength: [], format: '', luhn: false},
    ]
    // jQuery.extend(jQuery.payment.cardsPagBank, typesPagBank);
    jQuery.extend(jQuery.payment.cards, cardsFriendly);

    // original method
    const originalCardType = jQuery.payment.cardType;

    // Extending the cardType method from jqueryPayment
    jQuery.extend(jQuery.payment, {
        cardType: function (num) {
            // Try to find in our card array
            let cardTypes = getCardTypes(num);
            if (cardTypes.length > 0) {
                return cardTypes[0].type;
            }

            // if we don't find, we return the original result
            return originalCardType.call(this, num);
        }
    });

    /**
     * Gets the credit card types from the card number
     * @param cardNumber
     * @returns {*|*[]}
     */
    let getCardTypes = function (cardNumber) {
        //remove spaces
        cardNumber = cardNumber.replace(/\s/g, '');
        let result = [];

        if (jQuery.isEmptyObject(cardNumber)) {
            return result;
        }

        // if (cardNumber === '') {
        //     return jQuery.extend(true, [], jQuery.payment.cardsPagBank);
        // }

        for (let i = 0; i < typesPagBank.length; i++) {
            let value = typesPagBank[i];
            if (new RegExp(value.pattern).test(cardNumber)) {
                result.push(jQuery.extend(true, {}, value));
            }
        }

        return result.slice(-1);
    }

    /*endregion*/


    jQuery(document.body).on('updated_checkout', function (e) {
        jQuery(document.body).trigger('update_installments');
    });

    //region 3ds authentication
    let isSubmitting = false;
    let checkoutFormIdentifiers = 'form.woocommerce-checkout, form#order_review, .wc-block-components-form, .wc-block-checkout__form, form#order_update, form#add_payment_method';
    if (!jQuery(checkoutFormIdentifiers).length) {
        console.debug('PagBank: checkout form not found');
        return true;
    }
    let originalSubmitHandler = () => {};
    // get the original submit handler for checkout or order-pay page
    if (jQuery._data(jQuery(checkoutFormIdentifiers)[0], "events") !== undefined) {
        let formCheckout = jQuery('form.woocommerce-checkout, form#order_review, form#order_update, form#add_payment_method')[0];
        let formEvents = jQuery._data(formCheckout, "events");
        
        if (formEvents && formEvents.submit) {
            originalSubmitHandler = formEvents.submit[0].handler;
        }
    }

    let pagBankSubmitHandler = async function (e) {
        console.debug('PagBank: submit');

        if (isSubmitting) {
            return true;
        }
        e.preventDefault();
        e.stopImmediatePropagation();

        if ((jQuery('#ps-connect-payment-cc').attr('disabled') !== undefined ||
            jQuery('#payment_method_rm-pagbank').is(':checked') === false) &&
            jQuery('input[name="payment_method"]:checked').val() !== 'rm-pagbank-cc') //when using standalone methods 
        {
            isSubmitting = true;
            jQuery(checkoutFormIdentifiers).on('submit', originalSubmitHandler);
            jQuery(checkoutFormIdentifiers).trigger('submit');
            return true;
        }

        const cc_payment_token = jQuery('input[name="wc-rm-pagbank-cc-payment-token"]:checked').val();
        if (cc_payment_token && cc_payment_token !== 'new') {
            console.debug('PagBank: cartão salvo selecionado, não criptografar.');
            isSubmitting = true;
            jQuery(checkoutFormIdentifiers).on('submit', originalSubmitHandler);
            jQuery(checkoutFormIdentifiers).trigger('submit');
            return true;
        }

        if (window.ps_cc_has_changed !== false) {
            console.debug('Pagbank: cartao mudou NOVO');
            let card_number = jQuery('#rm-pagbank-card-number').val();
            window.ps_cc_number = card_number.replace(/\s/g, '');
            window.ps_cc_cvv = jQuery('#rm-pagbank-card-cvc').val().replace(/\s/g, '');
        }

        if (encryptCard() === false) {
            return false;
        }

        let has3dSession = typeof pagseguro_connect_3d_session !== 'undefined' && pagseguro_connect_3d_session;
        let is3dsEnabled = pagseguro_connect_3ds_enabled;
        let isRetryEnabled = pagseguro_connect_3ds_retry_enabled;
        let canRetry = jQuery('#rm-pagbank-card-retry-with-3ds')?.is(':checked');

        // If 3ds and 3ds_retry is not enabled, continue
        if (!is3dsEnabled && !isRetryEnabled || !has3dSession) {
            isSubmitting = true;
            jQuery(checkoutFormIdentifiers).on('submit', originalSubmitHandler);
            jQuery(checkoutFormIdentifiers).trigger('submit');
            return true;
        }

        // If 3DS authorization has already occurred, proceed normally
        if (typeof pagbank3dAuthorized !== 'undefined' && pagbank3dAuthorized === true) {
            isSubmitting = true;
            jQuery(checkoutFormIdentifiers).on('submit', originalSubmitHandler);
            jQuery(checkoutFormIdentifiers).trigger('submit');
            return true;
        }

        if (isRetryEnabled && !canRetry && !is3dsEnabled) {
            isSubmitting = true;
            jQuery(checkoutFormIdentifiers).on('submit', originalSubmitHandler);
            jQuery(checkoutFormIdentifiers).trigger('submit');
            return true;
        }

        let selectedInstallments = jQuery('#rm-pagbank-card-installments').val();
        if (selectedInstallments === "" || selectedInstallments === undefined) {
            selectedInstallments = 1;
        }

        let cartTotal;
        if (typeof window.ps_cc_installments === 'undefined') {
            cartTotal = jQuery('.order-total bdi, .product-total bdi').last().html();
            cartTotal = cartTotal.replace(/[^0-9,]/g, '');
            cartTotal = Math.round(parseFloat(cartTotal.toString()).toFixed(2) * 100);
        } else {
            cartTotal = window.ps_cc_installments.find((installment, idx, installments)=> installments[idx].installments == selectedInstallments).total_amount_raw;
        }

        //if cart total is less than 100, don't continue with 3ds
        if (cartTotal < 100) {
            isSubmitting = true;
            jQuery(checkoutFormIdentifiers).on('submit', originalSubmitHandler);
            jQuery(checkoutFormIdentifiers).trigger('submit');
            return true;
        }

        //region 3ds authentication method
        PagSeguro.setUp({
            session: pagseguro_connect_3d_session,
            env: pagseguro_connect_environment,
        });

        var checkoutFormData = jQuery(this).serializeArray();
        // Convert the form data to an object
        var checkoutFormDataObj = {};
        jQuery.each(checkoutFormData, function (i, field) {
            checkoutFormDataObj[field.name] = field.value;
        });

        let expiryVal = jQuery('#rm-pagbank-card-expiry').val();

        let request = {
            data: {
                paymentMethod: {
                    type: 'CREDIT_CARD',
                    installments: selectedInstallments*1,
                    card: {
                        number: window.ps_cc_number || jQuery('#rm-pagbank-card-number').val().replace(/\s/g, ''),
                        expMonth: jQuery('#rm-pagbank-card-expiry').val().split('/')[0].replace(/\s/g, ''),
                        expYear: expiryVal.includes('/') ? '20' + expiryVal.split('/')[1].slice(-2).replace(/\s/g, '') : '',
                        holder: {
                            name: jQuery('#rm-pagbank-card-holder-name').val().trim().replace(/\s+/g, ' ').replace(/[^A-Za-zÀ-ÖØ-öø-ÿ\s]/g, '')
                        }
                    }
                },
                dataOnly: false
            }
        }
        
        let customerName = checkoutFormDataObj['billing_first_name'] + ' ' + checkoutFormDataObj['billing_last_name'];
        customerName = customerName.trim().replace(/\s+/g, ' '); //removing duplicated spaces in the middle
        customerName = customerName.replace(/[^A-Za-zÀ-ÖØ-öø-ÿ\s]/g, '').replace(/\s+/g, ' '); //removing specials
        var billing_phone = checkoutFormDataObj['billing_cellphone']?.length ? checkoutFormDataObj['billing_cellphone'] : checkoutFormDataObj['billing_phone'] ?? null;

        if (!billing_phone) {
          const phones = typeof pagBankOrderDetails !== 'undefined' ? pagBankOrderDetails?.data?.customer?.phones : [];
          // If no phone is provided in the form, try to get it from the order details
          if (Array.isArray(phones) && phones.length > 0) {
            // ordem manual (pay_for_order)
            const { area, number } = phones[0];
            billing_phone = area + number;
          }

          if (!billing_phone) {
            alert(
              "Por favor, preencha o campo Telefone ou Celular para continuar com o pagamento."
            );
            return false;
          }
        }
        
        let orderData = typeof pagBankOrderDetails !== 'undefined'
            ? pagBankOrderDetails.data //if order-pay page
            : { //if checkout page get from form fields
                customer: {
                    name: customerName,
                    email: checkoutFormDataObj['billing_email'],
                    phones: [
                        {
                            country: '55',
                            area: billing_phone.replace(/\D/g, '').substring(0, 2),
                            number: billing_phone.replace(/\D/g, '').substring(2),
                            type: 'MOBILE'
                    }]
                },
                amount: {
                    value: cartTotal,
                    currency: 'BRL'
                },
                billingAddress: {
                    street: checkoutFormDataObj['billing_address_1'] ? checkoutFormDataObj['billing_address_1'].replace(/\s+/g, ' ') : 'Rua não informada',
                    number: checkoutFormDataObj['billing_number'] ? checkoutFormDataObj['billing_number'].replace(/\s+/g, ' ') : 'n/d',
                    complement: checkoutFormDataObj['billing_neighborhood'] ? checkoutFormDataObj['billing_neighborhood'].replace(/\s+/g, ' ') : 'n/d',
                    regionCode: checkoutFormDataObj['billing_state'] ? checkoutFormDataObj['billing_state'].replace(/\s+/g, ' ').toUpperCase() : 'SP',
                    country: 'BRA',
                    city: checkoutFormDataObj['billing_city'] ? checkoutFormDataObj['billing_city'].replace(/\s+/g, ' ') : 'n/d',
                    postalCode: checkoutFormDataObj['billing_postcode'] ? checkoutFormDataObj['billing_postcode'].replace(/\D+/g, '') : '00000000'
                }
        };

        request.data = {
            ...request.data,
            ...orderData
        };
        
        console.debug('PagBank 3DS Request Amount: ' + request.data.amount.value);
        //disable place order button
        jQuery('.woocommerce-checkout-payment, .woocommerce-checkout-review-order-table, form#order_review').block({
            message: 'Autenticação 3D em andamento',
            overlayCSS: {
                background: '#fff',
                opacity: 0.6
            },
            css: {border: 0}
        });

        PagSeguro.authenticate3DS(request).then(result => {
            switch (result.status) {
                case 'CHANGE_PAYMENT_METHOD':
                    // The user must change the payment method used
                    alert('Pagamento negado pelo PagBank. Escolha outro método de pagamento ou cartão.');
                    jQuery('.woocommerce-checkout-payment, .woocommerce-checkout-review-order-table').unblock();
                    return false;
                case 'AUTH_FLOW_COMPLETED':
                    //O processo de autenticação foi realizado com sucesso, dessa forma foi gerado um id do 3DS que poderá ter o resultado igual a Autenticado ou Não Autenticado.
                    if (result.authenticationStatus === 'AUTHENTICATED') {
                        //O cliente foi autenticado com sucesso, dessa forma o pagamento foi autorizado.
                        jQuery('#rm-pagbank-card-3d').val(result.id);
                        console.debug('PagBank: 3DS Autenticado ou Sem desafio');
                        pagbank3dAuthorized = true;
                        jQuery('.woocommerce-checkout-payment, .woocommerce-checkout-review-order-table').unblock();
                        isSubmitting = true;
                        jQuery('form.woocommerce-checkout, form#order_review').on('submit', originalSubmitHandler);
                        jQuery('form.woocommerce-checkout, form#order_review').trigger('submit');
                        return true;
                    }
                    alert('Autenticação 3D falhou. Tente novamente.');
                    pagbank3dAuthorized = false;
                    jQuery('.woocommerce-checkout-payment, .woocommerce-checkout-review-order-table').unblock();
                    return false;
                case 'AUTH_NOT_SUPPORTED':
                    //A autenticação 3DS não ocorreu, isso pode ter ocorrido por falhas na comunicação com emissor ou bandeira, ou algum controle que não possibilitou a geração do 3DS id, essa transação não terá um retorno de status de autenticação e seguirá como uma transação sem 3DS.
                    //O cliente pode seguir adiante sem 3Ds (exceto débito)
                    if (pagseguro_connect_cc_3ds_allow_continue === 'yes') {
                        console.debug('PagBank: 3DS não suportado pelo cartão. Continuando sem 3DS.');
                        pagbank3dAuthorized = true;
                        jQuery('.woocommerce-checkout-payment, .woocommerce-checkout-review-order-table').unblock();

                        isSubmitting = true;
                        jQuery('form.woocommerce-checkout, form#order_review').on('submit', originalSubmitHandler);
                        jQuery('form.woocommerce-checkout, form#order_review').trigger('submit');
                        return true;
                    }
                    alert('Seu cartão não suporta autenticação 3D. Escolha outro método de pagamento ou cartão.');
                    jQuery('.woocommerce-checkout-payment, .woocommerce-checkout-review-order-table').unblock();
                    return false;
                case 'REQUIRE_CHALLENGE':
                    //É um status intermediário que é retornando em casos que o banco emissor solicita desafios, é importante para identificar que o desafio deve ser exibido.
                    console.debug('PagBank: REQUIRE_CHALLENGE - O desafio está sendo exibido pelo banco.');
                    break;
            }
        }).catch((err) => {
            if (err instanceof PagSeguro.PagSeguroError ) {
                console.error(err);
                console.debug('PagBank: ' + err.detail);
                let errMsgs = err.detail.errorMessages.map(error => pagBankParseErrorMessage(error)).join('\n');
                alert('Falha na requisição de autenticação 3D.\n' + errMsgs);
                jQuery('.woocommerce-checkout-payment, .woocommerce-checkout-review-order-table').unblock();
                return false;
            }
        })
        //endregion

        return false;
    }
    
    jQuery(checkoutFormIdentifiers).off('submit');
    jQuery(checkoutFormIdentifiers).on('submit', pagBankSubmitHandler);
    
    
    //endregion

    jQuery(checkoutFormIdentifiers).off('checkout_place_order').on('checkout_place_order', async function (e) {
        console.debug('PagBank: checkout_place_order');
        
        const cc_payment_token = jQuery('input[name="wc-rm-pagbank-cc-payment-token"]:checked').val();
        //if not pagseguro connect or not credit card, return
        if ((jQuery('#ps-connect-payment-cc').attr('disabled') !== undefined ||
            jQuery('#payment_method_rm-pagbank').is(':checked') === false) &&
            jQuery('input[name="payment_method"]:checked').val() !== 'rm-pagbank-cc' ||
            (cc_payment_token && cc_payment_token !== 'new')) //when using standalone methods
        {
            return true;
        }
        

         /*region Encrypt card and obfuscates before submit*/
        if (encryptCard() === false) {
            return;
        }

        //obfuscates cvv
        // saves in window the card number and cvv, so we can reuse it if the first attempt fails for some reason
        // pagbank requires a new encryption for each attempt, and we don't want to ask the customer to type again
        if (window.ps_cc_has_changed !== false) {
            let card_number = jQuery('#rm-pagbank-card-number').val();
            window.ps_cc_number = card_number.replace(/\s/g, '');
            window.ps_cc_cvv = jQuery('#rm-pagbank-card-cvc').val().replace(/\s/g, '');
    
            jQuery('#rm-pagbank-card-cvc').val('***');
            //obfuscates card number between 8th and last 4 digits
            let obfuscated_card_number = '';
            for (let i = 0; i < card_number.length; i++) {
                if (i > 6 && i < card_number.length - 4)
                    obfuscated_card_number += '*';
                else
                    obfuscated_card_number += card_number[i];
            }
            jQuery('#rm-pagbank-card-number').val(obfuscated_card_number);
            window.ps_cc_has_changed = false;
        }
        /*endregion*/
        
        isSubmitting = false;
    });

    
});

// jQuery(document.body).on('init_checkout', ()=>{
    jQuery(document).on('keyup change paste', '#rm-pagbank-card-number', (e)=>{
        window.ps_cc_has_changed = true;
        if ('undefined' !== typeof pagseguro_connect_3d_session) {
            pagbank3dAuthorized = false;
        }
        let cardNumber = jQuery(e.target).val();
        let ccBin = cardNumber.replace(/\s/g, '').substring(0, 6);
        if (ccBin !== window.ps_cc_bin && ccBin.length === 6 && !pagseguro_connect_change_card_page) {
            window.ps_cc_bin = ccBin;
            jQuery(document.body).trigger('update_installments');
        }
    });
    jQuery(document).on('keyup change paste', '#rm-pagbank-card-cvc', (e)=>{
        window.ps_cc_has_changed = true;
    });
    jQuery(document).on('input change paste', '#rm-pagbank-card-holder-name', (e)=>{
        jQuery(e.target).val(jQuery(e.target).val().toUpperCase());
    });
    
    // CPF/CNPJ formatting
    jQuery(document).on('input change paste', '#rm-pagbank-card-cpf-cnpj', (e)=>{
        let value = jQuery(e.target).val().replace(/[^0-9]/g, '');
        let formattedValue = '';
        
        if (value.length <= 11) {
            // CPF format: 000.000.000-00
            formattedValue = value.replace(/(\d{3})(\d{3})(\d{3})(\d{2})/, '$1.$2.$3-$4');
        } else {
            // CNPJ format: 00.000.000/0000-00
            formattedValue = value.replace(/(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/, '$1.$2.$3/$4-$5');
        }
        
        jQuery(e.target).val(formattedValue);
    });
// });

    jQuery(document.body).on('update_installments', (event, selector_installments = '#rm-pagbank-card-installments')=> {
        //if success, update the installments select with the response
        //if error, show error message
        let ccBin = typeof window.ps_cc_bin === 'undefined' || window.ps_cc_bin.replace(/[^0-9]/g, '').length < 6 ? '555566' : window.ps_cc_bin;
        let total = jQuery('.order-total bdi, .product-total bdi, .wc-block-components-totals-item__value').last().html();
        //extract amount from total, removing html elements
        total = total.replace(/<[^>]*>?/gm, '');
        //remove ,
        total = total.replace(/,/g, '');
        //replace , with .
        total = total.replace(/\./g, ',');
        //remove non numbers and . ,
        total = total.replace(/[^0-9,]/g, '');
    
    
        //convert to cents
        let orderTotal = parseFloat(total).toFixed(2) * 100;
        if (orderTotal < 100) {
            let select = jQuery(selector_installments);
            select.parent().hide();
            return;
        }
        // let maxInstallments = jQuery('#rm-pagbank-card-installments').attr('max_installments');
        let url = ajax_object.ajax_url;
        let encryptedOrderId = typeof pagBankOrderDetails !== 'undefined' ?
            pagBankOrderDetails?.encryptedOrderId : null;
        jQuery.ajax({
            url: url,
            method: 'POST',
            data: {
                cc_bin: ccBin,
                nonce: rm_pagbank_nonce,
                action: 'ps_get_installments',
                order_id: encryptedOrderId,
            },
            success: (response)=>{
                let select = jQuery(selector_installments);
                select.empty();
                let found = false;
                let previouslySelected = window.ps_cc_selected_installment || jQuery(selector_installments).val();
                for (let i = 0; i < response.length; i++) {
                    let option = jQuery('<option></option>');
                    option.attr('value', response[i].installments);
                    let text = response[i].installments + 'x de R$ ' + response[i].installment_amount;
                    let additional_text = ' (sem juros)';
                    if (response[i].interest_free === false)
                        additional_text = ' (Total R$ ' + response[i].total_amount + ')';
    
                    option.text(text + additional_text);
                    select.append(option);
                    if (previouslySelected == response[i].installments) {
                        found = true;
                    }
                }
                window.ps_cc_installments = response;

                // if previously selected installment is found, select it
                if (found) {
                    select.val(previouslySelected);
                } else if (response?.length > 0 && typeof window.ps_cc_selected_installment !== 'undefined') {
                    // If the previously selected installment is not found, select the last one
                    select.val(response[response.length-1].installments);
                }
            },
            error: (response)=>{
                alert('Erro ao calcular parcelas. Verifique os dados do cartão e tente novamente.');
                console.info('Lojista: Verifique os logs em WooCommerce > Status > Logs ' +
                    'para ver os possíveis problemas na obtenção das parcelas. Note que cartões de teste falharão ' +
                    'na maioria dos casos.');
            }
        });
    });

jQuery(document.body).on('checkout_error', function(event, error_data) {
    let method = jQuery('input[name="payment_method"]:checked').val();
    if (error_data.includes('Vamos tentar com validação 3DS') && method === 'rm-pagbank-cc') {
        const retry3dsInput = '<div class="rm-pagbank-retry-select">' +
            '<input type="checkbox" id="rm-pagbank-card-retry-with-3ds" class="rm-pagbank-checkbox" name="rm-pagbank-card-retry-with-3ds" value="1" checked>' +
            '<label for="rm-pagbank-card-retry-with-3ds">Tentar novamente com Validação 3DS</label>' +
            '</div>';

        const rmPagbankCcForm = jQuery('#wc-rm-pagbank-cc-form');
        if (rmPagbankCcForm.find('.rm-pagbank-retry-select').length > 0) {
            jQuery('#rm-pagbank-card-retry-with-3ds').prop('checked', true);
            return;
        }

        rmPagbankCcForm.prepend(retry3dsInput);
    }
});

jQuery(document).on("change", "#rm-pagbank-card-installments, #rm-pagbank-card-installments-token", function () {
  window.ps_cc_selected_installment = jQuery(this).val();
});

jQuery(function($){
    function togglePagBankFields() {
        var selected = $('input[name="wc-rm-pagbank-cc-payment-token"]:checked').val();
        if (selected !== 'new') {
            var bin = jQuery(this).data('cc-bin');
            if (bin) {
                window.ps_cc_bin = bin.toString();
                jQuery(document.body).trigger('update_installments', '#rm-pagbank-card-installments-token');
            }
        }
        return selected && selected !== 'new' ?  $('#rm-pagbank-installments-token').show() : $('#rm-pagbank-installments-token').hide();
    }
    $(document).on('change', 'input[name="wc-rm-pagbank-cc-payment-token"]', togglePagBankFields);
    togglePagBankFields();
});