<?php
/*
 * PagarmeCoreApiLib
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace PagarmeCoreApiLib\Models;

use JsonSerializable;

/**
 *Updates the default bank account for a recipient
 */
class UpdateRecipientBankAccountRequest implements JsonSerializable
{
    /**
     * Bank account
     * @required
     * @maps bank_account
     * @var \PagarmeCoreApiLib\Models\CreateBankAccountRequest $bankAccount public property
     */
    public $bankAccount;

    /**
     * Payment mode
     * @required
     * @maps payment_mode
     * @var string $paymentMode public property
     */
    public $paymentMode;

    /**
     * Constructor to set initial or default values of member properties
     * @param CreateBankAccountRequest $bankAccount Initialization value for $this->bankAccount
     * @param string                   $paymentMode Initialization value for $this->paymentMode
     */
    public function __construct()
    {
        switch (func_num_args()) {
            case 2:
                $this->bankAccount = func_get_arg(0);
                $this->paymentMode = func_get_arg(1);
                break;

            default:
                $this->paymentMode = 'bank_transfer';
                break;
        }
    }


    /**
     * Encode this object to JSON
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        $json = array();
        $json['bank_account'] = $this->bankAccount;
        $json['payment_mode'] = $this->paymentMode;

        return $json;
    }
}
