<?php
/*
 * PagarmeCoreApiLib
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace PagarmeCoreApiLib\Models;

use JsonSerializable;
use PagarmeCoreApiLib\Utils\DateTimeHelper;

/**
 * @todo Write general description for this model
 */
class GetTransfer implements JsonSerializable
{
    /**
     * @todo Write general description for this property
     * @required
     * @var string $id public property
     */
    public $id;

    /**
     * @todo Write general description for this property
     * @required
     * @maps gateway_id
     * @var string $gatewayId public property
     */
    public $gatewayId;

    /**
     * @todo Write general description for this property
     * @required
     * @var integer $amount public property
     */
    public $amount;

    /**
     * @todo Write general description for this property
     * @required
     * @var string $status public property
     */
    public $status;

    /**
     * @todo Write general description for this property
     * @required
     * @maps created_at
     * @factory \PagarmeCoreApiLib\Utils\DateTimeHelper::fromRfc3339DateTime
     * @var \DateTime $createdAt public property
     */
    public $createdAt;

    /**
     * @todo Write general description for this property
     * @required
     * @maps updated_at
     * @factory \PagarmeCoreApiLib\Utils\DateTimeHelper::fromRfc3339DateTime
     * @var \DateTime $updatedAt public property
     */
    public $updatedAt;

    /**
     * @todo Write general description for this property
     * @var array|null $metadata public property
     */
    public $metadata;

    /**
     * @todo Write general description for this property
     * @var integer|null $fee public property
     */
    public $fee;

    /**
     * @todo Write general description for this property
     * @maps funding_date
     * @factory \PagarmeCoreApiLib\Utils\DateTimeHelper::fromRfc3339DateTime
     * @var \DateTime|null $fundingDate public property
     */
    public $fundingDate;

    /**
     * @todo Write general description for this property
     * @maps funding_estimated_date
     * @factory \PagarmeCoreApiLib\Utils\DateTimeHelper::fromRfc3339DateTime
     * @var \DateTime|null $fundingEstimatedDate public property
     */
    public $fundingEstimatedDate;

    /**
     * @todo Write general description for this property
     * @required
     * @var string $type public property
     */
    public $type;

    /**
     * @todo Write general description for this property
     * @required
     * @var \PagarmeCoreApiLib\Models\GetTransferSourceResponse $source public property
     */
    public $source;

    /**
     * @todo Write general description for this property
     * @required
     * @var \PagarmeCoreApiLib\Models\GetTransferTargetResponse $target public property
     */
    public $target;

    /**
     * Constructor to set initial or default values of member properties
     * @param string                     $id                   Initialization value for $this->id
     * @param string                     $gatewayId            Initialization value for $this->gatewayId
     * @param integer                    $amount               Initialization value for $this->amount
     * @param string                     $status               Initialization value for $this->status
     * @param \DateTime                  $createdAt            Initialization value for $this->createdAt
     * @param \DateTime                  $updatedAt            Initialization value for $this->updatedAt
     * @param array                      $metadata             Initialization value for $this->metadata
     * @param integer                    $fee                  Initialization value for $this->fee
     * @param \DateTime                  $fundingDate          Initialization value for $this->fundingDate
     * @param \DateTime                  $fundingEstimatedDate Initialization value for $this->fundingEstimatedDate
     * @param string                     $type                 Initialization value for $this->type
     * @param GetTransferSourceResponse  $source               Initialization value for $this->source
     * @param GetTransferTargetResponse  $target               Initialization value for $this->target
     */
    public function __construct()
    {
        if (13 == func_num_args()) {
            $this->id                   = func_get_arg(0);
            $this->gatewayId            = func_get_arg(1);
            $this->amount               = func_get_arg(2);
            $this->status               = func_get_arg(3);
            $this->createdAt            = func_get_arg(4);
            $this->updatedAt            = func_get_arg(5);
            $this->metadata             = func_get_arg(6);
            $this->fee                  = func_get_arg(7);
            $this->fundingDate          = func_get_arg(8);
            $this->fundingEstimatedDate = func_get_arg(9);
            $this->type                 = func_get_arg(10);
            $this->source               = func_get_arg(11);
            $this->target               = func_get_arg(12);
        }
    }


    /**
     * Encode this object to JSON
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        $json = array();
        $json['id']                     = $this->id;
        $json['gateway_id']             = $this->gatewayId;
        $json['amount']                 = $this->amount;
        $json['status']                 = $this->status;
        $json['created_at']             = DateTimeHelper::toRfc3339DateTime($this->createdAt);
        $json['updated_at']             = DateTimeHelper::toRfc3339DateTime($this->updatedAt);
        $json['metadata']               = $this->metadata;
        $json['fee']                    = $this->fee;
        $json['funding_date']           = isset($this->fundingDate) ?
            DateTimeHelper::toRfc3339DateTime($this->fundingDate) : null;
        $json['funding_estimated_date'] = isset($this->fundingEstimatedDate) ?
            DateTimeHelper::toRfc3339DateTime($this->fundingEstimatedDate) : null;
        $json['type']                   = $this->type;
        $json['source']                 = $this->source;
        $json['target']                 = $this->target;

        return $json;
    }
}
