<?php
/*
 * PagarmeCoreApiLib
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace PagarmeCoreApiLib\Models;

use JsonSerializable;
use PagarmeCoreApiLib\Utils\DateTimeHelper;

/**
 *Checkout pix payment response
 */
class GetCheckoutPixPaymentResponse implements JsonSerializable
{
    /**
     * Expires at
     * @required
     * @maps expires_at
     * @factory \PagarmeCoreApiLib\Utils\DateTimeHelper::fromRfc3339DateTime
     * @var \DateTime $expiresAt public property
     */
    public $expiresAt;

    /**
     * Additional information
     * @required
     * @maps additional_information
     * @var \PagarmeCoreApiLib\Models\PixAdditionalInformation[] $additionalInformation public property
     */
    public $additionalInformation;

    /**
     * Constructor to set initial or default values of member properties
     * @param \DateTime $expiresAt             Initialization value for $this->expiresAt
     * @param array     $additionalInformation Initialization value for $this->additionalInformation
     */
    public function __construct()
    {
        if (2 == func_num_args()) {
            $this->expiresAt             = func_get_arg(0);
            $this->additionalInformation = func_get_arg(1);
        }
    }


    /**
     * Encode this object to JSON
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        $json = array();
        $json['expires_at']             = DateTimeHelper::toRfc3339DateTime($this->expiresAt);
        $json['additional_information'] = $this->additionalInformation;

        return $json;
    }
}
