<?php
/*
 * PagarmeCoreApiLib
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace PagarmeCoreApiLib\Models;

use JsonSerializable;

/**
 *Checkout Payment Settings Response
 */
class GetCheckoutPaymentSettingsResponse implements JsonSerializable
{
    /**
     * Success Url
     * @required
     * @maps success_url
     * @var string $successUrl public property
     */
    public $successUrl;

    /**
     * Payment Url
     * @required
     * @maps payment_url
     * @var string $paymentUrl public property
     */
    public $paymentUrl;

    /**
     * Accepted Payment Methods
     * @required
     * @maps accepted_payment_methods
     * @var array $acceptedPaymentMethods public property
     */
    public $acceptedPaymentMethods;

    /**
     * Status
     * @required
     * @var string $status public property
     */
    public $status;

    /**
     * Customer
     * @var \PagarmeCoreApiLib\Models\GetCustomerResponse|null $customer public property
     */
    public $customer;

    /**
     * Payment amount
     * @var integer|null $amount public property
     */
    public $amount;

    /**
     * Default Payment Method
     * @maps default_payment_method
     * @var string|null $defaultPaymentMethod public property
     */
    public $defaultPaymentMethod;

    /**
     * Gateway Affiliation Id
     * @maps gateway_affiliation_id
     * @var string|null $gatewayAffiliationId public property
     */
    public $gatewayAffiliationId;

    /**
     * Constructor to set initial or default values of member properties
     * @param string              $successUrl             Initialization value for $this->successUrl
     * @param string              $paymentUrl             Initialization value for $this->paymentUrl
     * @param array               $acceptedPaymentMethods Initialization value for $this->acceptedPaymentMethods
     * @param string              $status                 Initialization value for $this->status
     * @param GetCustomerResponse $customer               Initialization value for $this->customer
     * @param integer             $amount                 Initialization value for $this->amount
     * @param string              $defaultPaymentMethod   Initialization value for $this->defaultPaymentMethod
     * @param string              $gatewayAffiliationId   Initialization value for $this->gatewayAffiliationId
     */
    public function __construct()
    {
        if (8 == func_num_args()) {
            $this->successUrl             = func_get_arg(0);
            $this->paymentUrl             = func_get_arg(1);
            $this->acceptedPaymentMethods = func_get_arg(2);
            $this->status                 = func_get_arg(3);
            $this->customer               = func_get_arg(4);
            $this->amount                 = func_get_arg(5);
            $this->defaultPaymentMethod   = func_get_arg(6);
            $this->gatewayAffiliationId   = func_get_arg(7);
        }
    }


    /**
     * Encode this object to JSON
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        $json = array();
        $json['success_url']              = $this->successUrl;
        $json['payment_url']              = $this->paymentUrl;
        $json['accepted_payment_methods'] = $this->acceptedPaymentMethods;
        $json['status']                   = $this->status;
        $json['customer']                 = $this->customer;
        $json['amount']                   = $this->amount;
        $json['default_payment_method']   = $this->defaultPaymentMethod;
        $json['gateway_affiliation_id']   = $this->gatewayAffiliationId;

        return $json;
    }
}
