<?php
/*
 * PagarmeCoreApiLib
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace PagarmeCoreApiLib\Models;

use JsonSerializable;

/**
 *Request for creating a recipient
 */
class CreateRecipientRequest implements JsonSerializable
{
    /**
     * Default Bank Account
     * @required
     * @maps default_bank_account
     * @var array $defaultBankAccount public property
     */
    public $defaultBankAccount;
    /**
     * Transfer Settings
     * @required
     * @maps transfer_settings
     * @var CreateTransferSettingsRequest $transferSettings public property
     */
    public $transferSettings;

    /**
     * Automatic Anticipation Settings
     * @required
     * @maps automatic_anticipation_settings
     * @var array|null|mixed $automaticAnticipationSettings public property
     */
    public $automaticAnticipationSettings;
    /**
     * Register Information
     * @required
     * @maps register_information
     * @var CreateRegisterInformationBaseRequest
     */
    public $registerInformation;
    /**
     * Code
     * @required
     * @maps code
     * @var string $code public property
     */
    public $code;


    /**
     * @param CreateBankAccountRequest $defaultBankAccount
     * @param null|CreateTransferSettingsRequest $transferSettings
     * @param array|null|mixed $automaticAnticipationSettings
     * @param CreateRegisterInformationBaseRequest $registerInformation
     * @param string $code
     */
    public function __construct(
        CreateBankAccountRequest $defaultBankAccount,
        $transferSettings,
        $automaticAnticipationSettings,
        CreateRegisterInformationBaseRequest $registerInformation,
        $code
    ) {
        $this->defaultBankAccount = $defaultBankAccount;
        $this->transferSettings = $transferSettings;
        $this->automaticAnticipationSettings = $automaticAnticipationSettings;
        $this->registerInformation = $registerInformation;
        $this->code = $code;
    }
    
    /**
     * Encode this object to JSON
     * @return array
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize()
    {
        $json = [];
        $json['default_bank_account']               = $this->defaultBankAccount;
        $json['transfer_settings']                  = $this->transferSettings;
        $json['automatic_anticipation_settings']    = $this->automaticAnticipationSettings;
        $json['register_information']               = $this->registerInformation;
        $json['code']                               = $this->code;

        return $json;
    }
}
