<?php
/*
 * PagarmeCoreApiLib
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace PagarmeCoreApiLib\Models;

use JsonSerializable;

/**
 *Checkout payment request
 */
class CreateCheckoutPaymentRequest implements JsonSerializable
{
    /**
     * Accepted Payment Methods
     * @required
     * @maps accepted_payment_methods
     * @var array $acceptedPaymentMethods public property
     */
    public $acceptedPaymentMethods;

    /**
     * Accepted Multi Payment Methods
     * @required
     * @maps accepted_multi_payment_methods
     * @var array $acceptedMultiPaymentMethods public property
     */
    public $acceptedMultiPaymentMethods;

    /**
     * Success url
     * @required
     * @maps success_url
     * @var string $successUrl public property
     */
    public $successUrl;

    /**
     * Default payment method
     * @maps default_payment_method
     * @var string|null $defaultPaymentMethod public property
     */
    public $defaultPaymentMethod;

    /**
     * Gateway Affiliation Id
     * @maps gateway_affiliation_id
     * @var string|null $gatewayAffiliationId public property
     */
    public $gatewayAffiliationId;

    /**
     * Credit Card payment request
     * @maps credit_card
     * @var \PagarmeCoreApiLib\Models\CreateCheckoutCreditCardPaymentRequest|null $creditCard public property
     */
    public $creditCard;

    /**
     * Debit Card payment request
     * @maps debit_card
     * @var \PagarmeCoreApiLib\Models\CreateCheckoutDebitCardPaymentRequest|null $debitCard public property
     */
    public $debitCard;

    /**
     * Boleto payment request
     * @var \PagarmeCoreApiLib\Models\CreateCheckoutBoletoPaymentRequest|null $boleto public property
     */
    public $boleto;

    /**
     * Customer is editable?
     * @maps customer_editable
     * @var bool|null $customerEditable public property
     */
    public $customerEditable;

    /**
     * Time in minutes for expiration
     * @maps expires_in
     * @var integer|null $expiresIn public property
     */
    public $expiresIn;

    /**
     * Skip postpay success screen?
     * @required
     * @maps skip_checkout_success_page
     * @var bool $skipCheckoutSuccessPage public property
     */
    public $skipCheckoutSuccessPage;

    /**
     * Billing Address is editable?
     * @required
     * @maps billing_address_editable
     * @var bool $billingAddressEditable public property
     */
    public $billingAddressEditable;

    /**
     * Billing Address
     * @required
     * @maps billing_address
     * @var \PagarmeCoreApiLib\Models\CreateAddressRequest $billingAddress public property
     */
    public $billingAddress;

    /**
     * Bank Transfer payment request
     * @maps bank_transfer
     * @var \PagarmeCoreApiLib\Models\CreateCheckoutBankTransferRequest|null $bankTransfer public property
     */
    public $bankTransfer;

    /**
     * Accepted Brands
     * @required
     * @maps accepted_brands
     * @var array $acceptedBrands public property
     */
    public $acceptedBrands;

    /**
     * Pix payment request
     * @var \PagarmeCoreApiLib\Models\CreateCheckoutPixPaymentRequest|null $pix public property
     */
    public $pix;

    /**
     * Constructor to set initial or default values of member properties
     * @param array                                  $acceptedPaymentMethods      Initialization value for $this-
     *                                                                              >acceptedPaymentMethods
     * @param array                                  $acceptedMultiPaymentMethods Initialization value for $this-
     *                                                                              >acceptedMultiPaymentMethods
     * @param string                                 $successUrl                  Initialization value for $this-
     *                                                                              >successUrl
     * @param string                                 $defaultPaymentMethod        Initialization value for $this-
     *                                                                              >defaultPaymentMethod
     * @param string                                 $gatewayAffiliationId        Initialization value for $this-
     *                                                                              >gatewayAffiliationId
     * @param CreateCheckoutCreditCardPaymentRequest $creditCard                  Initialization value for $this-
     *                                                                              >creditCard
     * @param CreateCheckoutDebitCardPaymentRequest  $debitCard                   Initialization value for $this-
     *                                                                              >debitCard
     * @param CreateCheckoutBoletoPaymentRequest     $boleto                      Initialization value for $this-
     *                                                                              >boleto
     * @param bool                                   $customerEditable            Initialization value for $this-
     *                                                                              >customerEditable
     * @param integer                                $expiresIn                   Initialization value for $this-
     *                                                                              >expiresIn
     * @param bool                                   $skipCheckoutSuccessPage     Initialization value for $this-
     *                                                                              >skipCheckoutSuccessPage
     * @param bool                                   $billingAddressEditable      Initialization value for $this-
     *                                                                              >billingAddressEditable
     * @param CreateAddressRequest                   $billingAddress              Initialization value for $this-
     *                                                                              >billingAddress
     * @param CreateCheckoutBankTransferRequest      $bankTransfer                Initialization value for $this-
     *                                                                              >bankTransfer
     * @param array                                  $acceptedBrands              Initialization value for $this-
     *                                                                              >acceptedBrands
     * @param CreateCheckoutPixPaymentRequest        $pix                         Initialization value for $this->pix
     */
    public function __construct()
    {
        if (16 == func_num_args()) {
            $this->acceptedPaymentMethods      = func_get_arg(0);
            $this->acceptedMultiPaymentMethods = func_get_arg(1);
            $this->successUrl                  = func_get_arg(2);
            $this->defaultPaymentMethod        = func_get_arg(3);
            $this->gatewayAffiliationId        = func_get_arg(4);
            $this->creditCard                  = func_get_arg(5);
            $this->debitCard                   = func_get_arg(6);
            $this->boleto                      = func_get_arg(7);
            $this->customerEditable            = func_get_arg(8);
            $this->expiresIn                   = func_get_arg(9);
            $this->skipCheckoutSuccessPage     = func_get_arg(10);
            $this->billingAddressEditable      = func_get_arg(11);
            $this->billingAddress              = func_get_arg(12);
            $this->bankTransfer                = func_get_arg(13);
            $this->acceptedBrands              = func_get_arg(14);
            $this->pix                         = func_get_arg(15);
        }
    }


    /**
     * Encode this object to JSON
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        $json = array();
        $json['accepted_payment_methods']       = $this->acceptedPaymentMethods;
        $json['accepted_multi_payment_methods'] = $this->acceptedMultiPaymentMethods;
        $json['success_url']                    = $this->successUrl;
        $json['default_payment_method']         = $this->defaultPaymentMethod;
        $json['gateway_affiliation_id']         = $this->gatewayAffiliationId;
        $json['credit_card']                    = $this->creditCard;
        $json['debit_card']                     = $this->debitCard;
        $json['boleto']                         = $this->boleto;
        $json['customer_editable']              = $this->customerEditable;
        $json['expires_in']                     = $this->expiresIn;
        $json['skip_checkout_success_page']     = $this->skipCheckoutSuccessPage;
        $json['billing_address_editable']       = $this->billingAddressEditable;
        $json['billing_address']                = $this->billingAddress;
        $json['bank_transfer']                  = $this->bankTransfer;
        $json['accepted_brands']                = $this->acceptedBrands;
        $json['pix']                            = $this->pix;

        return $json;
    }
}
