import { ValidatedTextInput } from '@woocommerce/blocks-components';
import { PacketaWidget } from './PacketaWidget';
import { useView } from "./useView";

export const View = ( { cart } ) => {

	const view = useView( cart );
	if ( null === view ) {
		return null;
	}

	const {
		buttonCallback,
		buttonLabel,
		buttonPlace,
		buttonInfo,
		inputValue,
		inputRequired,
		errorMessage,
		showLogo,
		logo,
		translations,
		loading,
	} = view;

	// translations are sometimes unexpectedly undefined
	if ( ! translations ) {
		return null;
	}

	return (
		<PacketaWidget
			onClick={ buttonCallback }
			buttonLabel={ buttonLabel }
			showLogo={ showLogo }
			logoSrc={ logo }
			logoAlt={ translations.packeta }
			place={ buttonPlace }
			info={ buttonInfo }
			loading={ loading }
			placeholderText={ translations.placeholderText }
		>
			<ValidatedTextInput
				key={ inputRequired ? 'required' : 'optional' }
				value={ inputValue }
				required={ inputRequired }
				errorMessage={ errorMessage }
			/>
		</PacketaWidget>
	);

};
