<?php
/**
 * Plugin implementing Packeta shipping methods.
 *
 * @package   Packeta
 *
 * @wordpress-plugin
 *
 * Plugin Name: Packeta
 * Description: This is the official plugin, that allows you to choose pickup points of Packeta and its external carriers in all of Europe, or utilize address delivery to 25 countries in the European Union, straight from the cart in your e-shop. Furthermore, you can also submit all your orders to Packeta with just one click.
 * Version: 2.2.0
 * Author: Zásilkovna s.r.o.
 * Author URI: https://www.zasilkovna.cz/
 * Text Domain: packeta
 * Domain Path: /languages
 * Requires at least: 6.3
 * Requires PHP: 7.4
 * Requires Plugins: woocommerce
 *
 * Tested up to: 6.8.2
 * WC requires at least: 5.1
 * WC tested up to: 10.3.4
 *
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */

use Packetery\Module\Plugin;
use Packetery\Nette\DI\Container;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/** @var Container $container */
$container = require __DIR__ . '/bootstrap.php';
/** @var Plugin $packetaPlugin */
$packetaPlugin = $container->getByType( Plugin::class );
$packetaPlugin->run();
