<?php

/**
 * This file is part of the Latte (https://latte.nette.org)
 * Copyright (c) 2008 David Grudl (https://davidgrudl.com)
 */
declare (strict_types=1);
namespace Packetery\Latte\Runtime;

use Packetery\Latte\RuntimeException;
use Packetery\Nette\Utils\Strings;
/**
 * @internal
 */
class Defaults
{
    /** @return array<string, callable> */
    public function getFilters() : array
    {
        return ['batch' => [Filters::class, 'batch'], 'breakLines' => [Filters::class, 'breaklines'], 'breaklines' => [Filters::class, 'breaklines'], 'bytes' => [Filters::class, 'bytes'], 'capitalize' => \extension_loaded('mbstring') ? [Filters::class, 'capitalize'] : function () {
            throw new RuntimeException('Filter |capitalize requires mbstring extension.');
        }, 'ceil' => [Filters::class, 'ceil'], 'clamp' => [Filters::class, 'clamp'], 'dataStream' => [Filters::class, 'dataStream'], 'datastream' => [Filters::class, 'dataStream'], 'date' => [Filters::class, 'date'], 'escapeCss' => [Filters::class, 'escapeCss'], 'escapeHtml' => [Filters::class, 'escapeHtml'], 'escapeHtmlComment' => [Filters::class, 'escapeHtmlComment'], 'escapeICal' => [Filters::class, 'escapeICal'], 'escapeJs' => [Filters::class, 'escapeJs'], 'escapeUrl' => 'rawurlencode', 'escapeXml' => [Filters::class, 'escapeXml'], 'explode' => [Filters::class, 'explode'], 'first' => [Filters::class, 'first'], 'firstUpper' => \extension_loaded('mbstring') ? [Filters::class, 'firstUpper'] : function () {
            throw new RuntimeException('Filter |firstUpper requires mbstring extension.');
        }, 'floor' => [Filters::class, 'floor'], 'checkUrl' => [Filters::class, 'safeUrl'], 'implode' => [Filters::class, 'implode'], 'indent' => [Filters::class, 'indent'], 'join' => [Filters::class, 'implode'], 'last' => [Filters::class, 'last'], 'length' => [Filters::class, 'length'], 'lower' => \extension_loaded('mbstring') ? [Filters::class, 'lower'] : function () {
            throw new RuntimeException('Filter |lower requires mbstring extension.');
        }, 'number' => 'number_format', 'padLeft' => [Filters::class, 'padLeft'], 'padRight' => [Filters::class, 'padRight'], 'query' => [Filters::class, 'query'], 'random' => [Filters::class, 'random'], 'repeat' => [Filters::class, 'repeat'], 'replace' => [Filters::class, 'replace'], 'replaceRe' => [Filters::class, 'replaceRe'], 'replaceRE' => [Filters::class, 'replaceRe'], 'reverse' => [Filters::class, 'reverse'], 'round' => [Filters::class, 'round'], 'slice' => [Filters::class, 'slice'], 'sort' => [Filters::class, 'sort'], 'spaceless' => [Filters::class, 'strip'], 'split' => [Filters::class, 'explode'], 'strip' => [Filters::class, 'strip'], 'stripHtml' => [Filters::class, 'stripHtml'], 'striphtml' => [Filters::class, 'stripHtml'], 'stripTags' => [Filters::class, 'stripTags'], 'striptags' => [Filters::class, 'stripTags'], 'substr' => [Filters::class, 'substring'], 'trim' => [Filters::class, 'trim'], 'truncate' => [Filters::class, 'truncate'], 'upper' => \extension_loaded('mbstring') ? [Filters::class, 'upper'] : function () {
            throw new RuntimeException('Filter |upper requires mbstring extension.');
        }, 'webalize' => \class_exists(Strings::class) ? [Strings::class, 'webalize'] : function () {
            throw new RuntimeException('Filter |webalize requires nette/utils package.');
        }];
    }
    /** @return array<string, callable> */
    public function getFunctions() : array
    {
        return ['clamp' => [Filters::class, 'clamp'], 'divisibleBy' => [Filters::class, 'divisibleBy'], 'even' => [Filters::class, 'even'], 'first' => [Filters::class, 'first'], 'last' => [Filters::class, 'last'], 'odd' => [Filters::class, 'odd'], 'slice' => [Filters::class, 'slice']];
    }
}
